/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.converter.TaskReportResultToCsvConverter;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.task.TaskCountByCandidateGroupResult;
import org.camunda.bpm.engine.task.TaskReport;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class TaskReportRestServiceTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String TASK_REPORT_URL = "/rest-test/task/report";
    protected static final String CANDIDATE_GROUP_REPORT_URL = "/rest-test/task/report/candidate-group-count";
    protected TaskReport mockedReportQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedReportQuery = this.setUpMockHistoricProcessInstanceReportQuery();
    }

    private TaskReport setUpMockHistoricProcessInstanceReportQuery() {
        TaskReport mockedReportQuery = (TaskReport)Mockito.mock(TaskReport.class);
        List<TaskCountByCandidateGroupResult> taskCountByCandidateGroupResults = MockProvider.createMockTaskCountByCandidateGroupReport();
        Mockito.when((Object)mockedReportQuery.taskCountByCandidateGroup()).thenReturn(taskCountByCandidateGroupResults);
        Mockito.when((Object)processEngine.getTaskService().createTaskReport()).thenReturn((Object)mockedReportQuery);
        return mockedReportQuery;
    }

    @Test
    public void testEmptyReport() {
        RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(CANDIDATE_GROUP_REPORT_URL, new Object[0]);
        ((TaskReport)Mockito.verify((Object)this.mockedReportQuery)).taskCountByCandidateGroup();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testMissingAuthorization() {
        String message = "not authorized";
        Mockito.when((Object)this.mockedReportQuery.taskCountByCandidateGroup()).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)message), new Object[0]).when().get(CANDIDATE_GROUP_REPORT_URL, new Object[0]);
    }

    @Test
    public void testTaskCountByCandidateGroupReport() {
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(CANDIDATE_GROUP_REPORT_URL, new Object[0]);
        String content = response.asString();
        List reports = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one report returned.", (long)1L, (long)reports.size());
        Assert.assertNotNull((String)"The returned report should not be null.", reports.get(0));
        String returnedGroup = JsonPath.from((String)content).getString("[0].groupName");
        int returnedCount = JsonPath.from((String)content).getInt("[0].taskCount");
        Assert.assertEquals((Object)"groupId1", (Object)returnedGroup);
        Assert.assertEquals((long)2L, (long)returnedCount);
    }

    @Test
    public void testEmptyCsvReport() {
        RestAssured.given().accept("text/csv").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("text/csv").when().get(CANDIDATE_GROUP_REPORT_URL, new Object[0]);
        ((TaskReport)Mockito.verify((Object)this.mockedReportQuery)).taskCountByCandidateGroup();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedReportQuery});
    }

    @Test
    public void testCsvTaskCountByCandidateGroupReport() {
        Response response = (Response)RestAssured.given().accept("text/csv").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("text/csv").header("Content-Disposition", "attachment; filename=\"task-count-by-candidate-group.csv\"").when().get(CANDIDATE_GROUP_REPORT_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertTrue((boolean)responseContent.contains(TaskReportResultToCsvConverter.CANDIDATE_GROUP_HEADER));
        Assert.assertTrue((boolean)responseContent.contains("groupId1"));
        Assert.assertTrue((boolean)responseContent.contains(String.valueOf(2)));
    }

    @Test
    public void testApplicationCsvTaskCountByCandidateGroupReport() {
        Response response = (Response)RestAssured.given().accept("application/csv").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/csv").header("Content-Disposition", "attachment; filename=\"task-count-by-candidate-group.csv\"").when().get(CANDIDATE_GROUP_REPORT_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertTrue((boolean)responseContent.contains(TaskReportResultToCsvConverter.CANDIDATE_GROUP_HEADER));
        Assert.assertTrue((boolean)responseContent.contains("groupId1"));
        Assert.assertTrue((boolean)responseContent.contains(String.valueOf(2)));
    }
}

