/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricExternalTaskLog;
import org.camunda.bpm.engine.history.HistoricExternalTaskLogQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class HistoricExternalTaskLogRestServiceInteractionTest
extends AbstractRestServiceTest {
    protected static final String HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL = "/rest-test/history/external-task-log";
    protected static final String SINGLE_HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL = "/rest-test/history/external-task-log/{id}";
    protected static final String HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_GET_ERROR_DETAILS_URL = "/rest-test/history/external-task-log/{id}/error-details";
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected ProcessEngine namedProcessEngine;
    protected HistoryService mockHistoryService;
    protected HistoricExternalTaskLogQuery mockQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockQuery = (HistoricExternalTaskLogQuery)Mockito.mock(HistoricExternalTaskLogQuery.class);
        HistoricExternalTaskLog mockedHistoricExternalTaskLog = MockProvider.createMockHistoricExternalTaskLog();
        Mockito.when((Object)((HistoricExternalTaskLog)this.mockQuery.singleResult())).thenReturn((Object)mockedHistoricExternalTaskLog);
        Mockito.when((Object)this.mockQuery.logId("aHistoricExternalTaskLogId")).thenReturn((Object)this.mockQuery);
        this.mockHistoryService = (HistoryService)Mockito.mock(HistoryService.class);
        Mockito.when((Object)this.mockHistoryService.createHistoricExternalTaskLogQuery()).thenReturn((Object)this.mockQuery);
        this.namedProcessEngine = this.getProcessEngine("default");
        Mockito.when((Object)this.namedProcessEngine.getHistoryService()).thenReturn((Object)this.mockHistoryService);
    }

    @Test
    public void testSimpleHistoricExternalTaskLogGet() {
        RestAssured.given().pathParam("id", (Object)"aHistoricExternalTaskLogId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", CoreMatchers.equalTo((Object)"aHistoricExternalTaskLogId"), new Object[0]).body("timestamp", CoreMatchers.equalTo((Object)MockProvider.EXAMPLE_HISTORIC_EXTERNAL_TASK_LOG_TIMESTAMP), new Object[0]).body("removalTime", CoreMatchers.equalTo((Object)MockProvider.EXAMPLE_HISTORIC_EXTERNAL_TASK_LOG_REMOVAL_TIME), new Object[0]).body("externalTaskId", CoreMatchers.equalTo((Object)"anExternalTaskId"), new Object[0]).body("topicName", CoreMatchers.equalTo((Object)"aTopicName"), new Object[0]).body("workerId", CoreMatchers.equalTo((Object)"aWorkerId"), new Object[0]).body("retries", CoreMatchers.equalTo((Object)5), new Object[0]).body("priority", CoreMatchers.equalTo((Object)2147483689L), new Object[0]).body("errorMessage", CoreMatchers.equalTo((Object)"aEXTERNAL_TASKExceptionMsg"), new Object[0]).body("activityId", CoreMatchers.equalTo((Object)"anActId"), new Object[0]).body("activityInstanceId", CoreMatchers.equalTo((Object)"anActInstanceId"), new Object[0]).body("executionId", CoreMatchers.equalTo((Object)"anExecId"), new Object[0]).body("processInstanceId", CoreMatchers.equalTo((Object)"aProcInstId"), new Object[0]).body("processDefinitionId", CoreMatchers.equalTo((Object)"aProcDefId"), new Object[0]).body("processDefinitionKey", CoreMatchers.equalTo((Object)"aProcDefKey"), new Object[0]).body("tenantId", CoreMatchers.equalTo((Object)"aTenantId"), new Object[0]).body("rootProcessInstanceId", CoreMatchers.equalTo((Object)"aRootProcInstId"), new Object[0]).body("creationLog", CoreMatchers.equalTo((Object)true), new Object[0]).body("failureLog", CoreMatchers.equalTo((Object)true), new Object[0]).body("successLog", CoreMatchers.equalTo((Object)true), new Object[0]).body("deletionLog", CoreMatchers.equalTo((Object)true), new Object[0]).when().get(SINGLE_HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockQuery});
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockQuery)).logId("aHistoricExternalTaskLogId");
        ((HistoricExternalTaskLogQuery)inOrder.verify((Object)this.mockQuery)).singleResult();
    }

    @Test
    public void testHistoricExternalTaskLogGetIdDoesntExist() {
        String id = "nonExistingId";
        HistoricExternalTaskLogQuery invalidQueryNonExistingHistoricExternalTaskLog = (HistoricExternalTaskLogQuery)Mockito.mock(HistoricExternalTaskLogQuery.class);
        Mockito.when((Object)this.mockHistoryService.createHistoricExternalTaskLogQuery().logId(id)).thenReturn((Object)invalidQueryNonExistingHistoricExternalTaskLog);
        Mockito.when((Object)((HistoricExternalTaskLog)invalidQueryNonExistingHistoricExternalTaskLog.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)id).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Historic external task log with id " + id + " does not exist")), new Object[0]).when().get(SINGLE_HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testGetErrorDetails() {
        String errorDetails = "someErrorDetails";
        Mockito.when((Object)this.mockHistoryService.getHistoricExternalTaskLogErrorDetails("aHistoricExternalTaskLogId")).thenReturn((Object)errorDetails);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aHistoricExternalTaskLogId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT).when().get(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_GET_ERROR_DETAILS_URL, new Object[0]);
        String content = response.asString();
        Assert.assertEquals((Object)errorDetails, (Object)content);
    }

    @Test
    public void testGetErrorDetailsExternalTaskNotFound() {
        String exceptionMessage = "historic external task log not found";
        ((HistoryService)Mockito.doThrow((Throwable)new ProcessEngineException(exceptionMessage)).when((Object)this.mockHistoryService)).getHistoricExternalTaskLogErrorDetails("aHistoricExternalTaskLogId");
        RestAssured.given().pathParam("id", (Object)"aHistoricExternalTaskLogId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)exceptionMessage), new Object[0]).when().get(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_GET_ERROR_DETAILS_URL, new Object[0]);
    }

    @Test
    public void testGetErrorDetailsThrowsAuthorizationException() {
        String exceptionMessage = "expected exception";
        ((HistoryService)Mockito.doThrow((Throwable)new AuthorizationException(exceptionMessage)).when((Object)this.mockHistoryService)).getHistoricExternalTaskLogErrorDetails("aHistoricExternalTaskLogId");
        RestAssured.given().pathParam("id", (Object)"aHistoricExternalTaskLogId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", CoreMatchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)exceptionMessage), new Object[0]).when().get(HISTORIC_EXTERNAL_TASK_LOG_RESOURCE_GET_ERROR_DETAILS_URL, new Object[0]);
    }
}

