/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.rest.sub.impl.AbstractVariablesResource;
import org.camunda.bpm.engine.runtime.DeserializationTypeValidator;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class VariableDeserializationTypeValidationTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    protected AbstractVariablesResource variablesResourceSpy;
    protected DeserializationTypeValidator validator;

    @Before
    public void setUpMocks() {
        this.validator = (DeserializationTypeValidator)Mockito.mock(DeserializationTypeValidator.class);
        ProcessEngineConfiguration configurationMock = (ProcessEngineConfiguration)Mockito.mock(ProcessEngineConfiguration.class);
        Mockito.when((Object)configurationMock.isDeserializationTypeValidationEnabled()).thenReturn((Object)true);
        Mockito.when((Object)configurationMock.getDeserializationTypeValidator()).thenReturn((Object)this.validator);
        this.variablesResourceSpy = this.createVariablesResourceSpy();
        Mockito.when((Object)this.variablesResourceSpy.getProcessEngineConfiguration()).thenReturn((Object)configurationMock);
    }

    @Test
    public void shouldValidateNothingForPrimitiveClass() {
        JavaType type = TypeFactory.defaultInstance().constructType(Integer.TYPE);
        this.setValidatorMockResult(true);
        this.variablesResourceSpy.validateType(type);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.validator});
    }

    @Test
    public void shouldValidateBaseTypeOnlyForSimpleClass() {
        JavaType type = TypeFactory.defaultInstance().constructType(String.class);
        this.setValidatorMockResult(true);
        this.variablesResourceSpy.validateType(type);
        ((DeserializationTypeValidator)Mockito.verify((Object)this.validator)).validate("java.lang.String");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.validator});
    }

    @Test
    public void shouldValidateBaseTypeOnlyForComplexClass() {
        JavaType type = TypeFactory.defaultInstance().constructType(Complex.class);
        this.setValidatorMockResult(true);
        this.variablesResourceSpy.validateType(type);
        ((DeserializationTypeValidator)Mockito.verify((Object)this.validator)).validate("org.camunda.bpm.engine.rest.sub.impl.VariableDeserializationTypeValidationTest$Complex");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.validator});
    }

    @Test
    public void shouldValidateContentTypeOnlyForArrayClass() {
        JavaType type = TypeFactory.defaultInstance().constructType(Integer[].class);
        this.setValidatorMockResult(true);
        this.variablesResourceSpy.validateType(type);
        ((DeserializationTypeValidator)Mockito.verify((Object)this.validator)).validate("java.lang.Integer");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.validator});
    }

    @Test
    public void shouldValidateCollectionAndContentTypeForCollectionClass() {
        JavaType type = TypeFactory.defaultInstance().constructFromCanonical("java.util.ArrayList<java.lang.String>");
        this.setValidatorMockResult(true);
        this.variablesResourceSpy.validateType(type);
        ((DeserializationTypeValidator)Mockito.verify((Object)this.validator)).validate("java.util.ArrayList");
        ((DeserializationTypeValidator)Mockito.verify((Object)this.validator)).validate("java.lang.String");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.validator});
    }

    @Test
    public void shouldValidateCollectionAndContentTypeForNestedCollectionClass() {
        JavaType type = TypeFactory.defaultInstance().constructFromCanonical("java.util.ArrayList<java.util.ArrayList<java.lang.String>>");
        this.setValidatorMockResult(true);
        this.variablesResourceSpy.validateType(type);
        ((DeserializationTypeValidator)Mockito.verify((Object)this.validator, (VerificationMode)Mockito.times((int)2))).validate("java.util.ArrayList");
        ((DeserializationTypeValidator)Mockito.verify((Object)this.validator)).validate("java.lang.String");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.validator});
    }

    @Test
    public void shouldValidateMapAndKeyAndContentTypeForMapClass() {
        JavaType type = TypeFactory.defaultInstance().constructFromCanonical("java.util.HashMap<java.lang.String, java.lang.Integer>");
        this.setValidatorMockResult(true);
        this.variablesResourceSpy.validateType(type);
        ((DeserializationTypeValidator)Mockito.verify((Object)this.validator)).validate("java.util.HashMap");
        ((DeserializationTypeValidator)Mockito.verify((Object)this.validator)).validate("java.lang.String");
        ((DeserializationTypeValidator)Mockito.verify((Object)this.validator)).validate("java.lang.Integer");
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.validator});
    }

    @Test
    public void shouldFailForSimpleClass() {
        JavaType type = TypeFactory.defaultInstance().constructType(String.class);
        this.setValidatorMockResult(false);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("[java.lang.String]");
        this.variablesResourceSpy.validateType(type);
    }

    @Test
    public void shouldFailForComplexClass() {
        JavaType type = TypeFactory.defaultInstance().constructType(Complex.class);
        this.setValidatorMockResult(false);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("[org.camunda.bpm.engine.rest.sub.impl.VariableDeserializationTypeValidationTest$Complex]");
        this.variablesResourceSpy.validateType(type);
    }

    @Test
    public void shouldFailForArrayClass() {
        JavaType type = TypeFactory.defaultInstance().constructType(Integer[].class);
        this.setValidatorMockResult(false);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("[java.lang.Integer]");
        this.variablesResourceSpy.validateType(type);
    }

    @Test
    public void shouldFailForCollectionClass() {
        JavaType type = TypeFactory.defaultInstance().constructFromCanonical("java.util.ArrayList<java.lang.String>");
        this.setValidatorMockResult(false);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("[java.util.ArrayList, java.lang.String]");
        this.variablesResourceSpy.validateType(type);
    }

    @Test
    public void shouldFailForMapClass() {
        JavaType type = TypeFactory.defaultInstance().constructFromCanonical("java.util.HashMap<java.lang.String, java.lang.Integer>");
        this.setValidatorMockResult(false);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("[java.util.HashMap, java.lang.String, java.lang.Integer]");
        this.variablesResourceSpy.validateType(type);
    }

    @Test
    public void shouldFailOnceForMapClass() {
        JavaType type = TypeFactory.defaultInstance().constructFromCanonical("java.util.HashMap<java.lang.String, java.lang.String>");
        this.setValidatorMockResult(false);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("[java.util.HashMap, java.lang.String]");
        this.variablesResourceSpy.validateType(type);
    }

    protected void setValidatorMockResult(boolean result) {
        Mockito.when((Object)this.validator.validate(Mockito.anyString())).thenReturn((Object)result);
    }

    protected AbstractVariablesResource createVariablesResourceSpy() {
        return (AbstractVariablesResource)Mockito.spy((Object)new AbstractVariablesResource((ProcessEngine)Mockito.mock(ProcessEngine.class), "test", (ObjectMapper)Mockito.mock(ObjectMapper.class)){

            protected void updateVariableEntities(VariableMap variables, List<String> deletions) {
            }

            protected void setVariableEntity(String variableKey, TypedValue variableValue) {
            }

            protected void removeVariableEntity(String variableKey) {
            }

            protected TypedValue getVariableEntity(String variableKey, boolean deserializeValue) {
                return null;
            }

            protected VariableMap getVariableEntities(boolean deserializeValues) {
                return null;
            }

            protected String getResourceTypeName() {
                return null;
            }
        });
    }

    public static class Nested {
        private int testInt;

        public int getTestInt() {
            return this.testInt;
        }
    }

    public static class Complex {
        private Nested nested;

        public Nested getNested() {
            return this.nested;
        }
    }
}

