/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.util.container;

import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.startup.Tomcat;
import org.camunda.bpm.engine.rest.spi.ProcessEngineProvider;
import org.camunda.bpm.engine.rest.spi.impl.MockedProcessEngineProvider;
import org.camunda.bpm.engine.rest.util.container.EmbeddedServerBootstrap;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.resolver.api.Coordinate;
import org.jboss.shrinkwrap.resolver.api.maven.ConfigurableMavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;

public abstract class TomcatServerBootstrap
extends EmbeddedServerBootstrap {
    private Tomcat tomcat;
    private String workingDir;
    private String webXmlPath;

    public TomcatServerBootstrap(String webXmlPath) {
        this.webXmlPath = webXmlPath;
    }

    @Override
    public void start() {
        Properties serverProperties = this.readProperties();
        int port = Integer.parseInt(serverProperties.getProperty("rest.http.port"));
        this.tomcat = new Tomcat();
        this.tomcat.setPort(port);
        this.tomcat.setBaseDir(this.getWorkingDir());
        this.tomcat.getHost().setAppBase(this.getWorkingDir());
        this.tomcat.getHost().setAutoDeploy(true);
        this.tomcat.getHost().setDeployOnStartup(true);
        String contextPath = "/" + this.getContextPath();
        PomEquippedResolveStage resolver = (PomEquippedResolveStage)((ConfigurableMavenResolverSystem)Maven.configureResolver().useLegacyLocalRepo(true)).configureViaPlugin();
        WebArchive wa = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"rest-test.war")).setWebXML(this.webXmlPath)).addAsLibraries(((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)resolver.addDependencies((Coordinate[])new MavenDependency[]{MavenDependencies.createDependency((String)"org.mockito:mockito-core", (ScopeType)ScopeType.TEST, (boolean)false, (MavenDependencyExclusion[])new MavenDependencyExclusion[]{MavenDependencies.createExclusion((String)"org.hamcrest:hamcrest-core")})})).resolve()).withTransitivity()).asFile())).addAsServiceProvider(ProcessEngineProvider.class, new Class[]{MockedProcessEngineProvider.class})).add((Asset)new ClassLoaderAsset("runtime/tomcat/context.xml"), "META-INF/context.xml")).addPackages(true, new String[]{"org.camunda.bpm.engine.rest"});
        this.addRuntimeSpecificLibraries(wa, resolver);
        wa.setWebXML(this.webXmlPath);
        String webAppPath = this.getWorkingDir() + "/" + this.getContextPath() + ".war";
        ((ZipExporter)wa.as(ZipExporter.class)).exportTo(new File(webAppPath), true);
        this.tomcat.addWebapp(this.tomcat.getHost(), contextPath, webAppPath);
        try {
            this.tomcat.start();
        }
        catch (LifecycleException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract void addRuntimeSpecificLibraries(WebArchive var1, PomEquippedResolveStage var2);

    private String getContextPath() {
        return "rest-test";
    }

    @Override
    public void stop() {
        try {
            try {
                this.tomcat.stop();
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Failed to stop tomcat instance", e);
            }
            try {
                this.tomcat.destroy();
            }
            catch (Exception e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Failed to destroy instance", e);
            }
            this.tomcat = null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getWorkingDir() {
        if (this.workingDir == null) {
            this.workingDir = System.getProperty("java.io.tmpdir");
        }
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }
}

