/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import java.util.Collections;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.BatchQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.batch.BatchDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.JsonPathUtil;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class BatchRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String BATCH_RESOURCE_URL = "/rest-test/batch";
    protected static final String SINGLE_BATCH_RESOURCE_URL = "/rest-test/batch/{id}";
    protected static final String SUSPENDED_BATCH_RESOURCE_URL = "/rest-test/batch/{id}/suspended";
    protected ManagementService managementServiceMock;
    protected BatchQuery queryMock;

    @Before
    public void setUpBatchQueryMock() {
        Batch batchMock = MockProvider.createMockBatch();
        this.queryMock = (BatchQuery)Mockito.mock(BatchQuery.class);
        Mockito.when((Object)this.queryMock.batchId((String)Mockito.eq((Object)"aBatchId"))).thenReturn((Object)this.queryMock);
        Mockito.when((Object)((Batch)this.queryMock.singleResult())).thenReturn((Object)batchMock);
        this.managementServiceMock = (ManagementService)Mockito.mock(ManagementService.class);
        Mockito.when((Object)this.managementServiceMock.createBatchQuery()).thenReturn((Object)this.queryMock);
        Mockito.when((Object)processEngine.getManagementService()).thenReturn((Object)this.managementServiceMock);
    }

    @Test
    public void testGetBatch() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aBatchId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(SINGLE_BATCH_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        ((BatchQuery)inOrder.verify((Object)this.queryMock)).batchId("aBatchId");
        ((BatchQuery)inOrder.verify((Object)this.queryMock)).singleResult();
        inOrder.verifyNoMoreInteractions();
        this.verifyBatchJson(response.asString());
    }

    @Test
    public void testGetNonExistingBatch() {
        String nonExistingId = "nonExistingId";
        BatchQuery batchQuery = (BatchQuery)Mockito.mock(BatchQuery.class);
        Mockito.when((Object)batchQuery.batchId(nonExistingId)).thenReturn((Object)batchQuery);
        Mockito.when((Object)((Batch)batchQuery.singleResult())).thenReturn(null);
        Mockito.when((Object)this.managementServiceMock.createBatchQuery()).thenReturn((Object)batchQuery);
        RestAssured.given().pathParam("id", (Object)nonExistingId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Batch with id '" + nonExistingId + "' does not exist")), new Object[0]).when().get(SINGLE_BATCH_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void deleteBatch() {
        RestAssured.given().pathParam("id", (Object)"aBatchId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_BATCH_RESOURCE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).deleteBatch((String)Mockito.eq((Object)"aBatchId"), Mockito.eq((boolean)false));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.managementServiceMock});
    }

    @Test
    public void deleteBatchNotCascade() {
        RestAssured.given().pathParam("id", (Object)"aBatchId").queryParam("cascade", new Object[]{false}).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_BATCH_RESOURCE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).deleteBatch((String)Mockito.eq((Object)"aBatchId"), Mockito.eq((boolean)false));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.managementServiceMock});
    }

    @Test
    public void deleteBatchCascade() {
        RestAssured.given().pathParam("id", (Object)"aBatchId").queryParam("cascade", new Object[]{true}).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_BATCH_RESOURCE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).deleteBatch((String)Mockito.eq((Object)"aBatchId"), Mockito.eq((boolean)true));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.managementServiceMock});
    }

    @Test
    public void deleteNonExistingBatch() {
        String nonExistingId = "nonExistingId";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("Batch for id '" + nonExistingId + "' cannot be found")}).when((Object)this.managementServiceMock)).deleteBatch((String)Mockito.eq((Object)nonExistingId), Mockito.eq((boolean)false));
        RestAssured.given().pathParam("id", (Object)nonExistingId).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Unable to delete batch with id '" + nonExistingId + "'")), new Object[0]).when().delete(SINGLE_BATCH_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void deleteNonExistingBatchNotCascade() {
        String nonExistingId = "nonExistingId";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("Batch for id '" + nonExistingId + "' cannot be found")}).when((Object)this.managementServiceMock)).deleteBatch((String)Mockito.eq((Object)nonExistingId), Mockito.eq((boolean)false));
        RestAssured.given().pathParam("id", (Object)nonExistingId).queryParam("cascade", new Object[]{false}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Unable to delete batch with id '" + nonExistingId + "'")), new Object[0]).when().delete(SINGLE_BATCH_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void deleteNonExistingBatchCascade() {
        String nonExistingId = "nonExistingId";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("Batch for id '" + nonExistingId + "' cannot be found")}).when((Object)this.managementServiceMock)).deleteBatch((String)Mockito.eq((Object)nonExistingId), Mockito.eq((boolean)true));
        RestAssured.given().pathParam("id", (Object)nonExistingId).queryParam("cascade", new Object[]{true}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Unable to delete batch with id '" + nonExistingId + "'")), new Object[0]).when().delete(SINGLE_BATCH_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void suspendBatch() {
        RestAssured.given().pathParam("id", (Object)"aBatchId").contentType(ContentType.JSON).body(Collections.singletonMap("suspended", true)).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SUSPENDED_BATCH_RESOURCE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).suspendBatchById((String)Mockito.eq((Object)"aBatchId"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.managementServiceMock});
    }

    @Test
    public void suspendNonExistingBatch() {
        String nonExistingId = "nonExistingId";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("Batch for id '" + nonExistingId + "' cannot be found")}).when((Object)this.managementServiceMock)).suspendBatchById((String)Mockito.eq((Object)nonExistingId));
        RestAssured.given().pathParam("id", (Object)nonExistingId).contentType(ContentType.JSON).body(Collections.singletonMap("suspended", true)).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Unable to suspend batch with id '" + nonExistingId + "'")), new Object[0]).when().put(SUSPENDED_BATCH_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void suspendBatchUnauthorized() {
        String batchId = "aBatchId";
        String expectedMessage = "The user with id 'userId' does not have 'UPDATE' permission on resource '" + batchId + "' of type 'Batch'.";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedMessage)}).when((Object)this.managementServiceMock)).suspendBatchById((String)Mockito.eq((Object)batchId));
        RestAssured.given().pathParam("id", (Object)batchId).contentType(ContentType.JSON).body(Collections.singletonMap("suspended", true)).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(SUSPENDED_BATCH_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void activateBatch() {
        RestAssured.given().pathParam("id", (Object)"aBatchId").contentType(ContentType.JSON).body(Collections.singletonMap("suspended", false)).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SUSPENDED_BATCH_RESOURCE_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.managementServiceMock)).activateBatchById((String)Mockito.eq((Object)"aBatchId"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.managementServiceMock});
    }

    @Test
    public void activateNonExistingBatch() {
        String nonExistingId = "nonExistingId";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("Batch for id '" + nonExistingId + "' cannot be found")}).when((Object)this.managementServiceMock)).activateBatchById((String)Mockito.eq((Object)nonExistingId));
        RestAssured.given().pathParam("id", (Object)nonExistingId).contentType(ContentType.JSON).body(Collections.singletonMap("suspended", false)).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Unable to activate batch with id '" + nonExistingId + "'")), new Object[0]).when().put(SUSPENDED_BATCH_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void activateBatchUnauthorized() {
        String batchId = "aBatchId";
        String expectedMessage = "The user with id 'userId' does not have 'UPDATE' permission on resource '" + batchId + "' of type 'Batch'.";
        ((ManagementService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedMessage)}).when((Object)this.managementServiceMock)).activateBatchById((String)Mockito.eq((Object)batchId));
        RestAssured.given().pathParam("id", (Object)batchId).contentType(ContentType.JSON).body(Collections.singletonMap("suspended", false)).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).when().put(SUSPENDED_BATCH_RESOURCE_URL, new Object[0]);
    }

    protected void verifyBatchJson(String batchJson) {
        BatchDto batch = (BatchDto)JsonPathUtil.from(batchJson).getObject("", BatchDto.class);
        Assert.assertNotNull((String)"The returned batch should not be null.", (Object)batch);
        Assert.assertEquals((Object)"aBatchId", (Object)batch.getId());
        Assert.assertEquals((Object)"aBatchType", (Object)batch.getType());
        Assert.assertEquals((long)10L, (long)batch.getTotalJobs());
        Assert.assertEquals((long)11L, (long)batch.getBatchJobsPerSeed());
        Assert.assertEquals((long)12L, (long)batch.getInvocationsPerBatchJob());
        Assert.assertEquals((Object)"aSeedJobDefinitionId", (Object)batch.getSeedJobDefinitionId());
        Assert.assertEquals((Object)"aMonitorJobDefinitionId", (Object)batch.getMonitorJobDefinitionId());
        Assert.assertEquals((Object)"aBatchJobDefinitionId", (Object)batch.getBatchJobDefinitionId());
        Assert.assertEquals((Object)"aTenantId", (Object)batch.getTenantId());
        Assert.assertEquals((Object)"userId", (Object)batch.getCreateUserId());
    }
}

