/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoryServiceImpl;
import org.camunda.bpm.engine.impl.ManagementServiceImpl;
import org.camunda.bpm.engine.impl.RuntimeServiceImpl;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.batch.BatchDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceSuspensionStateDto;
import org.camunda.bpm.engine.rest.dto.runtime.SetJobRetriesByProcessDto;
import org.camunda.bpm.engine.rest.dto.runtime.batch.CorrelationMessageAsyncDto;
import org.camunda.bpm.engine.rest.dto.runtime.batch.DeleteProcessInstancesDto;
import org.camunda.bpm.engine.rest.dto.runtime.batch.SetVariablesAsyncDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.helper.EqualsList;
import org.camunda.bpm.engine.rest.helper.EqualsMap;
import org.camunda.bpm.engine.rest.helper.ErrorMessageHelper;
import org.camunda.bpm.engine.rest.helper.ExampleVariableObject;
import org.camunda.bpm.engine.rest.helper.MockObjectValue;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.VariableTypeHelper;
import org.camunda.bpm.engine.rest.helper.variable.EqualsNullValue;
import org.camunda.bpm.engine.rest.helper.variable.EqualsObjectValue;
import org.camunda.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.camunda.bpm.engine.rest.helper.variable.EqualsUntypedValue;
import org.camunda.bpm.engine.rest.util.DateTimeUtils;
import org.camunda.bpm.engine.rest.util.JsonPathUtil;
import org.camunda.bpm.engine.rest.util.ModificationInstructionBuilder;
import org.camunda.bpm.engine.rest.util.VariablesBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.MessageCorrelationAsyncBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.UpdateProcessInstanceSuspensionStateSelectBuilder;
import org.camunda.bpm.engine.runtime.UpdateProcessInstanceSuspensionStateTenantBuilder;
import org.camunda.bpm.engine.runtime.UpdateProcessInstancesSuspensionStateBuilder;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.LongValue;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class ProcessInstanceRestServiceInteractionTest
extends AbstractRestServiceTest {
    protected static final String TEST_DELETE_REASON = "test";
    protected static final String RETRIES = "retries";
    protected static final String FAIL_IF_NOT_EXISTS = "failIfNotExists";
    protected static final String DELETE_REASON = "deleteReason";
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String PROCESS_INSTANCE_URL = "/rest-test/process-instance";
    protected static final String SINGLE_PROCESS_INSTANCE_URL = "/rest-test/process-instance/{id}";
    protected static final String PROCESS_INSTANCE_VARIABLES_URL = "/rest-test/process-instance/{id}/variables";
    protected static final String DELETE_PROCESS_INSTANCES_ASYNC_URL = "/rest-test/process-instance/delete";
    protected static final String DELETE_PROCESS_INSTANCES_ASYNC_HIST_QUERY_URL = "/rest-test/process-instance/delete-historic-query-based";
    protected static final String SET_JOB_RETRIES_ASYNC_URL = "/rest-test/process-instance/job-retries";
    protected static final String SET_JOB_RETRIES_ASYNC_HIST_QUERY_URL = "/rest-test/process-instance/job-retries-historic-query-based";
    protected static final String SINGLE_PROCESS_INSTANCE_VARIABLE_URL = "/rest-test/process-instance/{id}/variables/{varId}";
    protected static final String SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL = "/rest-test/process-instance/{id}/variables/{varId}/data";
    protected static final String PROCESS_INSTANCE_ACTIVIY_INSTANCES_URL = "/rest-test/process-instance/{id}/activity-instances";
    protected static final String EXAMPLE_PROCESS_INSTANCE_ID_WITH_NULL_VALUE_AS_VARIABLE = "aProcessInstanceWithNullValueAsVariable";
    protected static final String SINGLE_PROCESS_INSTANCE_SUSPENDED_URL = "/rest-test/process-instance/{id}/suspended";
    protected static final String PROCESS_INSTANCE_SUSPENDED_URL = "/rest-test/process-instance/suspended";
    protected static final String PROCESS_INSTANCE_SUSPENDED_ASYNC_URL = "/rest-test/process-instance/suspended-async";
    protected static final String PROCESS_INSTANCE_MODIFICATION_URL = "/rest-test/process-instance/{id}/modification";
    protected static final String PROCESS_INSTANCE_MODIFICATION_ASYNC_URL = "/rest-test/process-instance/{id}/modification-async";
    protected static final String PROCESS_INSTANCE_SET_VARIABLES_ASYNC_URL = "/rest-test/process-instance/variables-async";
    protected static final String PROCESS_INSTANCE_CORRELATE_MESSAGE_ASYNC_URL = "/rest-test/process-instance/message-async";
    protected static final Answer<Object> RETURNS_SELF = invocation -> {
        Object mock = invocation.getMock();
        if (invocation.getMethod().getReturnType().isInstance(mock)) {
            return mock;
        }
        return Mockito.RETURNS_DEFAULTS.answer(invocation);
    };
    protected static final VariableMap EXAMPLE_OBJECT_VARIABLES = Variables.createVariables();
    private RuntimeServiceImpl runtimeServiceMock;
    private ManagementServiceImpl mockManagementService;
    private HistoryServiceImpl historyServiceMock;
    private UpdateProcessInstanceSuspensionStateTenantBuilder mockUpdateSuspensionStateBuilder;
    private UpdateProcessInstanceSuspensionStateSelectBuilder mockUpdateSuspensionStateSelectBuilder;
    private UpdateProcessInstancesSuspensionStateBuilder mockUpdateProcessInstancesSuspensionStateBuilder;

    @Before
    public void setUpRuntimeData() {
        this.runtimeServiceMock = (RuntimeServiceImpl)Mockito.mock(RuntimeServiceImpl.class);
        this.mockManagementService = (ManagementServiceImpl)Mockito.mock(ManagementServiceImpl.class);
        this.historyServiceMock = (HistoryServiceImpl)Mockito.mock(HistoryServiceImpl.class);
        Mockito.when((Object)this.runtimeServiceMock.getVariablesTyped("aProcInstId", true)).thenReturn((Object)EXAMPLE_VARIABLES);
        Mockito.when((Object)this.runtimeServiceMock.getVariablesTyped("anotherId", true)).thenReturn((Object)EXAMPLE_OBJECT_VARIABLES);
        Mockito.when((Object)this.runtimeServiceMock.getVariablesTyped(EXAMPLE_PROCESS_INSTANCE_ID_WITH_NULL_VALUE_AS_VARIABLE, true)).thenReturn((Object)EXAMPLE_VARIABLES_WITH_NULL_VALUE);
        Mockito.when((Object)this.runtimeServiceMock.getActivityInstance("aProcInstId")).thenReturn((Object)EXAMPLE_ACTIVITY_INSTANCE);
        this.mockUpdateSuspensionStateSelectBuilder = (UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.mock(UpdateProcessInstanceSuspensionStateSelectBuilder.class);
        Mockito.when((Object)this.runtimeServiceMock.updateProcessInstanceSuspensionState()).thenReturn((Object)this.mockUpdateSuspensionStateSelectBuilder);
        this.mockUpdateSuspensionStateBuilder = (UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.mock(UpdateProcessInstanceSuspensionStateTenantBuilder.class);
        Mockito.when((Object)this.mockUpdateSuspensionStateSelectBuilder.byProcessInstanceId((String)Mockito.any())).thenReturn((Object)this.mockUpdateSuspensionStateBuilder);
        Mockito.when((Object)this.mockUpdateSuspensionStateSelectBuilder.byProcessDefinitionId((String)Mockito.any())).thenReturn((Object)this.mockUpdateSuspensionStateBuilder);
        Mockito.when((Object)this.mockUpdateSuspensionStateSelectBuilder.byProcessDefinitionKey((String)Mockito.any())).thenReturn((Object)this.mockUpdateSuspensionStateBuilder);
        this.mockUpdateProcessInstancesSuspensionStateBuilder = (UpdateProcessInstancesSuspensionStateBuilder)Mockito.mock(UpdateProcessInstancesSuspensionStateBuilder.class);
        Mockito.when((Object)this.mockUpdateSuspensionStateSelectBuilder.byProcessInstanceIds((List)Mockito.any())).thenReturn((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder);
        Mockito.when((Object)this.mockUpdateSuspensionStateSelectBuilder.byProcessInstanceQuery((ProcessInstanceQuery)Mockito.any())).thenReturn((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder);
        Mockito.when((Object)this.mockUpdateSuspensionStateSelectBuilder.byHistoricProcessInstanceQuery((HistoricProcessInstanceQuery)Mockito.any())).thenReturn((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder);
        Mockito.when((Object)processEngine.getRuntimeService()).thenReturn((Object)this.runtimeServiceMock);
        Mockito.when((Object)processEngine.getManagementService()).thenReturn((Object)this.mockManagementService);
        Mockito.when((Object)processEngine.getHistoryService()).thenReturn((Object)this.historyServiceMock);
    }

    @Test
    public void testGetActivityInstanceTree() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aProcInstId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"anActivityInstanceId"), new Object[0]).body("parentActivityInstanceId", Matchers.equalTo((Object)"aParentActivityInstanceId"), new Object[0]).body("activityId", Matchers.equalTo((Object)"anActivityId"), new Object[0]).body("processInstanceId", Matchers.equalTo((Object)"aProcessInstanceId"), new Object[0]).body("processDefinitionId", Matchers.equalTo((Object)"aProcessDefinitionId"), new Object[0]).body("executionIds", Matchers.not((Matcher)Matchers.empty()), new Object[0]).body("executionIds[0]", Matchers.equalTo((Object)"anExecutionId"), new Object[0]).body("activityName", Matchers.equalTo((Object)"anActivityName"), new Object[0]).body("name", Matchers.equalTo((Object)"anActivityName"), new Object[0]).body("incidentIds", Matchers.empty(), new Object[0]).body("incidents", Matchers.not((Matcher)Matchers.empty()), new Object[0]).body("incidents[0].id", Matchers.equalTo((Object)"anIncidentId"), new Object[0]).body("incidents[0].activityId", Matchers.equalTo((Object)"anActivityId"), new Object[0]).body("childActivityInstances", Matchers.not((Matcher)Matchers.empty()), new Object[0]).body("childActivityInstances[0].id", Matchers.equalTo((Object)"aChildActivityInstanceId"), new Object[0]).body("childActivityInstances[0].parentActivityInstanceId", Matchers.equalTo((Object)"aChildParentActivityInstanceId"), new Object[0]).body("childActivityInstances[0].activityId", Matchers.equalTo((Object)"aChildActivityId"), new Object[0]).body("childActivityInstances[0].activityType", Matchers.equalTo((Object)"aChildActivityType"), new Object[0]).body("childActivityInstances[0].activityName", Matchers.equalTo((Object)"aChildActivityName"), new Object[0]).body("childActivityInstances[0].name", Matchers.equalTo((Object)"aChildActivityName"), new Object[0]).body("childActivityInstances[0].processInstanceId", Matchers.equalTo((Object)"aChildProcessInstanceId"), new Object[0]).body("childActivityInstances[0].processDefinitionId", Matchers.equalTo((Object)"aChildProcessDefinitionId"), new Object[0]).body("childActivityInstances[0].executionIds", Matchers.not((Matcher)Matchers.empty()), new Object[0]).body("childActivityInstances[0].childActivityInstances", Matchers.empty(), new Object[0]).body("childActivityInstances[0].childTransitionInstances", Matchers.empty(), new Object[0]).body("childActivityInstances[0].incidentIds", Matchers.not((Matcher)Matchers.empty()), new Object[0]).body("childActivityInstances[0].incidentIds[0]", Matchers.equalTo((Object)"anIncidentId"), new Object[0]).body("childActivityInstances[0].incidents[0].id", Matchers.equalTo((Object)"anIncidentId"), new Object[0]).body("childActivityInstances[0].incidents[0].activityId", Matchers.equalTo((Object)"anActivityId"), new Object[0]).body("childTransitionInstances", Matchers.not((Matcher)Matchers.empty()), new Object[0]).body("childTransitionInstances[0].id", Matchers.equalTo((Object)"aChildActivityInstanceId"), new Object[0]).body("childTransitionInstances[0].parentActivityInstanceId", Matchers.equalTo((Object)"aChildParentActivityInstanceId"), new Object[0]).body("childTransitionInstances[0].activityId", Matchers.equalTo((Object)"aChildActivityId"), new Object[0]).body("childTransitionInstances[0].activityName", Matchers.equalTo((Object)"aChildActivityName"), new Object[0]).body("childTransitionInstances[0].activityType", Matchers.equalTo((Object)"aChildActivityType"), new Object[0]).body("childTransitionInstances[0].targetActivityId", Matchers.equalTo((Object)"aChildActivityId"), new Object[0]).body("childTransitionInstances[0].processInstanceId", Matchers.equalTo((Object)"aChildProcessInstanceId"), new Object[0]).body("childTransitionInstances[0].processDefinitionId", Matchers.equalTo((Object)"aChildProcessDefinitionId"), new Object[0]).body("childTransitionInstances[0].executionId", Matchers.equalTo((Object)"anExecutionId"), new Object[0]).body("childTransitionInstances[0].incidentIds", Matchers.not((Matcher)Matchers.empty()), new Object[0]).body("childTransitionInstances[0].incidentIds[0]", Matchers.equalTo((Object)"anotherIncidentId"), new Object[0]).body("childTransitionInstances[0].incidents[0].id", Matchers.equalTo((Object)"anIncidentId"), new Object[0]).body("childTransitionInstances[0].incidents[0].activityId", Matchers.equalTo((Object)"anActivityId"), new Object[0]).when().get(PROCESS_INSTANCE_ACTIVIY_INSTANCES_URL, new Object[0]);
        Assert.assertEquals((String)"Should return right number of properties", (long)13L, (long)response.jsonPath().getMap("").size());
    }

    @Test
    public void testGetActivityInstanceTreeForNonExistingProcessInstance() {
        Mockito.when((Object)this.runtimeServiceMock.getActivityInstance(Mockito.anyString())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aNonExistingProcessInstanceId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Process instance with id aNonExistingProcessInstanceId does not exist"), new Object[0]).when().get(PROCESS_INSTANCE_ACTIVIY_INSTANCES_URL, new Object[0]);
    }

    @Test
    public void testGetActivityInstanceTreeWithInternalError() {
        Mockito.when((Object)this.runtimeServiceMock.getActivityInstance(Mockito.anyString())).thenThrow(new Throwable[]{new ProcessEngineException("expected exception")});
        RestAssured.given().pathParam("id", (Object)"aNonExistingProcessInstanceId").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"expected exception"), new Object[0]).when().get(PROCESS_INSTANCE_ACTIVIY_INSTANCES_URL, new Object[0]);
    }

    @Test
    public void testGetActivityInstanceTreeThrowsAuthorizationException() {
        String message = "expected exception";
        Mockito.when((Object)this.runtimeServiceMock.getActivityInstance(Mockito.anyString())).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"aProcInstId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().get(PROCESS_INSTANCE_ACTIVIY_INSTANCES_URL, new Object[0]);
    }

    @Test
    public void testGetVariables() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aProcInstId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("aVariableKey", Matchers.notNullValue(), new Object[0]).body("aVariableKey.value", Matchers.equalTo((Object)EXAMPLE_VARIABLE_VALUE.getValue()), new Object[0]).body("aVariableKey.type", Matchers.equalTo((Object)String.class.getSimpleName()), new Object[0]).when().get(PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
        Assert.assertEquals((String)"Should return exactly one variable", (long)1L, (long)response.jsonPath().getMap("").size());
    }

    @Test
    public void testDeleteAsync() {
        List<String> ids = Arrays.asList("aProcInstId");
        Mockito.when((Object)this.runtimeServiceMock.deleteProcessInstancesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.any(), (String)Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)new BatchEntity());
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("processInstanceIds", ids);
        messageBodyJson.put(DELETE_REASON, TEST_DELETE_REASON);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(DELETE_PROCESS_INSTANCES_ASYNC_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock, (VerificationMode)Mockito.times((int)1))).deleteProcessInstancesAsync(ids, null, TEST_DELETE_REASON, false, false);
    }

    @Test
    public void testDeleteAsyncWithQuery() {
        HashMap<String, String> messageBodyJson = new HashMap<String, String>();
        messageBodyJson.put(DELETE_REASON, TEST_DELETE_REASON);
        ProcessInstanceQueryDto query = new ProcessInstanceQueryDto();
        messageBodyJson.put("processInstanceQuery", (String)query);
        Mockito.when((Object)this.runtimeServiceMock.deleteProcessInstancesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.any(), (String)Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)new BatchEntity());
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(DELETE_PROCESS_INSTANCES_ASYNC_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock, (VerificationMode)Mockito.times((int)1))).deleteProcessInstancesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.any(), (String)Mockito.eq((Object)TEST_DELETE_REASON), Mockito.eq((boolean)false), Mockito.eq((boolean)false));
    }

    @Test
    public void testDeleteAsyncWithBadRequestQuery() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("process instance ids are empty")}).when((Object)this.runtimeServiceMock)).deleteProcessInstancesAsync((List)Mockito.eq((Object)null), (ProcessInstanceQuery)Mockito.eq((Object)null), Mockito.anyString(), Mockito.anyBoolean(), Mockito.anyBoolean());
        HashMap<String, String> messageBodyJson = new HashMap<String, String>();
        messageBodyJson.put(DELETE_REASON, TEST_DELETE_REASON);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(DELETE_PROCESS_INSTANCES_ASYNC_URL, new Object[0]);
    }

    @Test
    public void testDeleteAsyncWithSkipCustomListeners() {
        Mockito.when((Object)this.runtimeServiceMock.deleteProcessInstancesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.any(), (String)Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)new BatchEntity());
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put(DELETE_REASON, TEST_DELETE_REASON);
        messageBodyJson.put("processInstanceIds", Arrays.asList("processInstanceId1", "processInstanceId2"));
        messageBodyJson.put("skipCustomListeners", true);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(DELETE_PROCESS_INSTANCES_ASYNC_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).deleteProcessInstancesAsync(Mockito.anyList(), (ProcessInstanceQuery)Mockito.any(), (String)Mockito.eq((Object)TEST_DELETE_REASON), Mockito.eq((boolean)true), Mockito.eq((boolean)false));
    }

    @Test
    public void testDeleteAsyncWithSkipSubprocesses() {
        Mockito.when((Object)this.runtimeServiceMock.deleteProcessInstancesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.any(), (String)Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)new BatchEntity());
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put(DELETE_REASON, TEST_DELETE_REASON);
        messageBodyJson.put("processInstanceIds", Arrays.asList("processInstanceId1", "processInstanceId2"));
        messageBodyJson.put("skipSubprocesses", true);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(DELETE_PROCESS_INSTANCES_ASYNC_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).deleteProcessInstancesAsync(Mockito.anyList(), (ProcessInstanceQuery)Mockito.any(), (String)Mockito.eq((Object)TEST_DELETE_REASON), Mockito.eq((boolean)false), Mockito.eq((boolean)true));
    }

    @Test
    public void testDeleteAsyncHistoricQueryBasedWithQuery() {
        Mockito.when((Object)this.runtimeServiceMock.deleteProcessInstancesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.eq((Object)null), (HistoricProcessInstanceQuery)Mockito.any(), (String)Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)new BatchEntity());
        HistoricProcessInstanceQuery mockedHistoricProcessInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQueryImpl.class);
        Mockito.when((Object)this.historyServiceMock.createHistoricProcessInstanceQuery()).thenReturn((Object)mockedHistoricProcessInstanceQuery);
        DeleteProcessInstancesDto body = new DeleteProcessInstancesDto();
        body.setHistoricProcessInstanceQuery(new HistoricProcessInstanceQueryDto());
        RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(DELETE_PROCESS_INSTANCES_ASYNC_HIST_QUERY_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock, (VerificationMode)Mockito.times((int)1))).deleteProcessInstancesAsync(null, null, mockedHistoricProcessInstanceQuery, null, false, false);
    }

    @Test
    public void testDeleteAsyncHistoricQueryBasedWithProcessInstanceIds() {
        Mockito.when((Object)this.runtimeServiceMock.deleteProcessInstancesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.eq((Object)null), (HistoricProcessInstanceQuery)Mockito.eq((Object)null), (String)Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)new BatchEntity());
        DeleteProcessInstancesDto body = new DeleteProcessInstancesDto();
        body.setProcessInstanceIds(Arrays.asList("aProcInstId"));
        RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(DELETE_PROCESS_INSTANCES_ASYNC_HIST_QUERY_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock, (VerificationMode)Mockito.times((int)1))).deleteProcessInstancesAsync(Arrays.asList("aProcInstId"), null, null, null, false, false);
    }

    @Test
    public void testDeleteAsyncHistoricQueryBasedWithQueryAndProcessInstanceIds() {
        Mockito.when((Object)this.runtimeServiceMock.deleteProcessInstancesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.eq((Object)null), (HistoricProcessInstanceQuery)Mockito.any(), (String)Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)new BatchEntity());
        HistoricProcessInstanceQuery mockedHistoricProcessInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQueryImpl.class);
        Mockito.when((Object)this.historyServiceMock.createHistoricProcessInstanceQuery()).thenReturn((Object)mockedHistoricProcessInstanceQuery);
        DeleteProcessInstancesDto body = new DeleteProcessInstancesDto();
        body.setHistoricProcessInstanceQuery(new HistoricProcessInstanceQueryDto());
        body.setProcessInstanceIds(Collections.singletonList("anotherId"));
        RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(DELETE_PROCESS_INSTANCES_ASYNC_HIST_QUERY_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock, (VerificationMode)Mockito.times((int)1))).deleteProcessInstancesAsync(Collections.singletonList("anotherId"), null, mockedHistoricProcessInstanceQuery, null, false, false);
    }

    @Test
    public void testDeleteAsyncHistoricQueryBasedWithoutQueryAndWithoutProcessInstanceIds() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("processInstanceIds is empty")}).when((Object)this.runtimeServiceMock)).deleteProcessInstancesAsync((List)Mockito.eq((Object)null), (ProcessInstanceQuery)Mockito.eq((Object)null), (HistoricProcessInstanceQuery)Mockito.eq((Object)null), (String)Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean());
        RestAssured.given().contentType(ContentType.JSON).body((Object)new DeleteProcessInstancesDto()).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(DELETE_PROCESS_INSTANCES_ASYNC_HIST_QUERY_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock, (VerificationMode)Mockito.times((int)1))).deleteProcessInstancesAsync(null, null, null, null, false, false);
    }

    @Test
    public void testDeleteAsyncHistoricQueryBasedWithDeleteReason() {
        Mockito.when((Object)this.runtimeServiceMock.deleteProcessInstancesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.any(), (HistoricProcessInstanceQuery)Mockito.any(), (String)Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)new BatchEntity());
        DeleteProcessInstancesDto body = new DeleteProcessInstancesDto();
        body.setDeleteReason("aDeleteReason");
        RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(DELETE_PROCESS_INSTANCES_ASYNC_HIST_QUERY_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock, (VerificationMode)Mockito.times((int)1))).deleteProcessInstancesAsync(null, null, null, "aDeleteReason", false, false);
    }

    @Test
    public void testDeleteAsyncHistoricQueryBasedWithSkipCustomListenerTrue() {
        Mockito.when((Object)this.runtimeServiceMock.deleteProcessInstancesAsync((List)Mockito.eq((Object)null), (ProcessInstanceQuery)Mockito.eq((Object)null), (HistoricProcessInstanceQuery)Mockito.any(), (String)Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)new BatchEntity());
        DeleteProcessInstancesDto body = new DeleteProcessInstancesDto();
        body.setSkipCustomListeners(true);
        RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(DELETE_PROCESS_INSTANCES_ASYNC_HIST_QUERY_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock, (VerificationMode)Mockito.times((int)1))).deleteProcessInstancesAsync(null, null, null, null, true, false);
    }

    @Test
    public void testDeleteAsyncHistoricQueryBasedWithSkipSubprocesses() {
        Mockito.when((Object)this.runtimeServiceMock.deleteProcessInstancesAsync((List)Mockito.eq((Object)null), (ProcessInstanceQuery)Mockito.eq((Object)null), (HistoricProcessInstanceQuery)Mockito.eq((Object)null), (String)Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)new BatchEntity());
        DeleteProcessInstancesDto body = new DeleteProcessInstancesDto();
        body.setSkipSubprocesses(Boolean.valueOf(true));
        RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(DELETE_PROCESS_INSTANCES_ASYNC_HIST_QUERY_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock, (VerificationMode)Mockito.times((int)1))).deleteProcessInstancesAsync(null, null, null, null, false, true);
    }

    @Test
    public void testGetVariablesWithNullValue() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)EXAMPLE_PROCESS_INSTANCE_ID_WITH_NULL_VALUE_AS_VARIABLE).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("anotherVariableKey", Matchers.notNullValue(), new Object[0]).body("anotherVariableKey.value", Matchers.nullValue(), new Object[0]).body("anotherVariableKey.type", Matchers.equalTo((Object)"Null"), new Object[0]).when().get(PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
        Assert.assertEquals((String)"Should return exactly one variable", (long)1L, (long)response.jsonPath().getMap("").size());
    }

    @Test
    public void testGetFileVariable() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        String mimeType = "text/plain";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(mimeType).create();
        Mockito.when((Object)this.runtimeServiceMock.getVariableTyped((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), Mockito.eq((boolean)true))).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON.toString()).and().body("valueInfo.mimeType", Matchers.equalTo((Object)mimeType), new Object[0]).body("valueInfo.filename", Matchers.equalTo((Object)filename), new Object[0]).body("value", Matchers.nullValue(), new Object[0]).when().get(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetNullFileVariable() {
        String variableKey = "aVariableKey";
        String filename = "test.txt";
        String mimeType = "text/plain";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).mimeType(mimeType).create();
        Mockito.when((Object)this.runtimeServiceMock.getVariableTyped((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT.toString()).and().body(Matchers.is((Matcher)Matchers.equalTo((Object)"")), new Matcher[0]).when().get(SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetFileVariableDownloadWithType() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(ContentType.TEXT.toString()).create();
        Mockito.when((Object)this.runtimeServiceMock.getVariableTyped((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT.toString()).and().body(Matchers.is((Matcher)Matchers.equalTo((Object)new String(byteContent))), new Matcher[0]).when().get(SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetFileVariableDownloadWithTypeAndEncoding() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        String encoding = "UTF-8";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(ContentType.TEXT.toString()).encoding(encoding).create();
        Mockito.when((Object)this.runtimeServiceMock.getVariableTyped((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).body(Matchers.is((Matcher)Matchers.equalTo((Object)new String(byteContent))), new Matcher[0]).when().get(SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        String contentType = response.contentType().replaceAll(" ", "");
        MatcherAssert.assertThat((Object)contentType, (Matcher)Matchers.is((Object)(ContentType.TEXT + ";charset=" + encoding)));
    }

    @Test
    public void testGetFileVariableDownloadWithoutType() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).create();
        Mockito.when((Object)this.runtimeServiceMock.getVariableTyped((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/octet-stream").and().body(Matchers.is((Matcher)Matchers.equalTo((Object)new String(byteContent))), new Matcher[0]).header("Content-Disposition", Matchers.containsString((String)filename)).when().get(SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testCannotDownloadVariableOtherThanFile() {
        String variableKey = "aVariableKey";
        LongValue variableValue = Variables.longValue((Long)123L);
        Mockito.when((Object)this.runtimeServiceMock.getVariableTyped((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType("application/json").and().when().get(SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testJavaObjectVariableSerialization() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"anotherId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("aVariableKey", Matchers.notNullValue(), new Object[0]).body("aVariableKey.value.property1", Matchers.equalTo((Object)"aPropertyValue"), new Object[0]).body("aVariableKey.value.property2", Matchers.equalTo((Object)true), new Object[0]).body("aVariableKey.type", Matchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName((ValueType)ValueType.OBJECT)), new Object[0]).body("aVariableKey.valueInfo.objectTypeName", Matchers.equalTo((Object)ExampleVariableObject.class.getName()), new Object[0]).body("aVariableKey.valueInfo.serializationDataFormat", Matchers.equalTo((Object)"application/json"), new Object[0]).when().get(PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
        Assert.assertEquals((String)"Should return exactly one variable", (long)1L, (long)response.jsonPath().getMap("").size());
    }

    @Test
    public void testGetObjectVariables() {
        String variableKey = "aVariableId";
        List<String> payload = Arrays.asList("a", "b");
        MockObjectValue variableValue = MockObjectValue.fromObjectValue((ObjectValue)Variables.objectValue(payload).serializationDataFormat("application/json").create()).objectTypeName(ArrayList.class.getName()).serializedValue("a serialized value");
        Mockito.when((Object)this.runtimeServiceMock.getVariablesTyped((String)Mockito.eq((Object)"aProcessInstanceId"), Mockito.anyBoolean())).thenReturn((Object)Variables.createVariables().putValueTyped(variableKey, (TypedValue)variableValue));
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body(variableKey + ".value", Matchers.equalTo(payload), new Object[0]).body(variableKey + ".type", Matchers.equalTo((Object)"Object"), new Object[0]).body(variableKey + ".valueInfo." + "serializationDataFormat", Matchers.equalTo((Object)"application/json"), new Object[0]).body(variableKey + ".valueInfo." + "objectTypeName", Matchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get(PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).getVariablesTyped("aProcessInstanceId", true);
    }

    @Test
    public void testGetObjectVariablesSerialized() {
        String variableKey = "aVariableId";
        ObjectValue variableValue = (ObjectValue)Variables.serializedObjectValue((String)"a serialized value").serializationDataFormat("application/json").objectTypeName(ArrayList.class.getName()).create();
        Mockito.when((Object)this.runtimeServiceMock.getVariablesTyped((String)Mockito.eq((Object)"aProcessInstanceId"), Mockito.anyBoolean())).thenReturn((Object)Variables.createVariables().putValueTyped(variableKey, (TypedValue)variableValue));
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").queryParam("deserializeValues", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).body(variableKey + ".value", Matchers.equalTo((Object)"a serialized value"), new Object[0]).body(variableKey + ".type", Matchers.equalTo((Object)"Object"), new Object[0]).body(variableKey + ".valueInfo." + "serializationDataFormat", Matchers.equalTo((Object)"application/json"), new Object[0]).body(variableKey + ".valueInfo." + "objectTypeName", Matchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get(PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).getVariablesTyped("aProcessInstanceId", false);
    }

    @Test
    public void testGetVariablesForNonExistingProcessInstance() {
        Mockito.when((Object)this.runtimeServiceMock.getVariablesTyped(Mockito.anyString(), Mockito.anyBoolean())).thenThrow(new Throwable[]{new ProcessEngineException("expected exception")});
        RestAssured.given().pathParam("id", (Object)"aNonExistingProcessInstanceId").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"expected exception"), new Object[0]).when().get(PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testGetVariablesThrowsAuthorizationException() {
        String message = "expected exception";
        Mockito.when((Object)this.runtimeServiceMock.getVariablesTyped(Mockito.anyString(), Mockito.anyBoolean())).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"aProcInstId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().get(PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testGetSingleInstance() {
        ProcessInstance mockInstance = MockProvider.createMockInstance();
        ProcessInstanceQuery sampleInstanceQuery = (ProcessInstanceQuery)Mockito.mock(ProcessInstanceQuery.class);
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceQuery()).thenReturn((Object)sampleInstanceQuery);
        Mockito.when((Object)sampleInstanceQuery.processInstanceId("aProcInstId")).thenReturn((Object)sampleInstanceQuery);
        Mockito.when((Object)((ProcessInstance)sampleInstanceQuery.singleResult())).thenReturn((Object)mockInstance);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("ended", Matchers.equalTo((Object)false), new Object[0]).body("definitionId", Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("businessKey", Matchers.equalTo((Object)"aKey"), new Object[0]).body("suspended", Matchers.equalTo((Object)false), new Object[0]).body("tenantId", Matchers.equalTo((Object)"aTenantId"), new Object[0]).when().get(SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testGetNonExistingProcessInstance() {
        ProcessInstanceQuery sampleInstanceQuery = (ProcessInstanceQuery)Mockito.mock(ProcessInstanceQuery.class);
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceQuery()).thenReturn((Object)sampleInstanceQuery);
        Mockito.when((Object)sampleInstanceQuery.processInstanceId(Mockito.anyString())).thenReturn((Object)sampleInstanceQuery);
        Mockito.when((Object)((ProcessInstance)sampleInstanceQuery.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aNonExistingInstanceId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Process instance with id aNonExistingInstanceId does not exist"), new Object[0]).when().get(SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testDeleteProcessInstance() {
        RestAssured.given().pathParam("id", (Object)"aProcInstId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).deleteProcessInstance("aProcInstId", null, false, true, false, false);
    }

    @Test
    public void testDeleteNonExistingProcessInstance() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new NotFoundException()}).when((Object)this.runtimeServiceMock)).deleteProcessInstance((String)Mockito.any(), (String)Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean());
        RestAssured.given().pathParam("id", (Object)"aProcInstId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).when().delete(SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testDeleteNonExistingProcessInstanceIfExists() {
        RestAssured.given().pathParam("id", (Object)"aProcInstId").queryParam(FAIL_IF_NOT_EXISTS, new Object[]{false}).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).deleteProcessInstanceIfExists("aProcInstId", null, false, true, false, false);
    }

    @Test
    public void testDeleteProcessInstanceThrowsAuthorizationException() {
        String message = "expected exception";
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.runtimeServiceMock)).deleteProcessInstance((String)Mockito.any(), (String)Mockito.any(), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean(), Mockito.anyBoolean());
        RestAssured.given().pathParam("id", (Object)"aProcInstId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().delete(SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
    }

    @Test
    public void testNoGivenDeleteReason1() {
        RestAssured.given().pathParam("id", (Object)"aProcInstId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).deleteProcessInstance("aProcInstId", null, false, true, false, false);
    }

    @Test
    public void testDeleteProcessInstanceSkipCustomListeners() {
        RestAssured.given().pathParam("id", (Object)"aProcInstId").queryParams("skipCustomListeners", (Object)true, new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).deleteProcessInstance("aProcInstId", null, true, true, false, false);
    }

    @Test
    public void testDeleteProcessInstanceWithCustomListeners() {
        RestAssured.given().pathParam("id", (Object)"aProcInstId").queryParams("skipCustomListeners", (Object)false, new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).deleteProcessInstance("aProcInstId", null, false, true, false, false);
    }

    @Test
    public void testDeleteProcessInstanceSkipIoMappings() {
        RestAssured.given().pathParam("id", (Object)"aProcInstId").queryParams("skipIoMappings", (Object)true, new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).deleteProcessInstance("aProcInstId", null, false, true, true, false);
    }

    @Test
    public void testDeleteProcessInstanceWithoutSkipingIoMappings() {
        RestAssured.given().pathParam("id", (Object)"aProcInstId").queryParams("skipIoMappings", (Object)false, new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).deleteProcessInstance("aProcInstId", null, false, true, false, false);
    }

    @Test
    public void testDeleteProcessInstanceSkipSubprocesses() {
        RestAssured.given().pathParam("id", (Object)"aProcInstId").queryParams("skipSubprocesses", (Object)true, new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).deleteProcessInstance("aProcInstId", null, false, true, false, true);
    }

    @Test
    public void testDeleteProcessInstanceWithoutSkipSubprocesses() {
        RestAssured.given().pathParam("id", (Object)"aProcInstId").queryParams("skipSubprocesses", (Object)false, new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).deleteProcessInstance("aProcInstId", null, false, true, false, false);
    }

    @Test
    public void testVariableModification() {
        String variableKey = "aKey";
        int variableValue = 123;
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, variableValue).getVariables();
        messageBodyJson.put("modifications", modifications);
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("deleteKey");
        messageBodyJson.put("deletions", deletions);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
        HashMap<String, Object> expectedModifications = new HashMap<String, Object>();
        expectedModifications.put(variableKey, variableValue);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).updateVariables((String)Mockito.eq((Object)"aProcInstId"), (Map)MockitoHamcrest.argThat((Matcher)new EqualsMap(expectedModifications)), (Collection)MockitoHamcrest.argThat((Matcher)new EqualsList(deletions)));
    }

    @Test
    public void testVariableModificationWithUnparseableInteger() {
        String variableKey = "aKey";
        String variableValue = "1abc";
        String variableType = "Integer";
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Cannot modify variables for process instance: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Integer.class))), new Object[0]).when().post(PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testVariableModificationWithUnparseableShort() {
        String variableKey = "aKey";
        String variableValue = "1abc";
        String variableType = "Short";
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Cannot modify variables for process instance: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Short.class))), new Object[0]).when().post(PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testVariableModificationWithUnparseableLong() {
        String variableKey = "aKey";
        String variableValue = "1abc";
        String variableType = "Long";
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Cannot modify variables for process instance: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Long.class))), new Object[0]).when().post(PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testVariableModificationWithUnparseableDouble() {
        String variableKey = "aKey";
        String variableValue = "1abc";
        String variableType = "Double";
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Cannot modify variables for process instance: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Double.class))), new Object[0]).when().post(PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testVariableModificationWithUnparseableDate() {
        String variableKey = "aKey";
        String variableValue = "1abc";
        String variableType = "Date";
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Cannot modify variables for process instance: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Date.class))), new Object[0]).when().post(PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testVariableModificationWithNotSupportedType() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "X";
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Cannot modify variables for process instance: Unsupported value type 'X'"), new Object[0]).when().post(PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testVariableModificationForNonExistingProcessInstance() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.runtimeServiceMock)).updateVariables((String)Mockito.any(), (Map)Mockito.any(), (Collection)Mockito.any());
        String variableKey = "aKey";
        int variableValue = 123;
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, variableValue).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Cannot modify variables for process instance aProcInstId: expected exception"), new Object[0]).when().post(PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testEmptyVariableModification() {
        RestAssured.given().pathParam("id", (Object)"aProcInstId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testVariableModificationThrowsAuthorizationException() {
        String variableKey = "aKey";
        int variableValue = 123;
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, variableValue).getVariables();
        messageBodyJson.put("modifications", modifications);
        String message = "excpected exception";
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.runtimeServiceMock)).updateVariables((String)Mockito.any(), (Map)Mockito.any(), (Collection)Mockito.any());
        RestAssured.given().pathParam("id", (Object)"aProcInstId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().post(PROCESS_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testGetSingleVariable() {
        String variableKey = "aVariableKey";
        int variableValue = 123;
        Mockito.when((Object)this.runtimeServiceMock.getVariableTyped((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), Mockito.eq((boolean)true))).thenReturn((Object)Variables.integerValue((Integer)variableValue));
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("value", Matchers.is((Object)123), new Object[0]).body("type", Matchers.is((Object)"Integer"), new Object[0]).when().get(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testNonExistingVariable() {
        String variableKey = "aVariableKey";
        Mockito.when((Object)this.runtimeServiceMock.getVariableTyped((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)("process instance variable with name " + variableKey + " does not exist")), new Object[0]).when().get(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetSingleVariableThrowsAuthorizationException() {
        String variableKey = "aVariableKey";
        String message = "excpected exception";
        Mockito.when((Object)this.runtimeServiceMock.getVariableTyped((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().get(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetSingleLocalVariableData() {
        Mockito.when((Object)this.runtimeServiceMock.getVariableTyped(Mockito.anyString(), (String)Mockito.eq((Object)"aBytesVariableKey"), Mockito.eq((boolean)false))).thenReturn((Object)EXAMPLE_VARIABLE_VALUE_BYTES);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)"aBytesVariableKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/octet-stream").when().get(SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).getVariableTyped("aProcInstId", "aBytesVariableKey", false);
    }

    @Test
    public void testGetSingleLocalVariableDataNonExisting() {
        Mockito.when((Object)this.runtimeServiceMock.getVariableTyped(Mockito.anyString(), (String)Mockito.eq((Object)"nonExisting"), Mockito.eq((boolean)false))).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)"nonExisting").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)"process instance variable with name nonExisting does not exist"), new Object[0]).when().get(SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).getVariableTyped("aProcInstId", "nonExisting", false);
    }

    @Test
    public void testGetSingleLocalVariabledataNotBinary() {
        Mockito.when((Object)this.runtimeServiceMock.getVariableTyped(Mockito.anyString(), (String)Mockito.eq((Object)"aVariableKey"), Mockito.eq((boolean)false))).thenReturn((Object)EXAMPLE_VARIABLE_VALUE);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)"aVariableKey").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).getVariableTyped("aProcInstId", "aVariableKey", false);
    }

    @Test
    public void testGetSingleLocalObjectVariable() {
        String variableKey = "aVariableId";
        List<String> payload = Arrays.asList("a", "b");
        MockObjectValue variableValue = MockObjectValue.fromObjectValue((ObjectValue)Variables.objectValue(payload).serializationDataFormat("application/json").create()).objectTypeName(ArrayList.class.getName()).serializedValue("a serialized value");
        Mockito.when((Object)this.runtimeServiceMock.getVariableTyped((String)Mockito.eq((Object)"aProcessInstanceId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("value", Matchers.equalTo(payload), new Object[0]).body("type", Matchers.equalTo((Object)"Object"), new Object[0]).body("valueInfo.serializationDataFormat", Matchers.equalTo((Object)"application/json"), new Object[0]).body("valueInfo.objectTypeName", Matchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).getVariableTyped("aProcessInstanceId", variableKey, true);
    }

    @Test
    public void testGetSingleLocalObjectVariableSerialized() {
        String variableKey = "aVariableId";
        ObjectValue variableValue = (ObjectValue)Variables.serializedObjectValue((String)"a serialized value").serializationDataFormat("application/json").objectTypeName(ArrayList.class.getName()).create();
        Mockito.when((Object)this.runtimeServiceMock.getVariableTyped((String)Mockito.eq((Object)"aProcessInstanceId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").pathParam("varId", (Object)variableKey).queryParam("deserializeValue", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("value", Matchers.equalTo((Object)"a serialized value"), new Object[0]).body("type", Matchers.equalTo((Object)"Object"), new Object[0]).body("valueInfo.serializationDataFormat", Matchers.equalTo((Object)"application/json"), new Object[0]).body("valueInfo.objectTypeName", Matchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).getVariableTyped("aProcessInstanceId", variableKey, false);
    }

    @Test
    public void testGetVariableForNonExistingInstance() {
        String variableKey = "aVariableKey";
        Mockito.when((Object)this.runtimeServiceMock.getVariableTyped((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), Mockito.eq((boolean)true))).thenThrow(new Throwable[]{new ProcessEngineException("expected exception")});
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)("Cannot get process instance variable " + variableKey + ": expected exception")), new Object[0]).when().get(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "aVariableValue";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap(variableValue);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsUntypedValue.matcher().value(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithTypeString() {
        String variableKey = "aVariableKey";
        String variableValue = "aVariableValue";
        String type = "String";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithTypeInteger() {
        String variableKey = "aVariableKey";
        Integer variableValue = 123;
        String type = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithUnparseableInteger() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Cannot put process instance variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Integer.class))), new Object[0]).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithTypeShort() {
        String variableKey = "aVariableKey";
        Short variableValue = 123;
        String type = "Short";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.shortValue(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithUnparseableShort() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Short";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Cannot put process instance variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Short.class))), new Object[0]).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithTypeLong() {
        String variableKey = "aVariableKey";
        Long variableValue = 123L;
        String type = "Long";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.longValue(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithUnparseableLong() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Long";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Cannot put process instance variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Long.class))), new Object[0]).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithTypeDouble() {
        String variableKey = "aVariableKey";
        Double variableValue = 123.456;
        String type = "Double";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.doubleValue(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithUnparseableDouble() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Double";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Cannot put process instance variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Double.class))), new Object[0]).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithTypeBoolean() {
        String variableKey = "aVariableKey";
        Boolean variableValue = true;
        String type = "Boolean";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.booleanValue(variableValue)));
    }

    @Test
    public void testPutSingleVariableWithTypeDate() throws Exception {
        Date now = new Date();
        String variableKey = "aVariableKey";
        String variableValue = DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now);
        String type = "Date";
        Date expectedValue = DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.parse(variableValue);
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.dateValue(expectedValue)));
    }

    @Test
    public void testPutSingleVariableWithUnparseableDate() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Date";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Cannot put process instance variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Date.class))), new Object[0]).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithNotSupportedType() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "X";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Cannot put process instance variable aVariableKey: Unsupported value type 'X'"), new Object[0]).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableThrowsAuthorizationException() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "String";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        String message = "expected exception";
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.runtimeServiceMock)).setVariable(Mockito.anyString(), Mockito.anyString(), Mockito.any());
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleBinaryVariable() throws Exception {
        byte[] bytes = "someContent".getBytes();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.bytesValue(bytes)));
    }

    @Test
    public void testPutSingleBinaryVariableWithValueType() throws Exception {
        byte[] bytes = "someContent".getBytes();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).multiPart("valueType", "Bytes", "text/plain").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.bytesValue(bytes)));
    }

    @Test
    public void testPutSingleBinaryVariableWithNoValue() throws Exception {
        byte[] bytes = new byte[]{};
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.bytesValue(bytes)));
    }

    @Test
    public void testPutSingleBinaryVariableThrowsAuthorizationException() {
        byte[] bytes = "someContent".getBytes();
        String variableKey = "aVariableKey";
        String message = "expected exception";
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.runtimeServiceMock)).setVariable(Mockito.anyString(), Mockito.anyString(), Mockito.any());
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).multiPart("data", "unspecified", bytes).expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleSerializableVariable() throws Exception {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("foo");
        ObjectMapper mapper = new ObjectMapper();
        String jsonBytes = mapper.writeValueAsString(serializable);
        String typeName = TypeFactory.defaultInstance().constructType(serializable.getClass()).toCanonical();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).multiPart("data", jsonBytes, "application/json").multiPart("type", typeName, "text/plain").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsObjectValue.objectValueMatcher().isDeserialized().value(serializable)));
    }

    @Test
    public void testPutSingleSerializableVariableUnsupportedMediaType() throws Exception {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("foo");
        ObjectMapper mapper = new ObjectMapper();
        String jsonBytes = mapper.writeValueAsString(serializable);
        String typeName = TypeFactory.defaultInstance().constructType(serializable.getClass()).toCanonical();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).multiPart("data", jsonBytes, "unsupported").multiPart("type", typeName, "text/plain").expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(Matchers.containsString((String)"Unrecognized content type for serialized java type: unsupported"), new Matcher[0]).when().post(SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock, (VerificationMode)Mockito.never())).setVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), Mockito.eq(serializable));
    }

    @Test
    public void testPutSingleVariableFromSerialized() throws Exception {
        String serializedValue = "{\"prop\" : \"value\"}";
        Map<String, Object> requestJson = VariablesBuilder.getObjectValueMap(serializedValue, ValueType.OBJECT.getName(), "aDataFormat", "aRootType");
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(requestJson).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsObjectValue.objectValueMatcher().serializedValue(serializedValue).serializationFormat("aDataFormat").objectTypeName("aRootType")));
    }

    @Test
    public void testPutSingleVariableFromInvalidSerialized() throws Exception {
        String serializedValue = "{\"prop\" : \"value\"}";
        Map<String, Object> requestJson = VariablesBuilder.getObjectValueMap(serializedValue, "aNonExistingType", null, null);
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(requestJson).expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Cannot put process instance variable aVariableKey: Unsupported value type 'aNonExistingType'"), new Object[0]).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableFromSerializedWithNoValue() {
        String variableKey = "aVariableKey";
        Map<String, Object> requestJson = VariablesBuilder.getObjectValueMap(null, ValueType.OBJECT.getName(), null, null);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(requestJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsObjectValue.objectValueMatcher()));
    }

    @Test
    public void testPutSingleVariableWithNoValue() {
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsNullValue.matcher()));
    }

    @Test
    public void testPutVariableForNonExistingInstance() {
        String variableKey = "aVariableKey";
        String variableValue = "aVariableValue";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap(variableValue);
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey), Mockito.any());
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)("Cannot put process instance variable " + variableKey + ": expected exception")), new Object[0]).when().put(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPostSingleFileVariableWithEncodingAndMimeType() throws Exception {
        byte[] value = "some text".getBytes();
        String variableKey = "aVariableKey";
        String encoding = "utf-8";
        String filename = "test.txt";
        String mimetype = "text/plain";
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).multiPart("data", filename, value, mimetype + "; encoding=" + encoding).multiPart("valueType", "File", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileValue.class);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), captor.capture());
        FileValue captured = (FileValue)captor.getValue();
        MatcherAssert.assertThat((Object)captured.getEncoding(), (Matcher)Matchers.is((Object)encoding));
        MatcherAssert.assertThat((Object)captured.getFilename(), (Matcher)Matchers.is((Object)filename));
        MatcherAssert.assertThat((Object)captured.getMimeType(), (Matcher)Matchers.is((Object)mimetype));
        MatcherAssert.assertThat((Object)IoUtil.readInputStream((InputStream)captured.getValue(), null), (Matcher)Matchers.is((Object)value));
    }

    @Test
    public void testPostSingleFileVariableWithMimeType() throws Exception {
        byte[] value = "some text".getBytes();
        String variableKey = "aVariableKey";
        String filename = "test.txt";
        String mimetype = "text/plain";
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).multiPart("data", filename, value, mimetype).multiPart("valueType", "File", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileValue.class);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), captor.capture());
        FileValue captured = (FileValue)captor.getValue();
        MatcherAssert.assertThat((Object)captured.getEncoding(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)captured.getFilename(), (Matcher)Matchers.is((Object)filename));
        MatcherAssert.assertThat((Object)captured.getMimeType(), (Matcher)Matchers.is((Object)mimetype));
        MatcherAssert.assertThat((Object)IoUtil.readInputStream((InputStream)captured.getValue(), null), (Matcher)Matchers.is((Object)value));
    }

    @Test
    public void testPostSingleFileVariableWithEncoding() throws Exception {
        byte[] value = "some text".getBytes();
        String variableKey = "aVariableKey";
        String encoding = "utf-8";
        String filename = "test.txt";
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).multiPart("data", filename, value, "encoding=" + encoding).multiPart("valueType", "File", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPostSingleFileVariableOnlyFilename() throws Exception {
        String variableKey = "aVariableKey";
        String filename = "test.txt";
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).multiPart("data", filename, new byte[0]).multiPart("valueType", "File", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_PROCESS_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileValue.class);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariable((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), captor.capture());
        FileValue captured = (FileValue)captor.getValue();
        MatcherAssert.assertThat((Object)captured.getEncoding(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)captured.getFilename(), (Matcher)Matchers.is((Object)filename));
        MatcherAssert.assertThat((Object)captured.getMimeType(), (Matcher)Matchers.is((Object)"application/octet-stream"));
        MatcherAssert.assertThat((Object)captured.getValue().available(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testDeleteSingleVariable() {
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).removeVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey));
    }

    @Test
    public void testDeleteVariableForNonExistingInstance() {
        String variableKey = "aVariableKey";
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.runtimeServiceMock)).removeVariable((String)Mockito.eq((Object)"aProcInstId"), (String)Mockito.eq((Object)variableKey));
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)("Cannot delete process instance variable " + variableKey + ": expected exception")), new Object[0]).when().delete(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testDeleteVariableThrowsAuthorizationException() {
        String variableKey = "aVariableKey";
        String message = "expected exception";
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.runtimeServiceMock)).removeVariable(Mockito.anyString(), Mockito.anyString());
        RestAssured.given().pathParam("id", (Object)"aProcInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().delete(SINGLE_PROCESS_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testActivateInstance() {
        ProcessInstanceSuspensionStateDto dto = new ProcessInstanceSuspensionStateDto();
        dto.setSuspended(false);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").contentType(ContentType.JSON).body((Object)dto).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessInstanceId("aProcInstId");
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateThrowsProcessEngineException() {
        ProcessInstanceSuspensionStateDto dto = new ProcessInstanceSuspensionStateDto();
        dto.setSuspended(false);
        String expectedMessage = "expectedMessage";
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedMessage)}).when((Object)this.mockUpdateSuspensionStateBuilder)).activate();
        RestAssured.given().pathParam("id", (Object)"aNonExistentProcInstId").contentType(ContentType.JSON).body((Object)dto).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedMessage), new Object[0]).when().put(SINGLE_PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateThrowsAuthorizationException() {
        ProcessInstanceSuspensionStateDto dto = new ProcessInstanceSuspensionStateDto();
        dto.setSuspended(false);
        String message = "expectedMessage";
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.mockUpdateSuspensionStateBuilder)).activate();
        RestAssured.given().pathParam("id", (Object)"aProcInstId").contentType(ContentType.JSON).body((Object)dto).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(SINGLE_PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendInstance() {
        ProcessInstanceSuspensionStateDto dto = new ProcessInstanceSuspensionStateDto();
        dto.setSuspended(true);
        RestAssured.given().pathParam("id", (Object)"aProcInstId").contentType(ContentType.JSON).body((Object)dto).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessInstanceId("aProcInstId");
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendThrowsProcessEngineException() {
        ProcessInstanceSuspensionStateDto dto = new ProcessInstanceSuspensionStateDto();
        dto.setSuspended(true);
        String expectedMessage = "expectedMessage";
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedMessage)}).when((Object)this.mockUpdateSuspensionStateBuilder)).suspend();
        RestAssured.given().pathParam("id", (Object)"aNonExistentProcInstId").contentType(ContentType.JSON).body((Object)dto).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedMessage), new Object[0]).when().put(SINGLE_PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendThrowsAuthorizationException() {
        ProcessInstanceSuspensionStateDto dto = new ProcessInstanceSuspensionStateDto();
        dto.setSuspended(true);
        String message = "expectedMessage";
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.mockUpdateSuspensionStateBuilder)).suspend();
        RestAssured.given().pathParam("id", (Object)"aProcInstId").contentType(ContentType.JSON).body((Object)dto).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(SINGLE_PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionKeyWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        String expectedException = "expectedException";
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedException)}).when((Object)this.mockUpdateSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionKeyThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        String message = "expectedMessage";
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.mockUpdateSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionKey() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionKeyWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        String expectedException = "expectedException";
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedException)}).when((Object)this.mockUpdateSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionKeyThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        String message = "expectedMessage";
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.mockUpdateSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionKeyAndTenantId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        params.put("processDefinitionTenantId", "aTenantId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateBuilder)).processDefinitionTenantId("aTenantId");
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionKeyWithoutTenantId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionKey", "aKey");
        params.put("processDefinitionWithoutTenantId", true);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateBuilder)).processDefinitionWithoutTenantId();
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateBuilder)).activate();
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionKeyAndTenantId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        params.put("processDefinitionTenantId", "aTenantId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateBuilder)).processDefinitionTenantId("aTenantId");
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionKeyWithoutTenantId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionKey", "aKey");
        params.put("processDefinitionWithoutTenantId", true);
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessDefinitionKey("aKey");
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateBuilder)).processDefinitionWithoutTenantId();
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionId", "aProcDefId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessDefinitionId("aProcDefId");
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateBuilder)).activate();
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionIdWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionId", "aProcDefId");
        String expectedException = "expectedException";
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedException)}).when((Object)this.mockUpdateSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateProcessInstanceByProcessDefinitionIdThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processDefinitionId", "aProcDefId");
        String message = "expectedMessage";
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.mockUpdateSuspensionStateBuilder)).activate();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionId() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionId", "aProcDefId");
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessDefinitionId("aProcDefId");
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionIdWithException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionId", "aProcDefId");
        String expectedException = "expectedException";
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException(expectedException)}).when((Object)this.mockUpdateSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)expectedException), new Object[0]).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendProcessInstanceByProcessDefinitionIdThrowsAuthorizationException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionId", "aProcDefId");
        String message = "expectedMessage";
        ((UpdateProcessInstanceSuspensionStateTenantBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.mockUpdateSuspensionStateBuilder)).suspend();
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testActivateProcessInstanceByIdShouldThrowException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", false);
        params.put("processInstanceId", "aProcInstId");
        String message = "Either processDefinitionId or processDefinitionKey should be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendProcessInstanceByIdShouldThrowException() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processInstanceId", "aProcInstId");
        String message = "Either processDefinitionId or processDefinitionKey should be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendWithMultipleByParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("suspended", true);
        params.put("processDefinitionId", "aProcDefId");
        params.put("processDefinitionKey", "aKey");
        String message = "Only one of processDefinitionId or processDefinitionKey should be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendProcessInstanceByNothing() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("suspended", true);
        String message = "Either processDefinitionId or processDefinitionKey should be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(params).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
    }

    @Test
    public void testSuspendInstances() {
        List<String> ids = Arrays.asList("aProcInstId");
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("processInstanceIds", ids);
        messageBodyJson.put("suspended", true);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessInstanceIds(ids);
        ((UpdateProcessInstancesSuspensionStateBuilder)Mockito.verify((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testActivateInstances() {
        List<String> ids = Arrays.asList("aProcInstId");
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("processInstanceIds", ids);
        messageBodyJson.put("suspended", false);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessInstanceIds(ids);
        ((UpdateProcessInstancesSuspensionStateBuilder)Mockito.verify((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder)).activate();
    }

    @Test
    public void testSuspendInstancesMultipleGroupOperations() {
        List<String> ids = Arrays.asList("aProcInstId");
        ProcessInstanceQueryDto query = new ProcessInstanceQueryDto();
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("processInstanceIds", ids);
        messageBodyJson.put("processInstanceQuery", query);
        messageBodyJson.put("suspended", true);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessInstanceIds(ids);
        ((UpdateProcessInstancesSuspensionStateBuilder)Mockito.verify((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder)).byProcessInstanceQuery((ProcessInstanceQuery)query.toQuery(processEngine));
        ((UpdateProcessInstancesSuspensionStateBuilder)Mockito.verify((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testSuspendProcessInstanceQuery() {
        ProcessInstanceQueryDto query = new ProcessInstanceQueryDto();
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("processInstanceQuery", query);
        messageBodyJson.put("suspended", true);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessInstanceQuery((ProcessInstanceQuery)query.toQuery(processEngine));
        ((UpdateProcessInstancesSuspensionStateBuilder)Mockito.verify((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testActivateProcessInstanceQuery() {
        ProcessInstanceQueryDto query = new ProcessInstanceQueryDto();
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("processInstanceQuery", query);
        messageBodyJson.put("suspended", false);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessInstanceQuery((ProcessInstanceQuery)query.toQuery(processEngine));
        ((UpdateProcessInstancesSuspensionStateBuilder)Mockito.verify((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder)).activate();
    }

    @Test
    public void testSuspendHistoricProcessInstanceQuery() {
        HistoricProcessInstanceQueryDto query = new HistoricProcessInstanceQueryDto();
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("historicProcessInstanceQuery", query);
        messageBodyJson.put("suspended", true);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byHistoricProcessInstanceQuery((HistoricProcessInstanceQuery)Mockito.any());
        ((UpdateProcessInstancesSuspensionStateBuilder)Mockito.verify((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder)).suspend();
    }

    @Test
    public void testActivateHistoricProcessInstanceQuery() {
        HistoricProcessInstanceDto query = new HistoricProcessInstanceDto();
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("historicProcessInstanceQuery", query);
        messageBodyJson.put("suspended", false);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(PROCESS_INSTANCE_SUSPENDED_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byHistoricProcessInstanceQuery((HistoricProcessInstanceQuery)Mockito.any());
        ((UpdateProcessInstancesSuspensionStateBuilder)Mockito.verify((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder)).activate();
    }

    @Test
    public void testSuspendAsyncWithProcessInstances() {
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        List<String> ids = Arrays.asList("aProcInstId");
        messageBodyJson.put("processInstanceIds", ids);
        messageBodyJson.put("suspended", true);
        Mockito.when((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder.suspendAsync()).thenReturn((Object)new BatchEntity());
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_SUSPENDED_ASYNC_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessInstanceIds(ids);
        ((UpdateProcessInstancesSuspensionStateBuilder)Mockito.verify((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder)).suspendAsync();
    }

    @Test
    public void testActivateAsyncWithProcessInstances() {
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        List<String> ids = Arrays.asList("aProcInstId");
        messageBodyJson.put("processInstanceIds", ids);
        messageBodyJson.put("suspended", false);
        Mockito.when((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder.activateAsync()).thenReturn((Object)new BatchEntity());
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_SUSPENDED_ASYNC_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessInstanceIds(ids);
        ((UpdateProcessInstancesSuspensionStateBuilder)Mockito.verify((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder)).activateAsync();
    }

    @Test
    public void testSuspendAsyncWithProcessInstanceQuery() {
        ProcessInstanceQueryDto query = new ProcessInstanceQueryDto();
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("processInstanceQuery", query);
        messageBodyJson.put("suspended", true);
        Mockito.when((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder.suspendAsync()).thenReturn((Object)new BatchEntity());
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_SUSPENDED_ASYNC_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessInstanceQuery((ProcessInstanceQuery)query.toQuery(processEngine));
        ((UpdateProcessInstancesSuspensionStateBuilder)Mockito.verify((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder)).suspendAsync();
    }

    @Test
    public void testActivateAsyncWithProcessInstanceQuery() {
        ProcessInstanceQueryDto query = new ProcessInstanceQueryDto();
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("processInstanceQuery", query);
        messageBodyJson.put("suspended", false);
        Mockito.when((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder.activateAsync()).thenReturn((Object)new BatchEntity());
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_SUSPENDED_ASYNC_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessInstanceQuery((ProcessInstanceQuery)query.toQuery(processEngine));
        ((UpdateProcessInstancesSuspensionStateBuilder)Mockito.verify((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder)).activateAsync();
    }

    @Test
    public void testSuspendAsyncWithHistoricProcessInstanceQuery() {
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        List<String> ids = Arrays.asList("aProcInstId");
        messageBodyJson.put("processInstanceIds", ids);
        messageBodyJson.put("suspended", true);
        Mockito.when((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder.suspendAsync()).thenReturn((Object)new BatchEntity());
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_SUSPENDED_ASYNC_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessInstanceIds(ids);
        ((UpdateProcessInstancesSuspensionStateBuilder)Mockito.verify((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder)).suspendAsync();
    }

    @Test
    public void testActivateAsyncWithHistoricProcessInstanceQuery() {
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        List<String> ids = Arrays.asList("aProcInstId");
        messageBodyJson.put("processInstanceIds", ids);
        messageBodyJson.put("suspended", false);
        Mockito.when((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder.activateAsync()).thenReturn((Object)new BatchEntity());
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_SUSPENDED_ASYNC_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessInstanceIds(ids);
        ((UpdateProcessInstancesSuspensionStateBuilder)Mockito.verify((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder)).activateAsync();
    }

    @Test
    public void testSuspendAsyncWithMultipleGroupOperations() {
        List<String> ids = Arrays.asList("aProcInstId");
        ProcessInstanceQueryDto query = new ProcessInstanceQueryDto();
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("processInstanceIds", ids);
        messageBodyJson.put("processInstanceQuery", query);
        messageBodyJson.put("suspended", true);
        Mockito.when((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder.suspendAsync()).thenReturn((Object)new BatchEntity());
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_SUSPENDED_ASYNC_URL, new Object[0]);
        ((UpdateProcessInstanceSuspensionStateSelectBuilder)Mockito.verify((Object)this.mockUpdateSuspensionStateSelectBuilder)).byProcessInstanceIds(ids);
        ((UpdateProcessInstancesSuspensionStateBuilder)Mockito.verify((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder)).byProcessInstanceQuery((ProcessInstanceQuery)query.toQuery(processEngine));
        ((UpdateProcessInstancesSuspensionStateBuilder)Mockito.verify((Object)this.mockUpdateProcessInstancesSuspensionStateBuilder)).suspendAsync();
    }

    @Test
    public void testSuspendAsyncWithNothing() {
        HashMap<String, Boolean> messageBodyJson = new HashMap<String, Boolean>();
        messageBodyJson.put("suspended", true);
        String message = "Either processInstanceIds, processInstanceQuery or historicProcessInstanceQuery should be set to update the suspension state.";
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)message), new Object[0]).when().post(PROCESS_INSTANCE_SUSPENDED_ASYNC_URL, new Object[0]);
    }

    @Test
    public void testProcessInstanceModification() {
        ProcessInstanceModificationInstantiationBuilder mockModificationBuilder = this.setUpMockModificationBuilder();
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceModification(Mockito.anyString())).thenReturn((Object)mockModificationBuilder);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("skipCustomListeners", Boolean.valueOf(true));
        json.put("skipIoMappings", Boolean.valueOf(true));
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.cancellation().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.cancellation().activityInstanceId("activityInstanceId").getJson());
        instructions.add(ModificationInstructionBuilder.cancellation().transitionInstanceId("transitionInstanceId").getJson());
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").ancestorActivityInstanceId("ancestorActivityInstanceId").getJson());
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("activityId").ancestorActivityInstanceId("ancestorActivityInstanceId").getJson());
        instructions.add(ModificationInstructionBuilder.startTransition().transitionId("transitionId").getJson());
        instructions.add(ModificationInstructionBuilder.startTransition().transitionId("transitionId").ancestorActivityInstanceId("ancestorActivityInstanceId").getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(PROCESS_INSTANCE_MODIFICATION_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceModification((String)Mockito.eq((Object)"aProcessInstanceId"));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockModificationBuilder});
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).cancelAllForActivity("activityId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).cancelActivityInstance("activityInstanceId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).cancelTransitionInstance("transitionInstanceId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).startBeforeActivity("activityId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).startBeforeActivity("activityId", "ancestorActivityInstanceId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).startAfterActivity("activityId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).startAfterActivity("activityId", "ancestorActivityInstanceId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).startTransition("transitionId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).startTransition("transitionId", "ancestorActivityInstanceId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).execute(true, true);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testProcessInstanceModificationWithVariables() {
        ProcessInstanceModificationInstantiationBuilder mockModificationBuilder = this.setUpMockModificationBuilder();
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceModification(Mockito.anyString())).thenReturn((Object)mockModificationBuilder);
        HashMap json = new HashMap();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").variables(VariablesBuilder.create().variable("var", "value", "String", false).variable("varLocal", "valueLocal", "String", true).getVariables()).getJson());
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("activityId").variables(VariablesBuilder.create().variable("var", 52, "Integer", false).variable("varLocal", 74, "Integer", true).getVariables()).getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(PROCESS_INSTANCE_MODIFICATION_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceModification((String)Mockito.eq((Object)"aProcessInstanceId"));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockModificationBuilder});
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).startBeforeActivity("activityId");
        ((ProcessInstanceModificationInstantiationBuilder)Mockito.verify((Object)mockModificationBuilder)).setVariableLocal((String)Mockito.eq((Object)"varLocal"), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue("valueLocal")));
        ((ProcessInstanceModificationInstantiationBuilder)Mockito.verify((Object)mockModificationBuilder)).setVariable((String)Mockito.eq((Object)"var"), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue("value")));
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).startAfterActivity("activityId");
        ((ProcessInstanceModificationInstantiationBuilder)Mockito.verify((Object)mockModificationBuilder)).setVariable((String)Mockito.eq((Object)"var"), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(52)));
        ((ProcessInstanceModificationInstantiationBuilder)Mockito.verify((Object)mockModificationBuilder)).setVariableLocal((String)Mockito.eq((Object)"varLocal"), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(74)));
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).execute(false, false);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testInvalidModification() {
        HashMap json = new HashMap();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startBefore().getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"'activityId' must be set"), new Object[0]).when().post(PROCESS_INSTANCE_MODIFICATION_URL, new Object[0]);
        instructions = new ArrayList();
        instructions.add(ModificationInstructionBuilder.startAfter().getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"'activityId' must be set"), new Object[0]).when().post(PROCESS_INSTANCE_MODIFICATION_URL, new Object[0]);
        instructions = new ArrayList();
        instructions.add(ModificationInstructionBuilder.startTransition().getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"'transitionId' must be set"), new Object[0]).when().post(PROCESS_INSTANCE_MODIFICATION_URL, new Object[0]);
        instructions = new ArrayList();
        instructions.add(ModificationInstructionBuilder.cancellation().getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"For instruction type 'cancel': exactly one, 'activityId', 'activityInstanceId', or 'transitionInstanceId', is required"), new Object[0]).when().post(PROCESS_INSTANCE_MODIFICATION_URL, new Object[0]);
        instructions = new ArrayList();
        instructions.add(ModificationInstructionBuilder.cancellation().activityId("anActivityId").activityInstanceId("anActivityInstanceId").getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"For instruction type 'cancel': exactly one, 'activityId', 'activityInstanceId', or 'transitionInstanceId', is required"), new Object[0]).when().post(PROCESS_INSTANCE_MODIFICATION_URL, new Object[0]);
    }

    @Test
    public void testModifyProcessInstanceThrowsAuthorizationException() {
        ProcessInstanceModificationInstantiationBuilder mockModificationBuilder = this.setUpMockModificationBuilder();
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceModification(Mockito.anyString())).thenReturn((Object)mockModificationBuilder);
        String message = "expected exception";
        ((ProcessInstanceModificationInstantiationBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)mockModificationBuilder)).execute(Mockito.anyBoolean(), Mockito.anyBoolean());
        HashMap json = new HashMap();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").variables(VariablesBuilder.create().variable("var", "value", "String", false).variable("varLocal", "valueLocal", "String", true).getVariables()).getJson());
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("activityId").variables(VariablesBuilder.create().variable("var", 52, "Integer", false).variable("varLocal", 74, "Integer", true).getVariables()).getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(PROCESS_INSTANCE_MODIFICATION_URL, new Object[0]);
    }

    @Test
    public void testSyncProcessInstanceModificationWithAnnotation() {
        ProcessInstanceModificationInstantiationBuilder mockModificationBuilder = this.setUpMockModificationBuilder();
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceModification(Mockito.anyString())).thenReturn((Object)mockModificationBuilder);
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        json.put("instructions", instructions);
        json.put("annotation", "anAnnotation");
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(PROCESS_INSTANCE_MODIFICATION_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceModification((String)Mockito.eq((Object)"aProcessInstanceId"));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockModificationBuilder});
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).startBeforeActivity("activityId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).setAnnotation("anAnnotation");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).execute(false, false);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testSetRetriesByProcessAsync() {
        List<String> ids = Arrays.asList("aProcInstId");
        Batch batchEntity = MockProvider.createMockBatch();
        Mockito.when((Object)this.mockManagementService.setJobRetriesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.any(), Mockito.anyInt())).thenReturn((Object)batchEntity);
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("processInstances", ids);
        messageBodyJson.put(RETRIES, 5);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_JOB_RETRIES_ASYNC_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
        ((ManagementServiceImpl)Mockito.verify((Object)this.mockManagementService, (VerificationMode)Mockito.times((int)1))).setJobRetriesAsync((List)Mockito.eq(ids), (ProcessInstanceQuery)Mockito.eq((Object)null), Mockito.eq((int)5));
    }

    @Test
    public void testSetRetriesByProcessAsyncWithQuery() {
        Batch batchEntity = MockProvider.createMockBatch();
        Mockito.when((Object)this.mockManagementService.setJobRetriesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.any(), Mockito.anyInt())).thenReturn((Object)batchEntity);
        HashMap<String, Integer> messageBodyJson = new HashMap<String, Integer>();
        messageBodyJson.put(RETRIES, 5);
        HistoricProcessInstanceQueryDto query = new HistoricProcessInstanceQueryDto();
        messageBodyJson.put("processInstanceQuery", (Integer)query);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_JOB_RETRIES_ASYNC_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
        ((ManagementServiceImpl)Mockito.verify((Object)this.mockManagementService, (VerificationMode)Mockito.times((int)1))).setJobRetriesAsync((List)Mockito.eq((Object)null), (ProcessInstanceQuery)Mockito.any(), Mockito.eq((int)5));
    }

    @Test
    public void testSetRetriesByProcessWithBadRequestQuery() {
        ((ManagementServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("job ids are empty")}).when((Object)this.mockManagementService)).setJobRetriesAsync((List)Mockito.eq((Object)null), (ProcessInstanceQuery)Mockito.eq((Object)null), Mockito.anyInt());
        HashMap<String, Integer> messageBodyJson = new HashMap<String, Integer>();
        messageBodyJson.put(RETRIES, 5);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(SET_JOB_RETRIES_ASYNC_URL, new Object[0]);
    }

    @Test
    public void testSetRetriesByProcessWithoutRetries() {
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        messageBodyJson.put("processInstances", null);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(SET_JOB_RETRIES_ASYNC_URL, new Object[0]);
    }

    @Test
    public void testSetRetriesByProcessWithNegativeRetries() {
        ((ManagementServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("retries are negative")}).when((Object)this.mockManagementService)).setJobRetriesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.any(), Mockito.eq((int)-1));
        HashMap<String, Integer> messageBodyJson = new HashMap<String, Integer>();
        messageBodyJson.put(RETRIES, -1);
        HistoricProcessInstanceQueryDto query = new HistoricProcessInstanceQueryDto();
        messageBodyJson.put("processInstanceQuery", (Integer)query);
        RestAssured.given().contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(SET_JOB_RETRIES_ASYNC_URL, new Object[0]);
    }

    @Test
    public void testSetRetriesByProcessAsyncHistoricQueryBasedWithQuery() {
        Batch batchEntity = MockProvider.createMockBatch();
        Mockito.when((Object)this.mockManagementService.setJobRetriesAsync((List)Mockito.eq((Object)null), (ProcessInstanceQuery)Mockito.eq((Object)null), (HistoricProcessInstanceQuery)Mockito.any(HistoricProcessInstanceQuery.class), Mockito.anyInt())).thenReturn((Object)batchEntity);
        HistoricProcessInstanceQuery mockedHistoricProcessInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQuery.class);
        Mockito.when((Object)this.historyServiceMock.createHistoricProcessInstanceQuery()).thenReturn((Object)mockedHistoricProcessInstanceQuery);
        List<HistoricProcessInstance> historicProcessInstances = MockProvider.createMockRunningHistoricProcessInstances();
        Mockito.when((Object)mockedHistoricProcessInstanceQuery.list()).thenReturn(historicProcessInstances);
        SetJobRetriesByProcessDto body = new SetJobRetriesByProcessDto();
        body.setRetries(Integer.valueOf(3));
        body.setHistoricProcessInstanceQuery(new HistoricProcessInstanceQueryDto());
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_JOB_RETRIES_ASYNC_HIST_QUERY_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
        ((ManagementServiceImpl)Mockito.verify((Object)this.mockManagementService, (VerificationMode)Mockito.times((int)1))).setJobRetriesAsync(null, null, mockedHistoricProcessInstanceQuery, 3);
    }

    @Test
    public void testSetRetriesByProcessAsyncHistoricQueryBasedWithProcessInstanceIds() {
        Batch batchEntity = MockProvider.createMockBatch();
        Mockito.when((Object)this.mockManagementService.setJobRetriesAsync(Mockito.anyList(), (ProcessInstanceQuery)Mockito.eq((Object)null), (HistoricProcessInstanceQuery)Mockito.eq((Object)null), Mockito.anyInt())).thenReturn((Object)batchEntity);
        SetJobRetriesByProcessDto body = new SetJobRetriesByProcessDto();
        body.setRetries(Integer.valueOf(3));
        body.setProcessInstances(Arrays.asList("aProcInstId"));
        RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_JOB_RETRIES_ASYNC_HIST_QUERY_URL, new Object[0]);
        ((ManagementServiceImpl)Mockito.verify((Object)this.mockManagementService, (VerificationMode)Mockito.times((int)1))).setJobRetriesAsync(Arrays.asList("aProcInstId"), null, null, 3);
    }

    @Test
    public void testSetRetriesByProcessAsyncHistoricQueryBasedWithQueryAndProcessInstanceIds() {
        Batch batchEntity = MockProvider.createMockBatch();
        Mockito.when((Object)this.mockManagementService.setJobRetriesAsync(Mockito.anyList(), (ProcessInstanceQuery)Mockito.eq((Object)null), (HistoricProcessInstanceQuery)Mockito.any(HistoricProcessInstanceQuery.class), Mockito.anyInt())).thenReturn((Object)batchEntity);
        HistoricProcessInstanceQuery mockedHistoricProcessInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQuery.class);
        Mockito.when((Object)this.historyServiceMock.createHistoricProcessInstanceQuery()).thenReturn((Object)mockedHistoricProcessInstanceQuery);
        List<HistoricProcessInstance> historicProcessInstances = MockProvider.createMockRunningHistoricProcessInstances();
        Mockito.when((Object)mockedHistoricProcessInstanceQuery.list()).thenReturn(historicProcessInstances);
        SetJobRetriesByProcessDto body = new SetJobRetriesByProcessDto();
        body.setRetries(Integer.valueOf(3));
        body.setProcessInstances(Arrays.asList("anotherId"));
        body.setHistoricProcessInstanceQuery(new HistoricProcessInstanceQueryDto());
        RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_JOB_RETRIES_ASYNC_HIST_QUERY_URL, new Object[0]);
        ((ManagementServiceImpl)Mockito.verify((Object)this.mockManagementService, (VerificationMode)Mockito.times((int)1))).setJobRetriesAsync(Arrays.asList("anotherId"), null, mockedHistoricProcessInstanceQuery, 3);
    }

    @Test
    public void testSetRetriesByProcessAsyncHistoricQueryBasedWithBadRequestQuery() {
        ((ManagementServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("jobIds is empty")}).when((Object)this.mockManagementService)).setJobRetriesAsync((List)Mockito.eq((Object)null), (ProcessInstanceQuery)Mockito.eq((Object)null), (HistoricProcessInstanceQuery)Mockito.eq((Object)null), Mockito.anyInt());
        SetJobRetriesByProcessDto body = new SetJobRetriesByProcessDto();
        body.setRetries(Integer.valueOf(3));
        RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(SET_JOB_RETRIES_ASYNC_HIST_QUERY_URL, new Object[0]);
    }

    @Test
    public void testSetRetriesByProcessAsyncHistoricQueryBasedWithNegativeRetries() {
        ((ManagementServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("retries are negative")}).when((Object)this.mockManagementService)).setJobRetriesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.eq((Object)null), (HistoricProcessInstanceQuery)Mockito.any(), Mockito.eq((int)-3));
        HistoricProcessInstanceQuery mockedHistoricProcessInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQuery.class);
        Mockito.when((Object)this.historyServiceMock.createHistoricProcessInstanceQuery()).thenReturn((Object)mockedHistoricProcessInstanceQuery);
        List<HistoricProcessInstance> historicProcessInstances = MockProvider.createMockRunningHistoricProcessInstances();
        Mockito.when((Object)mockedHistoricProcessInstanceQuery.list()).thenReturn(historicProcessInstances);
        SetJobRetriesByProcessDto body = new SetJobRetriesByProcessDto();
        body.setRetries(Integer.valueOf(-3));
        body.setHistoricProcessInstanceQuery(new HistoricProcessInstanceQueryDto());
        RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(SET_JOB_RETRIES_ASYNC_HIST_QUERY_URL, new Object[0]);
    }

    @Test
    public void testProcessInstanceModificationAsync() {
        ProcessInstanceModificationInstantiationBuilder mockModificationBuilder = this.setUpMockModificationBuilder();
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceModification(Mockito.anyString())).thenReturn((Object)mockModificationBuilder);
        Batch batchMock = MockProvider.createMockBatch();
        Mockito.when((Object)mockModificationBuilder.executeAsync(Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)batchMock);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("skipCustomListeners", Boolean.valueOf(true));
        json.put("skipIoMappings", Boolean.valueOf(true));
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.cancellation().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.cancellation().activityInstanceId("activityInstanceId").getJson());
        instructions.add(ModificationInstructionBuilder.cancellation().transitionInstanceId("transitionInstanceId").getJson());
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").ancestorActivityInstanceId("ancestorActivityInstanceId").getJson());
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("activityId").ancestorActivityInstanceId("ancestorActivityInstanceId").getJson());
        instructions.add(ModificationInstructionBuilder.startTransition().transitionId("transitionId").getJson());
        instructions.add(ModificationInstructionBuilder.startTransition().transitionId("transitionId").ancestorActivityInstanceId("ancestorActivityInstanceId").getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_MODIFICATION_ASYNC_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceModification((String)Mockito.eq((Object)"aProcessInstanceId"));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockModificationBuilder});
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).cancelAllForActivity("activityId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).cancelActivityInstance("activityInstanceId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).cancelTransitionInstance("transitionInstanceId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).startBeforeActivity("activityId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).startBeforeActivity("activityId", "ancestorActivityInstanceId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).startAfterActivity("activityId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).startAfterActivity("activityId", "ancestorActivityInstanceId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).startTransition("transitionId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).startTransition("transitionId", "ancestorActivityInstanceId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).executeAsync(true, true);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testInvalidModificationAsync() {
        HashMap json = new HashMap();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startBefore().getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"'activityId' must be set"), new Object[0]).when().post(PROCESS_INSTANCE_MODIFICATION_ASYNC_URL, new Object[0]);
        instructions = new ArrayList();
        instructions.add(ModificationInstructionBuilder.startAfter().getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"'activityId' must be set"), new Object[0]).when().post(PROCESS_INSTANCE_MODIFICATION_ASYNC_URL, new Object[0]);
        instructions = new ArrayList();
        instructions.add(ModificationInstructionBuilder.startTransition().getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"'transitionId' must be set"), new Object[0]).when().post(PROCESS_INSTANCE_MODIFICATION_ASYNC_URL, new Object[0]);
        instructions = new ArrayList();
        instructions.add(ModificationInstructionBuilder.cancellation().getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"For instruction type 'cancel': exactly one, 'activityId', 'activityInstanceId', or 'transitionInstanceId', is required"), new Object[0]).when().post(PROCESS_INSTANCE_MODIFICATION_ASYNC_URL, new Object[0]);
        instructions = new ArrayList();
        instructions.add(ModificationInstructionBuilder.cancellation().activityId("anActivityId").activityInstanceId("anActivityInstanceId").getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"For instruction type 'cancel': exactly one, 'activityId', 'activityInstanceId', or 'transitionInstanceId', is required"), new Object[0]).when().post(PROCESS_INSTANCE_MODIFICATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void testModifyProcessInstanceAsyncThrowsAuthorizationException() {
        ProcessInstanceModificationInstantiationBuilder mockModificationBuilder = this.setUpMockModificationBuilder();
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceModification(Mockito.anyString())).thenReturn((Object)mockModificationBuilder);
        String message = "expected exception";
        ((ProcessInstanceModificationInstantiationBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)mockModificationBuilder)).executeAsync(Mockito.anyBoolean(), Mockito.anyBoolean());
        HashMap json = new HashMap();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.startBefore().activityId("activityId").getJson());
        instructions.add(ModificationInstructionBuilder.startAfter().activityId("activityId").getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(PROCESS_INSTANCE_MODIFICATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void testAsyncProcessInstanceModificationWithAnnotation() {
        ProcessInstanceModificationInstantiationBuilder mockModificationBuilder = this.setUpMockModificationBuilder();
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceModification(Mockito.anyString())).thenReturn((Object)mockModificationBuilder);
        Batch batchMock = MockProvider.createMockBatch();
        Mockito.when((Object)mockModificationBuilder.executeAsync(Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)batchMock);
        HashMap<String, Object> json = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.cancellation().activityId("activityId").getJson());
        json.put("instructions", instructions);
        json.put("annotation", "anAnnotation");
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_MODIFICATION_ASYNC_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).createProcessInstanceModification((String)Mockito.eq((Object)"aProcessInstanceId"));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockModificationBuilder});
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).cancelAllForActivity("activityId");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).setAnnotation("anAnnotation");
        ((ProcessInstanceModificationInstantiationBuilder)inOrder.verify((Object)mockModificationBuilder)).executeAsync(false, false);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    public void testSyncProcessInstanceModificationCancellationSource() {
        ProcessInstanceModificationInstantiationBuilder mockModificationBuilder = this.setUpMockModificationBuilder();
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceModification(Mockito.anyString())).thenReturn((Object)mockModificationBuilder);
        HashMap json = new HashMap();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.cancellation().activityId("activityId").getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(PROCESS_INSTANCE_MODIFICATION_URL, new Object[0]);
        ((ProcessInstanceModificationInstantiationBuilder)Mockito.verify((Object)mockModificationBuilder)).cancellationSourceExternal(true);
    }

    @Test
    public void testAsyncProcessInstanceModificationCancellationSource() {
        ProcessInstanceModificationInstantiationBuilder mockModificationBuilder = this.setUpMockModificationBuilder();
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceModification(Mockito.anyString())).thenReturn((Object)mockModificationBuilder);
        Batch batchMock = MockProvider.createMockBatch();
        Mockito.when((Object)mockModificationBuilder.executeAsync(Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)batchMock);
        HashMap json = new HashMap();
        ArrayList<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
        instructions.add(ModificationInstructionBuilder.cancellation().activityId("activityId").getJson());
        json.put("instructions", instructions);
        RestAssured.given().pathParam("id", (Object)"aProcessInstanceId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_MODIFICATION_ASYNC_URL, new Object[0]);
        ((ProcessInstanceModificationInstantiationBuilder)Mockito.verify((Object)mockModificationBuilder)).cancellationSourceExternal(true);
    }

    @Test
    public void shouldSetVariablesAsync() {
        Batch batchMock = MockProvider.createMockBatch();
        Mockito.when((Object)this.runtimeServiceMock.setVariablesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.any(), (HistoricProcessInstanceQuery)Mockito.any(), (Map)Mockito.any())).thenReturn((Object)batchMock);
        SetVariablesAsyncDto body = new SetVariablesAsyncDto();
        VariableValueDto variableValueDto = new VariableValueDto();
        variableValueDto.setValue((Object)"bar");
        body.setVariables(Collections.singletonMap("foo", variableValueDto));
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_SET_VARIABLES_ASYNC_URL, new Object[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Map.class);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariablesAsync((List)Mockito.eq(null), (ProcessInstanceQuery)Mockito.eq(null), (HistoricProcessInstanceQuery)Mockito.eq(null), (Map)captor.capture());
        Assertions.assertThat(((Map)captor.getValue()).get("foo")).isEqualTo((Object)"bar");
        this.verifyBatchJson(response.asString());
    }

    @Test
    public void shouldThrowExceptionWhenSetVariablesAsync_UnsupportedType() {
        Batch batchMock = MockProvider.createMockBatch();
        Mockito.when((Object)this.runtimeServiceMock.setVariablesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.any(), (HistoricProcessInstanceQuery)Mockito.any(), (Map)Mockito.any())).thenReturn((Object)batchMock);
        SetVariablesAsyncDto body = new SetVariablesAsyncDto();
        VariableValueDto variableValueDto = new VariableValueDto();
        variableValueDto.setValue((Object)"bar");
        variableValueDto.setType("unknown");
        body.setVariables(Collections.singletonMap("foo", variableValueDto));
        RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(Matchers.containsString((String)"{\"type\":\"InvalidRequestException\",\"message\":\"Cannot set variables: Unsupported value type 'unknown'\"}"), new Matcher[0]).when().post(PROCESS_INSTANCE_SET_VARIABLES_ASYNC_URL, new Object[0]);
    }

    @Test
    public void shouldTransformProcessEngineExceptionToInvalidRequestException() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("message")}).when((Object)this.runtimeServiceMock)).setVariablesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.any(), (HistoricProcessInstanceQuery)Mockito.any(), (Map)Mockito.any());
        RestAssured.given().contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(Matchers.containsString((String)"{\"type\":\"InvalidRequestException\",\"message\":\"message\"}"), new Matcher[0]).when().post(PROCESS_INSTANCE_SET_VARIABLES_ASYNC_URL, new Object[0]);
    }

    @Test
    public void shouldThrowExceptionWhenSetVariablesAsync_AuthorizationException() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException("message")}).when((Object)this.runtimeServiceMock)).setVariablesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.any(), (HistoricProcessInstanceQuery)Mockito.any(), (Map)Mockito.any());
        RestAssured.given().contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body(Matchers.containsString((String)"{\"type\":\"AuthorizationException\""), new Matcher[0]).when().post(PROCESS_INSTANCE_SET_VARIABLES_ASYNC_URL, new Object[0]);
    }

    @Test
    public void shouldThrowExceptionWhenSetVariablesAsync_NullValueException() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new NullValueException("message")}).when((Object)this.runtimeServiceMock)).setVariablesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.any(), (HistoricProcessInstanceQuery)Mockito.any(), (Map)Mockito.any());
        RestAssured.given().contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(Matchers.containsString((String)"{\"type\":\"InvalidRequestException\",\"message\":\"message\"}"), new Matcher[0]).when().post(PROCESS_INSTANCE_SET_VARIABLES_ASYNC_URL, new Object[0]);
    }

    @Test
    public void shouldThrowExceptionWhenSetVariablesAsync_BadUserRequestException() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("message")}).when((Object)this.runtimeServiceMock)).setVariablesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.any(), (HistoricProcessInstanceQuery)Mockito.any(), (Map)Mockito.any());
        RestAssured.given().contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(Matchers.containsString((String)"{\"type\":\"BadUserRequestException\",\"message\":\"message\"}"), new Matcher[0]).when().post(PROCESS_INSTANCE_SET_VARIABLES_ASYNC_URL, new Object[0]);
    }

    @Test
    public void shouldSetVariablesAsync_RuntimeQuery() {
        Batch batchMock = MockProvider.createMockBatch();
        Mockito.when((Object)this.runtimeServiceMock.setVariablesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.any(), (HistoricProcessInstanceQuery)Mockito.any(), (Map)Mockito.any())).thenReturn((Object)batchMock);
        ProcessInstanceQuery mockedProcessInstanceQuery = (ProcessInstanceQuery)Mockito.mock(ProcessInstanceQuery.class);
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceQuery()).thenReturn((Object)mockedProcessInstanceQuery);
        SetVariablesAsyncDto body = new SetVariablesAsyncDto();
        ProcessInstanceQueryDto processInstanceQueryDto = new ProcessInstanceQueryDto();
        processInstanceQueryDto.setProcessDefinitionId("foo");
        body.setProcessInstanceQuery(processInstanceQueryDto);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_SET_VARIABLES_ASYNC_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)mockedProcessInstanceQuery)).processDefinitionId("foo");
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariablesAsync((List)Mockito.eq(null), (ProcessInstanceQuery)Mockito.eq((Object)mockedProcessInstanceQuery), (HistoricProcessInstanceQuery)Mockito.eq(null), (Map)Mockito.eq(null));
        this.verifyBatchJson(response.asString());
    }

    @Test
    public void shouldSetVariablesAsync_HistoryQuery() {
        Batch batchMock = MockProvider.createMockBatch();
        Mockito.when((Object)this.runtimeServiceMock.setVariablesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.any(), (HistoricProcessInstanceQuery)Mockito.any(), (Map)Mockito.any())).thenReturn((Object)batchMock);
        HistoricProcessInstanceQuery mockedHistoricProcessInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQuery.class);
        Mockito.when((Object)this.historyServiceMock.createHistoricProcessInstanceQuery()).thenReturn((Object)mockedHistoricProcessInstanceQuery);
        SetVariablesAsyncDto body = new SetVariablesAsyncDto();
        HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto = new HistoricProcessInstanceQueryDto();
        historicProcessInstanceQueryDto.setProcessDefinitionId("foo");
        body.setHistoricProcessInstanceQuery(historicProcessInstanceQueryDto);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_SET_VARIABLES_ASYNC_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)mockedHistoricProcessInstanceQuery)).processDefinitionId("foo");
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariablesAsync((List)Mockito.eq(null), (ProcessInstanceQuery)Mockito.eq(null), (HistoricProcessInstanceQuery)Mockito.eq((Object)mockedHistoricProcessInstanceQuery), (Map)Mockito.eq(null));
        this.verifyBatchJson(response.asString());
    }

    @Test
    public void shouldSetVariablesAsync_ByIds() {
        Batch batchMock = MockProvider.createMockBatch();
        Mockito.when((Object)this.runtimeServiceMock.setVariablesAsync((List)Mockito.any(), (ProcessInstanceQuery)Mockito.any(), (HistoricProcessInstanceQuery)Mockito.any(), (Map)Mockito.any())).thenReturn((Object)batchMock);
        SetVariablesAsyncDto body = new SetVariablesAsyncDto();
        List<String> processInstanceIds = Arrays.asList("foo", "bar");
        body.setProcessInstanceIds(processInstanceIds);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_SET_VARIABLES_ASYNC_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).setVariablesAsync((List)Mockito.eq(processInstanceIds), (ProcessInstanceQuery)Mockito.eq(null), (HistoricProcessInstanceQuery)Mockito.eq(null), (Map)Mockito.eq(null));
        this.verifyBatchJson(response.asString());
    }

    @Test
    public void shouldCorrelateMessageAsync() {
        Batch batchMock = MockProvider.createMockBatch();
        MessageCorrelationAsyncBuilder builderMock = (MessageCorrelationAsyncBuilder)Mockito.mock(MessageCorrelationAsyncBuilder.class, RETURNS_SELF);
        Mockito.when((Object)builderMock.correlateAllAsync()).thenReturn((Object)batchMock);
        Mockito.when((Object)this.runtimeServiceMock.createMessageCorrelationAsync((String)Mockito.any())).thenReturn((Object)builderMock);
        CorrelationMessageAsyncDto body = new CorrelationMessageAsyncDto();
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_CORRELATE_MESSAGE_ASYNC_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelationAsync(null);
        ((MessageCorrelationAsyncBuilder)Mockito.verify((Object)builderMock)).correlateAllAsync();
        this.verifyBatchJson(response.asString());
    }

    @Test
    public void shouldNotTransformProcessEngineExceptionToInvalidRequestExceptionWhenCorrelateMessageAsync() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("message")}).when((Object)this.runtimeServiceMock)).createMessageCorrelationAsync((String)Mockito.any());
        RestAssured.given().contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body(Matchers.containsString((String)"{\"type\":\"ProcessEngineException\",\"message\":\"message\"}"), new Matcher[0]).when().post(PROCESS_INSTANCE_CORRELATE_MESSAGE_ASYNC_URL, new Object[0]);
    }

    @Test
    public void shouldThrowExceptionWhenCorrelateMessageAsync_AuthorizationException() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException("message")}).when((Object)this.runtimeServiceMock)).createMessageCorrelationAsync((String)Mockito.any());
        RestAssured.given().contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body(Matchers.containsString((String)"{\"type\":\"AuthorizationException\""), new Matcher[0]).when().post(PROCESS_INSTANCE_CORRELATE_MESSAGE_ASYNC_URL, new Object[0]);
    }

    @Test
    public void shouldThrowExceptionWhenCorrelateMessageAsync_NullValueException() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new NullValueException("message")}).when((Object)this.runtimeServiceMock)).createMessageCorrelationAsync((String)Mockito.any());
        RestAssured.given().contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(Matchers.containsString((String)"{\"type\":\"InvalidRequestException\",\"message\":\"message\"}"), new Matcher[0]).when().post(PROCESS_INSTANCE_CORRELATE_MESSAGE_ASYNC_URL, new Object[0]);
    }

    @Test
    public void shouldThrowExceptionWhenCorrelateMessageAsync_BadUserRequestException() {
        ((RuntimeServiceImpl)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("message")}).when((Object)this.runtimeServiceMock)).createMessageCorrelationAsync((String)Mockito.any());
        RestAssured.given().contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(Matchers.containsString((String)"{\"type\":\"BadUserRequestException\",\"message\":\"message\"}"), new Matcher[0]).when().post(PROCESS_INSTANCE_CORRELATE_MESSAGE_ASYNC_URL, new Object[0]);
    }

    @Test
    public void shouldCorrelateMessageAsync_RuntimeQuery() {
        Batch batchMock = MockProvider.createMockBatch();
        MessageCorrelationAsyncBuilder builderMock = (MessageCorrelationAsyncBuilder)Mockito.mock(MessageCorrelationAsyncBuilder.class, RETURNS_SELF);
        Mockito.when((Object)builderMock.correlateAllAsync()).thenReturn((Object)batchMock);
        Mockito.when((Object)this.runtimeServiceMock.createMessageCorrelationAsync((String)Mockito.any())).thenReturn((Object)builderMock);
        ProcessInstanceQuery mockedProcessInstanceQuery = (ProcessInstanceQuery)Mockito.mock(ProcessInstanceQuery.class);
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceQuery()).thenReturn((Object)mockedProcessInstanceQuery);
        CorrelationMessageAsyncDto body = new CorrelationMessageAsyncDto();
        ProcessInstanceQueryDto processInstanceQueryDto = new ProcessInstanceQueryDto();
        processInstanceQueryDto.setProcessDefinitionId("foo");
        body.setProcessInstanceQuery(processInstanceQueryDto);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_CORRELATE_MESSAGE_ASYNC_URL, new Object[0]);
        ((ProcessInstanceQuery)Mockito.verify((Object)mockedProcessInstanceQuery)).processDefinitionId("foo");
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelationAsync(null);
        ((MessageCorrelationAsyncBuilder)Mockito.verify((Object)builderMock)).processInstanceQuery(mockedProcessInstanceQuery);
        ((MessageCorrelationAsyncBuilder)Mockito.verify((Object)builderMock)).correlateAllAsync();
        this.verifyBatchJson(response.asString());
    }

    @Test
    public void shouldCorrelateMessageAsync_HistoryQuery() {
        Batch batchMock = MockProvider.createMockBatch();
        MessageCorrelationAsyncBuilder builderMock = (MessageCorrelationAsyncBuilder)Mockito.mock(MessageCorrelationAsyncBuilder.class, RETURNS_SELF);
        Mockito.when((Object)builderMock.correlateAllAsync()).thenReturn((Object)batchMock);
        Mockito.when((Object)this.runtimeServiceMock.createMessageCorrelationAsync((String)Mockito.any())).thenReturn((Object)builderMock);
        HistoricProcessInstanceQuery mockedHistoricProcessInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQuery.class);
        Mockito.when((Object)this.historyServiceMock.createHistoricProcessInstanceQuery()).thenReturn((Object)mockedHistoricProcessInstanceQuery);
        CorrelationMessageAsyncDto body = new CorrelationMessageAsyncDto();
        HistoricProcessInstanceQueryDto historicProcessInstanceQueryDto = new HistoricProcessInstanceQueryDto();
        historicProcessInstanceQueryDto.setProcessDefinitionId("foo");
        body.setHistoricProcessInstanceQuery(historicProcessInstanceQueryDto);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_CORRELATE_MESSAGE_ASYNC_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)mockedHistoricProcessInstanceQuery)).processDefinitionId("foo");
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelationAsync(null);
        ((MessageCorrelationAsyncBuilder)Mockito.verify((Object)builderMock)).historicProcessInstanceQuery(mockedHistoricProcessInstanceQuery);
        ((MessageCorrelationAsyncBuilder)Mockito.verify((Object)builderMock)).correlateAllAsync();
        this.verifyBatchJson(response.asString());
    }

    @Test
    public void shouldCorrelateMessageAsync_ByIds() {
        Batch batchMock = MockProvider.createMockBatch();
        MessageCorrelationAsyncBuilder builderMock = (MessageCorrelationAsyncBuilder)Mockito.mock(MessageCorrelationAsyncBuilder.class, RETURNS_SELF);
        Mockito.when((Object)builderMock.correlateAllAsync()).thenReturn((Object)batchMock);
        Mockito.when((Object)this.runtimeServiceMock.createMessageCorrelationAsync((String)Mockito.any())).thenReturn((Object)builderMock);
        CorrelationMessageAsyncDto body = new CorrelationMessageAsyncDto();
        List<String> processInstanceIds = Arrays.asList("foo", "bar");
        body.setProcessInstanceIds(processInstanceIds);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body((Object)body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(PROCESS_INSTANCE_CORRELATE_MESSAGE_ASYNC_URL, new Object[0]);
        ((RuntimeServiceImpl)Mockito.verify((Object)this.runtimeServiceMock)).createMessageCorrelationAsync(null);
        ((MessageCorrelationAsyncBuilder)Mockito.verify((Object)builderMock)).processInstanceIds(processInstanceIds);
        ((MessageCorrelationAsyncBuilder)Mockito.verify((Object)builderMock)).correlateAllAsync();
        this.verifyBatchJson(response.asString());
    }

    protected ProcessInstanceModificationInstantiationBuilder setUpMockModificationBuilder() {
        ProcessInstanceModificationInstantiationBuilder mockModificationBuilder = (ProcessInstanceModificationInstantiationBuilder)Mockito.mock(ProcessInstanceModificationInstantiationBuilder.class);
        Mockito.when((Object)mockModificationBuilder.cancelActivityInstance(Mockito.anyString())).thenReturn((Object)mockModificationBuilder);
        Mockito.when((Object)mockModificationBuilder.cancelAllForActivity(Mockito.anyString())).thenReturn((Object)mockModificationBuilder);
        Mockito.when((Object)mockModificationBuilder.cancellationSourceExternal(Mockito.anyBoolean())).thenReturn((Object)mockModificationBuilder);
        Mockito.when((Object)((ProcessInstanceModificationInstantiationBuilder)mockModificationBuilder.startAfterActivity(Mockito.anyString()))).thenReturn((Object)mockModificationBuilder);
        Mockito.when((Object)mockModificationBuilder.startAfterActivity(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)mockModificationBuilder);
        Mockito.when((Object)((ProcessInstanceModificationInstantiationBuilder)mockModificationBuilder.startBeforeActivity(Mockito.anyString()))).thenReturn((Object)mockModificationBuilder);
        Mockito.when((Object)mockModificationBuilder.startBeforeActivity(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)mockModificationBuilder);
        Mockito.when((Object)((ProcessInstanceModificationInstantiationBuilder)mockModificationBuilder.startTransition(Mockito.anyString()))).thenReturn((Object)mockModificationBuilder);
        Mockito.when((Object)mockModificationBuilder.startTransition(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)mockModificationBuilder);
        Mockito.when((Object)((ProcessInstanceModificationInstantiationBuilder)mockModificationBuilder.setVariables((Map)Mockito.any(Map.class)))).thenReturn((Object)mockModificationBuilder);
        Mockito.when((Object)((ProcessInstanceModificationInstantiationBuilder)mockModificationBuilder.setVariablesLocal((Map)Mockito.any(Map.class)))).thenReturn((Object)mockModificationBuilder);
        return mockModificationBuilder;
    }

    protected void verifyBatchJson(String batchJson) {
        BatchDto batch = (BatchDto)JsonPathUtil.from(batchJson).getObject("", BatchDto.class);
        Assert.assertNotNull((String)"The returned batch should not be null.", (Object)batch);
        Assert.assertEquals((Object)"aBatchId", (Object)batch.getId());
        Assert.assertEquals((Object)"aBatchType", (Object)batch.getType());
        Assert.assertEquals((long)10L, (long)batch.getTotalJobs());
        Assert.assertEquals((long)11L, (long)batch.getBatchJobsPerSeed());
        Assert.assertEquals((long)12L, (long)batch.getInvocationsPerBatchJob());
        Assert.assertEquals((Object)"aSeedJobDefinitionId", (Object)batch.getSeedJobDefinitionId());
        Assert.assertEquals((Object)"aMonitorJobDefinitionId", (Object)batch.getMonitorJobDefinitionId());
        Assert.assertEquals((Object)"aBatchJobDefinitionId", (Object)batch.getBatchJobDefinitionId());
        Assert.assertEquals((Object)"aTenantId", (Object)batch.getTenantId());
    }

    static {
        ExampleVariableObject variableValue = new ExampleVariableObject();
        variableValue.setProperty1("aPropertyValue");
        variableValue.setProperty2(true);
        EXAMPLE_OBJECT_VARIABLES.putValueTyped("aVariableKey", (TypedValue)MockObjectValue.fromObjectValue((ObjectValue)Variables.objectValue((Object)variableValue).serializationDataFormat("application/json").create()).objectTypeName(ExampleVariableObject.class.getName()));
    }
}

