/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.batch.history.HistoricBatchQuery;
import org.camunda.bpm.engine.history.SetRemovalTimeSelectModeForHistoricBatchesBuilder;
import org.camunda.bpm.engine.history.SetRemovalTimeToHistoricBatchesBuilder;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.batch.BatchDto;
import org.camunda.bpm.engine.rest.dto.history.batch.HistoricBatchDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.JsonPathUtil;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class HistoricBatchRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_BATCH_RESOURCE_URL = "/rest-test/history/batch";
    protected static final String HISTORIC_SINGLE_BATCH_RESOURCE_URL = "/rest-test/history/batch/{id}";
    protected static final String SET_REMOVAL_TIME_HISTORIC_BATCHES_ASYNC_URL = "/rest-test/history/batch/set-removal-time";
    protected HistoryService historyServiceMock;
    protected HistoricBatchQuery queryMock;

    @Before
    public void setUpHistoricBatchQueryMock() {
        HistoricBatch historicBatchMock = MockProvider.createMockHistoricBatch();
        this.queryMock = (HistoricBatchQuery)Mockito.mock(HistoricBatchQuery.class);
        Mockito.when((Object)this.queryMock.batchId((String)Mockito.eq((Object)"aBatchId"))).thenReturn((Object)this.queryMock);
        Mockito.when((Object)((HistoricBatch)this.queryMock.singleResult())).thenReturn((Object)historicBatchMock);
        this.historyServiceMock = (HistoryService)Mockito.mock(HistoryService.class);
        Mockito.when((Object)this.historyServiceMock.createHistoricBatchQuery()).thenReturn((Object)this.queryMock);
        Mockito.when((Object)processEngine.getHistoryService()).thenReturn((Object)this.historyServiceMock);
    }

    @Test
    public void testGetHistoricBatch() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aBatchId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_SINGLE_BATCH_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.queryMock});
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).batchId("aBatchId");
        ((HistoricBatchQuery)inOrder.verify((Object)this.queryMock)).singleResult();
        inOrder.verifyNoMoreInteractions();
        this.verifyHistoricBatchJson(response.asString());
    }

    @Test
    public void testGetNonExistingHistoricBatch() {
        String nonExistingId = "nonExistingId";
        HistoricBatchQuery historicBatchQuery = (HistoricBatchQuery)Mockito.mock(HistoricBatchQuery.class);
        Mockito.when((Object)historicBatchQuery.batchId(nonExistingId)).thenReturn((Object)historicBatchQuery);
        Mockito.when((Object)((HistoricBatch)historicBatchQuery.singleResult())).thenReturn(null);
        Mockito.when((Object)this.historyServiceMock.createHistoricBatchQuery()).thenReturn((Object)historicBatchQuery);
        RestAssured.given().pathParam("id", (Object)nonExistingId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Historic batch with id '" + nonExistingId + "' does not exist")), new Object[0]).when().get(HISTORIC_SINGLE_BATCH_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void deleteHistoricBatch() {
        RestAssured.given().pathParam("id", (Object)"aBatchId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(HISTORIC_SINGLE_BATCH_RESOURCE_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.historyServiceMock)).deleteHistoricBatch((String)Mockito.eq((Object)"aBatchId"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.historyServiceMock});
    }

    @Test
    public void deleteNonExistingHistoricBatch() {
        String nonExistingId = "nonExistingId";
        ((HistoryService)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("Historic batch for id '" + nonExistingId + "' cannot be found")}).when((Object)this.historyServiceMock)).deleteHistoricBatch((String)Mockito.eq((Object)nonExistingId));
        RestAssured.given().pathParam("id", (Object)nonExistingId).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Unable to delete historic batch with id '" + nonExistingId + "'")), new Object[0]).when().delete(HISTORIC_SINGLE_BATCH_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void shouldSetRemovalTime_ByIds() {
        SetRemovalTimeSelectModeForHistoricBatchesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricBatchesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricBatches()).thenReturn((Object)builderMock);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("historicBatchIds", Collections.singletonList("aBatchId"));
        payload.put("calculatedRemovalTime", true);
        RestAssured.given().contentType(ContentType.JSON).body(payload).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_BATCHES_ASYNC_URL, new Object[0]);
        SetRemovalTimeSelectModeForHistoricBatchesBuilder builder = this.historyServiceMock.setRemovalTimeToHistoricBatches();
        ((SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.verify((Object)builder)).calculatedRemovalTime();
        ((SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.verify((Object)builder)).byIds(new String[]{"aBatchId"});
        ((SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.verify((Object)builder)).byQuery(null);
        ((SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.verify((Object)builder)).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{builder});
    }

    @Test
    public void shouldSetRemovalTime_ByQuery() {
        SetRemovalTimeSelectModeForHistoricBatchesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricBatchesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricBatches()).thenReturn((Object)builderMock);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("calculatedRemovalTime", true);
        payload.put("historicBatchQuery", Collections.singletonMap("batchId", "aBatchId"));
        RestAssured.given().contentType(ContentType.JSON).body(payload).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_BATCHES_ASYNC_URL, new Object[0]);
        SetRemovalTimeSelectModeForHistoricBatchesBuilder builder = this.historyServiceMock.setRemovalTimeToHistoricBatches();
        ((HistoricBatchQuery)Mockito.verify((Object)this.queryMock)).batchId("aBatchId");
        ((SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.verify((Object)builder)).calculatedRemovalTime();
        ((SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.verify((Object)builder)).byIds(null);
        ((SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.verify((Object)builder)).byQuery(this.queryMock);
        ((SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.verify((Object)builder)).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{builder});
    }

    @Test
    public void shouldSetRemovalTime_Absolute() {
        Date removalTime = new Date();
        SetRemovalTimeSelectModeForHistoricBatchesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricBatchesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricBatches()).thenReturn((Object)builderMock);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("historicBatchIds", Collections.singletonList("aBatchId"));
        payload.put("absoluteRemovalTime", removalTime);
        RestAssured.given().contentType(ContentType.JSON).body(payload).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_BATCHES_ASYNC_URL, new Object[0]);
        SetRemovalTimeSelectModeForHistoricBatchesBuilder builder = this.historyServiceMock.setRemovalTimeToHistoricBatches();
        ((SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.verify((Object)builder)).absoluteRemovalTime(removalTime);
        ((SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.verify((Object)builder)).byIds(new String[]{"aBatchId"});
        ((SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.verify((Object)builder)).byQuery(null);
        ((SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.verify((Object)builder)).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{builder});
    }

    @Test
    public void shouldNotSetRemovalTime_Absolute() {
        SetRemovalTimeSelectModeForHistoricBatchesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricBatchesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricBatches()).thenReturn((Object)builderMock);
        HashMap<String, List<String>> payload = new HashMap<String, List<String>>();
        payload.put("historicBatchIds", Collections.singletonList("aBatchId"));
        payload.put("absoluteRemovalTime", null);
        RestAssured.given().contentType(ContentType.JSON).body(payload).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_BATCHES_ASYNC_URL, new Object[0]);
        SetRemovalTimeSelectModeForHistoricBatchesBuilder builder = this.historyServiceMock.setRemovalTimeToHistoricBatches();
        ((SetRemovalTimeToHistoricBatchesBuilder)Mockito.verify((Object)builder)).byIds(new String[]{"aBatchId"});
        ((SetRemovalTimeToHistoricBatchesBuilder)Mockito.verify((Object)builder)).byQuery(null);
        ((SetRemovalTimeToHistoricBatchesBuilder)Mockito.verify((Object)builder)).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{builder});
    }

    @Test
    public void shouldClearRemovalTime() {
        SetRemovalTimeSelectModeForHistoricBatchesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricBatchesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricBatches()).thenReturn((Object)builderMock);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        payload.put("historicBatchIds", Collections.singletonList("aBatchId"));
        payload.put("clearedRemovalTime", true);
        RestAssured.given().contentType(ContentType.JSON).body(payload).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_BATCHES_ASYNC_URL, new Object[0]);
        SetRemovalTimeSelectModeForHistoricBatchesBuilder builder = this.historyServiceMock.setRemovalTimeToHistoricBatches();
        ((SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.verify((Object)builder)).clearedRemovalTime();
        ((SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.verify((Object)builder)).byIds(new String[]{"aBatchId"});
        ((SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.verify((Object)builder)).byQuery(null);
        ((SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.verify((Object)builder)).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{builder});
    }

    @Test
    public void shouldSetRemovalTime_Response() {
        SetRemovalTimeSelectModeForHistoricBatchesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricBatchesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricBatches()).thenReturn((Object)builderMock);
        Batch batchEntity = MockProvider.createMockBatch();
        Mockito.when((Object)builderMock.executeAsync()).thenReturn((Object)batchEntity);
        Response response = (Response)RestAssured.given().contentType(ContentType.JSON).body(Collections.emptyMap()).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_BATCHES_ASYNC_URL, new Object[0]);
        this.verifyBatchJson(response.asString());
    }

    @Test
    public void shouldSetRemovalTime_ThrowBadUserException() {
        SetRemovalTimeSelectModeForHistoricBatchesBuilder builderMock = (SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.mock(SetRemovalTimeSelectModeForHistoricBatchesBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.historyServiceMock.setRemovalTimeToHistoricBatches()).thenReturn((Object)builderMock);
        ((SetRemovalTimeSelectModeForHistoricBatchesBuilder)Mockito.doThrow(BadUserRequestException.class).when((Object)builderMock)).executeAsync();
        RestAssured.given().contentType(ContentType.JSON).body(Collections.emptyMap()).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(SET_REMOVAL_TIME_HISTORIC_BATCHES_ASYNC_URL, new Object[0]);
    }

    protected void verifyBatchJson(String batchJson) {
        BatchDto batch = (BatchDto)JsonPathUtil.from(batchJson).getObject("", BatchDto.class);
        Assert.assertNotNull((String)"The returned batch should not be null.", (Object)batch);
        Assert.assertEquals((Object)"aBatchId", (Object)batch.getId());
        Assert.assertEquals((Object)"aBatchType", (Object)batch.getType());
        Assert.assertEquals((long)10L, (long)batch.getTotalJobs());
        Assert.assertEquals((long)11L, (long)batch.getBatchJobsPerSeed());
        Assert.assertEquals((long)12L, (long)batch.getInvocationsPerBatchJob());
        Assert.assertEquals((Object)"aSeedJobDefinitionId", (Object)batch.getSeedJobDefinitionId());
        Assert.assertEquals((Object)"aMonitorJobDefinitionId", (Object)batch.getMonitorJobDefinitionId());
        Assert.assertEquals((Object)"aBatchJobDefinitionId", (Object)batch.getBatchJobDefinitionId());
        Assert.assertEquals((Object)"aTenantId", (Object)batch.getTenantId());
    }

    protected void verifyHistoricBatchJson(String historicBatchJson) {
        HistoricBatchDto historicBatch = (HistoricBatchDto)JsonPathUtil.from(historicBatchJson).getObject("", HistoricBatchDto.class);
        Assert.assertNotNull((String)"The returned historic batch should not be null.", (Object)historicBatch);
        Assert.assertEquals((Object)"aBatchId", (Object)historicBatch.getId());
        Assert.assertEquals((Object)"aBatchType", (Object)historicBatch.getType());
        Assert.assertEquals((long)10L, (long)historicBatch.getTotalJobs());
        Assert.assertEquals((long)11L, (long)historicBatch.getBatchJobsPerSeed());
        Assert.assertEquals((long)12L, (long)historicBatch.getInvocationsPerBatchJob());
        Assert.assertEquals((Object)"aSeedJobDefinitionId", (Object)historicBatch.getSeedJobDefinitionId());
        Assert.assertEquals((Object)"aMonitorJobDefinitionId", (Object)historicBatch.getMonitorJobDefinitionId());
        Assert.assertEquals((Object)"aBatchJobDefinitionId", (Object)historicBatch.getBatchJobDefinitionId());
        Assert.assertEquals((Object)"aTenantId", (Object)historicBatch.getTenantId());
        Assert.assertEquals((Object)"userId", (Object)historicBatch.getCreateUserId());
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_BATCH_START_TIME), (Object)historicBatch.getStartTime());
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_BATCH_END_TIME), (Object)historicBatch.getEndTime());
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_BATCH_REMOVAL_TIME), (Object)historicBatch.getRemovalTime());
    }
}

