/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.standalone;

import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.ProcessInstanceWithVariables;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class AbstractEmptyBodyFilterTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String TEST_RESOURCE_ROOT_PATH = "/rest-test/rest";
    protected static final String PROCESS_DEFINITION_URL = "/rest-test/rest/process-definition";
    protected static final String SINGLE_PROCESS_DEFINITION_BY_KEY_URL = "/rest-test/rest/process-definition/key/aKey";
    protected static final String START_PROCESS_INSTANCE_BY_KEY_URL = "/rest-test/rest/process-definition/key/aKey/start";
    protected ProcessInstantiationBuilder mockInstantiationBuilder;
    protected RuntimeService runtimeServiceMock;
    protected CloseableHttpClient client;
    protected RequestConfig reqConfig;
    protected final String BASE_URL = "http://localhost:38080";

    @Before
    public void setUpHttpClientAndRuntimeData() {
        this.client = HttpClients.createDefault();
        this.reqConfig = RequestConfig.custom().setConnectTimeout(180000).setSocketTimeout(600000).build();
        ProcessDefinition mockDefinition = MockProvider.createMockDefinition();
        this.runtimeServiceMock = (RuntimeService)Mockito.mock(RuntimeService.class);
        Mockito.when((Object)processEngine.getRuntimeService()).thenReturn((Object)this.runtimeServiceMock);
        this.mockInstantiationBuilder = (ProcessInstantiationBuilder)Mockito.mock(ProcessInstantiationBuilder.class);
        Mockito.when((Object)((ProcessInstantiationBuilder)this.mockInstantiationBuilder.setVariables((Map)Mockito.any()))).thenReturn((Object)this.mockInstantiationBuilder);
        Mockito.when((Object)this.mockInstantiationBuilder.businessKey((String)Mockito.any())).thenReturn((Object)this.mockInstantiationBuilder);
        Mockito.when((Object)this.mockInstantiationBuilder.caseInstanceId((String)Mockito.any())).thenReturn((Object)this.mockInstantiationBuilder);
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceById((String)Mockito.any())).thenReturn((Object)this.mockInstantiationBuilder);
        ProcessInstanceWithVariables resultInstanceWithVariables = MockProvider.createMockInstanceWithVariables();
        Mockito.when((Object)this.mockInstantiationBuilder.executeWithVariablesInReturn(Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)resultInstanceWithVariables);
        ProcessDefinitionQuery processDefinitionQueryMock = (ProcessDefinitionQuery)Mockito.mock(ProcessDefinitionQuery.class);
        Mockito.when((Object)processDefinitionQueryMock.processDefinitionKey("aKey")).thenReturn((Object)processDefinitionQueryMock);
        Mockito.when((Object)processDefinitionQueryMock.withoutTenantId()).thenReturn((Object)processDefinitionQueryMock);
        Mockito.when((Object)processDefinitionQueryMock.latestVersion()).thenReturn((Object)processDefinitionQueryMock);
        Mockito.when((Object)((ProcessDefinition)processDefinitionQueryMock.singleResult())).thenReturn((Object)mockDefinition);
        RepositoryService repositoryServiceMock = (RepositoryService)Mockito.mock(RepositoryService.class);
        Mockito.when((Object)processEngine.getRepositoryService()).thenReturn((Object)repositoryServiceMock);
        Mockito.when((Object)repositoryServiceMock.createProcessDefinitionQuery()).thenReturn((Object)processDefinitionQueryMock);
    }

    @After
    public void tearDown() throws IOException {
        this.client.close();
    }

    @Test
    public void testBodyIsEmpty() throws IOException {
        this.evaluatePostRequest((HttpEntity)new ByteArrayEntity("".getBytes("UTF-8")), ContentType.create((String)"application/json").toString(), 200, true);
    }

    @Test
    public void testBodyIsNull() throws IOException {
        this.evaluatePostRequest(null, ContentType.create((String)"application/json").toString(), 200, true);
    }

    @Test
    public void testBodyIsNullAndContentTypeIsNull() throws IOException {
        this.evaluatePostRequest(null, null, 415, false);
    }

    @Test
    public void testBodyIsNullAndContentTypeHasISOCharset() throws IOException {
        this.evaluatePostRequest(null, ContentType.create((String)"application/json", (String)"iso-8859-1").toString(), 200, true);
    }

    @Test
    public void testBodyIsEmptyJSONObject() throws IOException {
        this.evaluatePostRequest((HttpEntity)new ByteArrayEntity("{}".getBytes("UTF-8")), ContentType.create((String)"application/json").toString(), 200, true);
    }

    private void evaluatePostRequest(HttpEntity reqBody, String reqContentType, int expectedStatusCode, boolean assertResponseBody) throws IOException {
        HttpPost post = new HttpPost("http://localhost:38080/rest-test/rest/process-definition/key/aKey/start");
        post.setConfig(this.reqConfig);
        if (reqContentType != null) {
            post.setHeader("Content-Type", reqContentType);
        }
        post.setEntity(reqBody);
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)post);
        Assert.assertEquals((long)expectedStatusCode, (long)response.getStatusLine().getStatusCode());
        if (assertResponseBody) {
            MatcherAssert.assertThat((Object)EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8"), (Matcher)CoreMatchers.containsString((String)"aProcInstId"));
        }
        response.close();
    }
}

