/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricCaseInstanceQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.VariableQueryParameterDto;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringSetConverter;
import org.camunda.bpm.engine.rest.dto.converter.VariableListConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;

public class HistoricCaseInstanceQueryDto
extends AbstractQueryDto<HistoricCaseInstanceQuery> {
    public static final String SORT_BY_CASE_INSTANCE_ID_VALUE = "instanceId";
    public static final String SORT_BY_CASE_DEFINITION_ID_VALUE = "definitionId";
    public static final String SORT_BY_CASE_INSTANCE_BUSINESS_KEY_VALUE = "businessKey";
    public static final String SORT_BY_CASE_INSTANCE_CREATE_TIME_VALUE = "createTime";
    public static final String SORT_BY_CASE_INSTANCE_CLOSE_TIME_VALUE = "closeTime";
    public static final String SORT_BY_CASE_INSTANCE_DURATION_VALUE = "duration";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    public static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    public String caseInstanceId;
    public Set<String> caseInstanceIds;
    public String caseDefinitionId;
    public String caseDefinitionKey;
    public String caseDefinitionName;
    public String caseDefinitionNameLike;
    public List<String> caseDefinitionKeyNotIn;
    public String caseInstanceBusinessKey;
    public String caseInstanceBusinessKeyLike;
    public String superCaseInstanceId;
    public String subCaseInstanceId;
    private String superProcessInstanceId;
    private String subProcessInstanceId;
    private List<String> tenantIds;
    private Boolean withoutTenantId;
    public String createdBy;
    public List<String> caseActivityIdIn;
    public Date createdBefore;
    public Date createdAfter;
    public Date closedBefore;
    public Date closedAfter;
    public Boolean active;
    public Boolean completed;
    public Boolean terminated;
    public Boolean closed;
    public Boolean notClosed;
    protected List<VariableQueryParameterDto> variables;
    protected Boolean variableValuesIgnoreCase;
    protected Boolean variableNamesIgnoreCase;

    public HistoricCaseInstanceQueryDto() {
    }

    public HistoricCaseInstanceQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @CamundaQueryParam(value="caseInstanceIds", converter=StringSetConverter.class)
    public void setCaseInstanceIds(Set<String> caseInstanceIds) {
        this.caseInstanceIds = caseInstanceIds;
    }

    @CamundaQueryParam(value="caseDefinitionId")
    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @CamundaQueryParam(value="caseDefinitionName")
    public void setCaseDefinitionName(String caseDefinitionName) {
        this.caseDefinitionName = caseDefinitionName;
    }

    @CamundaQueryParam(value="caseDefinitionNameLike")
    public void setCaseDefinitionNameLike(String caseDefinitionNameLike) {
        this.caseDefinitionNameLike = caseDefinitionNameLike;
    }

    @CamundaQueryParam(value="caseDefinitionKey")
    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    @CamundaQueryParam(value="caseDefinitionKeyNotIn", converter=StringListConverter.class)
    public void setCaseDefinitionKeyNotIn(List<String> caseDefinitionKeys) {
        this.caseDefinitionKeyNotIn = caseDefinitionKeys;
    }

    @CamundaQueryParam(value="caseInstanceBusinessKey")
    public void setCaseInstanceBusinessKey(String caseInstanceBusinessKey) {
        this.caseInstanceBusinessKey = caseInstanceBusinessKey;
    }

    @CamundaQueryParam(value="caseInstanceBusinessKeyLike")
    public void setCaseInstanceBusinessKeyLike(String caseInstanceBusinessKeyLike) {
        this.caseInstanceBusinessKeyLike = caseInstanceBusinessKeyLike;
    }

    @CamundaQueryParam(value="superCaseInstanceId")
    public void setSuperCaseInstanceId(String superCaseInstanceId) {
        this.superCaseInstanceId = superCaseInstanceId;
    }

    @CamundaQueryParam(value="subCaseInstanceId")
    public void setSubCaseInstanceId(String subCaseInstanceId) {
        this.subCaseInstanceId = subCaseInstanceId;
    }

    @CamundaQueryParam(value="superProcessInstanceId")
    public void setSuperProcessInstanceId(String superProcessInstanceId) {
        this.superProcessInstanceId = superProcessInstanceId;
    }

    @CamundaQueryParam(value="subProcessInstanceId")
    public void setSubProcessInstanceId(String subProcessInstanceId) {
        this.subProcessInstanceId = subProcessInstanceId;
    }

    @CamundaQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @CamundaQueryParam(value="withoutTenantId", converter=BooleanConverter.class)
    public void setWithoutTenantId(Boolean withoutTenantId) {
        this.withoutTenantId = withoutTenantId;
    }

    @CamundaQueryParam(value="createdBy")
    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @CamundaQueryParam(value="createdBefore", converter=DateConverter.class)
    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
    }

    @CamundaQueryParam(value="createdAfter", converter=DateConverter.class)
    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
    }

    @CamundaQueryParam(value="closedBefore", converter=DateConverter.class)
    public void setClosedBefore(Date closedBefore) {
        this.closedBefore = closedBefore;
    }

    @CamundaQueryParam(value="closedAfter", converter=DateConverter.class)
    public void setClosedAfter(Date closedAfter) {
        this.closedAfter = closedAfter;
    }

    @CamundaQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @CamundaQueryParam(value="completed", converter=BooleanConverter.class)
    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    @CamundaQueryParam(value="terminated", converter=BooleanConverter.class)
    public void setTerminated(Boolean terminated) {
        this.terminated = terminated;
    }

    @CamundaQueryParam(value="closed", converter=BooleanConverter.class)
    public void setClosed(Boolean closed) {
        this.closed = closed;
    }

    @CamundaQueryParam(value="notClosed", converter=BooleanConverter.class)
    public void setNotClosed(Boolean notClosed) {
        this.notClosed = notClosed;
    }

    @CamundaQueryParam(value="variables", converter=VariableListConverter.class)
    public void setVariables(List<VariableQueryParameterDto> variables) {
        this.variables = variables;
    }

    @CamundaQueryParam(value="variableValuesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableValuesIgnoreCase(Boolean variableValuesIgnoreCase) {
        this.variableValuesIgnoreCase = variableValuesIgnoreCase;
    }

    @CamundaQueryParam(value="variableNamesIgnoreCase", converter=BooleanConverter.class)
    public void setVariableNamesIgnoreCase(Boolean variableNamesIgnoreCase) {
        this.variableNamesIgnoreCase = variableNamesIgnoreCase;
    }

    @CamundaQueryParam(value="caseActivityIdIn", converter=StringListConverter.class)
    public void setCaseActivityIdIn(List<String> caseActivityIdIn) {
        this.caseActivityIdIn = caseActivityIdIn;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricCaseInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricCaseInstanceQuery();
    }

    @Override
    protected void applyFilters(HistoricCaseInstanceQuery query) {
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.caseInstanceIds != null) {
            query.caseInstanceIds(this.caseInstanceIds);
        }
        if (this.caseDefinitionId != null) {
            query.caseDefinitionId(this.caseDefinitionId);
        }
        if (this.caseDefinitionKey != null) {
            query.caseDefinitionKey(this.caseDefinitionKey);
        }
        if (this.caseDefinitionName != null) {
            query.caseDefinitionName(this.caseDefinitionName);
        }
        if (this.caseDefinitionNameLike != null) {
            query.caseDefinitionNameLike(this.caseDefinitionNameLike);
        }
        if (this.caseDefinitionKeyNotIn != null) {
            query.caseDefinitionKeyNotIn(this.caseDefinitionKeyNotIn);
        }
        if (this.caseInstanceBusinessKey != null) {
            query.caseInstanceBusinessKey(this.caseInstanceBusinessKey);
        }
        if (this.caseInstanceBusinessKeyLike != null) {
            query.caseInstanceBusinessKeyLike(this.caseInstanceBusinessKeyLike);
        }
        if (this.superCaseInstanceId != null) {
            query.superCaseInstanceId(this.superCaseInstanceId);
        }
        if (this.subCaseInstanceId != null) {
            query.subCaseInstanceId(this.subCaseInstanceId);
        }
        if (this.superProcessInstanceId != null) {
            query.superProcessInstanceId(this.superProcessInstanceId);
        }
        if (this.subProcessInstanceId != null) {
            query.subProcessInstanceId(this.subProcessInstanceId);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
        if (Boolean.TRUE.equals(this.withoutTenantId)) {
            query.withoutTenantId();
        }
        if (this.createdBy != null) {
            query.createdBy(this.createdBy);
        }
        if (this.createdBefore != null) {
            query.createdBefore(this.createdBefore);
        }
        if (this.createdAfter != null) {
            query.createdAfter(this.createdAfter);
        }
        if (this.closedBefore != null) {
            query.closedBefore(this.closedBefore);
        }
        if (this.closedAfter != null) {
            query.closedAfter(this.closedAfter);
        }
        if (this.active != null && this.active.booleanValue()) {
            query.active();
        }
        if (this.completed != null && this.completed.booleanValue()) {
            query.completed();
        }
        if (this.terminated != null && this.terminated.booleanValue()) {
            query.terminated();
        }
        if (this.closed != null && this.closed.booleanValue()) {
            query.closed();
        }
        if (this.notClosed != null && this.notClosed.booleanValue()) {
            query.notClosed();
        }
        if (this.caseActivityIdIn != null && !this.caseActivityIdIn.isEmpty()) {
            query.caseActivityIdIn(this.caseActivityIdIn.toArray(new String[this.caseActivityIdIn.size()]));
        }
        if (Boolean.TRUE.equals(this.variableNamesIgnoreCase)) {
            query.matchVariableNamesIgnoreCase();
        }
        if (Boolean.TRUE.equals(this.variableValuesIgnoreCase)) {
            query.matchVariableValuesIgnoreCase();
        }
        if (this.variables != null) {
            for (VariableQueryParameterDto variableQueryParam : this.variables) {
                String variableName = variableQueryParam.getName();
                String op = variableQueryParam.getOperator();
                Object variableValue = variableQueryParam.resolveValue(this.objectMapper);
                if (op.equals("eq")) {
                    query.variableValueEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("gt")) {
                    query.variableValueGreaterThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("gteq")) {
                    query.variableValueGreaterThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("lt")) {
                    query.variableValueLessThan(variableName, variableValue);
                    continue;
                }
                if (op.equals("lteq")) {
                    query.variableValueLessThanOrEqual(variableName, variableValue);
                    continue;
                }
                if (op.equals("neq")) {
                    query.variableValueNotEquals(variableName, variableValue);
                    continue;
                }
                if (op.equals("like")) {
                    query.variableValueLike(variableName, String.valueOf(variableValue));
                    continue;
                }
                throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Invalid variable comparator specified: " + op);
            }
        }
    }

    @Override
    protected void applySortBy(HistoricCaseInstanceQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_CASE_INSTANCE_ID_VALUE)) {
            query.orderByCaseInstanceId();
        } else if (sortBy.equals(SORT_BY_CASE_DEFINITION_ID_VALUE)) {
            query.orderByCaseDefinitionId();
        } else if (sortBy.equals(SORT_BY_CASE_INSTANCE_BUSINESS_KEY_VALUE)) {
            query.orderByCaseInstanceBusinessKey();
        } else if (sortBy.equals(SORT_BY_CASE_INSTANCE_CREATE_TIME_VALUE)) {
            query.orderByCaseInstanceCreateTime();
        } else if (sortBy.equals(SORT_BY_CASE_INSTANCE_CLOSE_TIME_VALUE)) {
            query.orderByCaseInstanceCloseTime();
        } else if (sortBy.equals(SORT_BY_CASE_INSTANCE_DURATION_VALUE)) {
            query.orderByCaseInstanceDuration();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_INSTANCE_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_DEFINITION_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_INSTANCE_BUSINESS_KEY_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_INSTANCE_CREATE_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_INSTANCE_CLOSE_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_CASE_INSTANCE_DURATION_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

