/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.repository.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.Resource;
import org.camunda.bpm.engine.rest.dto.repository.DeploymentResourceDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.repository.DeploymentResourcesResource;
import org.camunda.bpm.engine.rest.util.URLEncodingUtil;

public class DeploymentResourcesResourceImpl
implements DeploymentResourcesResource {
    protected static final Map<String, String> MEDIA_TYPE_MAPPING = new HashMap<String, String>();
    protected final ProcessEngine engine;
    protected final String deploymentId;

    public DeploymentResourcesResourceImpl(ProcessEngine engine, String deploymentId) {
        this.engine = engine;
        this.deploymentId = deploymentId;
    }

    @Override
    public List<DeploymentResourceDto> getDeploymentResources() {
        List resources = this.engine.getRepositoryService().getDeploymentResources(this.deploymentId);
        ArrayList<DeploymentResourceDto> deploymentResources = new ArrayList<DeploymentResourceDto>();
        for (Resource resource : resources) {
            deploymentResources.add(DeploymentResourceDto.fromResources(resource));
        }
        if (!deploymentResources.isEmpty()) {
            return deploymentResources;
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "Deployment resources for deployment id '" + this.deploymentId + "' do not exist.");
    }

    @Override
    public DeploymentResourceDto getDeploymentResource(String resourceId) {
        List<DeploymentResourceDto> deploymentResources = this.getDeploymentResources();
        for (DeploymentResourceDto deploymentResource : deploymentResources) {
            if (!deploymentResource.getId().equals(resourceId)) continue;
            return deploymentResource;
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "Deployment resource with resource id '" + resourceId + "' for deployment id '" + this.deploymentId + "' does not exist.");
    }

    @Override
    public Response getDeploymentResourceData(String resourceId) {
        RepositoryService repositoryService = this.engine.getRepositoryService();
        InputStream resourceAsStream = repositoryService.getResourceAsStreamById(this.deploymentId, resourceId);
        if (resourceAsStream != null) {
            DeploymentResourceDto resource = this.getDeploymentResource(resourceId);
            String name = resource.getName();
            String filename = null;
            String mediaType = null;
            if (name != null) {
                int idx;
                String extension;
                String[] extensionParts;
                String[] filenameParts = (name = name.replace("\\", "/")).split("/");
                if (filenameParts.length > 0) {
                    int idx2 = filenameParts.length - 1;
                    filename = filenameParts[idx2];
                }
                if ((extensionParts = name.split("\\.")).length > 0 && (extension = extensionParts[idx = extensionParts.length - 1]) != null) {
                    mediaType = MEDIA_TYPE_MAPPING.get(extension);
                }
            }
            if (filename == null) {
                filename = "data";
            }
            if (mediaType == null) {
                mediaType = "application/octet-stream";
            }
            return Response.ok((Object)resourceAsStream, (String)mediaType).header("Content-Disposition", (Object)URLEncodingUtil.buildAttachmentValue(filename)).build();
        }
        throw new InvalidRequestException(Response.Status.NOT_FOUND, "Deployment resource '" + resourceId + "' for deployment id '" + this.deploymentId + "' does not exist.");
    }

    static {
        MEDIA_TYPE_MAPPING.put("bpmn", "application/xml");
        MEDIA_TYPE_MAPPING.put("cmmn", "application/xml");
        MEDIA_TYPE_MAPPING.put("dmn", "application/xml");
        MEDIA_TYPE_MAPPING.put("json", "application/json");
        MEDIA_TYPE_MAPPING.put("xml", "application/xml");
        MEDIA_TYPE_MAPPING.put("gif", "image/gif");
        MEDIA_TYPE_MAPPING.put("jpeg", "image/jpeg");
        MEDIA_TYPE_MAPPING.put("jpe", "image/jpeg");
        MEDIA_TYPE_MAPPING.put("jpg", "image/jpeg");
        MEDIA_TYPE_MAPPING.put("png", "image/png");
        MEDIA_TYPE_MAPPING.put("svg", "image/svg+xml");
        MEDIA_TYPE_MAPPING.put("tiff", "image/tiff");
        MEDIA_TYPE_MAPPING.put("tif", "image/tiff");
        MEDIA_TYPE_MAPPING.put("groovy", "text/plain");
        MEDIA_TYPE_MAPPING.put("java", "text/plain");
        MEDIA_TYPE_MAPPING.put("js", "text/plain");
        MEDIA_TYPE_MAPPING.put("php", "text/plain");
        MEDIA_TYPE_MAPPING.put("py", "text/plain");
        MEDIA_TYPE_MAPPING.put("rb", "text/plain");
        MEDIA_TYPE_MAPPING.put("html", "text/html");
        MEDIA_TYPE_MAPPING.put("txt", "text/plain");
    }
}

