/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.migration.MigratingActivityInstanceValidationReport;
import org.camunda.bpm.engine.migration.MigratingProcessInstanceValidationException;
import org.camunda.bpm.engine.migration.MigratingProcessInstanceValidationReport;
import org.camunda.bpm.engine.migration.MigratingTransitionInstanceValidationReport;
import org.camunda.bpm.engine.migration.MigrationInstruction;
import org.camunda.bpm.engine.migration.MigrationInstructionValidationReport;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.migration.MigrationPlanBuilder;
import org.camunda.bpm.engine.migration.MigrationPlanExecutionBuilder;
import org.camunda.bpm.engine.migration.MigrationPlanValidationException;
import org.camunda.bpm.engine.migration.MigrationPlanValidationReport;
import org.camunda.bpm.engine.migration.MigrationVariableValidationReport;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.helper.FluentAnswer;
import org.camunda.bpm.engine.rest.helper.MockMigrationPlanBuilder;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.NoIntermediaryInvocation;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.rest.util.migration.MigrationExecutionDtoBuilder;
import org.camunda.bpm.engine.rest.util.migration.MigrationPlanDtoBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.impl.value.PrimitiveTypeValueImpl;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class MigrationRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String MIGRATION_URL = "/rest-test/migration";
    protected static final String GENERATE_MIGRATION_URL = "/rest-test/migration/generate";
    protected static final String VALIDATE_MIGRATION_URL = "/rest-test/migration/validate";
    protected static final String EXECUTE_MIGRATION_URL = "/rest-test/migration/execute";
    protected static final String EXECUTE_MIGRATION_ASYNC_URL = "/rest-test/migration/executeAsync";
    protected RuntimeService runtimeServiceMock;
    protected MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock migrationPlanBuilderMock;
    protected MigrationPlanExecutionBuilder migrationPlanExecutionBuilderMock;

    @Before
    public void setUpRuntimeData() {
        this.runtimeServiceMock = (RuntimeService)Mockito.mock(RuntimeService.class);
        Mockito.when((Object)processEngine.getRuntimeService()).thenReturn((Object)this.runtimeServiceMock);
        this.migrationPlanBuilderMock = new MockMigrationPlanBuilder().sourceProcessDefinitionId("aProcessDefinitionId").targetProcessDefinitionId("aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").instruction("anotherActivity", "anActivityId").builder();
        Mockito.when((Object)this.runtimeServiceMock.createMigrationPlan((String)Mockito.eq((Object)"aProcessDefinitionId"), (String)Mockito.eq((Object)"aProcessDefinitionId:2"))).thenReturn((Object)this.migrationPlanBuilderMock);
        this.migrationPlanExecutionBuilderMock = (MigrationPlanExecutionBuilder)Mockito.mock(MigrationPlanExecutionBuilder.class);
        Mockito.when((Object)this.migrationPlanExecutionBuilderMock.processInstanceIds((List)Mockito.any())).thenReturn((Object)this.migrationPlanExecutionBuilderMock);
        Mockito.when((Object)this.runtimeServiceMock.newMigration((MigrationPlan)Mockito.any())).thenReturn((Object)this.migrationPlanExecutionBuilderMock);
    }

    @Test
    public void generateMigrationPlanWithInitialEmptyInstructions() {
        Map<String, Object> initialMigrationPlan = new MigrationPlanDtoBuilder("aProcessDefinitionId", "aProcessDefinitionId:2").instructions(Collections.emptyList()).build();
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(initialMigrationPlan).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(GENERATE_MIGRATION_URL, new Object[0]);
        this.verifyGenerateMigrationPlanInteraction(this.migrationPlanBuilderMock, initialMigrationPlan);
        this.verifyGenerateMigrationPlanResponse(response);
    }

    @Test
    public void generateMigrationPlanWithInitialNullInstructions() {
        Map<String, Object> initialMigrationPlan = new MigrationPlanDtoBuilder("aProcessDefinitionId", "aProcessDefinitionId:2").instructions(null).build();
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(initialMigrationPlan).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(GENERATE_MIGRATION_URL, new Object[0]);
        this.verifyGenerateMigrationPlanInteraction(this.migrationPlanBuilderMock, initialMigrationPlan);
        this.verifyGenerateMigrationPlanResponse(response);
    }

    @Test
    public void generateMigrationPlanWithNoInitialInstructions() {
        Map<String, Object> initialMigrationPlan = new MigrationPlanDtoBuilder("aProcessDefinitionId", "aProcessDefinitionId:2").build();
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(initialMigrationPlan).then().statusCode(Response.Status.OK.getStatusCode()).when().post(GENERATE_MIGRATION_URL, new Object[0]);
        this.verifyGenerateMigrationPlanInteraction(this.migrationPlanBuilderMock, initialMigrationPlan);
        this.verifyGenerateMigrationPlanResponse(response);
    }

    @Test
    public void generateMigrationPlanIgnoringInitialInstructions() {
        Map<String, Object> initialMigrationPlan = new MigrationPlanDtoBuilder("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("ignored", "ignored").build();
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(initialMigrationPlan).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(GENERATE_MIGRATION_URL, new Object[0]);
        this.verifyGenerateMigrationPlanInteraction(this.migrationPlanBuilderMock, initialMigrationPlan);
        this.verifyGenerateMigrationPlanResponse(response);
    }

    @Test
    public void generateMigrationPlanWithNullSourceProcessDefinition() {
        String message = "source process definition id is null";
        MigrationPlanBuilder planBuilder = (MigrationPlanBuilder)Mockito.mock(MigrationPlanBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.runtimeServiceMock.createMigrationPlan((String)Mockito.isNull(), Mockito.anyString())).thenReturn((Object)planBuilder);
        Mockito.when((Object)planBuilder.mapEqualActivities().build()).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> initialMigrationPlan = new MigrationPlanDtoBuilder(null, "aProcessDefinitionId:2").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(initialMigrationPlan).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(GENERATE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void generateMigrationPlanWithNonExistingSourceProcessDefinition() {
        String message = "source process definition with id aNonExistingProcDefId does not exist";
        MigrationPlanBuilder migrationPlanBuilder = (MigrationPlanBuilder)Mockito.mock(MigrationPlanBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.runtimeServiceMock.createMigrationPlan((String)Mockito.eq((Object)"aNonExistingProcDefId"), Mockito.anyString())).thenReturn((Object)migrationPlanBuilder);
        Mockito.when((Object)migrationPlanBuilder.mapEqualActivities().build()).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> initialMigrationPlan = new MigrationPlanDtoBuilder("aNonExistingProcDefId", "aProcessDefinitionId:2").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(initialMigrationPlan).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(GENERATE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void generateMigrationPlanWithNullTargetProcessDefinition() {
        String message = "target process definition id is null";
        MigrationPlanBuilder migrationPlanBuilder = (MigrationPlanBuilder)Mockito.mock(MigrationPlanBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.runtimeServiceMock.createMigrationPlan(Mockito.anyString(), (String)Mockito.isNull())).thenReturn((Object)migrationPlanBuilder);
        Mockito.when((Object)migrationPlanBuilder.mapEqualActivities().build()).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> initialMigrationPlan = new MigrationPlanDtoBuilder("aProcessDefinitionId", null).build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(initialMigrationPlan).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(GENERATE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void generateMigrationPlanWithNonExistingTargetProcessDefinition() {
        String message = "target process definition with id aNonExistingProcDefId does not exist";
        MigrationPlanBuilder migrationPlanBuilder = (MigrationPlanBuilder)Mockito.mock(MigrationPlanBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.runtimeServiceMock.createMigrationPlan(Mockito.anyString(), (String)Mockito.eq((Object)"aNonExistingProcDefId"))).thenReturn((Object)migrationPlanBuilder);
        Mockito.when((Object)migrationPlanBuilder.mapEqualActivities().build()).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> initialMigrationPlan = new MigrationPlanDtoBuilder("aProcessDefinitionId", "aNonExistingProcDefId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(initialMigrationPlan).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(GENERATE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void generatePlanUpdateEventTriggers() {
        this.migrationPlanBuilderMock = new MockMigrationPlanBuilder().sourceProcessDefinitionId("aProcessDefinitionId").targetProcessDefinitionId("aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity", true).builder();
        HashMap<String, Object> generationRequest = new HashMap<String, Object>();
        generationRequest.put("sourceProcessDefinitionId", "aProcessDefinitionId");
        generationRequest.put("targetProcessDefinitionId", "aProcessDefinitionId:2");
        generationRequest.put("updateEventTriggers", true);
        Mockito.when((Object)this.runtimeServiceMock.createMigrationPlan(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)this.migrationPlanBuilderMock);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(generationRequest).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(GENERATE_MIGRATION_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMigrationPlan((String)Mockito.eq((Object)"aProcessDefinitionId"), (String)Mockito.eq((Object)"aProcessDefinitionId:2"));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.migrationPlanBuilderMock});
        ((MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock)inOrder.verify((Object)this.migrationPlanBuilderMock)).mapEqualActivities();
        ((MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock)inOrder.verify((Object)this.migrationPlanBuilderMock, (VerificationMode)NoIntermediaryInvocation.immediatelyAfter())).updateEventTriggers();
        ((MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock)Mockito.verify((Object)this.migrationPlanBuilderMock, (VerificationMode)Mockito.never())).mapActivities(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void generatePlanUpdateEventTriggerResponse() {
        this.migrationPlanBuilderMock = new MockMigrationPlanBuilder().sourceProcessDefinitionId("aProcessDefinitionId").targetProcessDefinitionId("aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity", true).builder();
        Mockito.when((Object)this.runtimeServiceMock.createMigrationPlan(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)this.migrationPlanBuilderMock);
        HashMap<String, String> generationRequest = new HashMap<String, String>();
        generationRequest.put("sourceProcessDefinitionId", "aProcessDefinitionId");
        generationRequest.put("targetProcessDefinitionId", "aProcessDefinitionId:2");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(generationRequest).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("instructions[0].sourceActivityIds[0]", Matchers.equalTo((Object)"anActivityId"), new Object[0]).body("instructions[0].targetActivityIds[0]", Matchers.equalTo((Object)"anotherActivity"), new Object[0]).body("instructions[0].updateEventTrigger", Matchers.equalTo((Object)true), new Object[0]).when().post(GENERATE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void generatePlanVariables() {
        this.migrationPlanBuilderMock = new MockMigrationPlanBuilder().sourceProcessDefinitionId("aProcessDefinitionId").targetProcessDefinitionId("aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity", true).builder();
        HashMap<String, Object> generationRequest = new HashMap<String, Object>();
        generationRequest.put("sourceProcessDefinitionId", "aProcessDefinitionId");
        generationRequest.put("targetProcessDefinitionId", "aProcessDefinitionId:2");
        HashMap<String, VariableValueDto> variableDtos = new HashMap<String, VariableValueDto>();
        VariableValueDto valueDtoFoo = new VariableValueDto();
        valueDtoFoo.setValue((Object)"foo");
        valueDtoFoo.setType("String");
        valueDtoFoo.setValueInfo(Collections.singletonMap("transient", true));
        variableDtos.put("foo", valueDtoFoo);
        VariableValueDto valueDtoBar = new VariableValueDto();
        valueDtoBar.setValue((Object)5);
        valueDtoBar.setType("short");
        valueDtoBar.setValueInfo(Collections.singletonMap("transient", false));
        variableDtos.put("bar", valueDtoBar);
        generationRequest.put("variables", variableDtos);
        Mockito.when((Object)this.runtimeServiceMock.createMigrationPlan(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)this.migrationPlanBuilderMock);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(generationRequest).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(GENERATE_MIGRATION_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMigrationPlan((String)Mockito.eq((Object)"aProcessDefinitionId"), (String)Mockito.eq((Object)"aProcessDefinitionId:2"));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.migrationPlanBuilderMock});
        ((MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock)inOrder.verify((Object)this.migrationPlanBuilderMock)).mapEqualActivities();
        ArgumentCaptor variablesCaptor = ArgumentCaptor.forClass(Map.class);
        ((MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock)inOrder.verify((Object)this.migrationPlanBuilderMock)).setVariables((Map)variablesCaptor.capture());
        TypedValue foo = ((VariableMap)variablesCaptor.getValue()).getValueTyped("foo");
        Assertions.assertThat((Object)foo.getValue()).isEqualTo((Object)"foo");
        Assertions.assertThat((boolean)foo.isTransient()).isTrue();
        Assertions.assertThat((String)foo.getType().getName()).isEqualTo((Object)"string");
        TypedValue bar = ((VariableMap)variablesCaptor.getValue()).getValueTyped("bar");
        Assertions.assertThat((Object)bar.getValue()).isEqualTo((Object)5);
        Assertions.assertThat((boolean)bar.isTransient()).isFalse();
        Assertions.assertThat((String)bar.getType().getName()).isEqualTo((Object)"short");
        ((MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock)Mockito.verify((Object)this.migrationPlanBuilderMock, (VerificationMode)Mockito.never())).mapActivities(Mockito.anyString(), Mockito.anyString());
    }

    @Test
    public void generatePlanVariablesResponse() {
        this.migrationPlanBuilderMock = new MockMigrationPlanBuilder().sourceProcessDefinitionId("aProcessDefinitionId").targetProcessDefinitionId("aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity", true).variables(Variables.putValue((String)"foo", (Object)Variables.stringValue((String)"bar", (boolean)true)).putValue("bar", (Object)Variables.shortValue((Short)5))).builder();
        Mockito.when((Object)this.runtimeServiceMock.createMigrationPlan(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)this.migrationPlanBuilderMock);
        HashMap<String, Object> generationRequest = new HashMap<String, Object>();
        generationRequest.put("sourceProcessDefinitionId", "aProcessDefinitionId");
        generationRequest.put("targetProcessDefinitionId", "aProcessDefinitionId:2");
        generationRequest.put("variables", new HashMap());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(generationRequest).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("instructions[0].sourceActivityIds[0]", Matchers.equalTo((Object)"anActivityId"), new Object[0]).body("instructions[0].targetActivityIds[0]", Matchers.equalTo((Object)"anotherActivity"), new Object[0]).body("instructions[0].updateEventTrigger", Matchers.equalTo((Object)true), new Object[0]).body("variables.foo.value", CoreMatchers.is((Object)"bar"), new Object[0]).body("variables.foo.type", CoreMatchers.is((Object)"String"), new Object[0]).body("variables.foo.valueInfo.transient", CoreMatchers.is((Object)true), new Object[0]).body("variables.bar.value", CoreMatchers.is((Object)5), new Object[0]).body("variables.bar.type", CoreMatchers.is((Object)"Short"), new Object[0]).when().post(GENERATE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlan() {
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").instruction("anotherActivity", "anActivityId").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(EXECUTE_MIGRATION_URL, new Object[0]);
        this.verifyCreateMigrationPlanInteraction(this.migrationPlanBuilderMock, (Map)migrationExecution.get("migrationPlan"));
        this.verifyMigrationPlanExecutionInteraction(migrationExecution);
    }

    @Test
    public void executeMigrationPlanWithProcessInstanceQuery() {
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceQuery()).thenReturn((Object)new ProcessInstanceQueryImpl());
        ProcessInstanceQueryDto processInstanceQuery = new ProcessInstanceQueryDto();
        processInstanceQuery.setProcessDefinitionId("aProcessDefinitionId");
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").instruction("anotherActivity", "anActivityId").done().processInstanceQuery(processInstanceQuery).build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(EXECUTE_MIGRATION_URL, new Object[0]);
        this.verifyCreateMigrationPlanInteraction(this.migrationPlanBuilderMock, (Map)migrationExecution.get("migrationPlan"));
        this.verifyMigrationPlanExecutionInteraction(migrationExecution);
    }

    @Test
    public void executeMigrationPlanSkipListeners() {
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").done().processInstances("aProcessInstanceId").skipCustomListeners(true).build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(EXECUTE_MIGRATION_URL, new Object[0]);
        this.verifyMigrationPlanExecutionInteraction(migrationExecution);
    }

    @Test
    public void executeMigrationPlanSkipIoMappings() {
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").done().processInstances("aProcessInstanceId").skipIoMappings(true).build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(EXECUTE_MIGRATION_URL, new Object[0]);
        this.verifyMigrationPlanExecutionInteraction(migrationExecution);
    }

    @Test
    public void executeMigrationPlanWithNullInstructions() {
        MigrationInstructionValidationReport instructionReport = (MigrationInstructionValidationReport)Mockito.mock(MigrationInstructionValidationReport.class);
        Mockito.when((Object)instructionReport.getMigrationInstruction()).thenReturn(null);
        Mockito.when((Object)instructionReport.getFailures()).thenReturn(Collections.singletonList("failure"));
        MigrationPlanValidationReport validationReport = (MigrationPlanValidationReport)Mockito.mock(MigrationPlanValidationReport.class);
        Mockito.when((Object)validationReport.getInstructionReports()).thenReturn(Collections.singletonList(instructionReport));
        Mockito.when((Object)this.migrationPlanBuilderMock.build()).thenThrow(new Throwable[]{new MigrationPlanValidationException("fooo", validationReport)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)MigrationPlanValidationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.is((Object)"fooo"), new Object[0]).body("validationReport.instructionReports", Matchers.hasSize((int)1), new Object[0]).body("validationReport.instructionReports[0].instruction", CoreMatchers.nullValue(), new Object[0]).body("validationReport.instructionReports[0].failures", Matchers.hasSize((int)1), new Object[0]).body("validationReport.instructionReports[0].failures[0]", CoreMatchers.is((Object)"failure"), new Object[0]).when().post(EXECUTE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanWithEmptyInstructions() {
        MigrationInstructionValidationReport instructionReport = (MigrationInstructionValidationReport)Mockito.mock(MigrationInstructionValidationReport.class);
        Mockito.when((Object)instructionReport.getMigrationInstruction()).thenReturn(null);
        Mockito.when((Object)instructionReport.getFailures()).thenReturn(Collections.singletonList("failure"));
        MigrationPlanValidationReport validationReport = (MigrationPlanValidationReport)Mockito.mock(MigrationPlanValidationReport.class);
        Mockito.when((Object)validationReport.getInstructionReports()).thenReturn(Collections.singletonList(instructionReport));
        Mockito.when((Object)this.migrationPlanBuilderMock.build()).thenThrow(new Throwable[]{new MigrationPlanValidationException("fooo", validationReport)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").done().processInstances("aProcessInstanceId", "anotherId").build();
        ((Map)migrationExecution.get("migrationPlan")).put("instructions", Collections.emptyList());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)MigrationPlanValidationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.is((Object)"fooo"), new Object[0]).body("validationReport.instructionReports", Matchers.hasSize((int)1), new Object[0]).body("validationReport.instructionReports[0].instruction", CoreMatchers.nullValue(), new Object[0]).body("validationReport.instructionReports[0].failures", Matchers.hasSize((int)1), new Object[0]).body("validationReport.instructionReports[0].failures[0]", CoreMatchers.is((Object)"failure"), new Object[0]).when().post(EXECUTE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanWithNullSourceProcessInstanceId() {
        String message = "source process definition id is null";
        MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock migrationPlanBuilder = (MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock)Mockito.mock(MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock.class, (Answer)new FluentAnswer());
        Mockito.when((Object)this.runtimeServiceMock.createMigrationPlan((String)Mockito.isNull(), Mockito.anyString())).thenReturn((Object)migrationPlanBuilder);
        Mockito.when((Object)migrationPlanBuilder.build()).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan(null, "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").instruction("anotherActivity", "anActivityId").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(EXECUTE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanWithNonExistingSourceProcessInstanceId() {
        String message = "source process definition with id aNonExistingProcDefId does not exist";
        MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock migrationPlanBuilder = (MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock)Mockito.mock(MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock.class, (Answer)new FluentAnswer());
        Mockito.when((Object)this.runtimeServiceMock.createMigrationPlan((String)Mockito.eq((Object)"aNonExistingProcDefId"), Mockito.anyString())).thenReturn((Object)migrationPlanBuilder);
        Mockito.when((Object)migrationPlanBuilder.build()).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aNonExistingProcDefId", "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").instruction("anotherActivity", "anActivityId").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(EXECUTE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanWithNullTargetProcessInstanceId() {
        String message = "target process definition id is null";
        MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock migrationPlanBuilder = (MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock)Mockito.mock(MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock.class, (Answer)new FluentAnswer());
        Mockito.when((Object)this.runtimeServiceMock.createMigrationPlan(Mockito.anyString(), (String)Mockito.isNull())).thenReturn((Object)migrationPlanBuilder);
        Mockito.when((Object)migrationPlanBuilder.build()).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", null).instruction("anActivityId", "anotherActivity").instruction("anotherActivity", "anActivityId").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(EXECUTE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanWithNonExistingTargetProcessInstanceId() {
        String message = "target process definition with id aNonExistingProcDefId does not exist";
        MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock migrationPlanBuilder = (MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock)Mockito.mock(MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock.class, (Answer)new FluentAnswer());
        Mockito.when((Object)this.runtimeServiceMock.createMigrationPlan(Mockito.anyString(), (String)Mockito.eq((Object)"aNonExistingProcDefId"))).thenReturn((Object)migrationPlanBuilder);
        Mockito.when((Object)migrationPlanBuilder.build()).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aNonExistingProcDefId").instruction("anActivityId", "anotherActivity").instruction("anotherActivity", "anActivityId").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(EXECUTE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanWithNullSourceActivityId() {
        String message = "sourceActivityId is null";
        Mockito.when((Object)this.migrationPlanBuilderMock.mapActivities((String)Mockito.isNull(), Mockito.anyString())).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction(null, "anotherActivity").instruction("anotherActivity", "anActivityId").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(EXECUTE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanWithNonExistingSourceActivityId() {
        String message = "sourceActivity is null";
        Mockito.when((Object)this.migrationPlanBuilderMock.mapActivities((String)Mockito.eq((Object)"aNonExistingActivityId"), Mockito.anyString())).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("aNonExistingActivityId", "anotherActivity").instruction("anotherActivity", "anActivityId").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(EXECUTE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanWithNullTargetActivityId() {
        String message = "targetActivityId is null";
        Mockito.when((Object)this.migrationPlanBuilderMock.mapActivities(Mockito.anyString(), (String)Mockito.isNull())).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", null).instruction("anotherActivity", "anActivityId").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(EXECUTE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanWithNonExistingTargetActivityId() {
        String message = "targetActivity is null";
        Mockito.when((Object)this.migrationPlanBuilderMock.mapActivities(Mockito.anyString(), (String)Mockito.eq((Object)"aNonExistingActivityId"))).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", "aNonExistingActivityId").instruction("anotherActivity", "anActivityId").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(EXECUTE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanValidationException() {
        MigrationInstruction migrationInstruction = (MigrationInstruction)Mockito.mock(MigrationInstruction.class);
        Mockito.when((Object)migrationInstruction.getSourceActivityId()).thenReturn((Object)"anActivityId");
        Mockito.when((Object)migrationInstruction.getTargetActivityId()).thenReturn((Object)"anotherActivity");
        MigrationInstructionValidationReport instructionReport1 = (MigrationInstructionValidationReport)Mockito.mock(MigrationInstructionValidationReport.class);
        Mockito.when((Object)instructionReport1.getMigrationInstruction()).thenReturn((Object)migrationInstruction);
        Mockito.when((Object)instructionReport1.getFailures()).thenReturn(Arrays.asList("failure1", "failure2"));
        MigrationInstructionValidationReport instructionReport2 = (MigrationInstructionValidationReport)Mockito.mock(MigrationInstructionValidationReport.class);
        Mockito.when((Object)instructionReport2.getMigrationInstruction()).thenReturn((Object)migrationInstruction);
        Mockito.when((Object)instructionReport2.getFailures()).thenReturn(Arrays.asList("failure1", "failure2"));
        MigrationPlanValidationReport validationReport = (MigrationPlanValidationReport)Mockito.mock(MigrationPlanValidationReport.class);
        Mockito.when((Object)validationReport.getInstructionReports()).thenReturn(Arrays.asList(instructionReport1, instructionReport2));
        Mockito.when((Object)this.migrationPlanBuilderMock.build()).thenThrow(new Throwable[]{new MigrationPlanValidationException("fooo", validationReport)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)MigrationPlanValidationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.is((Object)"fooo"), new Object[0]).body("validationReport.instructionReports", Matchers.hasSize((int)2), new Object[0]).body("validationReport.instructionReports[0].instruction.sourceActivityIds", Matchers.hasSize((int)1), new Object[0]).body("validationReport.instructionReports[0].instruction.sourceActivityIds[0]", CoreMatchers.is((Object)"anActivityId"), new Object[0]).body("validationReport.instructionReports[0].instruction.targetActivityIds", Matchers.hasSize((int)1), new Object[0]).body("validationReport.instructionReports[0].instruction.targetActivityIds[0]", CoreMatchers.is((Object)"anotherActivity"), new Object[0]).body("validationReport.instructionReports[0].failures", Matchers.hasSize((int)2), new Object[0]).body("validationReport.instructionReports[0].failures[0]", CoreMatchers.is((Object)"failure1"), new Object[0]).body("validationReport.instructionReports[0].failures[1]", CoreMatchers.is((Object)"failure2"), new Object[0]).when().post(EXECUTE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void executeMigratingProcessInstanceValidationException() {
        MigrationInstruction migrationInstruction = (MigrationInstruction)Mockito.mock(MigrationInstruction.class);
        Mockito.when((Object)migrationInstruction.getSourceActivityId()).thenReturn((Object)"anActivityId");
        Mockito.when((Object)migrationInstruction.getTargetActivityId()).thenReturn((Object)"anotherActivity");
        MigratingActivityInstanceValidationReport instanceReport1 = (MigratingActivityInstanceValidationReport)Mockito.mock(MigratingActivityInstanceValidationReport.class);
        Mockito.when((Object)instanceReport1.getActivityInstanceId()).thenReturn((Object)"anActivityInstanceId");
        Mockito.when((Object)instanceReport1.getMigrationInstruction()).thenReturn((Object)migrationInstruction);
        Mockito.when((Object)instanceReport1.getSourceScopeId()).thenReturn((Object)"anActivityId");
        Mockito.when((Object)instanceReport1.getFailures()).thenReturn(Arrays.asList("failure1", "failure2"));
        MigratingTransitionInstanceValidationReport instanceReport2 = (MigratingTransitionInstanceValidationReport)Mockito.mock(MigratingTransitionInstanceValidationReport.class);
        Mockito.when((Object)instanceReport2.getTransitionInstanceId()).thenReturn((Object)"transitionInstanceId");
        Mockito.when((Object)instanceReport2.getMigrationInstruction()).thenReturn((Object)migrationInstruction);
        Mockito.when((Object)instanceReport2.getSourceScopeId()).thenReturn((Object)"anActivityId");
        Mockito.when((Object)instanceReport2.getFailures()).thenReturn(Arrays.asList("failure1", "failure2"));
        MigratingProcessInstanceValidationReport processInstanceReport = (MigratingProcessInstanceValidationReport)Mockito.mock(MigratingProcessInstanceValidationReport.class);
        Mockito.when((Object)processInstanceReport.getProcessInstanceId()).thenReturn((Object)"aProcessInstanceId");
        Mockito.when((Object)processInstanceReport.getFailures()).thenReturn(Arrays.asList("failure1", "failure2"));
        Mockito.when((Object)processInstanceReport.getActivityInstanceReports()).thenReturn(Arrays.asList(instanceReport1));
        Mockito.when((Object)processInstanceReport.getTransitionInstanceReports()).thenReturn(Arrays.asList(instanceReport2));
        ((MigrationPlanExecutionBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new MigratingProcessInstanceValidationException("fooo", processInstanceReport)}).when((Object)this.migrationPlanExecutionBuilderMock)).execute();
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)MigratingProcessInstanceValidationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.is((Object)"fooo"), new Object[0]).body("validationReport.processInstanceId", CoreMatchers.is((Object)"aProcessInstanceId"), new Object[0]).body("validationReport.failures", Matchers.hasSize((int)2), new Object[0]).body("validationReport.failures[0]", CoreMatchers.is((Object)"failure1"), new Object[0]).body("validationReport.failures[1]", CoreMatchers.is((Object)"failure2"), new Object[0]).body("validationReport.activityInstanceValidationReports", Matchers.hasSize((int)1), new Object[0]).body("validationReport.activityInstanceValidationReports[0].migrationInstruction.sourceActivityIds", Matchers.hasSize((int)1), new Object[0]).body("validationReport.activityInstanceValidationReports[0].migrationInstruction.sourceActivityIds[0]", CoreMatchers.is((Object)"anActivityId"), new Object[0]).body("validationReport.activityInstanceValidationReports[0].migrationInstruction.targetActivityIds", Matchers.hasSize((int)1), new Object[0]).body("validationReport.activityInstanceValidationReports[0].migrationInstruction.targetActivityIds[0]", CoreMatchers.is((Object)"anotherActivity"), new Object[0]).body("validationReport.activityInstanceValidationReports[0].activityInstanceId", CoreMatchers.is((Object)"anActivityInstanceId"), new Object[0]).body("validationReport.activityInstanceValidationReports[0].sourceScopeId", CoreMatchers.is((Object)"anActivityId"), new Object[0]).body("validationReport.activityInstanceValidationReports[0].failures", Matchers.hasSize((int)2), new Object[0]).body("validationReport.activityInstanceValidationReports[0].failures[0]", CoreMatchers.is((Object)"failure1"), new Object[0]).body("validationReport.activityInstanceValidationReports[0].failures[1]", CoreMatchers.is((Object)"failure2"), new Object[0]).body("validationReport.transitionInstanceValidationReports", Matchers.hasSize((int)1), new Object[0]).body("validationReport.transitionInstanceValidationReports[0].migrationInstruction.sourceActivityIds", Matchers.hasSize((int)1), new Object[0]).body("validationReport.transitionInstanceValidationReports[0].migrationInstruction.sourceActivityIds[0]", CoreMatchers.is((Object)"anActivityId"), new Object[0]).body("validationReport.transitionInstanceValidationReports[0].migrationInstruction.targetActivityIds", Matchers.hasSize((int)1), new Object[0]).body("validationReport.transitionInstanceValidationReports[0].migrationInstruction.targetActivityIds[0]", CoreMatchers.is((Object)"anotherActivity"), new Object[0]).body("validationReport.transitionInstanceValidationReports[0].transitionInstanceId", CoreMatchers.is((Object)"transitionInstanceId"), new Object[0]).body("validationReport.transitionInstanceValidationReports[0].sourceScopeId", CoreMatchers.is((Object)"anActivityId"), new Object[0]).body("validationReport.transitionInstanceValidationReports[0].failures", Matchers.hasSize((int)2), new Object[0]).body("validationReport.transitionInstanceValidationReports[0].failures[0]", CoreMatchers.is((Object)"failure1"), new Object[0]).body("validationReport.transitionInstanceValidationReports[0].failures[1]", CoreMatchers.is((Object)"failure2"), new Object[0]).when().post(EXECUTE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanAsync() {
        Batch batchMock = MockProvider.createMockBatch();
        Mockito.when((Object)this.migrationPlanExecutionBuilderMock.executeAsync()).thenReturn((Object)batchMock);
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").instruction("anotherActivity", "anActivityId").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", CoreMatchers.is((Object)"aBatchId"), new Object[0]).body("type", CoreMatchers.is((Object)"aBatchType"), new Object[0]).body("totalJobs", CoreMatchers.is((Object)10), new Object[0]).body("batchJobsPerSeed", CoreMatchers.is((Object)11), new Object[0]).body("invocationsPerBatchJob", CoreMatchers.is((Object)12), new Object[0]).body("seedJobDefinitionId", CoreMatchers.is((Object)"aSeedJobDefinitionId"), new Object[0]).body("monitorJobDefinitionId", CoreMatchers.is((Object)"aMonitorJobDefinitionId"), new Object[0]).body("batchJobDefinitionId", CoreMatchers.is((Object)"aBatchJobDefinitionId"), new Object[0]).body("tenantId", CoreMatchers.is((Object)"aTenantId"), new Object[0]).when().post(EXECUTE_MIGRATION_ASYNC_URL, new Object[0]);
        this.verifyCreateMigrationPlanInteraction(this.migrationPlanBuilderMock, (Map)migrationExecution.get("migrationPlan"));
        this.verifyMigrationPlanAsyncExecutionInteraction(migrationExecution);
    }

    @Test
    public void executeMigrationPlanAsyncWithProcessInstanceQuery() {
        Mockito.when((Object)this.runtimeServiceMock.createProcessInstanceQuery()).thenReturn((Object)new ProcessInstanceQueryImpl());
        ProcessInstanceQueryDto processInstanceQuery = new ProcessInstanceQueryDto();
        processInstanceQuery.setProcessDefinitionId("aProcessDefinitionId");
        Batch batchMock = MockProvider.createMockBatch();
        Mockito.when((Object)this.migrationPlanExecutionBuilderMock.executeAsync()).thenReturn((Object)batchMock);
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").instruction("anotherActivity", "anActivityId").done().processInstanceQuery(processInstanceQuery).build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", CoreMatchers.is((Object)"aBatchId"), new Object[0]).body("type", CoreMatchers.is((Object)"aBatchType"), new Object[0]).body("totalJobs", CoreMatchers.is((Object)10), new Object[0]).body("batchJobsPerSeed", CoreMatchers.is((Object)11), new Object[0]).body("invocationsPerBatchJob", CoreMatchers.is((Object)12), new Object[0]).body("seedJobDefinitionId", CoreMatchers.is((Object)"aSeedJobDefinitionId"), new Object[0]).body("monitorJobDefinitionId", CoreMatchers.is((Object)"aMonitorJobDefinitionId"), new Object[0]).body("batchJobDefinitionId", CoreMatchers.is((Object)"aBatchJobDefinitionId"), new Object[0]).body("tenantId", CoreMatchers.is((Object)"aTenantId"), new Object[0]).when().post(EXECUTE_MIGRATION_ASYNC_URL, new Object[0]);
        this.verifyCreateMigrationPlanInteraction(this.migrationPlanBuilderMock, (Map)migrationExecution.get("migrationPlan"));
        this.verifyMigrationPlanAsyncExecutionInteraction(migrationExecution);
    }

    @Test
    public void executeMigrationPlanAsyncSkipListeners() {
        Batch batchMock = MockProvider.createMockBatch();
        Mockito.when((Object)this.migrationPlanExecutionBuilderMock.executeAsync()).thenReturn((Object)batchMock);
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").done().processInstances("aProcessInstanceId").skipCustomListeners(true).build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXECUTE_MIGRATION_ASYNC_URL, new Object[0]);
        this.verifyMigrationPlanAsyncExecutionInteraction(migrationExecution);
    }

    @Test
    public void executeMigrationPlanAsyncSkipIoMappings() {
        Batch batchMock = MockProvider.createMockBatch();
        Mockito.when((Object)this.migrationPlanExecutionBuilderMock.executeAsync()).thenReturn((Object)batchMock);
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").done().processInstances("aProcessInstanceId").skipIoMappings(true).build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EXECUTE_MIGRATION_ASYNC_URL, new Object[0]);
        this.verifyMigrationPlanAsyncExecutionInteraction(migrationExecution);
    }

    @Test
    public void executeMigrationPlanAsyncWithNullInstructions() {
        MigrationInstructionValidationReport instructionReport = (MigrationInstructionValidationReport)Mockito.mock(MigrationInstructionValidationReport.class);
        Mockito.when((Object)instructionReport.getMigrationInstruction()).thenReturn(null);
        Mockito.when((Object)instructionReport.getFailures()).thenReturn(Collections.singletonList("failure"));
        MigrationPlanValidationReport validationReport = (MigrationPlanValidationReport)Mockito.mock(MigrationPlanValidationReport.class);
        Mockito.when((Object)validationReport.getInstructionReports()).thenReturn(Collections.singletonList(instructionReport));
        Mockito.when((Object)this.migrationPlanBuilderMock.build()).thenThrow(new Throwable[]{new MigrationPlanValidationException("fooo", validationReport)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)MigrationPlanValidationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.is((Object)"fooo"), new Object[0]).body("validationReport.instructionReports", Matchers.hasSize((int)1), new Object[0]).body("validationReport.instructionReports[0].instruction", CoreMatchers.nullValue(), new Object[0]).body("validationReport.instructionReports[0].failures", Matchers.hasSize((int)1), new Object[0]).body("validationReport.instructionReports[0].failures[0]", CoreMatchers.is((Object)"failure"), new Object[0]).when().post(EXECUTE_MIGRATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanAsyncWithEmptyInstructions() {
        MigrationInstructionValidationReport instructionReport = (MigrationInstructionValidationReport)Mockito.mock(MigrationInstructionValidationReport.class);
        Mockito.when((Object)instructionReport.getMigrationInstruction()).thenReturn(null);
        Mockito.when((Object)instructionReport.getFailures()).thenReturn(Collections.singletonList("failure"));
        MigrationPlanValidationReport validationReport = (MigrationPlanValidationReport)Mockito.mock(MigrationPlanValidationReport.class);
        Mockito.when((Object)validationReport.getInstructionReports()).thenReturn(Collections.singletonList(instructionReport));
        Mockito.when((Object)this.migrationPlanBuilderMock.build()).thenThrow(new Throwable[]{new MigrationPlanValidationException("fooo", validationReport)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").done().processInstances("aProcessInstanceId", "anotherId").build();
        ((Map)migrationExecution.get("migrationPlan")).put("instructions", Collections.emptyList());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)MigrationPlanValidationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.is((Object)"fooo"), new Object[0]).body("validationReport.instructionReports", Matchers.hasSize((int)1), new Object[0]).body("validationReport.instructionReports[0].instruction", CoreMatchers.nullValue(), new Object[0]).body("validationReport.instructionReports[0].failures", Matchers.hasSize((int)1), new Object[0]).body("validationReport.instructionReports[0].failures[0]", CoreMatchers.is((Object)"failure"), new Object[0]).when().post(EXECUTE_MIGRATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanAsyncWithNullSourceProcessDefinitionId() {
        String message = "source process definition id is null";
        MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock migrationPlanBuilder = (MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock)Mockito.mock(MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock.class, (Answer)new FluentAnswer());
        Mockito.when((Object)this.runtimeServiceMock.createMigrationPlan((String)Mockito.isNull(), Mockito.anyString())).thenReturn((Object)migrationPlanBuilder);
        Mockito.when((Object)migrationPlanBuilder.build()).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan(null, "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").instruction("anotherActivity", "anActivityId").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(EXECUTE_MIGRATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanAsyncWithNonExistingSourceProcessDefinitionId() {
        String message = "source process definition with id aNonExistingProcDefId does not exist";
        MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock migrationPlanBuilder = (MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock)Mockito.mock(MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock.class, (Answer)new FluentAnswer());
        Mockito.when((Object)this.runtimeServiceMock.createMigrationPlan((String)Mockito.eq((Object)"aNonExistingProcDefId"), Mockito.anyString())).thenReturn((Object)migrationPlanBuilder);
        Mockito.when((Object)migrationPlanBuilder.build()).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aNonExistingProcDefId", "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").instruction("anotherActivity", "anActivityId").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(EXECUTE_MIGRATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanAsyncWithNullTargetProcessDefinitionId() {
        String message = "target process definition id is null";
        MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock migrationPlanBuilder = (MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock)Mockito.mock(MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock.class, (Answer)new FluentAnswer());
        Mockito.when((Object)this.runtimeServiceMock.createMigrationPlan(Mockito.anyString(), (String)Mockito.isNull())).thenReturn((Object)migrationPlanBuilder);
        Mockito.when((Object)migrationPlanBuilder.build()).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", null).instruction("anActivityId", "anotherActivity").instruction("anotherActivity", "anActivityId").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(EXECUTE_MIGRATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanAsyncWithNonExistingTargetProcessDefinitionId() {
        String message = "target process definition with id aNonExistingProcDefId does not exist";
        MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock migrationPlanBuilder = (MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock)Mockito.mock(MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock.class, (Answer)new FluentAnswer());
        Mockito.when((Object)this.runtimeServiceMock.createMigrationPlan(Mockito.anyString(), (String)Mockito.eq((Object)"aNonExistingProcDefId"))).thenReturn((Object)migrationPlanBuilder);
        Mockito.when((Object)migrationPlanBuilder.build()).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aNonExistingProcDefId").instruction("anActivityId", "anotherActivity").instruction("anotherActivity", "anActivityId").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(EXECUTE_MIGRATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanAsyncWithNullSourceActivityId() {
        String message = "sourceActivityId is null";
        Mockito.when((Object)this.migrationPlanBuilderMock.mapActivities((String)Mockito.isNull(), Mockito.anyString())).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction(null, "anotherActivity").instruction("anotherActivity", "anActivityId").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(EXECUTE_MIGRATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanAsyncWithNonExistingSourceActivityId() {
        String message = "sourceActivity is null";
        Mockito.when((Object)this.migrationPlanBuilderMock.mapActivities((String)Mockito.eq((Object)"aNonExistingActivityId"), Mockito.anyString())).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("aNonExistingActivityId", "anotherActivity").instruction("anotherActivity", "anActivityId").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(EXECUTE_MIGRATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanAsyncWithNullTargetActivityId() {
        String message = "targetActivityId is null";
        Mockito.when((Object)this.migrationPlanBuilderMock.mapActivities(Mockito.anyString(), (String)Mockito.isNull())).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", null).instruction("anotherActivity", "anActivityId").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(EXECUTE_MIGRATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanAsyncWithNonExistingTargetActivityId() {
        String message = "targetActivity is null";
        Mockito.when((Object)this.migrationPlanBuilderMock.mapActivities(Mockito.anyString(), (String)Mockito.eq((Object)"aNonExistingActivityId"))).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", "aNonExistingActivityId").instruction("anotherActivity", "anActivityId").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", CoreMatchers.is((Object)message), new Object[0]).when().post(EXECUTE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanAsyncValidationException() {
        MigrationInstruction migrationInstruction = (MigrationInstruction)Mockito.mock(MigrationInstruction.class);
        Mockito.when((Object)migrationInstruction.getSourceActivityId()).thenReturn((Object)"anActivityId");
        Mockito.when((Object)migrationInstruction.getTargetActivityId()).thenReturn((Object)"anotherActivity");
        MigrationInstructionValidationReport instructionReport1 = (MigrationInstructionValidationReport)Mockito.mock(MigrationInstructionValidationReport.class);
        Mockito.when((Object)instructionReport1.getMigrationInstruction()).thenReturn((Object)migrationInstruction);
        Mockito.when((Object)instructionReport1.getFailures()).thenReturn(Arrays.asList("failure1", "failure2"));
        MigrationInstructionValidationReport instructionReport2 = (MigrationInstructionValidationReport)Mockito.mock(MigrationInstructionValidationReport.class);
        Mockito.when((Object)instructionReport2.getMigrationInstruction()).thenReturn((Object)migrationInstruction);
        Mockito.when((Object)instructionReport2.getFailures()).thenReturn(Arrays.asList("failure1", "failure2"));
        MigrationPlanValidationReport validationReport = (MigrationPlanValidationReport)Mockito.mock(MigrationPlanValidationReport.class);
        Mockito.when((Object)validationReport.getInstructionReports()).thenReturn(Arrays.asList(instructionReport1, instructionReport2));
        Mockito.when((Object)this.migrationPlanBuilderMock.build()).thenThrow(new Throwable[]{new MigrationPlanValidationException("fooo", validationReport)});
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)MigrationPlanValidationException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.is((Object)"fooo"), new Object[0]).body("validationReport.instructionReports", Matchers.hasSize((int)2), new Object[0]).body("validationReport.instructionReports[0].instruction.sourceActivityIds", Matchers.hasSize((int)1), new Object[0]).body("validationReport.instructionReports[0].instruction.sourceActivityIds[0]", CoreMatchers.is((Object)"anActivityId"), new Object[0]).body("validationReport.instructionReports[0].instruction.targetActivityIds", Matchers.hasSize((int)1), new Object[0]).body("validationReport.instructionReports[0].instruction.targetActivityIds[0]", CoreMatchers.is((Object)"anotherActivity"), new Object[0]).body("validationReport.instructionReports[0].failures", Matchers.hasSize((int)2), new Object[0]).body("validationReport.instructionReports[0].failures[0]", CoreMatchers.is((Object)"failure1"), new Object[0]).body("validationReport.instructionReports[0].failures[1]", CoreMatchers.is((Object)"failure2"), new Object[0]).when().post(EXECUTE_MIGRATION_ASYNC_URL, new Object[0]);
    }

    @Test
    public void executeMigrationPlanUpdateEventTrigger() {
        Map<String, Object> migrationExecution = new MigrationExecutionDtoBuilder().migrationPlan("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity", true).instruction("anotherActivity", "anActivityId", false).done().processInstances("aProcessInstanceId", "anotherId").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationExecution).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(EXECUTE_MIGRATION_URL, new Object[0]);
        this.verifyCreateMigrationPlanInteraction(this.migrationPlanBuilderMock, (Map)migrationExecution.get("migrationPlan"));
        this.verifyMigrationPlanExecutionInteraction(migrationExecution);
    }

    @Test
    public void validateMigrationPlan() {
        Map<String, Object> migrationPlan = new MigrationPlanDtoBuilder("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").instruction("anotherActivity", "anActivityId", true).build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationPlan).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("instructionReports", Matchers.hasSize((int)0), new Object[0]).body("variableReports.isEmpty()", CoreMatchers.is((Object)true), new Object[0]).when().post(VALIDATE_MIGRATION_URL, new Object[0]);
        this.verifyCreateMigrationPlanInteraction(this.migrationPlanBuilderMock, migrationPlan);
    }

    @Test
    public void validateMigrationPlanInstructionsValidationException() {
        MigrationInstruction migrationInstruction = (MigrationInstruction)Mockito.mock(MigrationInstruction.class);
        Mockito.when((Object)migrationInstruction.getSourceActivityId()).thenReturn((Object)"anActivityId");
        Mockito.when((Object)migrationInstruction.getTargetActivityId()).thenReturn((Object)"anotherActivity");
        MigrationInstructionValidationReport instructionReport1 = (MigrationInstructionValidationReport)Mockito.mock(MigrationInstructionValidationReport.class);
        Mockito.when((Object)instructionReport1.getMigrationInstruction()).thenReturn((Object)migrationInstruction);
        Mockito.when((Object)instructionReport1.getFailures()).thenReturn(Arrays.asList("failure1", "failure2"));
        MigrationInstructionValidationReport instructionReport2 = (MigrationInstructionValidationReport)Mockito.mock(MigrationInstructionValidationReport.class);
        Mockito.when((Object)instructionReport2.getMigrationInstruction()).thenReturn((Object)migrationInstruction);
        Mockito.when((Object)instructionReport2.getFailures()).thenReturn(Arrays.asList("failure1", "failure2"));
        MigrationPlanValidationReport validationReport = (MigrationPlanValidationReport)Mockito.mock(MigrationPlanValidationReport.class);
        Mockito.when((Object)validationReport.getInstructionReports()).thenReturn(Arrays.asList(instructionReport1, instructionReport2));
        Mockito.when((Object)this.migrationPlanBuilderMock.build()).thenThrow(new Throwable[]{new MigrationPlanValidationException("fooo", validationReport)});
        Map<String, Object> migrationPlan = new MigrationPlanDtoBuilder("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationPlan).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("instructionReports", Matchers.hasSize((int)2), new Object[0]).body("instructionReports[0].instruction.sourceActivityIds", Matchers.hasSize((int)1), new Object[0]).body("instructionReports[0].instruction.sourceActivityIds[0]", CoreMatchers.is((Object)"anActivityId"), new Object[0]).body("instructionReports[0].instruction.targetActivityIds", Matchers.hasSize((int)1), new Object[0]).body("instructionReports[0].instruction.targetActivityIds[0]", CoreMatchers.is((Object)"anotherActivity"), new Object[0]).body("instructionReports[0].failures", Matchers.hasSize((int)2), new Object[0]).body("instructionReports[0].failures[0]", CoreMatchers.is((Object)"failure1"), new Object[0]).body("instructionReports[0].failures[1]", CoreMatchers.is((Object)"failure2"), new Object[0]).when().post(VALIDATE_MIGRATION_URL, new Object[0]);
    }

    @Test
    public void validateMigrationPlanVariablesValidationException() {
        MigrationInstruction migrationInstruction = (MigrationInstruction)Mockito.mock(MigrationInstruction.class);
        Mockito.when((Object)migrationInstruction.getSourceActivityId()).thenReturn((Object)"anActivityId");
        Mockito.when((Object)migrationInstruction.getTargetActivityId()).thenReturn((Object)"anotherActivity");
        MigrationVariableValidationReport variableReport1 = (MigrationVariableValidationReport)Mockito.mock(MigrationVariableValidationReport.class);
        Mockito.when((Object)variableReport1.getTypedValue()).thenReturn((Object)new PrimitiveTypeValueImpl.StringValueImpl("bar"));
        Mockito.when((Object)variableReport1.getFailures()).thenReturn(Arrays.asList("failure1", "failure2"));
        MigrationVariableValidationReport variableReport2 = (MigrationVariableValidationReport)Mockito.mock(MigrationVariableValidationReport.class);
        Mockito.when((Object)variableReport2.getTypedValue()).thenReturn((Object)new PrimitiveTypeValueImpl.LongValueImpl(Long.valueOf(8L)));
        Mockito.when((Object)variableReport2.getFailures()).thenReturn(Arrays.asList("failure1", "failure2"));
        MigrationPlanValidationReport validationReport = (MigrationPlanValidationReport)Mockito.mock(MigrationPlanValidationReport.class);
        HashMap<String, MigrationVariableValidationReport> reports = new HashMap<String, MigrationVariableValidationReport>();
        reports.put("foo", variableReport1);
        reports.put("bar", variableReport2);
        Mockito.when((Object)validationReport.getVariableReports()).thenReturn(reports);
        Mockito.when((Object)this.migrationPlanBuilderMock.build()).thenThrow(new Throwable[]{new MigrationPlanValidationException("fooo", validationReport)});
        Map<String, Object> migrationPlan = new MigrationPlanDtoBuilder("aProcessDefinitionId", "aProcessDefinitionId:2").instruction("anActivityId", "anotherActivity").build();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(migrationPlan).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("variableReports.foo.type", CoreMatchers.is((Object)"String"), new Object[0]).body("variableReports.foo.value", CoreMatchers.is((Object)"bar"), new Object[0]).body("variableReports.foo.failures", Matchers.hasSize((int)2), new Object[0]).body("variableReports.foo.failures[0]", CoreMatchers.is((Object)"failure1"), new Object[0]).body("variableReports.foo.failures[1]", CoreMatchers.is((Object)"failure2"), new Object[0]).body("variableReports.bar.type", CoreMatchers.is((Object)"Long"), new Object[0]).body("variableReports.bar.value", CoreMatchers.is((Object)8), new Object[0]).body("variableReports.bar.failures", Matchers.hasSize((int)2), new Object[0]).body("variableReports.bar.failures[0]", CoreMatchers.is((Object)"failure1"), new Object[0]).body("variableReports.bar.failures[1]", CoreMatchers.is((Object)"failure2"), new Object[0]).when().post(VALIDATE_MIGRATION_URL, new Object[0]);
    }

    protected void verifyGenerateMigrationPlanResponse(Response response) {
        String responseContent = response.asString();
        String sourceProcessDefinitionId = JsonPath.from((String)responseContent).getString("sourceProcessDefinitionId");
        String targetProcessDefinitionId = JsonPath.from((String)responseContent).getString("targetProcessDefinitionId");
        List instructions = JsonPath.from((String)responseContent).getList("instructions");
        Assertions.assertThat((String)sourceProcessDefinitionId).isEqualTo((Object)"aProcessDefinitionId");
        Assertions.assertThat((String)targetProcessDefinitionId).isEqualTo((Object)"aProcessDefinitionId:2");
        Assertions.assertThat((List)instructions).hasSize(2);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)((Map)instructions.get(0))).containsEntry((Object)"sourceActivityIds", Collections.singletonList("anActivityId"))).containsEntry((Object)"targetActivityIds", Collections.singletonList("anotherActivity"))).containsEntry((Object)"updateEventTrigger", (Object)false);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)((Map)instructions.get(1))).containsEntry((Object)"sourceActivityIds", Collections.singletonList("anotherActivity"))).containsEntry((Object)"targetActivityIds", Collections.singletonList("anActivityId"))).containsEntry((Object)"updateEventTrigger", (Object)false);
    }

    protected void verifyGenerateMigrationPlanInteraction(MigrationPlanBuilder migrationPlanBuilderMock, Map<String, Object> initialMigrationPlan) {
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMigrationPlan((String)Mockito.eq((Object)initialMigrationPlan.get("sourceProcessDefinitionId").toString()), (String)Mockito.eq((Object)initialMigrationPlan.get("targetProcessDefinitionId").toString()));
        ((MigrationPlanBuilder)Mockito.verify((Object)migrationPlanBuilderMock)).mapEqualActivities();
        ((MigrationPlanBuilder)Mockito.verify((Object)migrationPlanBuilderMock, (VerificationMode)Mockito.never())).mapActivities(Mockito.anyString(), Mockito.anyString());
    }

    protected void verifyCreateMigrationPlanInteraction(MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock migrationPlanBuilderMock, Map<String, Object> migrationPlan) {
        ((RuntimeService)Mockito.verify((Object)this.runtimeServiceMock)).createMigrationPlan(migrationPlan.get("sourceProcessDefinitionId").toString(), migrationPlan.get("targetProcessDefinitionId").toString());
        ((MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock)Mockito.verify((Object)migrationPlanBuilderMock, (VerificationMode)Mockito.never())).mapEqualActivities();
        List instructions = (List)migrationPlan.get("instructions");
        if (instructions != null) {
            for (Map migrationInstructionDto : instructions) {
                InOrder inOrder = Mockito.inOrder((Object[])new Object[]{migrationPlanBuilderMock});
                String sourceActivityId = (String)((List)migrationInstructionDto.get("sourceActivityIds")).get(0);
                String targetActivityId = (String)((List)migrationInstructionDto.get("targetActivityIds")).get(0);
                ((MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock)inOrder.verify((Object)migrationPlanBuilderMock)).mapActivities((String)Mockito.eq((Object)sourceActivityId), (String)Mockito.eq((Object)targetActivityId));
                Boolean updateEventTrigger = (Boolean)migrationInstructionDto.get("updateEventTrigger");
                if (!Boolean.TRUE.equals(updateEventTrigger)) continue;
                ((MockMigrationPlanBuilder.JoinedMigrationPlanBuilderMock)inOrder.verify((Object)migrationPlanBuilderMock, (VerificationMode)NoIntermediaryInvocation.immediatelyAfter())).updateEventTrigger();
            }
        }
    }

    protected void verifyMigrationPlanExecutionInteraction(Map<String, Object> migrationExecution) {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.runtimeServiceMock, this.migrationPlanExecutionBuilderMock});
        ((RuntimeService)inOrder.verify((Object)this.runtimeServiceMock)).newMigration((MigrationPlan)Mockito.any(MigrationPlan.class));
        this.verifyMigrationExecutionBuilderInteraction(inOrder, migrationExecution);
        ((MigrationPlanExecutionBuilder)inOrder.verify((Object)this.migrationPlanExecutionBuilderMock)).execute();
        inOrder.verifyNoMoreInteractions();
    }

    protected void verifyMigrationPlanAsyncExecutionInteraction(Map<String, Object> migrationExecution) {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.runtimeServiceMock, this.migrationPlanExecutionBuilderMock});
        ((RuntimeService)inOrder.verify((Object)this.runtimeServiceMock)).newMigration((MigrationPlan)Mockito.any(MigrationPlan.class));
        this.verifyMigrationExecutionBuilderInteraction(inOrder, migrationExecution);
        ((MigrationPlanExecutionBuilder)inOrder.verify((Object)this.migrationPlanExecutionBuilderMock)).executeAsync();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.migrationPlanExecutionBuilderMock});
    }

    protected void verifyMigrationExecutionBuilderInteraction(InOrder inOrder, Map<String, Object> migrationExecution) {
        Boolean skipIoMappings;
        Boolean skipCustomListeners;
        List processInstanceIds = (List)migrationExecution.get("processInstanceIds");
        ((MigrationPlanExecutionBuilder)inOrder.verify((Object)this.migrationPlanExecutionBuilderMock)).processInstanceIds((List)Mockito.eq((Object)processInstanceIds));
        ProcessInstanceQueryDto processInstanceQuery = (ProcessInstanceQueryDto)migrationExecution.get("processInstanceQuery");
        if (processInstanceQuery != null) {
            this.verifyMigrationPlanExecutionProcessInstanceQuery(inOrder);
        }
        if (Boolean.TRUE.equals(skipCustomListeners = (Boolean)migrationExecution.get("skipCustomListeners"))) {
            ((MigrationPlanExecutionBuilder)inOrder.verify((Object)this.migrationPlanExecutionBuilderMock)).skipCustomListeners();
        }
        if (Boolean.TRUE.equals(skipIoMappings = (Boolean)migrationExecution.get("skipIoMappings"))) {
            ((MigrationPlanExecutionBuilder)inOrder.verify((Object)this.migrationPlanExecutionBuilderMock)).skipIoMappings();
        }
    }

    protected void verifyMigrationPlanExecutionProcessInstanceQuery(InOrder inOrder) {
        ArgumentCaptor queryCapture = ArgumentCaptor.forClass(ProcessInstanceQuery.class);
        ((MigrationPlanExecutionBuilder)inOrder.verify((Object)this.migrationPlanExecutionBuilderMock)).processInstanceQuery((ProcessInstanceQuery)queryCapture.capture());
        ProcessInstanceQueryImpl actualQuery = (ProcessInstanceQueryImpl)queryCapture.getValue();
        Assertions.assertThat((Object)actualQuery).isNotNull();
        Assertions.assertThat((String)actualQuery.getProcessDefinitionId()).isEqualTo((Object)"aProcessDefinitionId");
    }
}

