/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.filter.FilterQuery;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricActivityStatistics;
import org.camunda.bpm.engine.history.HistoricActivityStatisticsQuery;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.history.HistoricExternalTaskLog;
import org.camunda.bpm.engine.history.HistoricExternalTaskLogQuery;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricIncidentQuery;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricJobLogQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.impl.HistoricActivityStatisticsQueryImpl;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ExecutionQuery;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.IncidentQuery;
import org.camunda.bpm.engine.runtime.MessageCorrelationBuilder;
import org.camunda.bpm.engine.runtime.MessageCorrelationResult;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.runtime.VariableInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

public class ProcessEngineRestServiceTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String ENGINES_URL = "/rest-test/engine";
    protected static final String SINGLE_ENGINE_URL = "/rest-test/engine/{name}";
    protected static final String PROCESS_DEFINITION_URL = "/rest-test/engine/{name}/process-definition/{id}";
    protected static final String PROCESS_INSTANCE_URL = "/rest-test/engine/{name}/process-instance/{id}";
    protected static final String TASK_URL = "/rest-test/engine/{name}/task/{id}";
    protected static final String IDENTITY_GROUPS_URL = "/rest-test/engine/{name}/identity/groups";
    protected static final String MESSAGE_URL = "/rest-test/engine/{name}/message";
    protected static final String EXECUTION_URL = "/rest-test/engine/{name}/execution";
    protected static final String VARIABLE_INSTANCE_URL = "/rest-test/engine/{name}/variable-instance";
    protected static final String USER_URL = "/rest-test/engine/{name}/user";
    protected static final String GROUP_URL = "/rest-test/engine/{name}/group";
    protected static final String INCIDENT_URL = "/rest-test/engine/{name}/incident";
    protected static final String AUTHORIZATION_URL = "/rest-test/engine/{name}/authorization";
    protected static final String AUTHORIZATION_CHECK_URL = "/rest-test/engine/{name}/authorization/check";
    protected static final String DEPLOYMENT_REST_SERVICE_URL = "/rest-test/engine/{name}/deployment";
    protected static final String DEPLOYMENT_URL = "/rest-test/engine/{name}/deployment/{id}";
    protected static final String EXTERNAL_TASKS_URL = "/rest-test/engine/{name}/external-task";
    protected static final String JOB_DEFINITION_URL = "/rest-test/engine/{name}/job-definition";
    protected static final String CASE_DEFINITION_URL = "/rest-test/engine/{name}/case-definition";
    protected static final String CASE_INSTANCE_URL = "/rest-test/engine/{name}/case-instance";
    protected static final String CASE_EXECUTION_URL = "/rest-test/engine/{name}/case-execution";
    protected static final String FILTER_URL = "/rest-test/engine/{name}/filter";
    protected static final String HISTORY_URL = "/rest-test/engine/{name}/history";
    protected static final String HISTORY_ACTIVITY_INSTANCE_URL = "/rest-test/engine/{name}/history/activity-instance";
    protected static final String HISTORY_PROCESS_INSTANCE_URL = "/rest-test/engine/{name}/history/process-instance";
    protected static final String HISTORY_VARIABLE_INSTANCE_URL = "/rest-test/engine/{name}/history/variable-instance";
    protected static final String HISTORY_BINARY_VARIABLE_INSTANCE_URL = "/rest-test/engine/{name}/history/variable-instance/{id}/data";
    protected static final String HISTORY_ACTIVITY_STATISTICS_URL = "/rest-test/engine/{name}/history/process-definition/{id}/statistics";
    protected static final String HISTORY_DETAIL_URL = "/rest-test/engine/{name}/history/detail";
    protected static final String HISTORY_BINARY_DETAIL_URL = "/rest-test/engine/{name}/history/detail/data";
    protected static final String HISTORY_TASK_INSTANCE_URL = "/rest-test/engine/{name}/history/task";
    protected static final String HISTORY_INCIDENT_URL = "/rest-test/engine/{name}/history/incident";
    protected static final String HISTORY_JOB_LOG_URL = "/rest-test/engine/{name}/history/job-log";
    protected static final String HISTORY_EXTERNAL_TASK_LOG_URL = "/rest-test/engine/{name}/history/external-task-log";
    protected static final String EXAMPLE_ENGINE_NAME = "anEngineName";
    private ProcessEngine namedProcessEngine;
    private RepositoryService mockRepoService;
    private RuntimeService mockRuntimeService;
    private TaskService mockTaskService;
    private IdentityService mockIdentityService;
    private ManagementService mockManagementService;
    private HistoryService mockHistoryService;
    private ExternalTaskService mockExternalTaskService;
    private CaseService mockCaseService;
    private FilterService mockFilterService;
    private MessageCorrelationBuilder mockMessageCorrelationBuilder;
    private MessageCorrelationResult mockMessageCorrelationResult;

    @Before
    public void setUpRuntimeData() {
        this.namedProcessEngine = this.getProcessEngine(EXAMPLE_ENGINE_NAME);
        this.mockRepoService = (RepositoryService)Mockito.mock(RepositoryService.class);
        this.mockRuntimeService = (RuntimeService)Mockito.mock(RuntimeService.class);
        this.mockTaskService = (TaskService)Mockito.mock(TaskService.class);
        this.mockIdentityService = (IdentityService)Mockito.mock(IdentityService.class);
        this.mockManagementService = (ManagementService)Mockito.mock(ManagementService.class);
        this.mockHistoryService = (HistoryService)Mockito.mock(HistoryService.class);
        this.mockCaseService = (CaseService)Mockito.mock(CaseService.class);
        this.mockFilterService = (FilterService)Mockito.mock(FilterService.class);
        this.mockExternalTaskService = (ExternalTaskService)Mockito.mock(ExternalTaskService.class);
        Mockito.when((Object)this.namedProcessEngine.getRepositoryService()).thenReturn((Object)this.mockRepoService);
        Mockito.when((Object)this.namedProcessEngine.getRuntimeService()).thenReturn((Object)this.mockRuntimeService);
        Mockito.when((Object)this.namedProcessEngine.getTaskService()).thenReturn((Object)this.mockTaskService);
        Mockito.when((Object)this.namedProcessEngine.getIdentityService()).thenReturn((Object)this.mockIdentityService);
        Mockito.when((Object)this.namedProcessEngine.getManagementService()).thenReturn((Object)this.mockManagementService);
        Mockito.when((Object)this.namedProcessEngine.getHistoryService()).thenReturn((Object)this.mockHistoryService);
        Mockito.when((Object)this.namedProcessEngine.getCaseService()).thenReturn((Object)this.mockCaseService);
        Mockito.when((Object)this.namedProcessEngine.getFilterService()).thenReturn((Object)this.mockFilterService);
        Mockito.when((Object)this.namedProcessEngine.getExternalTaskService()).thenReturn((Object)this.mockExternalTaskService);
        this.createProcessDefinitionMock();
        this.createProcessInstanceMock();
        this.createTaskMock();
        this.createIdentityMocks();
        this.createExecutionMock();
        this.createVariableInstanceMock();
        this.createJobDefinitionMock();
        this.createIncidentMock();
        this.createDeploymentMock();
        this.createMessageCorrelationBuilderMock();
        this.createCaseDefinitionMock();
        this.createCaseInstanceMock();
        this.createCaseExecutionMock();
        this.createFilterMock();
        this.createExternalTaskMock();
        this.createHistoricActivityInstanceMock();
        this.createHistoricProcessInstanceMock();
        this.createHistoricVariableInstanceMock();
        this.createHistoricActivityStatisticsMock();
        this.createHistoricDetailMock();
        this.createHistoricTaskInstanceMock();
        this.createHistoricIncidentMock();
        this.createHistoricJobLogMock();
        this.createHistoricExternalTaskLogMock();
    }

    private void createProcessDefinitionMock() {
        ProcessDefinition mockDefinition = MockProvider.createMockDefinition();
        Mockito.when((Object)this.mockRepoService.getProcessDefinition((String)Mockito.eq((Object)"aProcDefId"))).thenReturn((Object)mockDefinition);
    }

    private void createCaseDefinitionMock() {
        ArrayList<CaseDefinition> caseDefinitions = new ArrayList<CaseDefinition>();
        CaseDefinition mockCaseDefinition = MockProvider.createMockCaseDefinition();
        caseDefinitions.add(mockCaseDefinition);
        CaseDefinitionQuery mockCaseDefinitionQuery = (CaseDefinitionQuery)Mockito.mock(CaseDefinitionQuery.class);
        Mockito.when((Object)mockCaseDefinitionQuery.list()).thenReturn(caseDefinitions);
        Mockito.when((Object)this.mockRepoService.createCaseDefinitionQuery()).thenReturn((Object)mockCaseDefinitionQuery);
    }

    private void createCaseInstanceMock() {
        ArrayList<CaseInstance> caseInstances = new ArrayList<CaseInstance>();
        CaseInstance mockCaseInstance = MockProvider.createMockCaseInstance();
        caseInstances.add(mockCaseInstance);
        CaseInstanceQuery mockCaseInstanceQuery = (CaseInstanceQuery)Mockito.mock(CaseInstanceQuery.class);
        Mockito.when((Object)mockCaseInstanceQuery.list()).thenReturn(caseInstances);
        Mockito.when((Object)this.mockCaseService.createCaseInstanceQuery()).thenReturn((Object)mockCaseInstanceQuery);
    }

    private void createCaseExecutionMock() {
        ArrayList<CaseExecution> caseExecutions = new ArrayList<CaseExecution>();
        CaseExecution mockCaseExecution = MockProvider.createMockCaseExecution();
        caseExecutions.add(mockCaseExecution);
        CaseExecutionQuery mockCaseExecutionQuery = (CaseExecutionQuery)Mockito.mock(CaseExecutionQuery.class);
        Mockito.when((Object)mockCaseExecutionQuery.list()).thenReturn(caseExecutions);
        Mockito.when((Object)this.mockCaseService.createCaseExecutionQuery()).thenReturn((Object)mockCaseExecutionQuery);
    }

    private void createProcessInstanceMock() {
        ProcessInstance mockInstance = MockProvider.createMockInstance();
        ProcessInstanceQuery mockInstanceQuery = (ProcessInstanceQuery)Mockito.mock(ProcessInstanceQuery.class);
        Mockito.when((Object)mockInstanceQuery.processInstanceId((String)Mockito.eq((Object)"aProcInstId"))).thenReturn((Object)mockInstanceQuery);
        Mockito.when((Object)((ProcessInstance)mockInstanceQuery.singleResult())).thenReturn((Object)mockInstance);
        Mockito.when((Object)this.mockRuntimeService.createProcessInstanceQuery()).thenReturn((Object)mockInstanceQuery);
    }

    private void createExecutionMock() {
        Execution mockExecution = MockProvider.createMockExecution();
        ExecutionQuery mockExecutionQuery = (ExecutionQuery)Mockito.mock(ExecutionQuery.class);
        Mockito.when((Object)mockExecutionQuery.processInstanceId((String)Mockito.eq((Object)"aProcInstId"))).thenReturn((Object)mockExecutionQuery);
        Mockito.when((Object)((Execution)mockExecutionQuery.singleResult())).thenReturn((Object)mockExecution);
        Mockito.when((Object)this.mockRuntimeService.createExecutionQuery()).thenReturn((Object)mockExecutionQuery);
    }

    private void createTaskMock() {
        Task mockTask = MockProvider.createMockTask();
        TaskQuery mockTaskQuery = (TaskQuery)Mockito.mock(TaskQuery.class);
        Mockito.when((Object)mockTaskQuery.taskId((String)Mockito.eq((Object)"anId"))).thenReturn((Object)mockTaskQuery);
        Mockito.when((Object)mockTaskQuery.initializeFormKeys()).thenReturn((Object)mockTaskQuery);
        Mockito.when((Object)((Task)mockTaskQuery.singleResult())).thenReturn((Object)mockTask);
        Mockito.when((Object)this.mockTaskService.createTaskQuery()).thenReturn((Object)mockTaskQuery);
    }

    private void createIdentityMocks() {
        UserQuery sampleUserQuery = (UserQuery)Mockito.mock(UserQuery.class);
        GroupQuery sampleGroupQuery = (GroupQuery)Mockito.mock(GroupQuery.class);
        ArrayList<User> mockUsers = new ArrayList<User>();
        User mockUser = MockProvider.createMockUser();
        mockUsers.add(mockUser);
        Mockito.when((Object)sampleUserQuery.memberOfGroup(Mockito.anyString())).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.list()).thenReturn(mockUsers);
        List<Group> mockGroups = MockProvider.createMockGroups();
        Mockito.when((Object)sampleGroupQuery.groupMember(Mockito.anyString())).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.orderByGroupName()).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)((GroupQuery)sampleGroupQuery.asc())).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.unlimitedList()).thenReturn(mockGroups);
        Mockito.when((Object)this.mockIdentityService.createGroupQuery()).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)this.mockIdentityService.createUserQuery()).thenReturn((Object)sampleUserQuery);
    }

    private void createVariableInstanceMock() {
        ArrayList<VariableInstance> variables = new ArrayList<VariableInstance>();
        VariableInstance mockInstance = MockProvider.createMockVariableInstance();
        variables.add(mockInstance);
        VariableInstanceQuery mockVariableInstanceQuery = (VariableInstanceQuery)Mockito.mock(VariableInstanceQuery.class);
        Mockito.when((Object)mockVariableInstanceQuery.list()).thenReturn(variables);
        Mockito.when((Object)this.mockRuntimeService.createVariableInstanceQuery()).thenReturn((Object)mockVariableInstanceQuery);
    }

    private void createJobDefinitionMock() {
        ArrayList<JobDefinition> jobDefinitions = new ArrayList<JobDefinition>();
        JobDefinition mockJobDefinition = MockProvider.createMockJobDefinition();
        jobDefinitions.add(mockJobDefinition);
        JobDefinitionQuery mockJobDefinitionQuery = (JobDefinitionQuery)Mockito.mock(JobDefinitionQuery.class);
        Mockito.when((Object)mockJobDefinitionQuery.list()).thenReturn(jobDefinitions);
        Mockito.when((Object)this.mockManagementService.createJobDefinitionQuery()).thenReturn((Object)mockJobDefinitionQuery);
    }

    private void createIncidentMock() {
        IncidentQuery mockIncidentQuery = (IncidentQuery)Mockito.mock(IncidentQuery.class);
        List<Incident> incidents = MockProvider.createMockIncidents();
        Mockito.when((Object)mockIncidentQuery.list()).thenReturn(incidents);
        Mockito.when((Object)this.mockRuntimeService.createIncidentQuery()).thenReturn((Object)mockIncidentQuery);
    }

    private void createMessageCorrelationBuilderMock() {
        this.mockMessageCorrelationBuilder = (MessageCorrelationBuilder)Mockito.mock(MessageCorrelationBuilder.class);
        this.mockMessageCorrelationResult = (MessageCorrelationResult)Mockito.mock(MessageCorrelationResult.class);
        Mockito.when((Object)this.mockRuntimeService.createMessageCorrelation(Mockito.anyString())).thenReturn((Object)this.mockMessageCorrelationBuilder);
        Mockito.when((Object)this.mockMessageCorrelationBuilder.correlateWithResult()).thenReturn((Object)this.mockMessageCorrelationResult);
        Mockito.when((Object)this.mockMessageCorrelationBuilder.processInstanceId(Mockito.anyString())).thenReturn((Object)this.mockMessageCorrelationBuilder);
        Mockito.when((Object)this.mockMessageCorrelationBuilder.processInstanceBusinessKey(Mockito.anyString())).thenReturn((Object)this.mockMessageCorrelationBuilder);
        Mockito.when((Object)this.mockMessageCorrelationBuilder.processInstanceVariableEquals(Mockito.anyString(), Mockito.any())).thenReturn((Object)this.mockMessageCorrelationBuilder);
        Mockito.when((Object)this.mockMessageCorrelationBuilder.setVariables((Map)Mockito.any())).thenReturn((Object)this.mockMessageCorrelationBuilder);
        Mockito.when((Object)this.mockMessageCorrelationBuilder.setVariable(Mockito.anyString(), Mockito.any())).thenReturn((Object)this.mockMessageCorrelationBuilder);
    }

    private void createHistoricActivityInstanceMock() {
        ArrayList<HistoricActivityInstance> activities = new ArrayList<HistoricActivityInstance>();
        HistoricActivityInstance mockInstance = MockProvider.createMockHistoricActivityInstance();
        activities.add(mockInstance);
        HistoricActivityInstanceQuery mockHistoricActivityInstanceQuery = (HistoricActivityInstanceQuery)Mockito.mock(HistoricActivityInstanceQuery.class);
        Mockito.when((Object)mockHistoricActivityInstanceQuery.list()).thenReturn(activities);
        Mockito.when((Object)this.mockHistoryService.createHistoricActivityInstanceQuery()).thenReturn((Object)mockHistoricActivityInstanceQuery);
    }

    private void createHistoricProcessInstanceMock() {
        ArrayList<HistoricProcessInstance> processes = new ArrayList<HistoricProcessInstance>();
        HistoricProcessInstance mockInstance = MockProvider.createMockHistoricProcessInstance();
        processes.add(mockInstance);
        HistoricProcessInstanceQuery mockHistoricProcessInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQuery.class);
        Mockito.when((Object)mockHistoricProcessInstanceQuery.list()).thenReturn(processes);
        Mockito.when((Object)this.mockHistoryService.createHistoricProcessInstanceQuery()).thenReturn((Object)mockHistoricProcessInstanceQuery);
    }

    private void createHistoricVariableInstanceMock() {
        ArrayList<HistoricVariableInstance> variables = new ArrayList<HistoricVariableInstance>();
        HistoricVariableInstance mockInstance = MockProvider.createMockHistoricVariableInstance();
        variables.add(mockInstance);
        HistoricVariableInstanceQuery mockHistoricVariableInstanceQuery = (HistoricVariableInstanceQuery)Mockito.mock(HistoricVariableInstanceQuery.class);
        Mockito.when((Object)mockHistoricVariableInstanceQuery.list()).thenReturn(variables);
        Mockito.when((Object)this.mockHistoryService.createHistoricVariableInstanceQuery()).thenReturn((Object)mockHistoricVariableInstanceQuery);
    }

    private void createHistoricActivityStatisticsMock() {
        List<HistoricActivityStatistics> statistics = MockProvider.createMockHistoricActivityStatistics();
        HistoricActivityStatisticsQuery query = (HistoricActivityStatisticsQuery)Mockito.mock(HistoricActivityStatisticsQueryImpl.class);
        Mockito.when((Object)this.mockHistoryService.createHistoricActivityStatisticsQuery("aProcDefId")).thenReturn((Object)query);
        Mockito.when((Object)query.list()).thenReturn(statistics);
    }

    private void createHistoricDetailMock() {
        List<HistoricDetail> details = MockProvider.createMockHistoricDetails();
        HistoricDetailQuery query = (HistoricDetailQuery)Mockito.mock(HistoricDetailQuery.class);
        Mockito.when((Object)this.mockHistoryService.createHistoricDetailQuery()).thenReturn((Object)query);
        Mockito.when((Object)query.list()).thenReturn(details);
    }

    private void createHistoricTaskInstanceMock() {
        List<HistoricTaskInstance> tasks = MockProvider.createMockHistoricTaskInstances();
        HistoricTaskInstanceQuery query = (HistoricTaskInstanceQuery)Mockito.mock(HistoricTaskInstanceQuery.class);
        Mockito.when((Object)this.mockHistoryService.createHistoricTaskInstanceQuery()).thenReturn((Object)query);
        Mockito.when((Object)query.list()).thenReturn(tasks);
    }

    private void createHistoricIncidentMock() {
        HistoricIncidentQuery mockHistoricIncidentQuery = (HistoricIncidentQuery)Mockito.mock(HistoricIncidentQuery.class);
        List<HistoricIncident> historicIncidents = MockProvider.createMockHistoricIncidents();
        Mockito.when((Object)mockHistoricIncidentQuery.list()).thenReturn(historicIncidents);
        Mockito.when((Object)this.mockHistoryService.createHistoricIncidentQuery()).thenReturn((Object)mockHistoricIncidentQuery);
    }

    private void createDeploymentMock() {
        Deployment mockDeployment = MockProvider.createMockDeployment();
        DeploymentQuery deploymentQueryMock = (DeploymentQuery)Mockito.mock(DeploymentQuery.class);
        Mockito.when((Object)deploymentQueryMock.deploymentId(Mockito.anyString())).thenReturn((Object)deploymentQueryMock);
        Mockito.when((Object)((Deployment)deploymentQueryMock.singleResult())).thenReturn((Object)mockDeployment);
        Mockito.when((Object)this.mockRepoService.createDeploymentQuery()).thenReturn((Object)deploymentQueryMock);
    }

    private void createFilterMock() {
        ArrayList<Filter> filters = new ArrayList<Filter>();
        Filter mockFilter = MockProvider.createMockFilter();
        filters.add(mockFilter);
        FilterQuery mockFilterQuery = (FilterQuery)Mockito.mock(FilterQuery.class);
        Mockito.when((Object)mockFilterQuery.list()).thenReturn(filters);
        Mockito.when((Object)this.mockFilterService.createFilterQuery()).thenReturn((Object)mockFilterQuery);
    }

    private void createHistoricJobLogMock() {
        HistoricJobLogQuery mockHistoricJobLogQuery = (HistoricJobLogQuery)Mockito.mock(HistoricJobLogQuery.class);
        List<HistoricJobLog> historicJobLogs = MockProvider.createMockHistoricJobLogs();
        Mockito.when((Object)mockHistoricJobLogQuery.list()).thenReturn(historicJobLogs);
        Mockito.when((Object)this.mockHistoryService.createHistoricJobLogQuery()).thenReturn((Object)mockHistoricJobLogQuery);
    }

    private void createExternalTaskMock() {
        ExternalTaskQuery query = (ExternalTaskQuery)Mockito.mock(ExternalTaskQuery.class);
        List<ExternalTask> tasks = MockProvider.createMockExternalTasks();
        Mockito.when((Object)query.list()).thenReturn(tasks);
        Mockito.when((Object)this.mockExternalTaskService.createExternalTaskQuery()).thenReturn((Object)query);
    }

    private void createHistoricExternalTaskLogMock() {
        HistoricExternalTaskLogQuery mockHistoricExternalTaskLogQuery = (HistoricExternalTaskLogQuery)Mockito.mock(HistoricExternalTaskLogQuery.class);
        List<HistoricExternalTaskLog> historicExternalTaskLogs = MockProvider.createMockHistoricExternalTaskLogs();
        Mockito.when((Object)mockHistoricExternalTaskLogQuery.list()).thenReturn(historicExternalTaskLogs);
        Mockito.when((Object)this.mockHistoryService.createHistoricExternalTaskLogQuery()).thenReturn((Object)mockHistoricExternalTaskLogQuery);
    }

    @Test
    public void testNonExistingEngineAccess() {
        RestAssured.given().pathParam("name", (Object)"aNonExistingEngineName").pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"No process engine available"), new Object[0]).when().get(PROCESS_DEFINITION_URL, new Object[0]);
    }

    @Test
    public void testEngineNamesList() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("$.size()", CoreMatchers.is((Object)2), new Object[0]).body("name", CoreMatchers.hasItems((Object[])new String[]{"default", "anotherEngineName"}), new Object[0]).when().get(ENGINES_URL, new Object[0]);
    }

    @Test
    public void testProcessDefinitionServiceEngineAccess() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_DEFINITION_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.mockRepoService)).getProcessDefinition((String)Mockito.eq((Object)"aProcDefId"));
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testProcessInstanceServiceEngineAccess() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).pathParam("id", (Object)"aProcInstId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(PROCESS_INSTANCE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.mockRuntimeService)).createProcessInstanceQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testTaskServiceEngineAccess() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(TASK_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.mockTaskService)).createTaskQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testIdentityServiceEngineAccess() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).queryParam("userId", new Object[]{"someId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(IDENTITY_GROUPS_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.mockIdentityService)).createUserQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testMessageServiceEngineAccess() {
        String messageName = "aMessage";
        HashMap<String, String> messageParameters = new HashMap<String, String>();
        messageParameters.put("messageName", messageName);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.mockRuntimeService)).createMessageCorrelation((String)Mockito.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.mockMessageCorrelationBuilder)).correlateWithResult();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockMessageCorrelationBuilder});
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testMessageWithResultServiceEngineAccess() {
        String messageName = "aMessage";
        HashMap<String, Object> messageParameters = new HashMap<String, Object>();
        messageParameters.put("messageName", messageName);
        messageParameters.put("resultEnabled", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(messageParameters).pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().contentType(ContentType.JSON).statusCode(Response.Status.OK.getStatusCode()).when().post(MESSAGE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.mockRuntimeService)).createMessageCorrelation((String)Mockito.eq((Object)messageName));
        ((MessageCorrelationBuilder)Mockito.verify((Object)this.mockMessageCorrelationBuilder)).correlateWithResult();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockMessageCorrelationBuilder});
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testExecutionServiceEngineAccess() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXECUTION_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.mockRuntimeService)).createExecutionQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testVariableInstanceServiceEngineAccess() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(VARIABLE_INSTANCE_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.mockRuntimeService)).createVariableInstanceQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testUserServiceEngineAccess() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(USER_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.mockIdentityService)).createUserQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testGroupServiceEngineAccess() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(GROUP_URL, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.mockIdentityService)).createGroupQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testAuthorizationServiceEngineAccess() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(AUTHORIZATION_CHECK_URL, new Object[0]);
    }

    @Test
    public void testHistoryServiceEngineAccess_HistoricActivityInstance() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_ACTIVITY_INSTANCE_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.mockHistoryService)).createHistoricActivityInstanceQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testHistoryServiceEngineAccess_HistoricProcessInstance() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_PROCESS_INSTANCE_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.mockHistoryService)).createHistoricProcessInstanceQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testHistoryServiceEngineAccess_HistoricVariableInstance() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_VARIABLE_INSTANCE_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.mockHistoryService)).createHistoricVariableInstanceQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Ignore
    @Test
    public void testHistoryServiceEngineAccess_HistoricVariableInstanceBinaryFile() {
        HistoricVariableInstanceQuery query = (HistoricVariableInstanceQuery)Mockito.mock(HistoricVariableInstanceQuery.class);
        HistoricVariableInstance instance = (HistoricVariableInstance)Mockito.mock(HistoricVariableInstance.class);
        String filename = "test.txt";
        byte[] byteContent = "test".getBytes();
        String encoding = "UTF-8";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(ContentType.TEXT.toString()).encoding(encoding).create();
        Mockito.when((Object)instance.getTypedValue()).thenReturn((Object)variableValue);
        Mockito.when((Object)((HistoricVariableInstance)query.singleResult())).thenReturn((Object)instance);
        Mockito.when((Object)this.mockHistoryService.createHistoricVariableInstanceQuery()).thenReturn((Object)query);
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body(CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new String(byteContent))), new Matcher[0]).and().header("Content-Disposition", "attachment; filename=\"" + filename + "\"; filename*=UTF-8''" + filename).contentType((Matcher)CoreMatchers.either((Matcher)CoreMatchers.equalTo((Object)(ContentType.TEXT.toString() + ";charset=UTF-8"))).or(CoreMatchers.equalTo((Object)(ContentType.TEXT.toString() + " ;charset=UTF-8")))).when().get(HISTORY_BINARY_VARIABLE_INSTANCE_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.mockHistoryService)).createHistoricVariableInstanceQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testHistoryServiceEngineAccess_HistoricActivityStatistics() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).pathParam("id", (Object)"aProcDefId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_ACTIVITY_STATISTICS_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.mockHistoryService)).createHistoricActivityStatisticsQuery("aProcDefId");
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testJobDefinitionAccess() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(JOB_DEFINITION_URL, new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).createJobDefinitionQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testHistoryServiceEngineAccess_HistoricDetail() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_DETAIL_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.mockHistoryService)).createHistoricDetailQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Ignore
    @Test
    public void testHistoryServiceEngineAccess_HistoricDetailBinaryFile() {
        HistoricDetailQuery query = (HistoricDetailQuery)Mockito.mock(HistoricDetailQuery.class);
        HistoricVariableUpdate instance = (HistoricVariableUpdate)Mockito.mock(HistoricVariableUpdate.class);
        String filename = "test.txt";
        byte[] byteContent = "test".getBytes();
        String encoding = "UTF-8";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(ContentType.TEXT.toString()).encoding(encoding).create();
        Mockito.when((Object)instance.getTypedValue()).thenReturn((Object)variableValue);
        Mockito.when((Object)((HistoricDetail)query.singleResult())).thenReturn((Object)instance);
        Mockito.when((Object)this.mockHistoryService.createHistoricDetailQuery()).thenReturn((Object)query);
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).body(CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)new String(byteContent))), new Matcher[0]).and().header("Content-Disposition", "attachment; filename=\"" + filename + "\"; filename*=UTF-8''" + filename).contentType((Matcher)CoreMatchers.either((Matcher)CoreMatchers.equalTo((Object)(ContentType.TEXT.toString() + ";charset=UTF-8"))).or(CoreMatchers.equalTo((Object)(ContentType.TEXT.toString() + " ;charset=UTF-8")))).when().get(HISTORY_BINARY_DETAIL_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.mockHistoryService)).createHistoricDetailQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testHistoryServiceEngineAccess_HistoricTaskInstance() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_TASK_INSTANCE_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.mockHistoryService)).createHistoricTaskInstanceQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testHistoryServiceEngineAccess_Incident() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(INCIDENT_URL, new Object[0]);
        ((RuntimeService)Mockito.verify((Object)this.mockRuntimeService)).createIncidentQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testHistoryServiceEngineAccess_HistoricIncident() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_INCIDENT_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.mockHistoryService)).createHistoricIncidentQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testDeploymentRestServiceEngineAccess() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).pathParam("id", (Object)"aDeploymentId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(DEPLOYMENT_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.mockRepoService)).createDeploymentQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testGetRegisteredDeployments() {
        HashSet<String> registeredDeployments = new HashSet<String>(Arrays.asList("deployment1", "deployment2"));
        Mockito.when((Object)this.mockManagementService.getRegisteredDeployments()).thenReturn(registeredDeployments);
        Response response = (Response)RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get("/rest-test/engine/{name}/deployment/registered", new Object[0]);
        ((ManagementService)Mockito.verify((Object)this.mockManagementService)).getRegisteredDeployments();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
        Assertions.assertThat((Iterable)((Iterable)response.getBody().as(Set.class))).isEqualTo(registeredDeployments);
    }

    @Test
    public void testCaseDefinitionAccess() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_DEFINITION_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.mockRepoService)).createCaseDefinitionQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testCaseInstanceAccess() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_INSTANCE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.mockCaseService)).createCaseInstanceQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testCaseExecutionAccess() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(CASE_EXECUTION_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.mockCaseService)).createCaseExecutionQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testFilterAccess() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(FILTER_URL, new Object[0]);
        ((FilterService)Mockito.verify((Object)this.mockFilterService)).createFilterQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testHistoryServiceEngineAccess_HistoricJobLog() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_JOB_LOG_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.mockHistoryService)).createHistoricJobLogQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testExternalTaskAccess() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(EXTERNAL_TASKS_URL, new Object[0]);
        ((ExternalTaskService)Mockito.verify((Object)this.mockExternalTaskService)).createExternalTaskQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }

    @Test
    public void testHistoryServiceEngineAccess_HistoricExternalTaskLog() {
        RestAssured.given().pathParam("name", (Object)EXAMPLE_ENGINE_NAME).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORY_EXTERNAL_TASK_LOG_URL, new Object[0]);
        ((HistoryService)Mockito.verify((Object)this.mockHistoryService)).createHistoricExternalTaskLogQuery();
        Mockito.verifyNoInteractions((Object[])new Object[]{processEngine});
    }
}

