/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.rest.CaseDefinitionRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.repository.CaseDefinitionDto;
import org.camunda.bpm.engine.rest.dto.repository.CaseDefinitionQueryDto;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.sub.repository.CaseDefinitionResource;
import org.camunda.bpm.engine.rest.sub.repository.impl.CaseDefinitionResourceImpl;

public class CaseDefinitionRestServiceImpl
extends AbstractRestProcessEngineAware
implements CaseDefinitionRestService {
    public CaseDefinitionRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public CaseDefinitionResource getCaseDefinitionByKey(String caseDefinitionKey) {
        CaseDefinition caseDefinition = (CaseDefinition)this.getProcessEngine().getRepositoryService().createCaseDefinitionQuery().caseDefinitionKey(caseDefinitionKey).withoutTenantId().latestVersion().singleResult();
        if (caseDefinition == null) {
            String errorMessage = String.format("No matching case definition with key: %s and no tenant-id", caseDefinitionKey);
            throw new RestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return this.getCaseDefinitionById(caseDefinition.getId());
    }

    @Override
    public CaseDefinitionResource getCaseDefinitionByKeyAndTenantId(String caseDefinitionKey, String tenantId) {
        CaseDefinition caseDefinition = (CaseDefinition)this.getProcessEngine().getRepositoryService().createCaseDefinitionQuery().caseDefinitionKey(caseDefinitionKey).tenantIdIn(new String[]{tenantId}).latestVersion().singleResult();
        if (caseDefinition == null) {
            String errorMessage = String.format("No matching case definition with key: %s and tenant-id: %s", caseDefinitionKey, tenantId);
            throw new RestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return this.getCaseDefinitionById(caseDefinition.getId());
    }

    @Override
    public CaseDefinitionResource getCaseDefinitionById(String caseDefinitionId) {
        return new CaseDefinitionResourceImpl(this.getProcessEngine(), caseDefinitionId, this.relativeRootResourcePath, this.getObjectMapper());
    }

    @Override
    public List<CaseDefinitionDto> getCaseDefinitions(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        CaseDefinitionQueryDto queryDto = new CaseDefinitionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ArrayList<CaseDefinitionDto> definitions = new ArrayList<CaseDefinitionDto>();
        ProcessEngine engine = this.getProcessEngine();
        CaseDefinitionQuery query = (CaseDefinitionQuery)queryDto.toQuery(engine);
        List<CaseDefinition> matchingDefinitions = null;
        matchingDefinitions = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        for (CaseDefinition definition : matchingDefinitions) {
            CaseDefinitionDto def = CaseDefinitionDto.fromCaseDefinition(definition);
            definitions.add(def);
        }
        return definitions;
    }

    private List<CaseDefinition> executePaginatedQuery(CaseDefinitionQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    @Override
    public CountResultDto getCaseDefinitionsCount(UriInfo uriInfo) {
        CaseDefinitionQueryDto queryDto = new CaseDefinitionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ProcessEngine engine = this.getProcessEngine();
        CaseDefinitionQuery query = (CaseDefinitionQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

