/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.identity.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.rest.dto.ResourceOptionsDto;
import org.camunda.bpm.engine.rest.sub.identity.TenantUserMembersResource;
import org.camunda.bpm.engine.rest.sub.identity.impl.AbstractIdentityResource;
import org.camunda.bpm.engine.rest.util.PathUtil;

public class TenantUserMembersResourceImpl
extends AbstractIdentityResource
implements TenantUserMembersResource {
    public TenantUserMembersResourceImpl(String processEngineName, String resourceId, String rootResourcePath, ObjectMapper objectMapper) {
        super(processEngineName, (Resource)Resources.TENANT_MEMBERSHIP, resourceId, objectMapper);
        this.relativeRootResourcePath = rootResourcePath;
    }

    @Override
    public void createMembership(String userId) {
        this.ensureNotReadOnly();
        userId = PathUtil.decodePathParam(userId);
        this.identityService.createTenantUserMembership(this.resourceId, userId);
    }

    @Override
    public void deleteMembership(String userId) {
        this.ensureNotReadOnly();
        userId = PathUtil.decodePathParam(userId);
        this.identityService.deleteTenantUserMembership(this.resourceId, userId);
    }

    @Override
    public ResourceOptionsDto availableOperations(UriInfo context) {
        ResourceOptionsDto dto = new ResourceOptionsDto();
        URI uri = context.getBaseUriBuilder().path(this.relativeRootResourcePath).path("/tenant").path(this.resourceId).path("/user-members").build(new Object[0]);
        if (!this.identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.DELETE)) {
            dto.addReflexiveLink(uri, "DELETE", "delete");
        }
        if (!this.identityService.isReadOnly() && this.isAuthorized((Permission)Permissions.CREATE)) {
            dto.addReflexiveLink(uri, "PUT", "create");
        }
        return dto;
    }
}

