/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.dmn.engine.DmnDecisionResult;
import org.camunda.bpm.dmn.engine.DmnEngineException;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.dmn.DecisionsEvaluationBuilder;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.impl.util.ReflectUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.HistoryTimeToLiveDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.helper.MockDecisionResultBuilder;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.sub.repository.impl.ProcessDefinitionResourceImpl;
import org.camunda.bpm.engine.rest.util.VariablesBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class DecisionDefinitionRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String DECISION_DEFINITION_URL = "/rest-test/decision-definition";
    protected static final String SINGLE_DECISION_DEFINITION_URL = "/rest-test/decision-definition/{id}";
    protected static final String SINGLE_DECISION_DEFINITION_BY_KEY_URL = "/rest-test/decision-definition/key/{key}";
    protected static final String SINGLE_DECISION_DEFINITION_BY_KEY_AND_TENANT_ID_URL = "/rest-test/decision-definition/key/{key}/tenant-id/{tenant-id}";
    protected static final String XML_DEFINITION_URL = "/rest-test/decision-definition/{id}/xml";
    protected static final String XML_DEFINITION_BY_KEY_URL = "/rest-test/decision-definition/key/{key}/xml";
    protected static final String DIAGRAM_DEFINITION_URL = "/rest-test/decision-definition/{id}/diagram";
    protected static final String EVALUATE_DECISION_URL = "/rest-test/decision-definition/{id}/evaluate";
    protected static final String EVALUATE_DECISION_BY_KEY_URL = "/rest-test/decision-definition/key/{key}/evaluate";
    protected static final String EVALUATE_DECISION_BY_KEY_AND_TENANT_ID_URL = "/rest-test/decision-definition/key/{key}/tenant-id/{tenant-id}/evaluate";
    protected static final String UPDATE_HISTORY_TIME_TO_LIVE_URL = "/rest-test/decision-definition/{id}/history-time-to-live";
    private RepositoryService repositoryServiceMock;
    private DecisionDefinitionQuery decisionDefinitionQueryMock;
    private DecisionService decisionServiceMock;
    private DecisionsEvaluationBuilder decisionEvaluationBuilderMock;

    @Before
    public void setUpRuntime() {
        DecisionDefinition mockDecisionDefinition = MockProvider.createMockDecisionDefinition();
        this.setUpRuntimeData(mockDecisionDefinition);
        this.setUpDecisionService();
    }

    private void setUpRuntimeData(DecisionDefinition mockDecisionDefinition) {
        this.repositoryServiceMock = (RepositoryService)Mockito.mock(RepositoryService.class);
        Mockito.when((Object)processEngine.getRepositoryService()).thenReturn((Object)this.repositoryServiceMock);
        Mockito.when((Object)this.repositoryServiceMock.getDecisionDefinition((String)Mockito.eq((Object)"aDecisionDefinitionId"))).thenReturn((Object)mockDecisionDefinition);
        Mockito.when((Object)this.repositoryServiceMock.getDecisionModel((String)Mockito.eq((Object)"aDecisionDefinitionId"))).thenReturn((Object)this.createMockDecisionDefinitionDmnXml());
        this.decisionDefinitionQueryMock = (DecisionDefinitionQuery)Mockito.mock(DecisionDefinitionQuery.class);
        Mockito.when((Object)this.decisionDefinitionQueryMock.decisionDefinitionKey("aDecisionDefinitionKey")).thenReturn((Object)this.decisionDefinitionQueryMock);
        Mockito.when((Object)this.decisionDefinitionQueryMock.tenantIdIn(new String[]{Mockito.anyString()})).thenReturn((Object)this.decisionDefinitionQueryMock);
        Mockito.when((Object)this.decisionDefinitionQueryMock.withoutTenantId()).thenReturn((Object)this.decisionDefinitionQueryMock);
        Mockito.when((Object)this.decisionDefinitionQueryMock.latestVersion()).thenReturn((Object)this.decisionDefinitionQueryMock);
        Mockito.when((Object)((DecisionDefinition)this.decisionDefinitionQueryMock.singleResult())).thenReturn((Object)mockDecisionDefinition);
        Mockito.when((Object)this.decisionDefinitionQueryMock.list()).thenReturn(Collections.singletonList(mockDecisionDefinition));
        Mockito.when((Object)this.repositoryServiceMock.createDecisionDefinitionQuery()).thenReturn((Object)this.decisionDefinitionQueryMock);
    }

    private InputStream createMockDecisionDefinitionDmnXml() {
        InputStream dmnXmlInputStream = ReflectUtil.getResourceAsStream((String)"decisions/decision-model.dmn");
        Assert.assertNotNull((Object)dmnXmlInputStream);
        return dmnXmlInputStream;
    }

    private void setUpDecisionService() {
        this.decisionEvaluationBuilderMock = (DecisionsEvaluationBuilder)Mockito.mock(DecisionsEvaluationBuilder.class);
        Mockito.when((Object)this.decisionEvaluationBuilderMock.variables(Mockito.anyMap())).thenReturn((Object)this.decisionEvaluationBuilderMock);
        this.decisionServiceMock = (DecisionService)Mockito.mock(DecisionService.class);
        Mockito.when((Object)this.decisionServiceMock.evaluateDecisionById("aDecisionDefinitionId")).thenReturn((Object)this.decisionEvaluationBuilderMock);
        Mockito.when((Object)this.decisionServiceMock.evaluateDecisionByKey("aDecisionDefinitionKey")).thenReturn((Object)this.decisionEvaluationBuilderMock);
        Mockito.when((Object)processEngine.getDecisionService()).thenReturn((Object)this.decisionServiceMock);
    }

    @Test
    public void testDecisionDefinitionDmnXmlRetrieval() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aDecisionDefinitionId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(XML_DEFINITION_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertTrue((boolean)responseContent.contains("aDecisionDefinitionId"));
        Assert.assertTrue((boolean)responseContent.contains("<?xml"));
    }

    @Test
    public void testDefinitionRetrieval() {
        RestAssured.given().pathParam("id", (Object)"aDecisionDefinitionId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aDecisionDefinitionId"), new Object[0]).body("key", Matchers.equalTo((Object)"aDecisionDefinitionKey"), new Object[0]).body("category", Matchers.equalTo((Object)"aDecisionDefinitionCategory"), new Object[0]).body("name", Matchers.equalTo((Object)"aDecisionDefinitionName"), new Object[0]).body("deploymentId", Matchers.equalTo((Object)"aDeploymentId"), new Object[0]).body("version", Matchers.equalTo((Object)1), new Object[0]).body("resource", Matchers.equalTo((Object)"aDecisionDefinitionResourceName"), new Object[0]).body("decisionRequirementsDefinitionId", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionId"), new Object[0]).body("decisionRequirementsDefinitionKey", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionKey"), new Object[0]).body("tenantId", Matchers.equalTo(null), new Object[0]).when().get(SINGLE_DECISION_DEFINITION_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getDecisionDefinition("aDecisionDefinitionId");
    }

    @Test
    public void testDecisionDefinitionDmnXmlRetrieval_ByKey() {
        Response response = (Response)RestAssured.given().pathParam("key", (Object)"aDecisionDefinitionKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(XML_DEFINITION_BY_KEY_URL, new Object[0]);
        String responseContent = response.asString();
        Assert.assertTrue((boolean)responseContent.contains("aDecisionDefinitionId"));
        Assert.assertTrue((boolean)responseContent.contains("<?xml"));
    }

    @Test
    public void testDefinitionRetrieval_ByKey() {
        RestAssured.given().pathParam("key", (Object)"aDecisionDefinitionKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aDecisionDefinitionId"), new Object[0]).body("key", Matchers.equalTo((Object)"aDecisionDefinitionKey"), new Object[0]).body("category", Matchers.equalTo((Object)"aDecisionDefinitionCategory"), new Object[0]).body("name", Matchers.equalTo((Object)"aDecisionDefinitionName"), new Object[0]).body("deploymentId", Matchers.equalTo((Object)"aDeploymentId"), new Object[0]).body("version", Matchers.equalTo((Object)1), new Object[0]).body("resource", Matchers.equalTo((Object)"aDecisionDefinitionResourceName"), new Object[0]).body("decisionRequirementsDefinitionId", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionId"), new Object[0]).body("decisionRequirementsDefinitionKey", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionKey"), new Object[0]).body("tenantId", Matchers.equalTo(null), new Object[0]).when().get(SINGLE_DECISION_DEFINITION_BY_KEY_URL, new Object[0]);
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.decisionDefinitionQueryMock)).withoutTenantId();
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getDecisionDefinition("aDecisionDefinitionId");
    }

    @Test
    public void testNonExistingDecisionDefinitionRetrieval_ByKey() {
        String nonExistingKey = "aNonExistingDefinitionKey";
        Mockito.when((Object)this.repositoryServiceMock.createDecisionDefinitionQuery().decisionDefinitionKey(nonExistingKey)).thenReturn((Object)this.decisionDefinitionQueryMock);
        Mockito.when((Object)this.decisionDefinitionQueryMock.latestVersion()).thenReturn((Object)this.decisionDefinitionQueryMock);
        Mockito.when((Object)((DecisionDefinition)this.decisionDefinitionQueryMock.singleResult())).thenReturn(null);
        Mockito.when((Object)this.decisionDefinitionQueryMock.list()).thenReturn(Collections.emptyList());
        RestAssured.given().pathParam("key", (Object)nonExistingKey).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("No matching decision definition with key: " + nonExistingKey)), new Object[0]).when().get(SINGLE_DECISION_DEFINITION_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testDefinitionRetrieval_ByKeyAndTenantId() {
        DecisionDefinition mockDefinition = MockProvider.mockDecisionDefinition().tenantId("aTenantId").build();
        this.setUpRuntimeData(mockDefinition);
        RestAssured.given().pathParam("key", (Object)"aDecisionDefinitionKey").pathParam("tenant-id", (Object)"aTenantId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"aDecisionDefinitionId"), new Object[0]).body("key", Matchers.equalTo((Object)"aDecisionDefinitionKey"), new Object[0]).body("category", Matchers.equalTo((Object)"aDecisionDefinitionCategory"), new Object[0]).body("name", Matchers.equalTo((Object)"aDecisionDefinitionName"), new Object[0]).body("deploymentId", Matchers.equalTo((Object)"aDeploymentId"), new Object[0]).body("version", Matchers.equalTo((Object)1), new Object[0]).body("resource", Matchers.equalTo((Object)"aDecisionDefinitionResourceName"), new Object[0]).body("decisionRequirementsDefinitionId", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionId"), new Object[0]).body("decisionRequirementsDefinitionKey", Matchers.equalTo((Object)"aDecisionRequirementsDefinitionKey"), new Object[0]).body("tenantId", Matchers.equalTo((Object)"aTenantId"), new Object[0]).when().get(SINGLE_DECISION_DEFINITION_BY_KEY_AND_TENANT_ID_URL, new Object[0]);
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.decisionDefinitionQueryMock)).tenantIdIn(new String[]{"aTenantId"});
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getDecisionDefinition("aDecisionDefinitionId");
    }

    @Test
    public void testNonExistingDecisionDefinitionRetrieval_ByKeyAndTenantId() {
        String nonExistingKey = "aNonExistingDefinitionKey";
        String nonExistingTenantId = "aNonExistingTenantId";
        Mockito.when((Object)this.repositoryServiceMock.createDecisionDefinitionQuery().decisionDefinitionKey(nonExistingKey)).thenReturn((Object)this.decisionDefinitionQueryMock);
        Mockito.when((Object)((DecisionDefinition)this.decisionDefinitionQueryMock.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("key", (Object)nonExistingKey).pathParam("tenant-id", (Object)nonExistingTenantId).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("No matching decision definition with key: " + nonExistingKey + " and tenant-id: " + nonExistingTenantId)), new Object[0]).when().get(SINGLE_DECISION_DEFINITION_BY_KEY_AND_TENANT_ID_URL, new Object[0]);
    }

    @Test
    public void testEvaluateDecisionByKeyAndTenantId() {
        DecisionDefinition mockDefinition = MockProvider.mockDecisionDefinition().tenantId("aTenantId").build();
        this.setUpRuntimeData(mockDefinition);
        DmnDecisionResult decisionResult = MockProvider.createMockDecisionResult();
        Mockito.when((Object)this.decisionEvaluationBuilderMock.evaluate()).thenReturn((Object)decisionResult);
        HashMap<String, Map<String, Object>> json = new HashMap<String, Map<String, Object>>();
        json.put("variables", VariablesBuilder.create().variable("amount", 420).variable("invoiceCategory", "MISC").getVariables());
        RestAssured.given().pathParam("key", (Object)"aDecisionDefinitionKey").pathParam("tenant-id", (Object)"aTenantId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EVALUATE_DECISION_BY_KEY_AND_TENANT_ID_URL, new Object[0]);
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("amount", 420);
        expectedVariables.put("invoiceCategory", "MISC");
        ((DecisionDefinitionQuery)Mockito.verify((Object)this.decisionDefinitionQueryMock)).tenantIdIn(new String[]{"aTenantId"});
        ((DecisionsEvaluationBuilder)Mockito.verify((Object)this.decisionEvaluationBuilderMock)).variables(expectedVariables);
        ((DecisionsEvaluationBuilder)Mockito.verify((Object)this.decisionEvaluationBuilderMock)).evaluate();
    }

    @Test
    public void testDecisionDiagramRetrieval() throws FileNotFoundException, URISyntaxException {
        File file = this.getFile("/processes/todo-process.png");
        Mockito.when((Object)this.repositoryServiceMock.getDecisionDiagram("aDecisionDefinitionId")).thenReturn((Object)new FileInputStream(file));
        byte[] actual = ((Response)RestAssured.given().pathParam("id", (Object)"aDecisionDefinitionId").expect().statusCode(Response.Status.OK.getStatusCode()).contentType("image/png").header("Content-Disposition", "attachment; filename=\"aResourceName.png\"; filename*=UTF-8''aResourceName.png").when().get(DIAGRAM_DEFINITION_URL, new Object[0])).getBody().asByteArray();
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getDecisionDefinition("aDecisionDefinitionId");
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getDecisionDiagram("aDecisionDefinitionId");
        byte[] expected = IoUtil.readInputStream((InputStream)new FileInputStream(file), (String)"decision diagram");
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testDecisionDiagramNullFilename() throws FileNotFoundException, URISyntaxException {
        File file = this.getFile("/processes/todo-process.png");
        Mockito.when((Object)this.repositoryServiceMock.getDecisionDefinition("aDecisionDefinitionId").getDiagramResourceName()).thenReturn(null);
        Mockito.when((Object)this.repositoryServiceMock.getDecisionDiagram("aDecisionDefinitionId")).thenReturn((Object)new FileInputStream(file));
        byte[] actual = ((Response)RestAssured.given().pathParam("id", (Object)"aDecisionDefinitionId").expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/octet-stream").header("Content-Disposition", "attachment; filename=\"" + null + "\"; filename*=UTF-8''" + null).when().get(DIAGRAM_DEFINITION_URL, new Object[0])).getBody().asByteArray();
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getDecisionDiagram("aDecisionDefinitionId");
        byte[] expected = IoUtil.readInputStream((InputStream)new FileInputStream(file), (String)"decision diagram");
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
    }

    @Test
    public void testDecisionDiagramNotExist() {
        Mockito.when((Object)this.repositoryServiceMock.getDecisionDiagram("aDecisionDefinitionId")).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aDecisionDefinitionId").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().get(DIAGRAM_DEFINITION_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getDecisionDefinition("aDecisionDefinitionId");
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).getDecisionDiagram("aDecisionDefinitionId");
    }

    @Test
    public void testDecisionDiagramMediaType() {
        Assert.assertEquals((Object)"image/png", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"decision.png"));
        Assert.assertEquals((Object)"image/png", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"decision.PNG"));
        Assert.assertEquals((Object)"image/svg+xml", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"decision.svg"));
        Assert.assertEquals((Object)"image/jpeg", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"decision.jpeg"));
        Assert.assertEquals((Object)"image/jpeg", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"decision.jpg"));
        Assert.assertEquals((Object)"image/gif", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"decision.gif"));
        Assert.assertEquals((Object)"image/bmp", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"decision.bmp"));
        Assert.assertEquals((Object)"application/octet-stream", (Object)ProcessDefinitionResourceImpl.getMediaTypeForFileSuffix((String)"decision.UNKNOWN"));
    }

    @Test
    public void testEvaluateDecisionByKey() {
        DmnDecisionResult decisionResult = MockProvider.createMockDecisionResult();
        Mockito.when((Object)this.decisionEvaluationBuilderMock.evaluate()).thenReturn((Object)decisionResult);
        HashMap<String, Map<String, Object>> json = new HashMap<String, Map<String, Object>>();
        json.put("variables", VariablesBuilder.create().variable("amount", 420).variable("invoiceCategory", "MISC").getVariables());
        RestAssured.given().pathParam("key", (Object)"aDecisionDefinitionKey").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EVALUATE_DECISION_BY_KEY_URL, new Object[0]);
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("amount", 420);
        expectedVariables.put("invoiceCategory", "MISC");
        ((DecisionsEvaluationBuilder)Mockito.verify((Object)this.decisionEvaluationBuilderMock)).variables(expectedVariables);
        ((DecisionsEvaluationBuilder)Mockito.verify((Object)this.decisionEvaluationBuilderMock)).evaluate();
    }

    @Test
    public void testEvaluateDecisionById() {
        DmnDecisionResult decisionResult = MockProvider.createMockDecisionResult();
        Mockito.when((Object)this.decisionEvaluationBuilderMock.evaluate()).thenReturn((Object)decisionResult);
        HashMap<String, Map<String, Object>> json = new HashMap<String, Map<String, Object>>();
        json.put("variables", VariablesBuilder.create().variable("amount", 420).variable("invoiceCategory", "MISC").getVariables());
        RestAssured.given().pathParam("id", (Object)"aDecisionDefinitionId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(EVALUATE_DECISION_URL, new Object[0]);
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("amount", 420);
        expectedVariables.put("invoiceCategory", "MISC");
        ((DecisionsEvaluationBuilder)Mockito.verify((Object)this.decisionEvaluationBuilderMock)).variables(expectedVariables);
        ((DecisionsEvaluationBuilder)Mockito.verify((Object)this.decisionEvaluationBuilderMock)).evaluate();
    }

    @Test
    public void testEvaluateDecisionSingleDecisionOutput() {
        DmnDecisionResult decisionResult = new MockDecisionResultBuilder().resultEntries().entry("status", (TypedValue)Variables.stringValue((String)"gold")).build();
        Mockito.when((Object)this.decisionEvaluationBuilderMock.evaluate()).thenReturn((Object)decisionResult);
        HashMap json = new HashMap();
        json.put("variables", Collections.emptyMap());
        RestAssured.given().pathParam("id", (Object)"aDecisionDefinitionId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("size()", Matchers.is((Object)1), new Object[0]).body("[0].size()", Matchers.is((Object)1), new Object[0]).body("[0].status", Matchers.is((Matcher)Matchers.notNullValue()), new Object[0]).body("[0].status.value", Matchers.is((Object)"gold"), new Object[0]).when().post(EVALUATE_DECISION_URL, new Object[0]);
    }

    @Test
    public void testEvaluateDecisionMultipleDecisionOutputs() {
        DmnDecisionResult decisionResult = new MockDecisionResultBuilder().resultEntries().entry("status", (TypedValue)Variables.stringValue((String)"gold")).resultEntries().entry("assignee", (TypedValue)Variables.stringValue((String)"manager")).build();
        Mockito.when((Object)this.decisionEvaluationBuilderMock.evaluate()).thenReturn((Object)decisionResult);
        HashMap json = new HashMap();
        json.put("variables", Collections.emptyMap());
        RestAssured.given().pathParam("id", (Object)"aDecisionDefinitionId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("size()", Matchers.is((Object)2), new Object[0]).body("[0].size()", Matchers.is((Object)1), new Object[0]).body("[0].status.value", Matchers.is((Object)"gold"), new Object[0]).body("[1].size()", Matchers.is((Object)1), new Object[0]).body("[1].assignee.value", Matchers.is((Object)"manager"), new Object[0]).when().post(EVALUATE_DECISION_URL, new Object[0]);
    }

    @Test
    public void testEvaluateDecisionMultipleDecisionValues() {
        DmnDecisionResult decisionResult = new MockDecisionResultBuilder().resultEntries().entry("status", (TypedValue)Variables.stringValue((String)"gold")).entry("assignee", (TypedValue)Variables.stringValue((String)"manager")).build();
        Mockito.when((Object)this.decisionEvaluationBuilderMock.evaluate()).thenReturn((Object)decisionResult);
        HashMap json = new HashMap();
        json.put("variables", Collections.emptyMap());
        RestAssured.given().pathParam("id", (Object)"aDecisionDefinitionId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("size()", Matchers.is((Object)1), new Object[0]).body("[0].size()", Matchers.is((Object)2), new Object[0]).body("[0].status.value", Matchers.is((Object)"gold"), new Object[0]).body("[0].assignee.value", Matchers.is((Object)"manager"), new Object[0]).when().post(EVALUATE_DECISION_URL, new Object[0]);
    }

    @Test
    public void testEvaluateDecision_NotFound() {
        String message = "expected message";
        Mockito.when((Object)this.decisionEvaluationBuilderMock.evaluate()).thenThrow(new Throwable[]{new NotFoundException(message)});
        HashMap json = new HashMap();
        json.put("variables", Collections.emptyMap());
        RestAssured.given().pathParam("id", (Object)"aDecisionDefinitionId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)message), new Object[0]).when().post(EVALUATE_DECISION_URL, new Object[0]);
    }

    @Test
    public void testEvaluateDecisionByKey_NotFound() {
        String message = "expected message";
        Mockito.when((Object)this.decisionEvaluationBuilderMock.evaluate()).thenThrow(new Throwable[]{new NotFoundException(message)});
        HashMap json = new HashMap();
        json.put("variables", Collections.emptyMap());
        RestAssured.given().pathParam("key", (Object)"aDecisionDefinitionKey").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)message), new Object[0]).when().post(EVALUATE_DECISION_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void shouldReturnErrorCode() {
        Mockito.when((Object)this.decisionEvaluationBuilderMock.evaluate()).thenThrow(new Throwable[]{new ProcessEngineException("foo", 123)});
        HashMap json = new HashMap();
        json.put("variables", Collections.emptyMap());
        RestAssured.given().pathParam("key", (Object)"aDecisionDefinitionKey").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"foo"), new Object[0]).body("code", Matchers.equalTo((Object)123), new Object[0]).when().post(EVALUATE_DECISION_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testEvaluateDecision_NotValid() {
        String message = "expected message";
        Mockito.when((Object)this.decisionEvaluationBuilderMock.evaluate()).thenThrow(new Throwable[]{new NotValidException(message)});
        HashMap json = new HashMap();
        json.put("variables", Collections.emptyMap());
        RestAssured.given().pathParam("id", (Object)"aDecisionDefinitionId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)message), new Object[0]).when().post(EVALUATE_DECISION_URL, new Object[0]);
    }

    @Test
    public void testEvaluateDecisionByKey_NotValid() {
        String message = "expected message";
        Mockito.when((Object)this.decisionEvaluationBuilderMock.evaluate()).thenThrow(new Throwable[]{new NotValidException(message)});
        HashMap json = new HashMap();
        json.put("variables", Collections.emptyMap());
        RestAssured.given().pathParam("key", (Object)"aDecisionDefinitionKey").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)message), new Object[0]).when().post(EVALUATE_DECISION_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testEvaluateDecision_NotAuthorized() {
        String message = "expected message";
        Mockito.when((Object)this.decisionEvaluationBuilderMock.evaluate()).thenThrow(new Throwable[]{new AuthorizationException(message)});
        HashMap json = new HashMap();
        json.put("variables", Collections.emptyMap());
        RestAssured.given().pathParam("id", (Object)"aDecisionDefinitionId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)message), new Object[0]).when().post(EVALUATE_DECISION_URL, new Object[0]);
    }

    @Test
    public void testEvaluateDecisionByKey_NotAuthorized() {
        String message = "expected message";
        Mockito.when((Object)this.decisionEvaluationBuilderMock.evaluate()).thenThrow(new Throwable[]{new AuthorizationException(message)});
        HashMap json = new HashMap();
        json.put("variables", Collections.emptyMap());
        RestAssured.given().pathParam("key", (Object)"aDecisionDefinitionKey").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)message), new Object[0]).when().post(EVALUATE_DECISION_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testEvaluateDecision_ProcessEngineException() {
        String message = "expected message";
        Mockito.when((Object)this.decisionEvaluationBuilderMock.evaluate()).thenThrow(new Throwable[]{new ProcessEngineException(message)});
        HashMap json = new HashMap();
        json.put("variables", Collections.emptyMap());
        RestAssured.given().pathParam("id", (Object)"aDecisionDefinitionId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)message), new Object[0]).when().post(EVALUATE_DECISION_URL, new Object[0]);
    }

    @Test
    public void testEvaluateDecisionByKey_ProcessEngineException() {
        String message = "expected message";
        Mockito.when((Object)this.decisionEvaluationBuilderMock.evaluate()).thenThrow(new Throwable[]{new ProcessEngineException(message)});
        HashMap json = new HashMap();
        json.put("variables", Collections.emptyMap());
        RestAssured.given().pathParam("key", (Object)"aDecisionDefinitionKey").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)message), new Object[0]).when().post(EVALUATE_DECISION_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testEvaluateDecision_DmnEngineException() {
        String message = "expected message";
        Mockito.when((Object)this.decisionEvaluationBuilderMock.evaluate()).thenThrow(new Throwable[]{new DmnEngineException(message)});
        HashMap json = new HashMap();
        json.put("variables", Collections.emptyMap());
        RestAssured.given().pathParam("id", (Object)"aDecisionDefinitionId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)message), new Object[0]).when().post(EVALUATE_DECISION_URL, new Object[0]);
    }

    @Test
    public void testEvaluateDecisionByKey_DmnEngineException() {
        String message = "expected message";
        Mockito.when((Object)this.decisionEvaluationBuilderMock.evaluate()).thenThrow(new Throwable[]{new DmnEngineException(message)});
        HashMap json = new HashMap();
        json.put("variables", Collections.emptyMap());
        RestAssured.given().pathParam("key", (Object)"aDecisionDefinitionKey").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)message), new Object[0]).when().post(EVALUATE_DECISION_BY_KEY_URL, new Object[0]);
    }

    @Test
    public void testUpdateHistoryTimeToLive() {
        RestAssured.given().pathParam("id", (Object)"aDecisionDefinitionId").body((Object)new HistoryTimeToLiveDto(Integer.valueOf(5))).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(UPDATE_HISTORY_TIME_TO_LIVE_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).updateDecisionDefinitionHistoryTimeToLive("aDecisionDefinitionId", Integer.valueOf(5));
    }

    @Test
    public void testUpdateHistoryTimeToLiveNullValue() {
        RestAssured.given().pathParam("id", (Object)"aDecisionDefinitionId").body((Object)new HistoryTimeToLiveDto()).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(UPDATE_HISTORY_TIME_TO_LIVE_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).updateDecisionDefinitionHistoryTimeToLive("aDecisionDefinitionId", null);
    }

    @Test
    public void testUpdateHistoryTimeToLiveNegativeValue() {
        String expectedMessage = "expectedMessage";
        ((RepositoryService)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException(expectedMessage)}).when((Object)this.repositoryServiceMock)).updateDecisionDefinitionHistoryTimeToLive((String)Mockito.eq((Object)"aDecisionDefinitionId"), Integer.valueOf(Mockito.eq((int)-1)));
        RestAssured.given().pathParam("id", (Object)"aDecisionDefinitionId").body((Object)new HistoryTimeToLiveDto(Integer.valueOf(-1))).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.is((Object)BadUserRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)expectedMessage), new Object[0]).when().put(UPDATE_HISTORY_TIME_TO_LIVE_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).updateDecisionDefinitionHistoryTimeToLive("aDecisionDefinitionId", Integer.valueOf(-1));
    }

    @Test
    public void testUpdateHistoryTimeToLiveAuthorizationException() {
        String expectedMessage = "expectedMessage";
        ((RepositoryService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(expectedMessage)}).when((Object)this.repositoryServiceMock)).updateDecisionDefinitionHistoryTimeToLive((String)Mockito.eq((Object)"aDecisionDefinitionId"), Integer.valueOf(Mockito.eq((int)5)));
        RestAssured.given().pathParam("id", (Object)"aDecisionDefinitionId").body((Object)new HistoryTimeToLiveDto(Integer.valueOf(5))).contentType(ContentType.JSON).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.is((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)expectedMessage), new Object[0]).when().put(UPDATE_HISTORY_TIME_TO_LIVE_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock)).updateDecisionDefinitionHistoryTimeToLive("aDecisionDefinitionId", Integer.valueOf(5));
    }
}

