/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.OrderingBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class HistoricActivityInstanceRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL = "/rest-test/history/activity-instance";
    protected static final String HISTORIC_ACTIVITY_INSTANCE_COUNT_RESOURCE_URL = "/rest-test/history/activity-instance/count";
    protected HistoricActivityInstanceQuery mockedQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedQuery = this.setUpMockHistoricActivityInstanceQuery(MockProvider.createMockHistoricActivityInstances());
    }

    private HistoricActivityInstanceQuery setUpMockHistoricActivityInstanceQuery(List<HistoricActivityInstance> mockedHistoricActivityInstances) {
        HistoricActivityInstanceQuery mockedhistoricActivityInstanceQuery = (HistoricActivityInstanceQuery)Mockito.mock(HistoricActivityInstanceQuery.class);
        Mockito.when((Object)mockedhistoricActivityInstanceQuery.list()).thenReturn(mockedHistoricActivityInstances);
        Mockito.when((Object)mockedhistoricActivityInstanceQuery.count()).thenReturn((Object)mockedHistoricActivityInstances.size());
        Mockito.when((Object)processEngine.getHistoryService().createHistoricActivityInstanceQuery()).thenReturn((Object)mockedhistoricActivityInstanceQuery);
        return mockedhistoricActivityInstanceQuery;
    }

    @Test
    public void testEmptyQuery() {
        String queryKey = "";
        RestAssured.given().queryParam("processInstanceId", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testNoParametersQueryAsPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("instanceId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"instanceId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityInstanceId", "asc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricActivityInstanceId();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityInstanceId", "desc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricActivityInstanceId();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("instanceId", "asc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("instanceId", "desc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("executionId", "asc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByExecutionId();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("executionId", "desc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByExecutionId();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityId", "asc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityId();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityId", "desc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityId();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityName", "asc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityName();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityName", "desc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityName();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityType", "asc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityType();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("activityType", "desc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByActivityType();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("startTime", "asc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricActivityInstanceStartTime();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("startTime", "desc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricActivityInstanceStartTime();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("endTime", "asc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricActivityInstanceEndTime();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("endTime", "desc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricActivityInstanceEndTime();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("duration", "asc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricActivityInstanceDuration();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("duration", "desc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByHistoricActivityInstanceDuration();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("definitionId", "asc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("definitionId", "desc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("occurrence", "asc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderPartiallyByOccurrence();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("occurrence", "desc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderPartiallyByOccurrence();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSecondarySortingAsPost() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        HashMap<String, List<Map<String, Object>>> json = new HashMap<String, List<Map<String, Object>>>();
        json.put("sorting", OrderingBuilder.create().orderBy("definitionId").desc().orderBy("instanceId").asc().getJson());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(HISTORIC_ACTIVITY_INSTANCE_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testQueryCountForPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().body("count", Matchers.equalTo((Object)1), new Object[0]).when().post(HISTORIC_ACTIVITY_INSTANCE_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testSimpleHistoricActivityQuery() {
        String processInstanceId = "aProcInstId";
        Response response = (Response)RestAssured.given().queryParam("processInstanceId", new Object[]{processInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).processInstanceId(processInstanceId);
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one activity instance returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"The returned activity instance should not be null.", instances.get(0));
        String returnedId = JsonPath.from((String)content).getString("[0].id");
        String returnedParentActivityInstanceId = JsonPath.from((String)content).getString("[0].parentActivityInstanceId");
        String returnedActivityId = JsonPath.from((String)content).getString("[0].activityId");
        String returnedActivityName = JsonPath.from((String)content).getString("[0].activityName");
        String returnedActivityType = JsonPath.from((String)content).getString("[0].activityType");
        String returnedProcessDefinitionKey = JsonPath.from((String)content).getString("[0].processDefinitionKey");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("[0].processInstanceId");
        String returnedExecutionId = JsonPath.from((String)content).getString("[0].executionId");
        String returnedTaskId = JsonPath.from((String)content).getString("[0].taskId");
        String returnedCalledProcessInstanceId = JsonPath.from((String)content).getString("[0].calledProcessInstanceId");
        String returnedCalledCaseInstanceId = JsonPath.from((String)content).getString("[0].calledCaseInstanceId");
        String returnedAssignee = JsonPath.from((String)content).getString("[0].assignee");
        Date returnedStartTime = DateTimeUtil.parseDate((String)JsonPath.from((String)content).getString("[0].startTime"));
        Date returnedEndTime = DateTimeUtil.parseDate((String)JsonPath.from((String)content).getString("[0].endTime"));
        long returnedDurationInMillis = JsonPath.from((String)content).getLong("[0].durationInMillis");
        boolean canceled = JsonPath.from((String)content).getBoolean("[0].canceled");
        boolean completeScope = JsonPath.from((String)content).getBoolean("[0].completeScope");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assert.assertEquals((Object)"aHistoricActivityInstanceId", (Object)returnedId);
        Assert.assertEquals((Object)"aHistoricParentActivityInstanceId", (Object)returnedParentActivityInstanceId);
        Assert.assertEquals((Object)"anActivity", (Object)returnedActivityId);
        Assert.assertEquals((Object)"anActivityName", (Object)returnedActivityName);
        Assert.assertEquals((Object)"anActivityType", (Object)returnedActivityType);
        Assert.assertEquals((Object)"aKey", (Object)returnedProcessDefinitionKey);
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId);
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals((Object)"anExecutionId", (Object)returnedExecutionId);
        Assert.assertEquals((Object)"anId", (Object)returnedTaskId);
        Assert.assertEquals((Object)"aHistoricCalledProcessInstanceId", (Object)returnedCalledProcessInstanceId);
        Assert.assertEquals((Object)"aHistoricCalledCaseInstanceId", (Object)returnedCalledCaseInstanceId);
        Assert.assertEquals((Object)"anAssignee", (Object)returnedAssignee);
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_ACTIVITY_INSTANCE_START_TIME), (Object)returnedStartTime);
        Assert.assertEquals((Object)DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_ACTIVITY_INSTANCE_END_TIME), (Object)returnedEndTime);
        Assert.assertEquals((long)2000L, (long)returnedDurationInMillis);
        Assert.assertEquals((Object)true, (Object)canceled);
        Assert.assertEquals((Object)true, (Object)completeScope);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId);
    }

    @Test
    public void testAdditionalParameters() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        RestAssured.given().queryParams(stringQueryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStringParameterQueryInvocations();
    }

    @Test
    public void testAdditionalParametersAsPost() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(stringQueryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStringParameterQueryInvocations();
    }

    @Test
    public void testBooleanParameters() {
        Map<String, Boolean> params = this.getCompleteBooleanQueryParameters();
        RestAssured.given().queryParams(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyBooleanParameterQueryInvocations();
    }

    @Test
    public void testBooleanParametersAsPost() {
        Map<String, Boolean> params = this.getCompleteBooleanQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(params).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyBooleanParameterQueryInvocations();
    }

    private Map<String, String> getCompleteStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("activityInstanceId", "aHistoricActivityInstanceId");
        parameters.put("processInstanceId", "aProcInstId");
        parameters.put("processDefinitionId", "aProcDefId");
        parameters.put("executionId", "anExecutionId");
        parameters.put("activityId", "anActivity");
        parameters.put("activityName", "anActivityName");
        parameters.put("activityNameLike", "anActivityName");
        parameters.put("activityType", "anActivityType");
        parameters.put("taskAssignee", "anAssignee");
        return parameters;
    }

    private Map<String, Boolean> getCompleteBooleanQueryParameters() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("canceled", true);
        parameters.put("completeScope", true);
        return parameters;
    }

    private void verifyStringParameterQueryInvocations() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityInstanceId(stringQueryParameters.get("activityInstanceId"));
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceId(stringQueryParameters.get("processInstanceId"));
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId(stringQueryParameters.get("processDefinitionId"));
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executionId(stringQueryParameters.get("executionId"));
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityId(stringQueryParameters.get("activityId"));
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityName(stringQueryParameters.get("activityName"));
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityNameLike(stringQueryParameters.get("activityNameLike"));
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityType(stringQueryParameters.get("activityType"));
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).taskAssignee(stringQueryParameters.get("taskAssignee"));
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    private void verifyBooleanParameterQueryInvocations() {
        Map<String, Boolean> booleanParams = this.getCompleteBooleanQueryParameters();
        Boolean canceled = booleanParams.get("canceled");
        Boolean completeScope = booleanParams.get("completeScope");
        if (canceled != null && canceled.booleanValue()) {
            ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).canceled();
        }
        if (completeScope != null && completeScope.booleanValue()) {
            ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).completeScope();
        }
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testFinishedHistoricActivityQuery() {
        Response response = (Response)RestAssured.given().queryParam("finished", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).finished();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one activity instance returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"The returned activity instance should not be null.", instances.get(0));
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("[0].processInstanceId");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedActivityEndTime = JsonPath.from((String)content).getString("[0].endTime");
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_ACTIVITY_INSTANCE_END_TIME, (Object)returnedActivityEndTime);
    }

    @Test
    public void testFinishedHistoricActivityQueryAsPost() {
        HashMap<String, Boolean> body = new HashMap<String, Boolean>();
        body.put("finished", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).finished();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one activity instance returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"The returned activity instance should not be null.", instances.get(0));
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("[0].processInstanceId");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedActivityEndTime = JsonPath.from((String)content).getString("[0].endTime");
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_ACTIVITY_INSTANCE_END_TIME, (Object)returnedActivityEndTime);
    }

    @Test
    public void testUnfinishedHistoricActivityQuery() {
        List<HistoricActivityInstance> mockedHistoricActivityInstances = MockProvider.createMockRunningHistoricActivityInstances();
        HistoricActivityInstanceQuery mockedhistoricActivityInstanceQuery = (HistoricActivityInstanceQuery)Mockito.mock(HistoricActivityInstanceQuery.class);
        Mockito.when((Object)mockedhistoricActivityInstanceQuery.list()).thenReturn(mockedHistoricActivityInstances);
        Mockito.when((Object)processEngine.getHistoryService().createHistoricActivityInstanceQuery()).thenReturn((Object)mockedhistoricActivityInstanceQuery);
        Response response = (Response)RestAssured.given().queryParam("unfinished", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockedhistoricActivityInstanceQuery});
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)mockedhistoricActivityInstanceQuery)).unfinished();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)mockedhistoricActivityInstanceQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one activity instance returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"The returned activity instance should not be null.", instances.get(0));
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedActivityEndTime = JsonPath.from((String)content).getString("[0].endTime");
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId);
        Assert.assertNull((Object)returnedActivityEndTime);
    }

    @Test
    public void testUnfinishedHistoricActivityQueryAsPost() {
        List<HistoricActivityInstance> mockedHistoricActivityInstances = MockProvider.createMockRunningHistoricActivityInstances();
        HistoricActivityInstanceQuery mockedhistoricActivityInstanceQuery = (HistoricActivityInstanceQuery)Mockito.mock(HistoricActivityInstanceQuery.class);
        Mockito.when((Object)mockedhistoricActivityInstanceQuery.list()).thenReturn(mockedHistoricActivityInstances);
        Mockito.when((Object)processEngine.getHistoryService().createHistoricActivityInstanceQuery()).thenReturn((Object)mockedhistoricActivityInstanceQuery);
        HashMap<String, Boolean> body = new HashMap<String, Boolean>();
        body.put("unfinished", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockedhistoricActivityInstanceQuery});
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)mockedhistoricActivityInstanceQuery)).unfinished();
        ((HistoricActivityInstanceQuery)inOrder.verify((Object)mockedhistoricActivityInstanceQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one activity instance returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"The returned activity instance should not be null.", instances.get(0));
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedActivityEndTime = JsonPath.from((String)content).getString("[0].endTime");
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId);
        Assert.assertNull((Object)returnedActivityEndTime);
    }

    @Test
    public void testHistoricBeforeAndAfterStartTimeQuery() {
        RestAssured.given().queryParam("startedBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_ACTIVITY_INSTANCE_STARTED_BEFORE}).queryParam("startedAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_ACTIVITY_INSTANCE_STARTED_AFTER}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStartParameterQueryInvocations();
    }

    @Test
    public void testHistoricBeforeAndAfterStartTimeQueryAsPost() {
        Map<String, Date> parameters = this.getCompleteStartDateQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStartParameterQueryInvocations();
    }

    private Map<String, Date> getCompleteStartDateQueryParameters() {
        HashMap<String, Date> parameters = new HashMap<String, Date>();
        parameters.put("startedAfter", DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_ACTIVITY_INSTANCE_STARTED_AFTER));
        parameters.put("startedBefore", DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_ACTIVITY_INSTANCE_STARTED_BEFORE));
        return parameters;
    }

    private void verifyStartParameterQueryInvocations() {
        Map<String, Date> startDateParameters = this.getCompleteStartDateQueryParameters();
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).startedBefore(startDateParameters.get("startedBefore"));
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).startedAfter(startDateParameters.get("startedAfter"));
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testHistoricAfterAndBeforeFinishTimeQuery() {
        RestAssured.given().queryParam("finishedAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_ACTIVITY_INSTANCE_FINISHED_AFTER}).queryParam("finishedBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_ACTIVITY_INSTANCE_FINISHED_BEFORE}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyFinishedParameterQueryInvocations();
    }

    @Test
    public void testHistoricAfterAndBeforeFinishTimeQueryAsPost() {
        Map<String, Date> parameters = this.getCompleteFinishedDateQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyFinishedParameterQueryInvocations();
    }

    private Map<String, Date> getCompleteFinishedDateQueryParameters() {
        HashMap<String, Date> parameters = new HashMap<String, Date>();
        parameters.put("finishedAfter", DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_ACTIVITY_INSTANCE_FINISHED_AFTER));
        parameters.put("finishedBefore", DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_ACTIVITY_INSTANCE_FINISHED_BEFORE));
        return parameters;
    }

    private void verifyFinishedParameterQueryInvocations() {
        Map<String, Date> finishedDateParameters = this.getCompleteFinishedDateQueryParameters();
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).finishedAfter(finishedDateParameters.get("finishedAfter"));
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).finishedBefore(finishedDateParameters.get("finishedBefore"));
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testTenantIdListParameter() {
        this.mockedQuery = this.setUpMockHistoricActivityInstanceQuery(this.createMockHistoricActivityInstancesTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)executions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testTenantIdListPostParameter() {
        this.mockedQuery = this.setUpMockHistoricActivityInstanceQuery(this.createMockHistoricActivityInstancesTwoTenants());
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("tenantIdIn", "aTenantId,anotherTenantId".split(","));
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)executions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testQueryFilterWithoutTenantIdParameter() {
        HistoricActivityInstance activityInstance = MockProvider.createMockHistoricActivityInstance(null);
        this.mockedQuery = this.setUpMockHistoricActivityInstanceQuery(Collections.singletonList(activityInstance));
        Response response = (Response)RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId).isEqualTo(null);
    }

    @Test
    public void testQueryFilterWithoutTenantIdPostParameter() {
        HistoricActivityInstance activityInstance = MockProvider.createMockHistoricActivityInstance(null);
        this.mockedQuery = this.setUpMockHistoricActivityInstanceQuery(Collections.singletonList(activityInstance));
        Map<String, Boolean> queryParameters = Collections.singletonMap("withoutTenantId", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_ACTIVITY_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((HistoricActivityInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId).isEqualTo(null);
    }

    private List<HistoricActivityInstance> createMockHistoricActivityInstancesTwoTenants() {
        return Arrays.asList(MockProvider.createMockHistoricActivityInstance("aTenantId"), MockProvider.createMockHistoricActivityInstance("anotherTenantId"));
    }
}

