/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.standalone;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.TenantQuery;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.AuthorizationServiceImpl;
import org.camunda.bpm.engine.impl.IdentityServiceImpl;
import org.camunda.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public abstract class AbstractAuthenticationFilterTest
extends AbstractRestServiceTest {
    protected static final String SERVLET_PATH = "/rest";
    protected static final String SERVICE_PATH = "/rest-test/rest/engine/{name}/process-definition";
    protected AuthorizationService authorizationServiceMock;
    protected IdentityService identityServiceMock;
    protected RepositoryService repositoryServiceMock;
    protected User userMock;
    protected List<String> groupIds;
    protected List<String> tenantIds;

    @Before
    public void setup() {
        this.authorizationServiceMock = (AuthorizationService)Mockito.mock(AuthorizationServiceImpl.class);
        this.identityServiceMock = (IdentityService)Mockito.mock(IdentityServiceImpl.class);
        this.repositoryServiceMock = (RepositoryService)Mockito.mock(RepositoryService.class);
        Mockito.when((Object)processEngine.getAuthorizationService()).thenReturn((Object)this.authorizationServiceMock);
        Mockito.when((Object)processEngine.getIdentityService()).thenReturn((Object)this.identityServiceMock);
        Mockito.when((Object)processEngine.getRepositoryService()).thenReturn((Object)this.repositoryServiceMock);
        this.userMock = MockProvider.createMockUser();
        List<Group> groupMocks = MockProvider.createMockGroups();
        this.groupIds = this.setupGroupQueryMock(groupMocks);
        List<Tenant> tenantMocks = Collections.singletonList(MockProvider.createMockTenant());
        this.tenantIds = this.setupTenantQueryMock(tenantMocks);
        ProcessDefinition mockDefinition = MockProvider.createMockDefinition();
        List<ProcessDefinition> mockDefinitions = Arrays.asList(mockDefinition);
        ProcessDefinitionQuery mockQuery = (ProcessDefinitionQuery)Mockito.mock(ProcessDefinitionQuery.class);
        Mockito.when((Object)this.repositoryServiceMock.createProcessDefinitionQuery()).thenReturn((Object)mockQuery);
        Mockito.when((Object)mockQuery.list()).thenReturn(mockDefinitions);
    }

    protected List<String> setupGroupQueryMock(List<Group> groups) {
        GroupQuery mockGroupQuery = (GroupQuery)Mockito.mock(GroupQuery.class);
        Mockito.when((Object)this.identityServiceMock.createGroupQuery()).thenReturn((Object)mockGroupQuery);
        Mockito.when((Object)mockGroupQuery.groupMember(Mockito.anyString())).thenReturn((Object)mockGroupQuery);
        Mockito.when((Object)mockGroupQuery.list()).thenReturn(groups);
        ArrayList<String> groupIds = new ArrayList<String>();
        for (Group groupMock : groups) {
            groupIds.add(groupMock.getId());
        }
        return groupIds;
    }

    protected List<String> setupTenantQueryMock(List<Tenant> tenants) {
        TenantQuery mockTenantQuery = (TenantQuery)Mockito.mock(TenantQuery.class);
        Mockito.when((Object)this.identityServiceMock.createTenantQuery()).thenReturn((Object)mockTenantQuery);
        Mockito.when((Object)mockTenantQuery.userMember(Mockito.anyString())).thenReturn((Object)mockTenantQuery);
        Mockito.when((Object)mockTenantQuery.includingGroupsOfUser(Mockito.anyBoolean())).thenReturn((Object)mockTenantQuery);
        Mockito.when((Object)mockTenantQuery.list()).thenReturn(tenants);
        ArrayList<String> tenantIds = new ArrayList<String>();
        for (Tenant tenant : tenants) {
            tenantIds.add(tenant.getId());
        }
        return tenantIds;
    }

    @Test
    public void testHttpBasicAuthenticationCheck() {
        Mockito.when((Object)this.identityServiceMock.checkPassword("userId", "s3cret")).thenReturn((Object)true);
        RestAssured.given().auth().basic("userId", "s3cret").pathParam("name", (Object)"default").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/json").when().get(SERVICE_PATH, new Object[0]);
        ((IdentityService)Mockito.verify((Object)this.identityServiceMock)).setAuthentication("userId", this.groupIds, this.tenantIds);
    }

    @Test
    public void testFailingAuthenticationCheck() {
        Mockito.when((Object)this.identityServiceMock.checkPassword("userId", "s3cret")).thenReturn((Object)false);
        RestAssured.given().auth().basic("userId", "s3cret").pathParam("name", (Object)"default").then().expect().statusCode(Response.Status.UNAUTHORIZED.getStatusCode()).header("WWW-Authenticate", "Basic realm=\"default\"").when().get(SERVICE_PATH, new Object[0]);
    }

    @Test
    public void testMissingAuthHeader() {
        RestAssured.given().pathParam("name", (Object)"someengine").then().expect().statusCode(Response.Status.UNAUTHORIZED.getStatusCode()).header("WWW-Authenticate", "Basic realm=\"someengine\"").when().get(SERVICE_PATH, new Object[0]);
    }

    @Test
    public void testUnexpectedAuthHeaderFormat() {
        RestAssured.given().header("Authorization", (Object)"Digest somevalues, and, some, more", new Object[0]).pathParam("name", (Object)"someengine").then().expect().statusCode(Response.Status.UNAUTHORIZED.getStatusCode()).header("WWW-Authenticate", "Basic realm=\"someengine\"").when().get(SERVICE_PATH, new Object[0]);
    }

    @Test
    public void testMalformedCredentials() {
        RestAssured.given().header("Authorization", (Object)("Basic " + new String(Base64.encodeBase64((byte[])"this is not a valid format".getBytes()))), new Object[0]).pathParam("name", (Object)"default").then().expect().statusCode(Response.Status.UNAUTHORIZED.getStatusCode()).header("WWW-Authenticate", "Basic realm=\"default\"").when().get(SERVICE_PATH, new Object[0]);
    }

    @Test
    public void testNonExistingEngineAuthentication() {
        RestAssured.given().auth().basic("userId", "s3cret").pathParam("name", (Object)"aNonExistingEngineName").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Process engine aNonExistingEngineName not available"), new Object[0]).when().get(SERVICE_PATH, new Object[0]);
    }

    @Test
    public void testMalformedBase64Value() {
        RestAssured.given().header("Authorization", (Object)"Basic someNonBase64Characters!(#", new Object[0]).pathParam("name", (Object)"default").then().expect().statusCode(Response.Status.UNAUTHORIZED.getStatusCode()).header("WWW-Authenticate", "Basic realm=\"default\"").when().get(SERVICE_PATH, new Object[0]);
    }
}

