/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.standalone;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.IdentityRestService;
import org.camunda.bpm.engine.rest.UserRestService;
import org.camunda.bpm.engine.rest.cache.Cache;
import org.camunda.bpm.engine.rest.hal.Hal;
import org.camunda.bpm.engine.rest.hal.HalLinkResolver;
import org.camunda.bpm.engine.rest.hal.cache.DefaultHalResourceCache;
import org.camunda.bpm.engine.rest.hal.cache.HalRelationCacheBootstrap;
import org.camunda.bpm.engine.rest.hal.cache.HalRelationCacheConfiguration;
import org.camunda.bpm.engine.rest.hal.cache.HalRelationCacheConfigurationException;
import org.camunda.bpm.engine.rest.hal.identitylink.HalIdentityLink;
import org.camunda.bpm.engine.rest.hal.user.HalUser;
import org.camunda.bpm.engine.task.IdentityLink;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class HalResourceCacheTest
extends AbstractRestServiceTest {
    protected DefaultHalResourceCache cache;
    protected HalRelationCacheBootstrap contextListener;

    @Before
    public void createCache() {
        this.cache = new DefaultHalResourceCache(100, 100L);
        this.contextListener = new HalRelationCacheBootstrap();
    }

    @After
    public void destroy() {
        this.contextListener.contextDestroyed(null);
    }

    @Test
    public void testResourceRetrieval() {
        this.cache.put("hello", (Object)"world");
        Assert.assertNull((Object)this.cache.get(null));
        Assert.assertNull((Object)this.cache.get("unknown"));
        Assert.assertEquals((Object)"world", (Object)this.cache.get("hello"));
    }

    @Test
    public void testCacheCapacity() {
        Assert.assertEquals((long)0L, (long)this.cache.size());
        this.cache.put("a", (Object)"a");
        this.cache.put("b", (Object)"b");
        this.cache.put("c", (Object)"c");
        Assert.assertEquals((long)3L, (long)this.cache.size());
        this.forwardTime(100L);
        for (int i = 0; i < 2 * this.cache.getCapacity(); ++i) {
            this.cache.put("id" + i, (Object)i);
        }
        Assert.assertTrue((this.cache.size() <= this.cache.getCapacity() ? 1 : 0) != 0);
        Assert.assertNull((Object)this.cache.get("a"));
        Assert.assertNull((Object)this.cache.get("b"));
        Assert.assertNull((Object)this.cache.get("c"));
    }

    @Test
    public void testEntryExpiration() {
        this.cache.put("hello", (Object)"world");
        Assert.assertEquals((Object)"world", (Object)this.cache.get("hello"));
        Assert.assertEquals((long)1L, (long)this.cache.size());
        this.forwardTime(this.cache.getSecondsToLive() + 1L);
        Assert.assertNull((Object)this.cache.get("hello"));
        Assert.assertEquals((long)0L, (long)this.cache.size());
    }

    @Test
    public void testInvalidConfigurationFormat() {
        try {
            this.contextListener.configureCaches("<!xml>");
            Assert.fail((String)"Exception expected");
        }
        catch (HalRelationCacheConfigurationException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IOException));
        }
    }

    @Test
    public void testUnknownCacheImplementationClass() {
        try {
            this.contextListener.configureCaches("{\"cacheImplementation\": \"org.camunda.bpm.UnknownCache\" }");
            Assert.fail((String)"Exception expected");
        }
        catch (HalRelationCacheConfigurationException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ClassNotFoundException));
        }
    }

    @Test
    public void testCacheImplementationNotImplementingCache() {
        try {
            this.contextListener.configureCaches("{\"cacheImplementation\": \"" + this.getClass().getName() + "\" }");
            Assert.fail((String)"Exception expected");
        }
        catch (HalRelationCacheConfigurationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(Cache.class.getName()));
        }
    }

    @Test
    public void testCacheCreation() {
        String contextParameter = "{\"cacheImplementation\": \"" + DefaultHalResourceCache.class.getName() + "\",\"" + "caches" + "\": {\"" + HalUser.class.getName() + "\": {\"capacity\": 123, \"secondsToLive\": 123}}}";
        this.contextListener.configureCaches(contextParameter);
        Cache cache = Hal.getInstance().getHalRelationCache(HalUser.class);
        Assert.assertNotNull((Object)cache);
        Assert.assertEquals((long)123L, (long)((DefaultHalResourceCache)cache).getCapacity());
        Assert.assertEquals((long)123L, (long)((DefaultHalResourceCache)cache).getSecondsToLive());
    }

    @Test
    public void testCacheInvalidParameterName() {
        HalRelationCacheConfiguration configuration = new HalRelationCacheConfiguration();
        configuration.setCacheImplementationClass(DefaultHalResourceCache.class);
        configuration.addCacheConfiguration(HalUser.class, Collections.singletonMap("unknown", "property"));
        try {
            this.contextListener.configureCaches(configuration);
            Assert.fail((String)"Exception expected");
        }
        catch (HalRelationCacheConfigurationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("setter"));
        }
    }

    @Test
    public void testEntityCaching() {
        String[] userIds = new String[]{"test"};
        User user = (User)Mockito.mock(User.class);
        Mockito.when((Object)user.getId()).thenReturn((Object)userIds[0]);
        Mockito.when((Object)user.getFirstName()).thenReturn((Object)"kermit");
        UserQuery userQuery = (UserQuery)Mockito.mock(UserQuery.class);
        Mockito.when((Object)userQuery.userIdIn((String[])Mockito.any())).thenReturn((Object)userQuery);
        Mockito.when((Object)userQuery.listPage(Mockito.anyInt(), Mockito.anyInt())).thenReturn(Arrays.asList(user));
        Mockito.when((Object)processEngine.getIdentityService().createUserQuery()).thenReturn((Object)userQuery);
        HalRelationCacheConfiguration configuration = new HalRelationCacheConfiguration();
        configuration.setCacheImplementationClass(DefaultHalResourceCache.class);
        HashMap<String, Integer> halUserConfig = new HashMap<String, Integer>();
        halUserConfig.put("capacity", 100);
        halUserConfig.put("secondsToLive", 10000);
        configuration.addCacheConfiguration(HalUser.class, halUserConfig);
        this.contextListener.configureCaches(configuration);
        DefaultHalResourceCache cache = (DefaultHalResourceCache)Hal.getInstance().getHalRelationCache(HalUser.class);
        Assert.assertNotNull((Object)cache);
        Assert.assertEquals((long)0L, (long)cache.size());
        HalLinkResolver linkResolver = Hal.getInstance().getLinkResolver(UserRestService.class);
        List halUsers = linkResolver.resolveLinks(userIds, processEngine);
        Assert.assertNotNull((Object)halUsers);
        Assert.assertEquals((long)1L, (long)halUsers.size());
        HalUser halUser = (HalUser)halUsers.get(0);
        Assert.assertEquals((Object)"kermit", (Object)halUser.getFirstName());
        Assert.assertEquals((long)1L, (long)cache.size());
        Mockito.when((Object)user.getFirstName()).thenReturn((Object)"fritz");
        halUsers = linkResolver.resolveLinks(userIds, processEngine);
        Assert.assertNotNull((Object)halUsers);
        Assert.assertEquals((long)1L, (long)halUsers.size());
        halUser = (HalUser)halUsers.get(0);
        Assert.assertEquals((Object)"kermit", (Object)halUser.getFirstName());
        this.forwardTime(cache.getSecondsToLive() * 3L);
        halUsers = linkResolver.resolveLinks(userIds, processEngine);
        Assert.assertNotNull((Object)halUsers);
        Assert.assertEquals((long)1L, (long)halUsers.size());
        halUser = (HalUser)halUsers.get(0);
        Assert.assertEquals((Object)"fritz", (Object)halUser.getFirstName());
    }

    @Test
    public void testIdentityLinkCaching() {
        String[] taskIds = new String[]{"test"};
        IdentityLink link1 = (IdentityLink)Mockito.mock(IdentityLink.class);
        Mockito.when((Object)link1.getTaskId()).thenReturn((Object)taskIds[0]);
        IdentityLink link2 = (IdentityLink)Mockito.mock(IdentityLink.class);
        Mockito.when((Object)link2.getTaskId()).thenReturn((Object)taskIds[0]);
        Mockito.when((Object)processEngine.getTaskService().getIdentityLinksForTask(Mockito.anyString())).thenReturn(Arrays.asList(link1, link2));
        HalRelationCacheConfiguration configuration = new HalRelationCacheConfiguration();
        configuration.setCacheImplementationClass(DefaultHalResourceCache.class);
        HashMap<String, Integer> halIdentityLinkConfig = new HashMap<String, Integer>();
        halIdentityLinkConfig.put("capacity", 100);
        halIdentityLinkConfig.put("secondsToLive", 10000);
        configuration.addCacheConfiguration(HalIdentityLink.class, halIdentityLinkConfig);
        this.contextListener.configureCaches(configuration);
        DefaultHalResourceCache cache = (DefaultHalResourceCache)Hal.getInstance().getHalRelationCache(HalIdentityLink.class);
        Assert.assertNotNull((Object)cache);
        Assert.assertEquals((long)0L, (long)cache.size());
        HalLinkResolver linkResolver = Hal.getInstance().getLinkResolver(IdentityRestService.class);
        List halIdentityLinks = linkResolver.resolveLinks(taskIds, processEngine);
        Assert.assertEquals((long)2L, (long)halIdentityLinks.size());
        Assert.assertEquals((long)1L, (long)cache.size());
        Assert.assertEquals((Object)halIdentityLinks, (Object)cache.get(taskIds[0]));
    }

    protected void forwardTime(long seconds) {
        Date later = new Date(ClockUtil.getCurrentTime().getTime() + seconds * 1000L);
        ClockUtil.setCurrentTime((Date)later);
    }
}

