/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.runtime.VariableNameDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.helper.ErrorMessageHelper;
import org.camunda.bpm.engine.rest.helper.ExampleVariableObject;
import org.camunda.bpm.engine.rest.helper.MockObjectValue;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.VariableTypeHelper;
import org.camunda.bpm.engine.rest.helper.variable.EqualsNullValue;
import org.camunda.bpm.engine.rest.helper.variable.EqualsObjectValue;
import org.camunda.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.camunda.bpm.engine.rest.helper.variable.EqualsUntypedValue;
import org.camunda.bpm.engine.rest.util.DateTimeUtils;
import org.camunda.bpm.engine.rest.util.VariablesBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.runtime.CaseExecutionCommandBuilder;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.CaseInstanceQuery;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.BooleanValue;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;

public class CaseInstanceRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String CASE_INSTANCE_URL = "/rest-test/case-instance";
    protected static final String SINGLE_CASE_INSTANCE_URL = "/rest-test/case-instance/{id}";
    protected static final String CASE_INSTANCE_COMPLETE_URL = "/rest-test/case-instance/{id}/complete";
    protected static final String CASE_INSTANCE_TERMINATE_URL = "/rest-test/case-instance/{id}/terminate";
    protected static final String CASE_INSTANCE_CLOSE_URL = "/rest-test/case-instance/{id}/close";
    protected static final String CASE_INSTANCE_VARIABLES_URL = "/rest-test/case-instance/{id}/variables";
    protected static final String SINGLE_CASE_INSTANCE_VARIABLE_URL = "/rest-test/case-instance/{id}/variables/{varId}";
    protected static final String SINGLE_CASE_INSTANCE_BINARY_VARIABLE_URL = "/rest-test/case-instance/{id}/variables/{varId}/data";
    protected static final VariableMap EXAMPLE_OBJECT_VARIABLES = Variables.createVariables();
    private CaseService caseServiceMock;
    private CaseInstanceQuery caseInstanceQueryMock;
    private CaseExecutionCommandBuilder caseExecutionCommandBuilderMock;

    @Before
    public void setUpRuntime() {
        CaseInstance mockCaseInstance = MockProvider.createMockCaseInstance();
        this.caseServiceMock = (CaseService)Mockito.mock(CaseService.class);
        Mockito.when((Object)processEngine.getCaseService()).thenReturn((Object)this.caseServiceMock);
        this.caseInstanceQueryMock = (CaseInstanceQuery)Mockito.mock(CaseInstanceQuery.class);
        Mockito.when((Object)this.caseServiceMock.createCaseInstanceQuery()).thenReturn((Object)this.caseInstanceQueryMock);
        Mockito.when((Object)this.caseInstanceQueryMock.caseInstanceId("aCaseInstId")).thenReturn((Object)this.caseInstanceQueryMock);
        Mockito.when((Object)((CaseInstance)this.caseInstanceQueryMock.singleResult())).thenReturn((Object)mockCaseInstance);
        Mockito.when((Object)this.caseServiceMock.getVariableTyped(Mockito.anyString(), (String)Mockito.eq((Object)"aVariableKey"), Mockito.anyBoolean())).thenReturn((Object)EXAMPLE_VARIABLE_VALUE);
        Mockito.when((Object)this.caseServiceMock.getVariableTyped(Mockito.anyString(), (String)Mockito.eq((Object)"aBytesVariableKey"), Mockito.eq((boolean)false))).thenReturn((Object)EXAMPLE_VARIABLE_VALUE_BYTES);
        Mockito.when((Object)this.caseServiceMock.getVariablesTyped(Mockito.anyString(), Mockito.eq((boolean)true))).thenReturn((Object)EXAMPLE_VARIABLES);
        Mockito.when((Object)this.caseServiceMock.getVariablesTyped(Mockito.anyString(), (Collection)Mockito.any(), Mockito.eq((boolean)true))).thenReturn((Object)EXAMPLE_VARIABLES);
        this.caseExecutionCommandBuilderMock = (CaseExecutionCommandBuilder)Mockito.mock(CaseExecutionCommandBuilder.class);
        Mockito.when((Object)this.caseServiceMock.withCaseExecution("aCaseInstId")).thenReturn((Object)this.caseExecutionCommandBuilderMock);
        Mockito.when((Object)this.caseExecutionCommandBuilderMock.setVariable(Mockito.anyString(), Mockito.any())).thenReturn((Object)this.caseExecutionCommandBuilderMock);
        Mockito.when((Object)this.caseExecutionCommandBuilderMock.setVariables((Map)Mockito.any())).thenReturn((Object)this.caseExecutionCommandBuilderMock);
        Mockito.when((Object)this.caseExecutionCommandBuilderMock.removeVariable(Mockito.anyString())).thenReturn((Object)this.caseExecutionCommandBuilderMock);
        Mockito.when((Object)this.caseExecutionCommandBuilderMock.removeVariables((Collection)Mockito.any())).thenReturn((Object)this.caseExecutionCommandBuilderMock);
    }

    @Test
    public void testCaseInstanceRetrieval() {
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", CoreMatchers.equalTo((Object)"aCaseInstId"), new Object[0]).body("businessKey", CoreMatchers.equalTo((Object)"aBusinessKey"), new Object[0]).body("caseDefinitionId", CoreMatchers.equalTo((Object)"aCaseDefinitionId"), new Object[0]).body("tenantId", CoreMatchers.equalTo((Object)"aTenantId"), new Object[0]).body("active", CoreMatchers.equalTo((Object)true), new Object[0]).body("completed", CoreMatchers.equalTo((Object)true), new Object[0]).body("terminated", CoreMatchers.equalTo((Object)true), new Object[0]).when().get(SINGLE_CASE_INSTANCE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).createCaseInstanceQuery();
        ((CaseInstanceQuery)Mockito.verify((Object)this.caseInstanceQueryMock)).caseInstanceId("aCaseInstId");
        ((CaseInstanceQuery)Mockito.verify((Object)this.caseInstanceQueryMock)).singleResult();
    }

    @Test
    public void testGetVariables() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aCaseInstId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("aVariableKey", Matchers.notNullValue(), new Object[0]).body("aVariableKey.value", CoreMatchers.equalTo((Object)EXAMPLE_VARIABLE_VALUE.getValue()), new Object[0]).body("aVariableKey.type", CoreMatchers.equalTo((Object)String.class.getSimpleName()), new Object[0]).when().get(CASE_INSTANCE_VARIABLES_URL, new Object[0]);
        Assert.assertEquals((String)"Should return exactly one variable", (long)1L, (long)response.jsonPath().getMap("").size());
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariablesTyped("aCaseInstId", true);
    }

    @Test
    public void testGetVariablesWithNullValue() {
        Mockito.when((Object)this.caseServiceMock.getVariablesTyped("aCaseInstId", true)).thenReturn((Object)EXAMPLE_VARIABLES_WITH_NULL_VALUE);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aCaseInstId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("anotherVariableKey", Matchers.notNullValue(), new Object[0]).body("anotherVariableKey.value", CoreMatchers.nullValue(), new Object[0]).body("anotherVariableKey.type", CoreMatchers.equalTo((Object)"Null"), new Object[0]).when().get(CASE_INSTANCE_VARIABLES_URL, new Object[0]);
        Assert.assertEquals((String)"Should return exactly one variable", (long)1L, (long)response.jsonPath().getMap("").size());
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariablesTyped("aCaseInstId", true);
    }

    @Test
    public void testJavaObjectVariableSerialization() {
        Mockito.when((Object)this.caseServiceMock.getVariablesTyped("aCaseInstId", true)).thenReturn((Object)EXAMPLE_OBJECT_VARIABLES);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aCaseInstId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("aVariableKey", Matchers.notNullValue(), new Object[0]).body("aVariableKey.value.property1", CoreMatchers.equalTo((Object)"aPropertyValue"), new Object[0]).body("aVariableKey.value.property2", CoreMatchers.equalTo((Object)true), new Object[0]).body("aVariableKey.type", CoreMatchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName((ValueType)ValueType.OBJECT)), new Object[0]).body("aVariableKey.valueInfo.objectTypeName", CoreMatchers.equalTo((Object)ExampleVariableObject.class.getName()), new Object[0]).body("aVariableKey.valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"application/json"), new Object[0]).when().get(CASE_INSTANCE_VARIABLES_URL, new Object[0]);
        Assert.assertEquals((String)"Should return exactly one variable", (long)1L, (long)response.jsonPath().getMap("").size());
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariablesTyped("aCaseInstId", true);
    }

    @Test
    public void testGetObjectVariablesSerialized() {
        String variableKey = "aVariableId";
        ObjectValue variableValue = (ObjectValue)Variables.serializedObjectValue((String)"a serialized value").serializationDataFormat("application/json").objectTypeName(ArrayList.class.getName()).create();
        Mockito.when((Object)this.caseServiceMock.getVariablesTyped((String)Mockito.eq((Object)"aCaseInstId"), Mockito.anyBoolean())).thenReturn((Object)Variables.createVariables().putValueTyped(variableKey, (TypedValue)variableValue));
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").queryParam("deserializeValues", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).body(variableKey + ".value", CoreMatchers.equalTo((Object)"a serialized value"), new Object[0]).body(variableKey + ".type", CoreMatchers.equalTo((Object)"Object"), new Object[0]).body(variableKey + ".valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"application/json"), new Object[0]).body(variableKey + ".valueInfo.objectTypeName", CoreMatchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get(CASE_INSTANCE_VARIABLES_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariablesTyped("aCaseInstId", false);
    }

    @Test
    public void testGetVariablesForNonExistingCaseInstance() {
        Mockito.when((Object)this.caseServiceMock.getVariablesTyped(Mockito.anyString(), Mockito.eq((boolean)true))).thenThrow(new Throwable[]{new ProcessEngineException("expected exception")});
        RestAssured.given().pathParam("id", (Object)"aNonExistingCaseInstanceId").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"expected exception"), new Object[0]).when().get(CASE_INSTANCE_VARIABLES_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariablesTyped("aNonExistingCaseInstanceId", true);
    }

    @Test
    public void testVariableModification() {
        String variableKey = "aKey";
        int variableValue = 123;
        HashMap<String, Object> messageBodyJson = new HashMap<String, Object>();
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, variableValue).getVariables();
        messageBodyJson.put("modifications", modifications);
        ArrayList<String> deletions = new ArrayList<String>();
        deletions.add("deleteKey");
        messageBodyJson.put("deletions", deletions);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_VARIABLES_URL, new Object[0]);
        HashMap<String, Integer> expectedModifications = new HashMap<String, Integer>();
        expectedModifications.put(variableKey, variableValue);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariables((Map)Mockito.eq(expectedModifications));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariables((Collection)Mockito.eq(deletions));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testVariableModificationWithUnparseableInteger() {
        String variableKey = "aKey";
        String variableValue = "1abc";
        String variableType = "Integer";
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot modify variables for case execution: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Integer.class))), new Object[0]).when().post(CASE_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testVariableModificationWithUnparseableShort() {
        String variableKey = "aKey";
        String variableValue = "1abc";
        String variableType = "Short";
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot modify variables for case execution: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Short.class))), new Object[0]).when().post(CASE_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testVariableModificationWithUnparseableLong() {
        String variableKey = "aKey";
        String variableValue = "1abc";
        String variableType = "Long";
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot modify variables for case execution: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Long.class))), new Object[0]).when().post(CASE_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testVariableModificationWithUnparseableDouble() {
        String variableKey = "aKey";
        String variableValue = "1abc";
        String variableType = "Double";
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot modify variables for case execution: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Double.class))), new Object[0]).when().post(CASE_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testVariableModificationWithUnparseableDate() {
        String variableKey = "aKey";
        String variableValue = "1abc";
        String variableType = "Date";
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot modify variables for case execution: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Date.class))), new Object[0]).when().post(CASE_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testVariableModificationWithNotSupportedType() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "X";
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"Cannot modify variables for case execution: Unsupported value type 'X'"), new Object[0]).when().post(CASE_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testVariableModificationForNonExistingCaseInstance() {
        ((CaseExecutionCommandBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.caseExecutionCommandBuilderMock)).execute();
        String variableKey = "aKey";
        int variableValue = 123;
        HashMap<String, Map<String, Object>> messageBodyJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> modifications = VariablesBuilder.create().variable(variableKey, variableValue).getVariables();
        messageBodyJson.put("modifications", modifications);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(messageBodyJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", CoreMatchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"Cannot modify variables for case execution aCaseInstId: expected exception"), new Object[0]).when().post(CASE_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testEmptyVariableModification() {
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testGetSingleVariable() {
        String variableKey = "aVariableKey";
        int variableValue = 123;
        Mockito.when((Object)this.caseServiceMock.getVariableTyped("aCaseInstId", variableKey, true)).thenReturn((Object)Variables.integerValue((Integer)variableValue));
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("value", Matchers.is((Object)123), new Object[0]).body("type", Matchers.is((Object)"Integer"), new Object[0]).when().get(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariableTyped("aCaseInstId", variableKey, true);
    }

    @Test
    public void testNonExistingVariable() {
        String variableKey = "aVariableKey";
        Mockito.when((Object)this.caseServiceMock.getVariableTyped((String)Mockito.eq((Object)"aCaseInstId"), (String)Mockito.eq((Object)variableKey), Mockito.eq((boolean)true))).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)("case execution variable with name " + variableKey + " does not exist")), new Object[0]).when().get(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetSingleLocalVariableData() {
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)"aBytesVariableKey").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/octet-stream").when().get(SINGLE_CASE_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariableTyped("aCaseInstId", "aBytesVariableKey", false);
    }

    @Test
    public void testGetSingleLocalVariableDataNonExisting() {
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)"nonExisting").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.is((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)"case execution variable with name nonExisting does not exist"), new Object[0]).when().get(SINGLE_CASE_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariableTyped("aCaseInstId", "nonExisting", false);
    }

    @Test
    public void testGetSingleLocalVariabledataNotBinary() {
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)"aVariableKey").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(SINGLE_CASE_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariableTyped("aCaseInstId", "aVariableKey", false);
    }

    @Test
    public void testGetSingleObjectVariable() {
        String variableKey = "aVariableId";
        List<String> payload = Arrays.asList("a", "b");
        MockObjectValue variableValue = MockObjectValue.fromObjectValue((ObjectValue)Variables.objectValue(payload).serializationDataFormat("application/json").create()).objectTypeName(ArrayList.class.getName()).serializedValue("a serialized value");
        Mockito.when((Object)this.caseServiceMock.getVariableTyped((String)Mockito.eq((Object)"aCaseInstId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("value", CoreMatchers.equalTo(payload), new Object[0]).body("type", CoreMatchers.equalTo((Object)"Object"), new Object[0]).body("valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"application/json"), new Object[0]).body("valueInfo.objectTypeName", CoreMatchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariableTyped("aCaseInstId", variableKey, true);
    }

    @Test
    public void testGetSingleObjectVariableSerialized() {
        String variableKey = "aVariableId";
        ObjectValue variableValue = (ObjectValue)Variables.serializedObjectValue((String)"a serialized value").serializationDataFormat("application/json").objectTypeName(ArrayList.class.getName()).create();
        Mockito.when((Object)this.caseServiceMock.getVariableTyped((String)Mockito.eq((Object)"aCaseInstId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).queryParam("deserializeValue", new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("value", CoreMatchers.equalTo((Object)"a serialized value"), new Object[0]).body("type", CoreMatchers.equalTo((Object)"Object"), new Object[0]).body("valueInfo.serializationDataFormat", CoreMatchers.equalTo((Object)"application/json"), new Object[0]).body("valueInfo.objectTypeName", CoreMatchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).when().get(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).getVariableTyped("aCaseInstId", variableKey, false);
    }

    @Test
    public void testGetVariableForNonExistingInstance() {
        String variableKey = "aVariableKey";
        Mockito.when((Object)this.caseServiceMock.getVariableTyped((String)Mockito.eq((Object)"aCaseInstId"), (String)Mockito.eq((Object)variableKey), Mockito.eq((boolean)true))).thenThrow(new Throwable[]{new ProcessEngineException("expected exception")});
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)("Cannot get case execution variable " + variableKey + ": expected exception")), new Object[0]).when().get(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetFileVariable() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        String mimeType = "text/plain";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(mimeType).create();
        Mockito.when((Object)this.caseServiceMock.getVariableTyped("aCaseInstId", variableKey, true)).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON.toString()).and().body("valueInfo.mimeType", CoreMatchers.equalTo((Object)mimeType), new Object[0]).body("valueInfo.filename", CoreMatchers.equalTo((Object)filename), new Object[0]).body("value", CoreMatchers.nullValue(), new Object[0]).when().get(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetNullFileVariable() {
        String variableKey = "aVariableKey";
        String filename = "test.txt";
        String mimeType = "text/plain";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).mimeType(mimeType).create();
        Mockito.when((Object)this.caseServiceMock.getVariableTyped((String)Mockito.eq((Object)"aCaseInstId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT.toString()).and().body(Matchers.is((Matcher)CoreMatchers.equalTo((Object)"")), new Matcher[0]).when().get(SINGLE_CASE_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetFileVariableDownloadWithType() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(ContentType.TEXT.toString()).create();
        Mockito.when((Object)this.caseServiceMock.getVariableTyped((String)Mockito.eq((Object)"aCaseInstId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.TEXT.toString()).and().body(Matchers.is((Matcher)CoreMatchers.equalTo((Object)new String(byteContent))), new Matcher[0]).when().get(SINGLE_CASE_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testGetFileVariableDownloadWithTypeAndEncoding() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        String encoding = "UTF-8";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).mimeType(ContentType.TEXT.toString()).encoding(encoding).create();
        Mockito.when((Object)this.caseServiceMock.getVariableTyped((String)Mockito.eq((Object)"aCaseInstId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).body(Matchers.is((Matcher)CoreMatchers.equalTo((Object)new String(byteContent))), new Matcher[0]).when().get(SINGLE_CASE_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        String contentType = response.contentType().replaceAll(" ", "");
        MatcherAssert.assertThat((Object)contentType, (Matcher)Matchers.is((Object)(ContentType.TEXT + ";charset=" + encoding)));
    }

    @Test
    public void testGetFileVariableDownloadWithoutType() {
        String variableKey = "aVariableKey";
        byte[] byteContent = "some bytes".getBytes();
        String filename = "test.txt";
        FileValue variableValue = (FileValue)Variables.fileValue((String)filename).file(byteContent).create();
        Mockito.when((Object)this.caseServiceMock.getVariableTyped((String)Mockito.eq((Object)"aCaseInstId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType("application/octet-stream").and().body(Matchers.is((Matcher)CoreMatchers.equalTo((Object)new String(byteContent))), new Matcher[0]).header("Content-Disposition", Matchers.containsString((String)filename)).when().get(SINGLE_CASE_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testCannotDownloadVariableOtherThanFile() {
        String variableKey = "aVariableKey";
        BooleanValue variableValue = Variables.booleanValue((Boolean)true);
        Mockito.when((Object)this.caseServiceMock.getVariableLocalTyped((String)Mockito.eq((Object)"anId"), (String)Mockito.eq((Object)variableKey), Mockito.anyBoolean())).thenReturn((Object)variableValue);
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().get(SINGLE_CASE_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "aVariableValue";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap(variableValue);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsUntypedValue.matcher().value(variableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleVariableWithTypeString() {
        String variableKey = "aVariableKey";
        String variableValue = "aVariableValue";
        String type = "String";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(variableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleVariableWithTypeInteger() {
        String variableKey = "aVariableKey";
        Integer variableValue = 123;
        String type = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(variableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleVariableWithUnparseableInteger() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put case execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Integer.class))), new Object[0]).when().put(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithTypeShort() {
        String variableKey = "aVariableKey";
        Short variableValue = 123;
        String type = "Short";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.shortValue(variableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleVariableWithUnparseableShort() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Short";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put case execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Short.class))), new Object[0]).when().put(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithTypeLong() {
        String variableKey = "aVariableKey";
        Long variableValue = 123L;
        String type = "Long";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.longValue(variableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleVariableWithUnparseableLong() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Long";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put case execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Long.class))), new Object[0]).when().put(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithTypeDouble() {
        String variableKey = "aVariableKey";
        Double variableValue = 123.456;
        String type = "Double";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.doubleValue(variableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleVariableWithUnparseableDouble() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Double";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put case execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Double.class))), new Object[0]).when().put(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithTypeBoolean() {
        String variableKey = "aVariableKey";
        Boolean variableValue = true;
        String type = "Boolean";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.booleanValue(variableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleVariableWithTypeDate() throws Exception {
        Date now = new Date();
        String variableKey = "aVariableKey";
        String variableValue = DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.format(now);
        String type = "Date";
        Date expectedValue = DateTimeUtils.DATE_FORMAT_WITH_TIMEZONE.parse(variableValue);
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.dateValue(expectedValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleVariableWithUnparseableDate() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "Date";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)("Cannot put case execution variable aVariableKey: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, type, Date.class))), new Object[0]).when().put(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithNotSupportedType() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String type = "X";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap((Object)variableValue, type);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", CoreMatchers.equalTo((Object)"Cannot put case execution variable aVariableKey: Unsupported value type 'X'"), new Object[0]).when().put(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleBinaryVariable() throws Exception {
        byte[] bytes = "someContent".getBytes();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.bytesValue(bytes)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleBinaryVariableWithValueType() throws Exception {
        byte[] bytes = "someContent".getBytes();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).multiPart("valueType", "Bytes", "text/plain").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.bytesValue(bytes)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleBinaryVariableWithNoValue() throws Exception {
        byte[] bytes = new byte[]{};
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).multiPart("data", null, bytes).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.bytesValue(bytes)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleSerializableVariable() throws Exception {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("foo");
        ObjectMapper mapper = new ObjectMapper();
        String jsonBytes = mapper.writeValueAsString(serializable);
        String typeName = TypeFactory.defaultInstance().constructType(serializable.getClass()).toCanonical();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).multiPart("data", jsonBytes, "application/json").multiPart("type", typeName, "text/plain").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsObjectValue.objectValueMatcher().isDeserialized().value(serializable)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutSingleSerializableVariableUnsupportedMediaType() throws Exception {
        ArrayList<String> serializable = new ArrayList<String>();
        serializable.add("foo");
        ObjectMapper mapper = new ObjectMapper();
        String jsonBytes = mapper.writeValueAsString(serializable);
        String typeName = TypeFactory.defaultInstance().constructType(serializable.getClass()).toCanonical();
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).multiPart("data", jsonBytes, "unsupported").multiPart("type", typeName, "text/plain").expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(Matchers.containsString((String)"Unrecognized content type for serialized java type: unsupported"), new Matcher[0]).when().post(SINGLE_CASE_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPutSingleVariableWithNoValue() {
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), MockitoHamcrest.argThat((Matcher)EqualsNullValue.matcher()));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testPutVariableForNonExistingInstance() {
        String variableKey = "aVariableKey";
        String variableValue = "aVariableValue";
        Map<String, Object> variableJson = VariablesBuilder.getVariableValueMap(variableValue);
        ((CaseExecutionCommandBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.caseExecutionCommandBuilderMock)).execute();
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).contentType(ContentType.JSON).body(variableJson).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)("Cannot put case execution variable " + variableKey + ": expected exception")), new Object[0]).when().put(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPostSingleFileVariableWithEncodingAndMimeType() throws Exception {
        byte[] value = "some text".getBytes();
        String variableKey = "aVariableKey";
        String encoding = "utf-8";
        String filename = "test.txt";
        String mimetype = "text/plain";
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).multiPart("data", filename, value, mimetype + "; encoding=" + encoding).multiPart("valueType", "File", "text/plain").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileValue.class);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), captor.capture());
        FileValue captured = (FileValue)captor.getValue();
        MatcherAssert.assertThat((Object)captured.getEncoding(), (Matcher)Matchers.is((Object)encoding));
        MatcherAssert.assertThat((Object)captured.getFilename(), (Matcher)Matchers.is((Object)filename));
        MatcherAssert.assertThat((Object)captured.getMimeType(), (Matcher)Matchers.is((Object)mimetype));
        MatcherAssert.assertThat((Object)IoUtil.readInputStream((InputStream)captured.getValue(), null), (Matcher)Matchers.is((Object)value));
    }

    @Test
    public void testPostSingleFileVariableWithMimeType() throws Exception {
        byte[] value = "some text".getBytes();
        String variableKey = "aVariableKey";
        String filename = "test.txt";
        String mimetype = "text/plain";
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).multiPart("data", filename, value, mimetype).multiPart("valueType", "File", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileValue.class);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), captor.capture());
        FileValue captured = (FileValue)captor.getValue();
        MatcherAssert.assertThat((Object)captured.getEncoding(), (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)captured.getFilename(), (Matcher)Matchers.is((Object)filename));
        MatcherAssert.assertThat((Object)captured.getMimeType(), (Matcher)Matchers.is((Object)mimetype));
        MatcherAssert.assertThat((Object)IoUtil.readInputStream((InputStream)captured.getValue(), null), (Matcher)Matchers.is((Object)value));
    }

    @Test
    public void testPostSingleFileVariableWithEncoding() throws Exception {
        byte[] value = "some text".getBytes();
        String variableKey = "aVariableKey";
        String encoding = "utf-8";
        String filename = "test.txt";
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).multiPart("data", filename, value, "encoding=" + encoding).multiPart("valueType", "File", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).when().post(SINGLE_CASE_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testPostSingleFileVariableOnlyFilename() throws Exception {
        String variableKey = "aVariableKey";
        String filename = "test.txt";
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).multiPart("data", filename, new byte[0]).multiPart("valueType", "File", "text/plain").header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SINGLE_CASE_INSTANCE_BINARY_VARIABLE_URL, new Object[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(FileValue.class);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)variableKey), captor.capture());
        FileValue captured = (FileValue)captor.getValue();
        MatcherAssert.assertThat((Object)captured.getEncoding(), (Matcher)Matchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)captured.getFilename(), (Matcher)Matchers.is((Object)filename));
        MatcherAssert.assertThat((Object)captured.getMimeType(), (Matcher)Matchers.is((Object)"application/octet-stream"));
        MatcherAssert.assertThat((Object)captured.getValue().available(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testDeleteSingleVariable() {
        String variableKey = "aVariableKey";
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(variableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).execute();
    }

    @Test
    public void testDeleteVariableForNonExistingInstance() {
        String variableKey = "aVariableKey";
        ((CaseExecutionCommandBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.caseExecutionCommandBuilderMock)).execute();
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").pathParam("varId", (Object)variableKey).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).body("type", Matchers.is((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.is((Object)("Cannot delete case execution variable " + variableKey + ": expected exception")), new Object[0]).when().delete(SINGLE_CASE_INSTANCE_VARIABLE_URL, new Object[0]);
    }

    @Test
    public void testComplete() {
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testUnsuccessfulComplete() {
        ((CaseExecutionCommandBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new NotValidException("expected exception")}).when((Object)this.caseExecutionCommandBuilderMock)).complete();
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot complete case instance aCaseInstId: expected exception"), new Object[0]).when().post(CASE_INSTANCE_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithSetVariable() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, (Object)aVariableValue, "Integer").variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithSetVariableLocal() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, aVariableValue, "Integer", true).variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithSetVariableAndVariableLocal() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, (Object)aVariableValue, "Integer").variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey, true);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithRemoveVariableAndVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithSetVariableAndRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithSetVariableAndRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithSetVariableLocalAndRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testCompleteWithSetVariableLocalAndRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_COMPLETE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).complete();
    }

    @Test
    public void testClose() {
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_CLOSE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).close();
    }

    @Test
    public void testUnsuccessfulClose() {
        ((CaseExecutionCommandBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new NotValidException("expected exception")}).when((Object)this.caseExecutionCommandBuilderMock)).close();
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot close case instance aCaseInstId: expected exception"), new Object[0]).when().post(CASE_INSTANCE_CLOSE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).close();
    }

    @Test
    public void testCloseWithSetVariable() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, (Object)aVariableValue, "Integer").variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_CLOSE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).close();
    }

    @Test
    public void testCloseWithSetVariableLocal() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, aVariableValue, "Integer", true).variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_CLOSE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).close();
    }

    @Test
    public void testCloseWithSetVariableAndVariableLocal() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, (Object)aVariableValue, "Integer").variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_CLOSE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).close();
    }

    @Test
    public void testCloseWithRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_CLOSE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).close();
    }

    @Test
    public void testCloseWithRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey, true);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_CLOSE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).close();
    }

    @Test
    public void testCloseWithRemoveVariableAndVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_CLOSE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).close();
    }

    @Test
    public void testCloseWithSetVariableAndRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_CLOSE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).close();
    }

    @Test
    public void testCloseWithSetVariableAndRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_CLOSE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).close();
    }

    @Test
    public void testCloseWithSetVariableLocalAndRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_CLOSE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).close();
    }

    @Test
    public void testCloseWithSetVariableLocalAndRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_CLOSE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).close();
    }

    @Test
    public void testTerminate() {
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testUnsuccessfulTerminate() {
        ((CaseExecutionCommandBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new NotValidException("expected exception")}).when((Object)this.caseExecutionCommandBuilderMock)).terminate();
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", CoreMatchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot terminate case instance aCaseInstId: expected exception"), new Object[0]).when().post(CASE_INSTANCE_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithSetVariable() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, (Object)aVariableValue, "Integer").variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithSetVariableLocal() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, aVariableValue, "Integer", true).variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithSetVariableAndVariableLocal() {
        String aVariableKey = "aKey";
        int aVariableValue = 123;
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        HashMap<String, Map<String, Object>> variablesJson = new HashMap<String, Map<String, Object>>();
        Map<String, Object> variables = VariablesBuilder.create().variable(aVariableKey, (Object)aVariableValue, "Integer").variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        variablesJson.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)aVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.integerValue(aVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey, true);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithRemoveVariableAndVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        VariableNameDto secondVariableName = new VariableNameDto(anotherVariableKey);
        variableNames.add(secondVariableName);
        HashMap<String, ArrayList<VariableNameDto>> variablesJson = new HashMap<String, ArrayList<VariableNameDto>>();
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(anotherVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithSetVariableAndRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithSetVariableAndRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, (Object)anotherVariableValue, "String").getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariable((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithSetVariableLocalAndRemoveVariable() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariable(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    @Test
    public void testTerminateWithSetVariableLocalAndRemoveVariableLocal() {
        String aVariableKey = "aKey";
        String anotherVariableKey = "anotherKey";
        String anotherVariableValue = "abc";
        Map<String, Object> variables = VariablesBuilder.create().variable(anotherVariableKey, anotherVariableValue, "String", true).getVariables();
        ArrayList<VariableNameDto> variableNames = new ArrayList<VariableNameDto>();
        VariableNameDto firstVariableName = new VariableNameDto(aVariableKey, true);
        variableNames.add(firstVariableName);
        HashMap<String, Object> variablesJson = new HashMap<String, Object>();
        variablesJson.put("variables", variables);
        variablesJson.put("deletions", variableNames);
        RestAssured.given().pathParam("id", (Object)"aCaseInstId").contentType(ContentType.JSON).body(variablesJson).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CASE_INSTANCE_TERMINATE_URL, new Object[0]);
        ((CaseService)Mockito.verify((Object)this.caseServiceMock)).withCaseExecution("aCaseInstId");
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).removeVariableLocal(aVariableKey);
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).setVariableLocal((String)Mockito.eq((Object)anotherVariableKey), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.stringValue(anotherVariableValue)));
        ((CaseExecutionCommandBuilder)Mockito.verify((Object)this.caseExecutionCommandBuilderMock)).terminate();
    }

    static {
        ExampleVariableObject variableValue = new ExampleVariableObject();
        variableValue.setProperty1("aPropertyValue");
        variableValue.setProperty2(true);
        EXAMPLE_OBJECT_VARIABLES.putValueTyped("aVariableKey", (TypedValue)MockObjectValue.fromObjectValue((ObjectValue)Variables.objectValue((Object)variableValue).serializationDataFormat("application/json").create()).objectTypeName(ExampleVariableObject.class.getName()));
    }
}

