/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.standalone;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.rest.helper.EqualsList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EqualsListTest {
    protected List<String> list1;
    protected List<String> list2;

    @Before
    public void setUp() {
        this.list1 = new ArrayList<String>();
        this.list2 = new ArrayList<String>();
    }

    @Test
    public void testListsSame() {
        Assert.assertTrue((boolean)new EqualsList(this.list1).matches(this.list1));
    }

    @Test
    public void testListsEqual() {
        this.list1.add("aString");
        this.list2.add("aString");
        Assert.assertTrue((boolean)new EqualsList(this.list1).matches(this.list2));
        Assert.assertTrue((boolean)new EqualsList(this.list2).matches(this.list1));
    }

    @Test
    public void testListsNotEqual() {
        this.list1.add("aString");
        Assert.assertFalse((boolean)new EqualsList(this.list1).matches(this.list2));
        Assert.assertFalse((boolean)new EqualsList(this.list2).matches(this.list1));
    }

    @Test
    public void testListsNull() {
        Assert.assertFalse((boolean)new EqualsList(null).matches(this.list1));
        Assert.assertFalse((boolean)new EqualsList(this.list1).matches(null));
        Assert.assertTrue((boolean)new EqualsList(null).matches(null));
    }
}

