/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.sub.history.impl;

import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.rest.dto.history.HistoricVariableInstanceDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.sub.AbstractResourceProvider;
import org.camunda.bpm.engine.rest.sub.history.HistoricVariableInstanceResource;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class HistoricVariableInstanceResourceImpl
extends AbstractResourceProvider<HistoricVariableInstanceQuery, HistoricVariableInstance, HistoricVariableInstanceDto>
implements HistoricVariableInstanceResource {
    public HistoricVariableInstanceResourceImpl(String variableId, ProcessEngine engine) {
        super(variableId, engine);
    }

    protected HistoricVariableInstanceQuery baseQuery() {
        return this.getEngine().getHistoryService().createHistoricVariableInstanceQuery().variableId(this.getId());
    }

    @Override
    protected Query<HistoricVariableInstanceQuery, HistoricVariableInstance> baseQueryForBinaryVariable() {
        return this.baseQuery().disableCustomObjectDeserialization();
    }

    @Override
    protected Query<HistoricVariableInstanceQuery, HistoricVariableInstance> baseQueryForVariable(boolean deserializeObjectValue) {
        HistoricVariableInstanceQuery query = this.baseQuery().disableBinaryFetching();
        if (!deserializeObjectValue) {
            query.disableCustomObjectDeserialization();
        }
        return query;
    }

    @Override
    protected TypedValue transformQueryResultIntoTypedValue(HistoricVariableInstance queryResult) {
        return queryResult.getTypedValue();
    }

    @Override
    protected HistoricVariableInstanceDto transformToDto(HistoricVariableInstance queryResult) {
        return HistoricVariableInstanceDto.fromHistoricVariableInstance(queryResult);
    }

    @Override
    protected String getResourceNameForErrorMessage() {
        return "Historic variable instance";
    }

    @Override
    public Response deleteVariableInstance() {
        try {
            this.getEngine().getHistoryService().deleteHistoricVariableInstance(this.id);
        }
        catch (NotFoundException nfe) {
            throw new InvalidRequestException(Response.Status.NOT_FOUND, (Exception)((Object)nfe), nfe.getMessage());
        }
        return Response.noContent().build();
    }
}

