/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricExternalTaskLog;
import org.camunda.bpm.engine.history.HistoricExternalTaskLogQuery;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricExternalTaskLogDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricExternalTaskLogQueryDto;
import org.camunda.bpm.engine.rest.history.HistoricExternalTaskLogRestService;
import org.camunda.bpm.engine.rest.sub.history.HistoricExternalTaskLogResource;
import org.camunda.bpm.engine.rest.sub.history.impl.HistoricExternalTaskLogResourceImpl;
import org.camunda.bpm.engine.rest.util.QueryUtil;

public class HistoricExternalTaskLogRestServiceImpl
implements HistoricExternalTaskLogRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricExternalTaskLogRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public HistoricExternalTaskLogResource getHistoricExternalTaskLog(String historicExternalTaskLogId) {
        return new HistoricExternalTaskLogResourceImpl(historicExternalTaskLogId, this.processEngine);
    }

    @Override
    public List<HistoricExternalTaskLogDto> getHistoricExternalTaskLogs(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        HistoricExternalTaskLogQueryDto queryDto = new HistoricExternalTaskLogQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricExternalTaskLogs(queryDto, firstResult, maxResults);
    }

    @Override
    public List<HistoricExternalTaskLogDto> queryHistoricExternalTaskLogs(HistoricExternalTaskLogQueryDto queryDto, Integer firstResult, Integer maxResults) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricExternalTaskLogQuery query = (HistoricExternalTaskLogQuery)queryDto.toQuery(this.processEngine);
        List<HistoricExternalTaskLog> matchingHistoricExternalTaskLogs = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<HistoricExternalTaskLogDto> results = new ArrayList<HistoricExternalTaskLogDto>();
        for (HistoricExternalTaskLog historicExternalTaskLog : matchingHistoricExternalTaskLogs) {
            HistoricExternalTaskLogDto result = HistoricExternalTaskLogDto.fromHistoricExternalTaskLog(historicExternalTaskLog);
            results.add(result);
        }
        return results;
    }

    @Override
    public CountResultDto getHistoricExternalTaskLogsCount(UriInfo uriInfo) {
        HistoricExternalTaskLogQueryDto queryDto = new HistoricExternalTaskLogQueryDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return this.queryHistoricExternalTaskLogsCount(queryDto);
    }

    @Override
    public CountResultDto queryHistoricExternalTaskLogsCount(HistoricExternalTaskLogQueryDto queryDto) {
        queryDto.setObjectMapper(this.objectMapper);
        HistoricExternalTaskLogQuery query = (HistoricExternalTaskLogQuery)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

