/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.Direction;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.rest.dto.AbstractSearchQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.SortingDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;

public abstract class AbstractQueryDto<T extends Query<?, ?>>
extends AbstractSearchQueryDto {
    public static final String SORT_ORDER_ASC_VALUE = "asc";
    public static final String SORT_ORDER_DESC_VALUE = "desc";
    public static final List<String> VALID_SORT_ORDER_VALUES = new ArrayList<String>();
    protected String sortBy;
    protected String sortOrder;
    protected List<SortingDto> sortings;
    protected Map<String, String> expressions = new HashMap<String, String>();

    public AbstractQueryDto() {
    }

    public AbstractQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="sortBy")
    public void setSortBy(String sortBy) {
        if (!this.isValidSortByValue(sortBy)) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "sortBy parameter has invalid value: " + sortBy);
        }
        this.sortBy = sortBy;
    }

    @CamundaQueryParam(value="sortOrder")
    public void setSortOrder(String sortOrder) {
        if (!VALID_SORT_ORDER_VALUES.contains(sortOrder)) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "sortOrder parameter has invalid value: " + sortOrder);
        }
        this.sortOrder = sortOrder;
    }

    public void setSorting(List<SortingDto> sorting) {
        this.sortings = sorting;
    }

    public List<SortingDto> getSorting() {
        return this.sortings;
    }

    protected abstract boolean isValidSortByValue(String var1);

    protected boolean sortOptionsValid() {
        return this.sortBy != null && this.sortOrder != null || this.sortBy == null && this.sortOrder == null;
    }

    public T toQuery(ProcessEngine engine) {
        T query = this.createNewQuery(engine);
        this.applyFilters(query);
        if (!this.sortOptionsValid()) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Only a single sorting parameter specified. sortBy and sortOrder required");
        }
        this.applySortingOptions(query, engine);
        return query;
    }

    protected abstract T createNewQuery(ProcessEngine var1);

    protected abstract void applyFilters(T var1);

    protected void applySortingOptions(T query, ProcessEngine engine) {
        if (this.sortBy != null) {
            this.applySortBy(query, this.sortBy, null, engine);
        }
        if (this.sortOrder != null) {
            this.applySortOrder(query, this.sortOrder);
        }
        if (this.sortings != null) {
            for (SortingDto sorting : this.sortings) {
                String sortingOrder = sorting.getSortOrder();
                String sortingBy = sorting.getSortBy();
                if (sortingBy != null) {
                    this.applySortBy(query, sortingBy, sorting.getParameters(), engine);
                }
                if (sortingOrder == null) continue;
                this.applySortOrder(query, sortingOrder);
            }
        }
    }

    protected abstract void applySortBy(T var1, String var2, Map<String, Object> var3, ProcessEngine var4);

    protected void applySortOrder(T query, String sortOrder) {
        if (sortOrder != null) {
            if (sortOrder.equals(SORT_ORDER_ASC_VALUE)) {
                query.asc();
            } else if (sortOrder.equals(SORT_ORDER_DESC_VALUE)) {
                query.desc();
            }
        }
    }

    public static String sortOrderValueForDirection(Direction direction) {
        if (Direction.ASCENDING.equals(direction)) {
            return SORT_ORDER_ASC_VALUE;
        }
        if (Direction.DESCENDING.equals(direction)) {
            return SORT_ORDER_DESC_VALUE;
        }
        throw new RestException("Unknown query sorting direction " + direction);
    }

    static {
        VALID_SORT_ORDER_VALUES.add(SORT_ORDER_ASC_VALUE);
        VALID_SORT_ORDER_VALUES.add(SORT_ORDER_DESC_VALUE);
    }
}

