/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.ProcessApplicationService;
import org.camunda.bpm.application.ProcessApplicationInfo;
import org.camunda.bpm.container.RuntimeContainerDelegate;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.camunda.bpm.engine.impl.form.CamundaFormRefImpl;
import org.camunda.bpm.engine.impl.form.validator.FormFieldValidationException;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.CaseDefinitionQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.helper.EqualsMap;
import org.camunda.bpm.engine.rest.helper.EqualsVariableMap;
import org.camunda.bpm.engine.rest.helper.ErrorMessageHelper;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.VariableTypeHelper;
import org.camunda.bpm.engine.rest.helper.variable.EqualsObjectValue;
import org.camunda.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.camunda.bpm.engine.rest.helper.variable.EqualsUntypedValue;
import org.camunda.bpm.engine.rest.util.DateTimeUtils;
import org.camunda.bpm.engine.rest.util.EncodingUtil;
import org.camunda.bpm.engine.rest.util.VariablesBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Comment;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.FileValue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;

public class TaskRestServiceInteractionTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String TASK_SERVICE_URL = "/rest-test/task";
    protected static final String SINGLE_TASK_URL = "/rest-test/task/{id}";
    protected static final String CLAIM_TASK_URL = "/rest-test/task/{id}/claim";
    protected static final String UNCLAIM_TASK_URL = "/rest-test/task/{id}/unclaim";
    protected static final String COMPLETE_TASK_URL = "/rest-test/task/{id}/complete";
    protected static final String RESOLVE_TASK_URL = "/rest-test/task/{id}/resolve";
    protected static final String DELEGATE_TASK_URL = "/rest-test/task/{id}/delegate";
    protected static final String ASSIGNEE_TASK_URL = "/rest-test/task/{id}/assignee";
    protected static final String TASK_IDENTITY_LINKS_URL = "/rest-test/task/{id}/identity-links";
    protected static final String TASK_FORM_URL = "/rest-test/task/{id}/form";
    protected static final String DEPLOYED_TASK_FORM_URL = "/rest-test/task/{id}/deployed-form";
    protected static final String RENDERED_FORM_URL = "/rest-test/task/{id}/rendered-form";
    protected static final String SUBMIT_FORM_URL = "/rest-test/task/{id}/submit-form";
    protected static final String FORM_VARIABLES_URL = "/rest-test/task/{id}/form-variables";
    protected static final String SINGLE_TASK_ADD_COMMENT_URL = "/rest-test/task/{id}/comment/create";
    protected static final String SINGLE_TASK_COMMENTS_URL = "/rest-test/task/{id}/comment";
    protected static final String SINGLE_TASK_SINGLE_COMMENT_URL = "/rest-test/task/{id}/comment/{commentId}";
    protected static final String SINGLE_TASK_ADD_ATTACHMENT_URL = "/rest-test/task/{id}/attachment/create";
    protected static final String SINGLE_TASK_ATTACHMENTS_URL = "/rest-test/task/{id}/attachment";
    protected static final String SINGLE_TASK_SINGLE_ATTACHMENT_URL = "/rest-test/task/{id}/attachment/{attachmentId}";
    protected static final String SINGLE_TASK_DELETE_SINGLE_ATTACHMENT_URL = "/rest-test/task/{id}/attachment/{attachmentId}";
    protected static final String SINGLE_TASK_SINGLE_ATTACHMENT_DATA_URL = "/rest-test/task/{id}/attachment/{attachmentId}/data";
    protected static final String TASK_CREATE_URL = "/rest-test/task/create";
    protected static final String HANDLE_BPMN_ERROR_URL = "/rest-test/task/{id}/bpmnError";
    protected static final String HANDLE_BPMN_ESCALATION_URL = "/rest-test/task/{id}/bpmnEscalation";
    private Task mockTask;
    private TaskService taskServiceMock;
    private TaskQuery mockQuery;
    private FormService formServiceMock;
    private ManagementService managementServiceMock;
    private RepositoryService repositoryServiceMock;
    private IdentityLink mockAssigneeIdentityLink;
    private IdentityLink mockOwnerIdentityLink;
    private IdentityLink mockCandidateGroupIdentityLink;
    private IdentityLink mockCandidateGroup2IdentityLink;
    private HistoricTaskInstanceQuery historicTaskInstanceQueryMock;
    private Comment mockTaskComment;
    private List<Comment> mockTaskComments;
    private Attachment mockTaskAttachment;
    private List<Attachment> mockTaskAttachments;

    @Before
    public void setUpRuntimeData() {
        this.taskServiceMock = (TaskService)Mockito.mock(TaskService.class);
        Mockito.when((Object)processEngine.getTaskService()).thenReturn((Object)this.taskServiceMock);
        this.mockTask = MockProvider.createMockTask();
        this.mockQuery = (TaskQuery)Mockito.mock(TaskQuery.class);
        Mockito.when((Object)this.mockQuery.initializeFormKeys()).thenReturn((Object)this.mockQuery);
        Mockito.when((Object)this.mockQuery.taskId((String)ArgumentMatchers.any())).thenReturn((Object)this.mockQuery);
        Mockito.when((Object)((Task)this.mockQuery.singleResult())).thenReturn((Object)this.mockTask);
        Mockito.when((Object)this.taskServiceMock.createTaskQuery()).thenReturn((Object)this.mockQuery);
        ArrayList<IdentityLink> identityLinks = new ArrayList<IdentityLink>();
        this.mockAssigneeIdentityLink = MockProvider.createMockUserAssigneeIdentityLink();
        identityLinks.add(this.mockAssigneeIdentityLink);
        this.mockOwnerIdentityLink = MockProvider.createMockUserOwnerIdentityLink();
        identityLinks.add(this.mockOwnerIdentityLink);
        this.mockCandidateGroupIdentityLink = MockProvider.createMockCandidateGroupIdentityLink();
        identityLinks.add(this.mockCandidateGroupIdentityLink);
        this.mockCandidateGroup2IdentityLink = MockProvider.createAnotherMockCandidateGroupIdentityLink();
        identityLinks.add(this.mockCandidateGroup2IdentityLink);
        Mockito.when((Object)this.taskServiceMock.getIdentityLinksForTask("anId")).thenReturn(identityLinks);
        this.mockTaskComment = MockProvider.createMockTaskComment();
        Mockito.when((Object)this.taskServiceMock.getTaskComment("anId", "aTaskCommentId")).thenReturn((Object)this.mockTaskComment);
        this.mockTaskComments = MockProvider.createMockTaskComments();
        Mockito.when((Object)this.taskServiceMock.getTaskComments("anId")).thenReturn(this.mockTaskComments);
        Mockito.when((Object)this.taskServiceMock.createComment("anId", null, "aTaskCommentFullMessage")).thenReturn((Object)this.mockTaskComment);
        this.mockTaskAttachment = MockProvider.createMockTaskAttachment();
        Mockito.when((Object)this.taskServiceMock.getTaskAttachment("anId", "aTaskAttachmentId")).thenReturn((Object)this.mockTaskAttachment);
        this.mockTaskAttachments = MockProvider.createMockTaskAttachments();
        Mockito.when((Object)this.taskServiceMock.getTaskAttachments("anId")).thenReturn(this.mockTaskAttachments);
        Mockito.when((Object)this.taskServiceMock.createAttachment((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)Mockito.any())).thenReturn((Object)this.mockTaskAttachment);
        Mockito.when((Object)this.taskServiceMock.createAttachment((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (InputStream)Mockito.any())).thenReturn((Object)this.mockTaskAttachment);
        Mockito.when((Object)this.taskServiceMock.getTaskAttachmentContent("anId", "aTaskAttachmentId")).thenReturn((Object)new ByteArrayInputStream(this.createMockByteData()));
        this.formServiceMock = (FormService)Mockito.mock(FormService.class);
        Mockito.when((Object)processEngine.getFormService()).thenReturn((Object)this.formServiceMock);
        TaskFormData mockFormData = MockProvider.createMockTaskFormData();
        Mockito.when((Object)this.formServiceMock.getTaskFormData((String)ArgumentMatchers.any())).thenReturn((Object)mockFormData);
        Mockito.when((Object)this.formServiceMock.getTaskFormKey((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)"aFormKey");
        VariableMap variablesMock = MockProvider.createMockFormVariables();
        Mockito.when((Object)this.formServiceMock.getTaskFormVariables((String)ArgumentMatchers.eq((Object)"anId"), (Collection)Mockito.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)variablesMock);
        this.repositoryServiceMock = (RepositoryService)Mockito.mock(RepositoryService.class);
        Mockito.when((Object)processEngine.getRepositoryService()).thenReturn((Object)this.repositoryServiceMock);
        ProcessDefinition mockDefinition = MockProvider.createMockDefinition();
        Mockito.when((Object)this.repositoryServiceMock.getProcessDefinition("aProcDefId")).thenReturn((Object)mockDefinition);
        this.managementServiceMock = (ManagementService)Mockito.mock(ManagementService.class);
        Mockito.when((Object)processEngine.getManagementService()).thenReturn((Object)this.managementServiceMock);
        Mockito.when((Object)this.managementServiceMock.getProcessApplicationForDeployment("aDeploymentId")).thenReturn((Object)"aProcessApplication");
        Mockito.when((Object)this.managementServiceMock.getHistoryLevel()).thenReturn((Object)ProcessEngineConfigurationImpl.HISTORYLEVEL_FULL);
        HistoryService historyServiceMock = (HistoryService)Mockito.mock(HistoryService.class);
        Mockito.when((Object)processEngine.getHistoryService()).thenReturn((Object)historyServiceMock);
        this.historicTaskInstanceQueryMock = (HistoricTaskInstanceQuery)Mockito.mock(HistoricTaskInstanceQuery.class);
        Mockito.when((Object)historyServiceMock.createHistoricTaskInstanceQuery()).thenReturn((Object)this.historicTaskInstanceQueryMock);
        Mockito.when((Object)this.historicTaskInstanceQueryMock.taskId((String)ArgumentMatchers.eq((Object)"anId"))).thenReturn((Object)this.historicTaskInstanceQueryMock);
        HistoricTaskInstance historicTaskInstanceMock = MockProvider.createMockHistoricTaskInstance();
        Mockito.when((Object)((HistoricTaskInstance)this.historicTaskInstanceQueryMock.singleResult())).thenReturn((Object)historicTaskInstanceMock);
        ProcessApplicationService processApplicationService = (ProcessApplicationService)Mockito.mock(ProcessApplicationService.class);
        ProcessApplicationInfo appMock = MockProvider.createMockProcessApplicationInfo();
        Mockito.when((Object)processApplicationService.getProcessApplicationInfo("aProcessApplication")).thenReturn((Object)appMock);
        RuntimeContainerDelegate delegate = (RuntimeContainerDelegate)Mockito.mock(RuntimeContainerDelegate.class);
        Mockito.when((Object)delegate.getProcessApplicationService()).thenReturn((Object)processApplicationService);
        RuntimeContainerDelegate.INSTANCE.set(delegate);
    }

    public void mockHistoryDisabled() {
        Mockito.when((Object)this.managementServiceMock.getHistoryLevel()).thenReturn((Object)ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE);
    }

    private byte[] createMockByteData() {
        return "someContent".getBytes();
    }

    @Test
    public void testGetSingleTask() {
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"anId"), new Object[0]).body("name", Matchers.equalTo((Object)"aName"), new Object[0]).body("assignee", Matchers.equalTo((Object)"anAssignee"), new Object[0]).body("created", Matchers.equalTo((Object)MockProvider.EXAMPLE_TASK_CREATE_TIME), new Object[0]).body("due", Matchers.equalTo((Object)MockProvider.EXAMPLE_TASK_DUE_DATE), new Object[0]).body("delegationState", Matchers.equalTo((Object)MockProvider.EXAMPLE_TASK_DELEGATION_STATE.toString()), new Object[0]).body("description", Matchers.equalTo((Object)"aDescription"), new Object[0]).body("executionId", Matchers.equalTo((Object)"anExecution"), new Object[0]).body("owner", Matchers.equalTo((Object)"anOwner"), new Object[0]).body("parentTaskId", Matchers.equalTo((Object)"aParentId"), new Object[0]).body("priority", Matchers.equalTo((Object)42), new Object[0]).body("processDefinitionId", Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("processInstanceId", Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("taskDefinitionKey", Matchers.equalTo((Object)"aTaskDefinitionKey"), new Object[0]).body("suspended", Matchers.equalTo((Object)false), new Object[0]).body("caseExecutionId", Matchers.equalTo((Object)"aCaseExecutionId"), new Object[0]).body("caseInstanceId", Matchers.equalTo((Object)"aCaseInstId"), new Object[0]).body("caseDefinitionId", Matchers.equalTo((Object)"aCaseDefnitionId"), new Object[0]).body("tenantId", Matchers.equalTo((Object)"aTenantId"), new Object[0]).body("lastUpdated", Matchers.equalTo((Object)MockProvider.EXAMPLE_TASK_LAST_UPDATED), new Object[0]).when().get(SINGLE_TASK_URL, new Object[0]);
    }

    @Test
    public void testGetSingleTaskHal() {
        List<User> mockUsers = Arrays.asList(MockProvider.mockUser().id("anAssignee").build(), MockProvider.mockUser().id("anOwner").build());
        UserQuery sampleUserQuery = (UserQuery)Mockito.mock(UserQuery.class);
        Mockito.when((Object)sampleUserQuery.userIdIn(new String[]{(String)ArgumentMatchers.eq((Object)"anAssignee"), (String)ArgumentMatchers.eq((Object)"anOwner")})).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.userIdIn(new String[]{(String)ArgumentMatchers.eq((Object)"anOwner"), (String)ArgumentMatchers.eq((Object)"anAssignee")})).thenReturn((Object)sampleUserQuery);
        Mockito.when((Object)sampleUserQuery.listPage(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)2))).thenReturn(mockUsers);
        Mockito.when((Object)sampleUserQuery.count()).thenReturn((Object)mockUsers.size());
        Mockito.when((Object)processEngine.getIdentityService().createUserQuery()).thenReturn((Object)sampleUserQuery);
        List<Group> mockGroups = Arrays.asList(MockProvider.mockGroup().id(this.mockCandidateGroupIdentityLink.getGroupId()).build(), MockProvider.mockGroup().id(this.mockCandidateGroup2IdentityLink.getGroupId()).build());
        GroupQuery sampleGroupQuery = (GroupQuery)Mockito.mock(GroupQuery.class);
        Mockito.when((Object)sampleGroupQuery.groupIdIn(new String[]{(String)ArgumentMatchers.eq((Object)"groupId1"), (String)ArgumentMatchers.eq((Object)"groupId2")})).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.groupIdIn(new String[]{(String)ArgumentMatchers.eq((Object)"groupId2"), (String)ArgumentMatchers.eq((Object)"groupId1")})).thenReturn((Object)sampleGroupQuery);
        Mockito.when((Object)sampleGroupQuery.listPage(ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)2))).thenReturn(mockGroups);
        Mockito.when((Object)sampleGroupQuery.count()).thenReturn((Object)mockGroups.size());
        Mockito.when((Object)processEngine.getIdentityService().createGroupQuery()).thenReturn((Object)sampleGroupQuery);
        List<ProcessDefinition> mockDefinitions = MockProvider.createMockDefinitions();
        ProcessDefinitionQuery sampleProcessDefinitionQuery = (ProcessDefinitionQuery)Mockito.mock(ProcessDefinitionQuery.class);
        Mockito.when((Object)sampleProcessDefinitionQuery.listPage(0, 1)).thenReturn(mockDefinitions);
        Mockito.when((Object)sampleProcessDefinitionQuery.processDefinitionIdIn(new String[]{"aProcDefId"})).thenReturn((Object)sampleProcessDefinitionQuery);
        Mockito.when((Object)sampleProcessDefinitionQuery.count()).thenReturn((Object)1L);
        Mockito.when((Object)processEngine.getRepositoryService().createProcessDefinitionQuery()).thenReturn((Object)sampleProcessDefinitionQuery);
        List<CaseDefinition> mockCaseDefinitions = MockProvider.createMockCaseDefinitions();
        CaseDefinitionQuery sampleCaseDefinitionQuery = (CaseDefinitionQuery)Mockito.mock(CaseDefinitionQuery.class);
        Mockito.when((Object)sampleCaseDefinitionQuery.listPage(0, 1)).thenReturn(mockCaseDefinitions);
        Mockito.when((Object)sampleCaseDefinitionQuery.caseDefinitionIdIn(new String[]{"aCaseDefnitionId"})).thenReturn((Object)sampleCaseDefinitionQuery);
        Mockito.when((Object)sampleCaseDefinitionQuery.count()).thenReturn((Object)1L);
        Mockito.when((Object)processEngine.getRepositoryService().createCaseDefinitionQuery()).thenReturn((Object)sampleCaseDefinitionQuery);
        Response response = (Response)RestAssured.given().header("accept", (Object)"application/hal+json", new Object[0]).pathParam("id", (Object)"anId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body("id", Matchers.equalTo((Object)"anId"), new Object[0]).body("name", Matchers.equalTo((Object)"aName"), new Object[0]).body("assignee", Matchers.equalTo((Object)"anAssignee"), new Object[0]).body("created", Matchers.equalTo((Object)MockProvider.EXAMPLE_TASK_CREATE_TIME), new Object[0]).body("due", Matchers.equalTo((Object)MockProvider.EXAMPLE_TASK_DUE_DATE), new Object[0]).body("delegationState", Matchers.equalTo((Object)MockProvider.EXAMPLE_TASK_DELEGATION_STATE.toString()), new Object[0]).body("description", Matchers.equalTo((Object)"aDescription"), new Object[0]).body("executionId", Matchers.equalTo((Object)"anExecution"), new Object[0]).body("owner", Matchers.equalTo((Object)"anOwner"), new Object[0]).body("parentTaskId", Matchers.equalTo((Object)"aParentId"), new Object[0]).body("priority", Matchers.equalTo((Object)42), new Object[0]).body("processDefinitionId", Matchers.equalTo((Object)"aProcDefId"), new Object[0]).body("processInstanceId", Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("taskDefinitionKey", Matchers.equalTo((Object)"aTaskDefinitionKey"), new Object[0]).body("suspended", Matchers.equalTo((Object)false), new Object[0]).body("caseExecutionId", Matchers.equalTo((Object)"aCaseExecutionId"), new Object[0]).body("caseInstanceId", Matchers.equalTo((Object)"aCaseInstId"), new Object[0]).body("caseDefinitionId", Matchers.equalTo((Object)"aCaseDefnitionId"), new Object[0]).body("tenantId", Matchers.equalTo((Object)"aTenantId"), new Object[0]).body("_links.assignee.href", Matchers.endsWith((String)"anAssignee"), new Object[0]).body("_links.caseDefinition.href", Matchers.endsWith((String)"aCaseDefnitionId"), new Object[0]).body("_links.caseExecution.href", Matchers.endsWith((String)"aCaseExecutionId"), new Object[0]).body("_links.caseInstance.href", Matchers.endsWith((String)"aCaseInstId"), new Object[0]).body("_links.execution.href", Matchers.endsWith((String)"anExecution"), new Object[0]).body("_links.owner.href", Matchers.endsWith((String)"anOwner"), new Object[0]).body("_links.parentTask.href", Matchers.endsWith((String)"aParentId"), new Object[0]).body("_links.processDefinition.href", Matchers.endsWith((String)"aProcDefId"), new Object[0]).body("_links.processInstance.href", Matchers.endsWith((String)"aProcInstId"), new Object[0]).body("_links.identityLink.href", Matchers.endsWith((String)"/task/anId/identity-links"), new Object[0]).body("_links.self.href", Matchers.endsWith((String)"anId"), new Object[0]).when().get(SINGLE_TASK_URL, new Object[0]);
        String content = response.asString();
        List embeddedUsers = JsonPath.from((String)content).getList("_embedded.user");
        Assert.assertEquals((String)"There should be two users returned.", (long)2L, (long)embeddedUsers.size());
        Map embeddedUser = (Map)embeddedUsers.get(0);
        Assert.assertNotNull((String)"The returned user should not be null.", (Object)embeddedUser);
        Assert.assertEquals((Object)"anAssignee", embeddedUser.get("id"));
        Assert.assertEquals((Object)"firstName", embeddedUser.get("firstName"));
        Assert.assertEquals((Object)"lastName", embeddedUser.get("lastName"));
        Assert.assertEquals((Object)"test@example.org", embeddedUser.get("email"));
        Assert.assertNull(embeddedUser.get("_embedded"));
        Map links = (Map)embeddedUser.get("_links");
        Assert.assertEquals((long)1L, (long)links.size());
        this.assertHalLink(links, "self", "/user/anAssignee");
        embeddedUser = (Map)embeddedUsers.get(1);
        Assert.assertNotNull((String)"The returned user should not be null.", (Object)embeddedUser);
        Assert.assertEquals((Object)"anOwner", embeddedUser.get("id"));
        Assert.assertEquals((Object)"firstName", embeddedUser.get("firstName"));
        Assert.assertEquals((Object)"lastName", embeddedUser.get("lastName"));
        Assert.assertEquals((Object)"test@example.org", embeddedUser.get("email"));
        Assert.assertNull(embeddedUser.get("_embedded"));
        links = (Map)embeddedUser.get("_links");
        Assert.assertEquals((long)1L, (long)links.size());
        this.assertHalLink(links, "self", "/user/anOwner");
        List embeddedGroups = JsonPath.from((String)content).getList("_embedded.group");
        Assert.assertEquals((String)"There should be two groups returned.", (long)2L, (long)embeddedGroups.size());
        Map embeddedGroup = (Map)embeddedGroups.get(0);
        Assert.assertNotNull((String)"The returned group should not be null.", (Object)embeddedGroup);
        Assert.assertEquals((Object)"groupId1", embeddedGroup.get("id"));
        Assert.assertEquals((Object)"group1", embeddedGroup.get("name"));
        Assert.assertEquals((Object)"organizational-unit", embeddedGroup.get("type"));
        Assert.assertNull(embeddedGroup.get("_embedded"));
        links = (Map)embeddedGroup.get("_links");
        Assert.assertEquals((long)1L, (long)links.size());
        this.assertHalLink(links, "self", "/group/groupId1");
        embeddedGroup = (Map)embeddedGroups.get(1);
        Assert.assertNotNull((String)"The returned group should not be null.", (Object)embeddedGroup);
        Assert.assertEquals((Object)"groupId2", embeddedGroup.get("id"));
        Assert.assertEquals((Object)"group1", embeddedGroup.get("name"));
        Assert.assertEquals((Object)"organizational-unit", embeddedGroup.get("type"));
        Assert.assertNull(embeddedGroup.get("_embedded"));
        links = (Map)embeddedGroup.get("_links");
        Assert.assertEquals((long)1L, (long)links.size());
        this.assertHalLink(links, "self", "/group/groupId2");
        List embeddedDefinitions = JsonPath.from((String)content).getList("_embedded.processDefinition");
        Assert.assertEquals((String)"There should be one processDefinition returned.", (long)1L, (long)embeddedDefinitions.size());
        Map embeddedProcessDefinition = (Map)embeddedDefinitions.get(0);
        Assert.assertNotNull((String)"The returned processDefinition should not be null.", (Object)embeddedProcessDefinition);
        Assert.assertEquals((Object)"aProcDefId", embeddedProcessDefinition.get("id"));
        Assert.assertEquals((Object)"aKey", embeddedProcessDefinition.get("key"));
        Assert.assertEquals((Object)"aCategory", embeddedProcessDefinition.get("category"));
        Assert.assertEquals((Object)"aName", embeddedProcessDefinition.get("name"));
        Assert.assertEquals((Object)"aDescription", embeddedProcessDefinition.get("description"));
        Assert.assertEquals((Object)42, embeddedProcessDefinition.get("version"));
        Assert.assertEquals((Object)"aVersionTag", embeddedProcessDefinition.get("versionTag"));
        Assert.assertEquals((Object)"aResourceName", embeddedProcessDefinition.get("resource"));
        Assert.assertEquals((Object)"aDeploymentId", embeddedProcessDefinition.get("deploymentId"));
        Assert.assertEquals((Object)"aResourceName.png", embeddedProcessDefinition.get("diagram"));
        Assert.assertEquals((Object)true, embeddedProcessDefinition.get("suspended"));
        Assert.assertEquals((Object)"http://camunda.org/someContext", embeddedProcessDefinition.get("contextPath"));
        links = (Map)embeddedProcessDefinition.get("_links");
        Assert.assertEquals((long)3L, (long)links.size());
        this.assertHalLink(links, "self", "/process-definition/aProcDefId");
        this.assertHalLink(links, "deployment", "/deployment/aDeploymentId");
        this.assertHalLink(links, "resource", "/deployment/aDeploymentId/resources/aResourceName");
        List embeddedCaseDefinitions = JsonPath.from((String)content).getList("_embedded.caseDefinition");
        Assert.assertEquals((String)"There should be one caseDefinition returned.", (long)1L, (long)embeddedCaseDefinitions.size());
        Map embeddedCaseDefinition = (Map)embeddedCaseDefinitions.get(0);
        Assert.assertNotNull((String)"The returned caseDefinition should not be null.", (Object)embeddedCaseDefinition);
        Assert.assertEquals((Object)"aCaseDefnitionId", embeddedCaseDefinition.get("id"));
        Assert.assertEquals((Object)"aCaseDefinitionKey", embeddedCaseDefinition.get("key"));
        Assert.assertEquals((Object)"aCaseDefinitionCategory", embeddedCaseDefinition.get("category"));
        Assert.assertEquals((Object)"aCaseDefinitionName", embeddedCaseDefinition.get("name"));
        Assert.assertEquals((Object)1, embeddedCaseDefinition.get("version"));
        Assert.assertEquals((Object)"aCaseDefinitionResourceName", embeddedCaseDefinition.get("resource"));
        Assert.assertEquals((Object)"aDeploymentId", embeddedCaseDefinition.get("deploymentId"));
        Assert.assertEquals((Object)"http://camunda.org/someContext", embeddedCaseDefinition.get("contextPath"));
        links = (Map)embeddedCaseDefinition.get("_links");
        Assert.assertEquals((long)3L, (long)links.size());
        this.assertHalLink(links, "self", "/case-definition/aCaseDefnitionId");
        this.assertHalLink(links, "deployment", "/deployment/aDeploymentId");
        this.assertHalLink(links, "resource", "/deployment/aDeploymentId/resources/aCaseDefinitionResourceName");
        List embeddedIdentityLinks = JsonPath.from((String)content).getList("_embedded.identityLink");
        Assert.assertEquals((String)"There should be three identityLink returned", (long)4L, (long)embeddedIdentityLinks.size());
        this.assertEmbeddedIdentityLink(this.mockAssigneeIdentityLink, (Map)embeddedIdentityLinks.get(0));
        this.assertEmbeddedIdentityLink(this.mockOwnerIdentityLink, (Map)embeddedIdentityLinks.get(1));
        this.assertEmbeddedIdentityLink(this.mockCandidateGroupIdentityLink, (Map)embeddedIdentityLinks.get(2));
        this.assertEmbeddedIdentityLink(this.mockCandidateGroup2IdentityLink, (Map)embeddedIdentityLinks.get(3));
    }

    protected void assertHalLink(Map<String, Object> links, String key, String expectedLink) {
        Map linkObject = (Map)links.get(key);
        Assert.assertNotNull((Object)linkObject);
        String actualLink = (String)linkObject.get("href");
        Assert.assertEquals((Object)expectedLink, (Object)actualLink);
    }

    protected void assertEmbeddedIdentityLink(IdentityLink expected, Map<String, Object> actual) {
        Assert.assertNotNull((String)"Embedded indentity link should not be null", actual);
        Assert.assertEquals((Object)expected.getType(), (Object)actual.get("type"));
        Assert.assertEquals((Object)expected.getUserId(), (Object)actual.get("userId"));
        Assert.assertEquals((Object)expected.getGroupId(), (Object)actual.get("groupId"));
        Assert.assertEquals((Object)expected.getTaskId(), (Object)actual.get("taskId"));
        Assert.assertNull((Object)actual.get("_embedded"));
        Map links = (Map)actual.get("_links");
        if (expected.getUserId() != null) {
            this.assertHalLink(links, "user", "/user/" + expected.getUserId());
        }
        if (expected.getGroupId() != null) {
            this.assertHalLink(links, "group", "/group/" + expected.getGroupId());
        }
        if (expected.getTaskId() != null) {
            this.assertHalLink(links, "task", "/task/" + expected.getTaskId());
        }
    }

    @Test
    public void testGetForm() {
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("key", Matchers.equalTo((Object)"aFormKey"), new Object[0]).body("camundaFormRef", CoreMatchers.nullValue(), new Object[0]).body("contextPath", Matchers.equalTo((Object)"http://camunda.org/someContext"), new Object[0]).when().get(TASK_FORM_URL, new Object[0]);
    }

    @Test
    public void testGetTaskshouldContainCamundaFormRef() {
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("camundaFormRef.key", Matchers.equalTo((Object)"aFormKey"), new Object[0]).body("camundaFormRef.binding", Matchers.equalTo((Object)"version"), new Object[0]).body("camundaFormRef.version", Matchers.equalTo((Object)3), new Object[0]).body("key", CoreMatchers.nullValue(), new Object[0]).when().get(SINGLE_TASK_URL, new Object[0]);
    }

    @Test
    public void testGetFormForNonRegisteredDeployment() {
        Mockito.when((Object)this.managementServiceMock.getProcessApplicationForDeployment("aDeploymentId")).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("key", Matchers.equalTo((Object)"aFormKey"), new Object[0]).body("contextPath", CoreMatchers.nullValue(), new Object[0]).when().get(TASK_FORM_URL, new Object[0]);
    }

    @Test
    public void testGetForm_shouldReturnFormRef() {
        TaskFormData mockTaskFormData = MockProvider.createMockTaskFormDataUsingFormRef();
        Mockito.when((Object)this.formServiceMock.getTaskFormData("anId")).thenReturn((Object)mockTaskFormData);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("camundaFormRef.key", Matchers.equalTo((Object)"aFormKey"), new Object[0]).body("camundaFormRef.binding", Matchers.equalTo((Object)"version"), new Object[0]).body("camundaFormRef.version", Matchers.equalTo((Object)3), new Object[0]).body("key", CoreMatchers.nullValue(), new Object[0]).body("contextPath", Matchers.equalTo((Object)"http://camunda.org/someContext"), new Object[0]).when().get(TASK_FORM_URL, new Object[0]);
    }

    @Test
    public void getFormForIndependentTask() {
        Mockito.when((Object)this.mockTask.getProcessDefinitionId()).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("key", Matchers.equalTo((Object)"aFormKey"), new Object[0]).body("contextPath", CoreMatchers.nullValue(), new Object[0]).when().get(TASK_FORM_URL, new Object[0]);
        ((RepositoryService)Mockito.verify((Object)this.repositoryServiceMock, (VerificationMode)Mockito.never())).getProcessDefinition(null);
    }

    @Test
    public void testGetForm_shouldReturnKeyContainingTaskId() {
        TaskFormData mockTaskFormData = MockProvider.createMockTaskFormDataUsingFormFieldsWithoutFormKey();
        Mockito.when((Object)this.formServiceMock.getTaskFormData("anId")).thenReturn((Object)mockTaskFormData);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("key", Matchers.equalTo((Object)"embedded:engine://engine/:engine/task/anId/rendered-form"), new Object[0]).body("contextPath", Matchers.equalTo((Object)"http://camunda.org/someContext"), new Object[0]).when().get(TASK_FORM_URL, new Object[0]);
    }

    @Test
    public void testGetForm__FormDataEqualsNull() {
        Mockito.when((Object)this.formServiceMock.getTaskFormData("anId")).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("contextPath", Matchers.equalTo((Object)"http://camunda.org/someContext"), new Object[0]).when().get(TASK_FORM_URL, new Object[0]);
    }

    @Test
    public void testGetFormThrowsAuthorizationException() {
        String message = "expected exception";
        ((FormService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.formServiceMock)).getTaskFormData(ArgumentMatchers.anyString());
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().get(TASK_FORM_URL, new Object[0]);
    }

    @Test
    public void testGetRenderedForm() {
        String expectedResult = "<formField>anyContent</formField>";
        Mockito.when((Object)this.formServiceMock.getRenderedTaskForm("anId")).thenReturn((Object)expectedResult);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"anId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(XHTML_XML_CONTENT_TYPE).when().get(RENDERED_FORM_URL, new Object[0]);
        String responseContent = response.asString();
        Assertions.assertThat((String)responseContent).isEqualTo((Object)expectedResult);
    }

    @Test
    public void testGetRenderedFormForDifferentPlatformEncoding() throws NoSuchFieldException, IllegalAccessException, UnsupportedEncodingException {
        String expectedResult = "<formField>unicode symbol: \u2200</formField>";
        Mockito.when((Object)this.formServiceMock.getRenderedTaskForm("anId")).thenReturn((Object)expectedResult);
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"anId").then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(XHTML_XML_CONTENT_TYPE).when().get(RENDERED_FORM_URL, new Object[0]);
        String responseContent = new String(response.asByteArray(), EncodingUtil.DEFAULT_ENCODING);
        Assertions.assertThat((String)responseContent).isEqualTo((Object)expectedResult);
    }

    @Test
    public void testGetRenderedFormReturnsNotFound() {
        Mockito.when((Object)this.formServiceMock.getRenderedTaskForm(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"anId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"No matching rendered form for task with the id anId found."), new Object[0]).when().get(RENDERED_FORM_URL, new Object[0]);
    }

    @Test
    public void testGetRenderedFormThrowsAuthorizationException() {
        String message = "expected exception";
        ((FormService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.formServiceMock)).getRenderedTaskForm(ArgumentMatchers.anyString());
        RestAssured.given().pathParam("id", (Object)"anId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().get(RENDERED_FORM_URL, new Object[0]);
    }

    @Test
    public void testSubmitForm() {
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SUBMIT_FORM_URL, new Object[0]);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).submitTaskForm("anId", null);
    }

    @Test
    public void testSubmitFormWithVariablesInReturn() {
        VariableMap variables = MockProvider.createMockSerializedVariables();
        Mockito.when((Object)this.formServiceMock.submitTaskFormWithVariablesInReturn("anId", null, false)).thenReturn((Object)variables);
        HashMap<String, Boolean> queryParameters = new HashMap<String, Boolean>();
        queryParameters.put("withVariablesInReturn", true);
        RestAssured.given().pathParam("id", (Object)"anId").contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.OK.getStatusCode()).body("aVariableInstanceName.value", Matchers.equalTo((Object)"aSerializedValue"), new Object[0]).body("aVariableInstanceName.type", Matchers.equalTo((Object)"Object"), new Object[0]).body("aVariableInstanceName.valueInfo.objectTypeName", Matchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).body("aVariableInstanceName.valueInfo.serializationDataFormat", Matchers.equalTo((Object)"application/json"), new Object[0]).body("aDeserializedVariableInstanceName.value", Matchers.equalTo((Object)"aSerializedValue"), new Object[0]).body("aDeserializedVariableInstanceName.type", Matchers.equalTo((Object)"Object"), new Object[0]).body("aDeserializedVariableInstanceName.valueInfo.objectTypeName", Matchers.equalTo((Object)Object.class.getName()), new Object[0]).body("aDeserializedVariableInstanceName.valueInfo.serializationDataFormat", Matchers.equalTo((Object)"application/json"), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).submitTaskFormWithVariablesInReturn("anId", null, false);
    }

    @Test
    public void testSubmitFormWithParameters() {
        Map<String, Object> variables = VariablesBuilder.create().variable("aVariable", "aStringValue").variable("anotherVariable", 42).variable("aThirdValue", Boolean.TRUE).getVariables();
        HashMap<String, Map<String, Object>> json = new HashMap<String, Map<String, Object>>();
        json.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SUBMIT_FORM_URL, new Object[0]);
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("aVariable", "aStringValue");
        expectedVariables.put("anotherVariable", 42);
        expectedVariables.put("aThirdValue", Boolean.TRUE);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).submitTaskForm((String)ArgumentMatchers.eq((Object)"anId"), (Map)MockitoHamcrest.argThat((Matcher)new EqualsMap(expectedVariables)));
    }

    @Test
    public void testSubmitTaskFormWithBase64EncodedBytes() {
        Map<String, Object> variables = VariablesBuilder.create().variable("aVariable", (Object)Base64.encodeBase64String((byte[])"someBytes".getBytes()), "Bytes").getVariables();
        HashMap<String, Map<String, Object>> json = new HashMap<String, Map<String, Object>>();
        json.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SUBMIT_FORM_URL, new Object[0]);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).submitTaskForm((String)ArgumentMatchers.eq((Object)"anId"), (Map)MockitoHamcrest.argThat((Matcher)new EqualsMap().matcher("aVariable", (Matcher<?>)EqualsPrimitiveValue.bytesValue("someBytes".getBytes()))));
    }

    @Test
    public void testSubmitTaskFormWithFileValue() {
        String variableKey = "aVariable";
        String filename = "test.txt";
        Map<String, Object> variables = VariablesBuilder.create().variable(variableKey, (Object)Base64.encodeBase64String((byte[])"someBytes".getBytes()), "File").getVariables();
        ((Map)variables.get(variableKey)).put("valueInfo", Collections.singletonMap("filename", filename));
        HashMap<String, Map<String, Object>> json = new HashMap<String, Map<String, Object>>();
        json.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(SUBMIT_FORM_URL, new Object[0]);
        ArgumentCaptor captor = ArgumentCaptor.forClass(VariableMap.class);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).submitTaskForm((String)ArgumentMatchers.eq((Object)"anId"), (Map)captor.capture());
        VariableMap map = (VariableMap)captor.getValue();
        FileValue fileValue = (FileValue)map.getValueTyped(variableKey);
        Assertions.assertThat((Object)fileValue).isNotNull();
        Assertions.assertThat((String)fileValue.getFilename()).isEqualTo((Object)filename);
        Assertions.assertThat((byte[])IoUtil.readInputStream((InputStream)fileValue.getValue(), null)).isEqualTo((Object)"someBytes".getBytes());
    }

    @Test
    public void testSubmitFormWithUnparseableIntegerVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Cannot submit task form anId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Integer.class))), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void testSubmitFormWithUnparseableShortVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Short";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Cannot submit task form anId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Short.class))), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void testSubmitFormWithUnparseableLongVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Long";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Cannot submit task form anId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Long.class))), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void testSubmitFormWithUnparseableDoubleVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Double";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Cannot submit task form anId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Double.class))), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void testSubmitFormWithUnparseableDateVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Date";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Cannot submit task form anId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Date.class))), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void shouldReturnErrorOnSubmitTaskForm() {
        ((FormService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("foo", 123)}).when((Object)this.formServiceMock)).submitTaskForm(ArgumentMatchers.anyString(), (Map)Mockito.any());
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Cannot submit task form anId: foo"), new Object[0]).body("code", Matchers.equalTo((Object)123), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void testSubmitFormWithNotSupportedVariableType() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "X";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot submit task form anId: Unsupported value type 'X'"), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void testUnsuccessfulSubmitForm() {
        ((FormService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.formServiceMock)).submitTaskForm((String)ArgumentMatchers.any(String.class), (Map)Mockito.any());
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Cannot submit task form anId: expected exception"), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void testSubmitFormThrowsAuthorizationException() {
        String message = "expected exception";
        ((FormService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.formServiceMock)).submitTaskForm(ArgumentMatchers.anyString(), (Map)Mockito.any());
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void testSubmitTaskFormThrowsFormFieldValidationException() {
        String message = "expected exception";
        ((FormService)Mockito.doThrow((Throwable[])new Throwable[]{new FormFieldValidationException((Object)"form-exception", message)}).when((Object)this.formServiceMock)).submitTaskForm(ArgumentMatchers.anyString(), (Map)Mockito.any());
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)("Cannot submit task form anId: " + message)), new Object[0]).when().post(SUBMIT_FORM_URL, new Object[0]);
    }

    @Test
    public void testGetTaskFormVariables() {
        ((Response)RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("aVariableInstanceName.type", Matchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName((ValueType)MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE.getType())), new Object[0]).body("aVariableInstanceName.value", Matchers.equalTo((Object)((String)MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE.getValue())), new Object[0]).when().get(FORM_VARIABLES_URL, new Object[0])).body();
        ((FormService)Mockito.verify((Object)this.formServiceMock, (VerificationMode)Mockito.times((int)1))).getTaskFormVariables("anId", null, true);
    }

    @Test
    public void testGetTaskFormVariablesVarNames() {
        RestAssured.given().pathParam("id", (Object)"anId").queryParam("variableNames", new Object[]{"a,b,c"}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(FORM_VARIABLES_URL, new Object[0]);
        ((FormService)Mockito.verify((Object)this.formServiceMock, (VerificationMode)Mockito.times((int)1))).getTaskFormVariables("anId", Arrays.asList("a", "b", "c"), true);
    }

    @Test
    public void testGetTaskFormVariablesAndDoNotDeserializeVariables() {
        ((Response)RestAssured.given().pathParam("id", (Object)"anId").queryParam("deserializeValues", new Object[]{false}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("aVariableInstanceName.type", Matchers.equalTo((Object)VariableTypeHelper.toExpectedValueTypeName((ValueType)MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE.getType())), new Object[0]).body("aVariableInstanceName.value", Matchers.equalTo((Object)((String)MockProvider.EXAMPLE_PRIMITIVE_VARIABLE_VALUE.getValue())), new Object[0]).when().get(FORM_VARIABLES_URL, new Object[0])).body();
        ((FormService)Mockito.verify((Object)this.formServiceMock, (VerificationMode)Mockito.times((int)1))).getTaskFormVariables("anId", null, false);
    }

    @Test
    public void testGetTaskFormVariablesVarNamesAndDoNotDeserializeVariables() {
        RestAssured.given().pathParam("id", (Object)"anId").queryParam("deserializeValues", new Object[]{false}).queryParam("variableNames", new Object[]{"a,b,c"}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(FORM_VARIABLES_URL, new Object[0]);
        ((FormService)Mockito.verify((Object)this.formServiceMock, (VerificationMode)Mockito.times((int)1))).getTaskFormVariables("anId", Arrays.asList("a", "b", "c"), false);
    }

    @Test
    public void testGetTaskFormVariablesThrowsAuthorizationException() {
        String message = "expected exception";
        ((FormService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.formServiceMock)).getTaskFormVariables(ArgumentMatchers.anyString(), (Collection)Mockito.any(), ArgumentMatchers.anyBoolean());
        RestAssured.given().pathParam("id", (Object)"anId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().get(FORM_VARIABLES_URL, new Object[0]);
    }

    @Test
    public void testClaimTask() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("userId", "userId");
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CLAIM_TASK_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).claim("anId", "userId");
    }

    @Test
    public void testMissingUserId() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("userId", null);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(CLAIM_TASK_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).claim("anId", null);
    }

    @Test
    public void testUnsuccessfulClaimTask() {
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.taskServiceMock)).claim((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"expected exception"), new Object[0]).when().post(CLAIM_TASK_URL, new Object[0]);
    }

    @Test
    public void testClaimTaskThrowsAuthorizationException() {
        String message = "expected exception";
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.taskServiceMock)).claim((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(CLAIM_TASK_URL, new Object[0]);
    }

    @Test
    public void testUnclaimTask() {
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(UNCLAIM_TASK_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setAssignee("anId", null);
    }

    @Test
    public void testUnsuccessfulUnclaimTask() {
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.taskServiceMock)).setAssignee((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"expected exception"), new Object[0]).when().post(UNCLAIM_TASK_URL, new Object[0]);
    }

    @Test
    public void testUnclaimTaskThrowsAuthorizationException() {
        String message = "expected exception";
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.taskServiceMock)).setAssignee((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(UNCLAIM_TASK_URL, new Object[0]);
    }

    @Test
    public void testSetAssignee() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("userId", "userId");
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(ASSIGNEE_TASK_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setAssignee("anId", "userId");
    }

    @Test
    public void testMissingUserIdSetAssignee() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("userId", null);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(ASSIGNEE_TASK_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).setAssignee("anId", null);
    }

    @Test
    public void testUnsuccessfulSetAssignee() {
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.taskServiceMock)).setAssignee((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"expected exception"), new Object[0]).when().post(ASSIGNEE_TASK_URL, new Object[0]);
    }

    @Test
    public void testSetAssigneeThrowsAuthorizationException() {
        String message = "expected exception";
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.taskServiceMock)).setAssignee((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        RestAssured.given().pathParam("id", (Object)"anId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(ASSIGNEE_TASK_URL, new Object[0]);
    }

    protected Map<String, Object> toExpectedJsonMap(IdentityLink identityLink) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("userId", identityLink.getUserId());
        result.put("groupId", identityLink.getGroupId());
        result.put("type", identityLink.getType());
        return result;
    }

    @Test
    public void testGetIdentityLinks() {
        Map<String, Object> expectedAssigneeIdentityLink = this.toExpectedJsonMap(this.mockAssigneeIdentityLink);
        Map<String, Object> expectedOwnerIdentityLink = this.toExpectedJsonMap(this.mockOwnerIdentityLink);
        Map<String, Object> expectedGroupIdentityLink = this.toExpectedJsonMap(this.mockCandidateGroupIdentityLink);
        Map<String, Object> expectedGroupIdentityLink2 = this.toExpectedJsonMap(this.mockCandidateGroup2IdentityLink);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("$.size()", Matchers.equalTo((Object)4), new Object[0]).body("$", Matchers.hasItem(expectedAssigneeIdentityLink), new Object[0]).body("$", Matchers.hasItem(expectedOwnerIdentityLink), new Object[0]).body("$", Matchers.hasItem(expectedGroupIdentityLink), new Object[0]).body("$", Matchers.hasItem(expectedGroupIdentityLink2), new Object[0]).when().get(TASK_IDENTITY_LINKS_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).getIdentityLinksForTask("anId");
    }

    @Test
    public void testGetIdentityLinksByType() {
        Map<String, Object> expectedGroupIdentityLink = this.toExpectedJsonMap(this.mockCandidateGroupIdentityLink);
        Map<String, Object> expectedGroupIdentityLink2 = this.toExpectedJsonMap(this.mockCandidateGroup2IdentityLink);
        RestAssured.given().pathParam("id", (Object)"anId").queryParam("type", new Object[]{"candidate"}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("$.size()", Matchers.equalTo((Object)2), new Object[0]).body("$", Matchers.hasItem(expectedGroupIdentityLink), new Object[0]).body("$", Matchers.hasItem(expectedGroupIdentityLink2), new Object[0]).when().get(TASK_IDENTITY_LINKS_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).getIdentityLinksForTask("anId");
    }

    @Test
    public void testGetIdentityLinksThrowsAuthorizationException() {
        String message = "expected exception";
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.taskServiceMock)).getIdentityLinksForTask(ArgumentMatchers.anyString());
        RestAssured.given().pathParam("id", (Object)"anId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().get(TASK_IDENTITY_LINKS_URL, new Object[0]);
    }

    @Test
    public void testAddUserIdentityLink() {
        String userId = "someUserId";
        String taskId = "anId";
        String type = "someType";
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("userId", userId);
        json.put("taskId", taskId);
        json.put("type", type);
        RestAssured.given().pathParam("id", (Object)taskId).header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(TASK_IDENTITY_LINKS_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).addUserIdentityLink(taskId, userId, type);
    }

    @Test
    public void testAddGroupIdentityLink() {
        String groupId = "someGroupId";
        String taskId = "anId";
        String type = "someType";
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("groupId", groupId);
        json.put("taskId", taskId);
        json.put("type", type);
        RestAssured.given().pathParam("id", (Object)taskId).header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(TASK_IDENTITY_LINKS_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).addGroupIdentityLink(taskId, groupId, type);
    }

    @Test
    public void testInvalidAddIdentityLink() {
        String groupId = "someGroupId";
        String userId = "someUserId";
        String taskId = "anId";
        String type = "someType";
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("groupId", groupId);
        json.put("userId", userId);
        json.put("taskId", taskId);
        json.put("type", type);
        RestAssured.given().pathParam("id", (Object)taskId).header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Identity Link requires userId or groupId, but not both"), new Object[0]).when().post(TASK_IDENTITY_LINKS_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock, (VerificationMode)Mockito.never())).addGroupIdentityLink(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((TaskService)Mockito.verify((Object)this.taskServiceMock, (VerificationMode)Mockito.never())).addGroupIdentityLink(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }

    @Test
    public void testUnderspecifiedAddIdentityLink() {
        String taskId = "anId";
        String type = "someType";
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("taskId", taskId);
        json.put("type", type);
        RestAssured.given().pathParam("id", (Object)taskId).header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Identity Link requires userId or groupId"), new Object[0]).when().post(TASK_IDENTITY_LINKS_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock, (VerificationMode)Mockito.never())).addGroupIdentityLink(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        ((TaskService)Mockito.verify((Object)this.taskServiceMock, (VerificationMode)Mockito.never())).addGroupIdentityLink(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }

    @Test
    public void testAddGroupIdentityLinkThrowsAuthorizationException() {
        String groupId = "someGroupId";
        String taskId = "anId";
        String type = "someType";
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("groupId", groupId);
        json.put("taskId", taskId);
        json.put("type", type);
        String message = "expected exception";
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.taskServiceMock)).addGroupIdentityLink(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        RestAssured.given().pathParam("id", (Object)"anId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(TASK_IDENTITY_LINKS_URL, new Object[0]);
    }

    @Test
    public void testAddUserIdentityLinkThrowsAuthorizationException() {
        String userId = "someUserId";
        String taskId = "anId";
        String type = "someType";
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("userId", userId);
        json.put("taskId", taskId);
        json.put("type", type);
        String message = "expected exception";
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.taskServiceMock)).addUserIdentityLink(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        RestAssured.given().pathParam("id", (Object)"anId").contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(TASK_IDENTITY_LINKS_URL, new Object[0]);
    }

    @Test
    public void testDeleteUserIdentityLink() {
        String deleteIdentityLinkUrl = "/rest-test/task/{id}/identity-links/delete";
        String taskId = "anId";
        String userId = "userId";
        String type = "someIdentityLinkType";
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("userId", userId);
        json.put("type", type);
        RestAssured.given().pathParam("id", (Object)taskId).header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(deleteIdentityLinkUrl, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).deleteUserIdentityLink(taskId, userId, type);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock, (VerificationMode)Mockito.never())).deleteGroupIdentityLink(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }

    @Test
    public void testDeleteGroupIdentityLink() {
        String deleteIdentityLinkUrl = "/rest-test/task/{id}/identity-links/delete";
        String taskId = "anId";
        String groupId = "groupId1";
        String type = "someIdentityLinkType";
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("groupId", groupId);
        json.put("type", type);
        RestAssured.given().pathParam("id", (Object)taskId).header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(deleteIdentityLinkUrl, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).deleteGroupIdentityLink(taskId, groupId, type);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock, (VerificationMode)Mockito.never())).deleteUserIdentityLink(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }

    @Test
    public void testDeleteGroupIdentityLinkThrowsAuthorizationException() {
        String deleteIdentityLinkUrl = "/rest-test/task/{id}/identity-links/delete";
        String taskId = "anId";
        String groupId = "groupId1";
        String type = "someIdentityLinkType";
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("groupId", groupId);
        json.put("type", type);
        String message = "expected exception";
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.taskServiceMock)).deleteGroupIdentityLink(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        RestAssured.given().pathParam("id", (Object)taskId).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(deleteIdentityLinkUrl, new Object[0]);
    }

    @Test
    public void testDeleteUserIdentityLinkThrowsAuthorizationException() {
        String deleteIdentityLinkUrl = "/rest-test/task/{id}/identity-links/delete";
        String taskId = "anId";
        String userId = "userId";
        String type = "someIdentityLinkType";
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("userId", userId);
        json.put("type", type);
        String message = "expected exception";
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.taskServiceMock)).deleteUserIdentityLink(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        RestAssured.given().pathParam("id", (Object)taskId).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(deleteIdentityLinkUrl, new Object[0]);
    }

    @Test
    public void testCompleteTask() {
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(COMPLETE_TASK_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).complete("anId", null);
    }

    @Test
    public void testCompleteWithParameters() {
        Map<String, Object> variables = VariablesBuilder.create().variable("aVariable", "aStringValue").variable("anotherVariable", 42).variable("aThirdValue", Boolean.TRUE).getVariables();
        HashMap<String, Map<String, Object>> json = new HashMap<String, Map<String, Object>>();
        json.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(COMPLETE_TASK_URL, new Object[0]);
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("aVariable", "aStringValue");
        expectedVariables.put("anotherVariable", 42);
        expectedVariables.put("aThirdValue", Boolean.TRUE);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).complete((String)ArgumentMatchers.eq((Object)"anId"), (Map)MockitoHamcrest.argThat((Matcher)new EqualsMap(expectedVariables)));
    }

    @Test
    public void testCompleteTaskWithVariablesInReturn() {
        VariableMap variables = MockProvider.createMockSerializedVariables();
        Mockito.when((Object)this.taskServiceMock.completeWithVariablesInReturn("anId", null, false)).thenReturn((Object)variables);
        HashMap<String, Boolean> json = new HashMap<String, Boolean>();
        json.put("withVariablesInReturn", Boolean.TRUE);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).body("aVariableInstanceName.value", Matchers.equalTo((Object)"aSerializedValue"), new Object[0]).body("aVariableInstanceName.type", Matchers.equalTo((Object)"Object"), new Object[0]).body("aVariableInstanceName.valueInfo.objectTypeName", Matchers.equalTo((Object)ArrayList.class.getName()), new Object[0]).body("aVariableInstanceName.valueInfo.serializationDataFormat", Matchers.equalTo((Object)"application/json"), new Object[0]).body("aDeserializedVariableInstanceName.value", Matchers.equalTo((Object)"aSerializedValue"), new Object[0]).body("aDeserializedVariableInstanceName.type", Matchers.equalTo((Object)"Object"), new Object[0]).body("aDeserializedVariableInstanceName.valueInfo.objectTypeName", Matchers.equalTo((Object)Object.class.getName()), new Object[0]).body("aDeserializedVariableInstanceName.valueInfo.serializationDataFormat", Matchers.equalTo((Object)"application/json"), new Object[0]).when().post(COMPLETE_TASK_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).completeWithVariablesInReturn("anId", null, false);
    }

    @Test
    public void testCompleteWithUnparseableIntegerVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Cannot complete task anId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Integer.class))), new Object[0]).when().post(COMPLETE_TASK_URL, new Object[0]);
    }

    @Test
    public void testCompleteWithUnparseableShortVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Short";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Cannot complete task anId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Short.class))), new Object[0]).when().post(COMPLETE_TASK_URL, new Object[0]);
    }

    @Test
    public void testCompleteWithUnparseableLongVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Long";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Cannot complete task anId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Long.class))), new Object[0]).when().post(COMPLETE_TASK_URL, new Object[0]);
    }

    @Test
    public void testCompleteWithUnparseableDoubleVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Double";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Cannot complete task anId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Double.class))), new Object[0]).when().post(COMPLETE_TASK_URL, new Object[0]);
    }

    @Test
    public void testCompleteWithUnparseableDateVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Date";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Cannot complete task anId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Date.class))), new Object[0]).when().post(COMPLETE_TASK_URL, new Object[0]);
    }

    @Test
    public void testCompleteWithNotSupportedVariableType() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "X";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot complete task anId: Unsupported value type 'X'"), new Object[0]).when().post(COMPLETE_TASK_URL, new Object[0]);
    }

    @Test
    public void testUnsuccessfulCompleteTask() {
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.taskServiceMock)).complete((String)ArgumentMatchers.any(String.class), (Map)Mockito.any());
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Cannot complete task anId: expected exception"), new Object[0]).when().post(COMPLETE_TASK_URL, new Object[0]);
    }

    @Test
    public void shouldReturnErrorOnCompletingTask() {
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("foo", 123)}).when((Object)this.taskServiceMock)).complete((String)ArgumentMatchers.any(String.class), (Map)Mockito.any());
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Cannot complete task anId: foo"), new Object[0]).body("code", Matchers.equalTo((Object)123), new Object[0]).when().post(COMPLETE_TASK_URL, new Object[0]);
    }

    @Test
    public void testCompleteTaskThrowsAuthorizationException() {
        String message = "expected exception";
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.taskServiceMock)).complete(ArgumentMatchers.anyString(), (Map)Mockito.any());
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(COMPLETE_TASK_URL, new Object[0]);
    }

    @Test
    public void testResolveTask() {
        Map<String, Object> variables = VariablesBuilder.create().variable("aVariable", "aStringValue").variable("anotherVariable", 42).variable("aThirdValue", Boolean.TRUE).getVariables();
        HashMap<String, Map<String, Object>> json = new HashMap<String, Map<String, Object>>();
        json.put("variables", variables);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(RESOLVE_TASK_URL, new Object[0]);
        HashMap<String, Object> expectedVariables = new HashMap<String, Object>();
        expectedVariables.put("aVariable", "aStringValue");
        expectedVariables.put("anotherVariable", 42);
        expectedVariables.put("aThirdValue", Boolean.TRUE);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).resolveTask((String)ArgumentMatchers.eq((Object)"anId"), (Map)MockitoHamcrest.argThat((Matcher)new EqualsMap(expectedVariables)));
    }

    @Test
    public void testResolveTaskWithUnparseableIntegerVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Integer";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Cannot resolve task anId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Integer.class))), new Object[0]).when().post(RESOLVE_TASK_URL, new Object[0]);
    }

    @Test
    public void testResolveTaskWithUnparseableShortVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Short";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Cannot resolve task anId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Short.class))), new Object[0]).when().post(RESOLVE_TASK_URL, new Object[0]);
    }

    @Test
    public void testResolveTaskWithUnparseableLongVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Long";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Cannot resolve task anId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Long.class))), new Object[0]).when().post(RESOLVE_TASK_URL, new Object[0]);
    }

    @Test
    public void testResolveTaskWithUnparseableDoubleVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Double";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Cannot resolve task anId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Double.class))), new Object[0]).when().post(RESOLVE_TASK_URL, new Object[0]);
    }

    @Test
    public void testResolveTaskWithUnparseableDateVariable() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "Date";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Cannot resolve task anId: " + ErrorMessageHelper.getExpectedFailingConversionMessage(variableValue, variableType, Date.class))), new Object[0]).when().post(RESOLVE_TASK_URL, new Object[0]);
    }

    @Test
    public void testResolveTaskWithNotSupportedVariableType() {
        String variableKey = "aVariableKey";
        String variableValue = "1abc";
        String variableType = "X";
        Map<String, Object> variableJson = VariablesBuilder.create().variable(variableKey, (Object)variableValue, variableType).getVariables();
        HashMap<String, Map<String, Object>> variables = new HashMap<String, Map<String, Object>>();
        variables.put("variables", variableJson);
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(variables).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Cannot resolve task anId: Unsupported value type 'X'"), new Object[0]).when().post(RESOLVE_TASK_URL, new Object[0]);
    }

    @Test
    public void testResolveTaskThrowsAuthorizationException() {
        String message = "expected exception";
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.taskServiceMock)).resolveTask(ArgumentMatchers.anyString(), (Map)Mockito.any());
        RestAssured.given().pathParam("id", (Object)"anId").contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(RESOLVE_TASK_URL, new Object[0]);
    }

    @Test
    public void testUnsuccessfulResolving() {
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.taskServiceMock)).resolveTask((String)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"expected exception"), new Object[0]).when().post(RESOLVE_TASK_URL, new Object[0]);
    }

    @Test
    public void testGetNonExistingTask() {
        Mockito.when((Object)((Task)this.mockQuery.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"nonExistingId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"No matching task with id nonExistingId"), new Object[0]).when().get(SINGLE_TASK_URL, new Object[0]);
    }

    @Test
    public void testGetNonExistingForm() {
        Mockito.when((Object)this.formServiceMock.getTaskFormData(ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new ProcessEngineException("Expected exception: task does not exist.")});
        RestAssured.given().pathParam("id", (Object)"nonExistingId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Cannot get form for task nonExistingId"), new Object[0]).when().get(TASK_FORM_URL, new Object[0]);
    }

    @Test
    public void testDelegateTask() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("userId", "userId");
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(DELEGATE_TASK_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).delegateTask("anId", "userId");
    }

    @Test
    public void testUnsuccessfulDelegateTask() {
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("expected exception")}).when((Object)this.taskServiceMock)).delegateTask((String)ArgumentMatchers.any(String.class), (String)ArgumentMatchers.any(String.class));
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("userId", "userId");
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)ProcessEngineException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"expected exception"), new Object[0]).when().post(DELEGATE_TASK_URL, new Object[0]);
    }

    @Test
    public void testDelegateTaskThrowsAuthorizationException() {
        String message = "expected exception";
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.taskServiceMock)).delegateTask((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(DELEGATE_TASK_URL, new Object[0]);
    }

    @Test
    public void testGetSingleTaskComment() {
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("commentId", (Object)"aTaskCommentId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("id", Matchers.equalTo((Object)"aTaskCommentId"), new Object[0]).body("taskId", Matchers.equalTo((Object)"anId"), new Object[0]).body("userId", Matchers.equalTo((Object)"userId"), new Object[0]).body("time", Matchers.equalTo((Object)MockProvider.EXAMPLE_TASK_COMMENT_TIME), new Object[0]).body("message", Matchers.equalTo((Object)"aTaskCommentFullMessage"), new Object[0]).body("processInstanceId", Matchers.equalTo((Object)"aProcInstId"), new Object[0]).body("removalTime", Matchers.equalTo((Object)MockProvider.EXAMPLE_TASK_COMMENT_TIME), new Object[0]).body("rootProcessInstanceId", Matchers.equalTo((Object)"aRootProcInstId"), new Object[0]).when().get(SINGLE_TASK_SINGLE_COMMENT_URL, new Object[0]);
    }

    @Test
    public void testGetSingleTaskCommentWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("commentId", (Object)"aTaskCommentId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(Matchers.containsString((String)"History is not enabled"), new Matcher[0]).when().get(SINGLE_TASK_SINGLE_COMMENT_URL, new Object[0]);
    }

    @Test
    public void testGetSingleTaskCommentForNonExistingComment() {
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("commentId", (Object)"nonExistingId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(Matchers.containsString((String)"Task comment with id nonExistingId does not exist for task id 'anId'."), new Matcher[0]).when().get(SINGLE_TASK_SINGLE_COMMENT_URL, new Object[0]);
    }

    @Test
    public void testGetSingleTaskCommentForNonExistingCommentWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("commentId", (Object)"nonExistingId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(Matchers.containsString((String)"History is not enabled"), new Matcher[0]).when().get(SINGLE_TASK_SINGLE_COMMENT_URL, new Object[0]);
    }

    @Test
    public void testGetSingleTaskCommentForNonExistingTask() {
        RestAssured.given().pathParam("id", (Object)"nonExistingId").pathParam("commentId", (Object)"aTaskCommentId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(Matchers.containsString((String)"Task comment with id aTaskCommentId does not exist for task id 'nonExistingId'"), new Matcher[0]).when().get(SINGLE_TASK_SINGLE_COMMENT_URL, new Object[0]);
    }

    @Test
    public void testGetSingleTaskCommentForNonExistingTaskWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"nonExistingId").pathParam("commentId", (Object)"aTaskCommentId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(Matchers.containsString((String)"History is not enabled"), new Matcher[0]).when().get(SINGLE_TASK_SINGLE_COMMENT_URL, new Object[0]);
    }

    @Test
    public void testGetTaskComments() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("$.size()", Matchers.equalTo((Object)1), new Object[0]).when().get(SINGLE_TASK_COMMENTS_URL, new Object[0]);
        this.verifyTaskComments(this.mockTaskComments, response);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).getTaskComments("anId");
    }

    @Test
    public void testGetTaskCommentsWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("$.size()", Matchers.equalTo((Object)0), new Object[0]).when().get(SINGLE_TASK_COMMENTS_URL, new Object[0]);
    }

    @Test
    public void testGetTaskNonExistingComments() {
        Mockito.when((Object)this.taskServiceMock.getTaskComments("anId")).thenReturn(Collections.emptyList());
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("$.size()", Matchers.equalTo((Object)0), new Object[0]).when().get(SINGLE_TASK_COMMENTS_URL, new Object[0]);
    }

    @Test
    public void testGetTaskNonExistingCommentsWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("$.size()", Matchers.equalTo((Object)0), new Object[0]).when().get(SINGLE_TASK_COMMENTS_URL, new Object[0]);
    }

    @Test
    public void testGetTaskCommentsForNonExistingTask() {
        Mockito.when((Object)this.historicTaskInstanceQueryMock.taskId("nonExistingId")).thenReturn((Object)this.historicTaskInstanceQueryMock);
        Mockito.when((Object)((HistoricTaskInstance)this.historicTaskInstanceQueryMock.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"nonExistingId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body(Matchers.containsString((String)"No task found for task id nonExistingId"), new Matcher[0]).when().get(SINGLE_TASK_COMMENTS_URL, new Object[0]);
    }

    @Test
    public void testGetTaskCommentsForNonExistingTaskWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"nonExistingId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("$.size()", Matchers.equalTo((Object)0), new Object[0]).when().get(SINGLE_TASK_COMMENTS_URL, new Object[0]);
    }

    @Test
    public void testAddCompleteTaskComment() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("message", "aTaskCommentFullMessage");
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().post(SINGLE_TASK_ADD_COMMENT_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).createComment("anId", null, "aTaskCommentFullMessage");
        this.verifyCreatedTaskComment(this.mockTaskComment, response);
    }

    @Test
    public void shouldAssignProcessInstanceIdToComment() {
        Mockito.when((Object)this.taskServiceMock.createComment("anId", "aProcessInstanceId", "aTaskCommentFullMessage")).thenReturn((Object)this.mockTaskComment);
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("message", "aTaskCommentFullMessage");
        json.put("processInstanceId", "aProcessInstanceId");
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().post(SINGLE_TASK_ADD_COMMENT_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).createComment("anId", "aProcessInstanceId", "aTaskCommentFullMessage");
        this.verifyCreatedTaskComment(this.mockTaskComment, response);
    }

    @Test
    public void testAddCompleteTaskCommentWithHistoryDisabled() {
        this.mockHistoryDisabled();
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("message", "aTaskCommentFullMessage");
        RestAssured.given().pathParam("id", (Object)"anId").contentType(ContentType.JSON).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body(Matchers.containsString((String)"History is not enabled"), new Matcher[0]).when().post(SINGLE_TASK_ADD_COMMENT_URL, new Object[0]);
    }

    @Test
    public void testAddCommentToNonExistingTask() {
        Mockito.when((Object)this.historicTaskInstanceQueryMock.taskId((String)ArgumentMatchers.eq((Object)"nonExistingId"))).thenReturn((Object)this.historicTaskInstanceQueryMock);
        Mockito.when((Object)((HistoricTaskInstance)this.historicTaskInstanceQueryMock.singleResult())).thenReturn(null);
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("message", "aTaskCommentFullMessage");
        RestAssured.given().pathParam("id", (Object)"nonExistingId").contentType(ContentType.JSON).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(Matchers.containsString((String)"No task found for task id nonExistingId"), new Matcher[0]).when().post(SINGLE_TASK_ADD_COMMENT_URL, new Object[0]);
    }

    @Test
    public void testAddCommentToNonExistingTaskWithHistoryDisabled() {
        this.mockHistoryDisabled();
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("message", "aTaskCommentFullMessage");
        RestAssured.given().pathParam("id", (Object)"nonExistingId").contentType(ContentType.JSON).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body(Matchers.containsString((String)"History is not enabled"), new Matcher[0]).when().post(SINGLE_TASK_ADD_COMMENT_URL, new Object[0]);
    }

    @Test
    public void testAddTaskCommentWithoutBody() {
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode()).when().post(SINGLE_TASK_ADD_COMMENT_URL, new Object[0]);
    }

    @Test
    public void testAddTaskCommentWithoutMessage() {
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException("Message is null")}).when((Object)this.taskServiceMock)).createComment("anId", null, null);
        RestAssured.given().pathParam("id", (Object)"anId").contentType(ContentType.JSON).body("{}").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(Matchers.containsString((String)"Not enough parameters submitted"), new Matcher[0]).when().post(SINGLE_TASK_ADD_COMMENT_URL, new Object[0]);
    }

    @Test
    public void testGetSingleTaskAttachment() {
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("attachmentId", (Object)"aTaskAttachmentId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("id", Matchers.equalTo((Object)"aTaskAttachmentId"), new Object[0]).body("taskId", Matchers.equalTo((Object)"anId"), new Object[0]).body("description", Matchers.equalTo((Object)"aTaskAttachmentDescription"), new Object[0]).body("type", Matchers.equalTo((Object)"aTaskAttachmentType"), new Object[0]).body("name", Matchers.equalTo((Object)"aTaskAttachmentName"), new Object[0]).body("url", Matchers.equalTo((Object)"aTaskAttachmentUrl"), new Object[0]).body("createTime", Matchers.equalTo((Object)MockProvider.EXAMPLE_TASK_ATTACHMENT_CREATE_DATE), new Object[0]).body("removalTime", Matchers.equalTo((Object)MockProvider.EXAMPLE_TASK_ATTACHMENT_REMOVAL_DATE), new Object[0]).body("rootProcessInstanceId", Matchers.equalTo((Object)"aRootProcInstId"), new Object[0]).when().get("/rest-test/task/{id}/attachment/{attachmentId}", new Object[0]);
    }

    @Test
    public void testGetSingleTaskAttachmentWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("attachmentId", (Object)"aTaskAttachmentId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(Matchers.containsString((String)"History is not enabled"), new Matcher[0]).when().get("/rest-test/task/{id}/attachment/{attachmentId}", new Object[0]);
    }

    @Test
    public void testGetSingleTaskAttachmentForNonExistingAttachmentId() {
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("attachmentId", (Object)"nonExistingId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body(Matchers.containsString((String)"Task attachment with id nonExistingId does not exist for task id 'anId'."), new Matcher[0]).when().get("/rest-test/task/{id}/attachment/{attachmentId}", new Object[0]);
    }

    @Test
    public void testGetSingleTaskAttachmentForNonExistingAttachmentIdWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("attachmentId", (Object)"nonExistingId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(Matchers.containsString((String)"History is not enabled"), new Matcher[0]).when().get("/rest-test/task/{id}/attachment/{attachmentId}", new Object[0]);
    }

    @Test
    public void testGetSingleTaskAttachmentForNonExistingTask() {
        RestAssured.given().pathParam("id", (Object)"nonExistingId").pathParam("attachmentId", (Object)"aTaskAttachmentId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(Matchers.containsString((String)"Task attachment with id aTaskAttachmentId does not exist for task id 'nonExistingId'"), new Matcher[0]).when().get("/rest-test/task/{id}/attachment/{attachmentId}", new Object[0]);
    }

    @Test
    public void testGetSingleTaskAttachmentForNonExistingTaskWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"nonExistingId").pathParam("attachmentId", (Object)"aTaskAttachmentId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(Matchers.containsString((String)"History is not enabled"), new Matcher[0]).when().get("/rest-test/task/{id}/attachment/{attachmentId}", new Object[0]);
    }

    @Test
    public void testGetTaskAttachments() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("$.size()", Matchers.equalTo((Object)1), new Object[0]).when().get(SINGLE_TASK_ATTACHMENTS_URL, new Object[0]);
        this.verifyTaskAttachments(this.mockTaskAttachments, response);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).getTaskAttachments("anId");
    }

    @Test
    public void testGetTaskAttachmentsWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("$.size()", Matchers.equalTo((Object)0), new Object[0]).when().get(SINGLE_TASK_ATTACHMENTS_URL, new Object[0]);
    }

    @Test
    public void testGetTaskAttachmentsForNonExistingTaskId() {
        Mockito.when((Object)this.historicTaskInstanceQueryMock.taskId("nonExistingId")).thenReturn((Object)this.historicTaskInstanceQueryMock);
        Mockito.when((Object)((HistoricTaskInstance)this.historicTaskInstanceQueryMock.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"nonExistingId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body(Matchers.containsString((String)"No task found for task id nonExistingId"), new Matcher[0]).when().get(SINGLE_TASK_ATTACHMENTS_URL, new Object[0]);
    }

    @Test
    public void testGetTaskAttachmentsForNonExistingTaskWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"nonExistingId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("$.size()", Matchers.equalTo((Object)0), new Object[0]).when().get(SINGLE_TASK_ATTACHMENTS_URL, new Object[0]);
    }

    @Test
    public void testGetTaskAttachmentsForNonExistingAttachments() {
        Mockito.when((Object)this.taskServiceMock.getTaskAttachments("anId")).thenReturn(Collections.emptyList());
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("$.size()", Matchers.equalTo((Object)0), new Object[0]).when().get(SINGLE_TASK_ATTACHMENTS_URL, new Object[0]);
    }

    @Test
    public void testGetTaskAttachmentsForNonExistingAttachmentsWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).body("$.size()", Matchers.equalTo((Object)0), new Object[0]).when().get(SINGLE_TASK_ATTACHMENTS_URL, new Object[0]);
    }

    @Test
    public void testCreateCompleteTaskAttachmentWithContent() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"anId").multiPart("attachment-name", "aTaskAttachmentName").multiPart("attachment-description", "aTaskAttachmentDescription").multiPart("attachment-type", "aTaskAttachmentType").multiPart("content", (Object)this.createMockByteData()).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SINGLE_TASK_ADD_ATTACHMENT_URL, new Object[0]);
        this.verifyCreatedTaskAttachment(this.mockTaskAttachment, response, false);
    }

    @Test
    public void testCreateTaskAttachmentWithContentToNonExistingTask() {
        Mockito.when((Object)this.historicTaskInstanceQueryMock.taskId((String)ArgumentMatchers.eq((Object)"nonExistingId"))).thenReturn((Object)this.historicTaskInstanceQueryMock);
        Mockito.when((Object)((HistoricTaskInstance)this.historicTaskInstanceQueryMock.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"nonExistingId").multiPart("attachment-name", "aTaskAttachmentName").multiPart("attachment-description", "aTaskAttachmentDescription").multiPart("attachment-type", "aTaskAttachmentType").multiPart("content", (Object)this.createMockByteData()).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(Matchers.containsString((String)"No task found for task id nonExistingId"), new Matcher[0]).when().post(SINGLE_TASK_ADD_ATTACHMENT_URL, new Object[0]);
    }

    @Test
    public void testCreateCompleteTaskAttachmentWithUrl() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"anId").multiPart("attachment-name", "aTaskAttachmentName").multiPart("attachment-description", "aTaskAttachmentDescription").multiPart("attachment-type", "aTaskAttachmentType").multiPart("url", "aTaskAttachmentUrl").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(SINGLE_TASK_ADD_ATTACHMENT_URL, new Object[0]);
        this.verifyCreatedTaskAttachment(this.mockTaskAttachment, response, true);
    }

    @Test
    public void testCreateCompleteTaskAttachmentWithUrlWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"anId").multiPart("attachment-name", "aTaskAttachmentName").multiPart("attachment-description", "aTaskAttachmentDescription").multiPart("attachment-type", "aTaskAttachmentType").multiPart("url", "aTaskAttachmentUrl").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body(Matchers.containsString((String)"History is not enabled"), new Matcher[0]).when().post(SINGLE_TASK_ADD_ATTACHMENT_URL, new Object[0]);
    }

    @Test
    public void testCreateTaskAttachmentWithUrlToNonExistingTask() {
        Mockito.when((Object)this.historicTaskInstanceQueryMock.taskId((String)ArgumentMatchers.eq((Object)"nonExistingId"))).thenReturn((Object)this.historicTaskInstanceQueryMock);
        Mockito.when((Object)((HistoricTaskInstance)this.historicTaskInstanceQueryMock.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"nonExistingId").multiPart("attachment-name", "aTaskAttachmentName").multiPart("attachment-description", "aTaskAttachmentDescription").multiPart("attachment-type", "aTaskAttachmentType").multiPart("url", "aTaskAttachmentUrl").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body(Matchers.containsString((String)"No task found for task id nonExistingId"), new Matcher[0]).when().post(SINGLE_TASK_ADD_ATTACHMENT_URL, new Object[0]);
    }

    @Test
    public void testCreateTaskAttachmentWithUrlToNonExistingTaskWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"nonExistingId").multiPart("attachment-name", "aTaskAttachmentName").multiPart("attachment-description", "aTaskAttachmentDescription").multiPart("attachment-type", "aTaskAttachmentType").multiPart("url", "aTaskAttachmentUrl").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body(Matchers.containsString((String)"History is not enabled"), new Matcher[0]).when().post(SINGLE_TASK_ADD_ATTACHMENT_URL, new Object[0]);
    }

    @Test
    public void testCreateTaskAttachmentWithoutMultiparts() {
        RestAssured.given().pathParam("id", (Object)"anId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.UNSUPPORTED_MEDIA_TYPE.getStatusCode()).when().post(SINGLE_TASK_ADD_ATTACHMENT_URL, new Object[0]);
    }

    @Test
    public void testGetSingleTaskAttachmentContent() {
        Response response = (Response)RestAssured.given().pathParam("id", (Object)"anId").pathParam("attachmentId", (Object)"aTaskAttachmentId").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(SINGLE_TASK_SINGLE_ATTACHMENT_DATA_URL, new Object[0]);
        byte[] responseContent = IoUtil.readInputStream((InputStream)response.asInputStream(), (String)"attachmentContent");
        Assert.assertEquals((Object)"someContent", (Object)new String(responseContent));
    }

    @Test
    public void testGetSingleTaskAttachmentContentWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("attachmentId", (Object)"aTaskAttachmentId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(Matchers.containsString((String)"History is not enabled"), new Matcher[0]).when().get(SINGLE_TASK_SINGLE_ATTACHMENT_DATA_URL, new Object[0]);
    }

    @Test
    public void testGetSingleTaskAttachmentContentForNonExistingAttachmentId() {
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("attachmentId", (Object)"nonExistingId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(Matchers.containsString((String)"Attachment content for attachment with id 'nonExistingId' does not exist for task id 'anId'."), new Matcher[0]).when().get(SINGLE_TASK_SINGLE_ATTACHMENT_DATA_URL, new Object[0]);
    }

    @Test
    public void testGetSingleTaskAttachmentContentForNonExistingAttachmentIdWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("attachmentId", (Object)"nonExistingId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(Matchers.containsString((String)"History is not enabled"), new Matcher[0]).when().get(SINGLE_TASK_SINGLE_ATTACHMENT_DATA_URL, new Object[0]);
    }

    @Test
    public void testGetSingleTaskAttachmentContentForNonExistingTask() {
        RestAssured.given().pathParam("id", (Object)"nonExistingId").pathParam("attachmentId", (Object)"aTaskAttachmentId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(Matchers.containsString((String)"Attachment content for attachment with id 'aTaskAttachmentId' does not exist for task id 'nonExistingId'."), new Matcher[0]).when().get(SINGLE_TASK_SINGLE_ATTACHMENT_DATA_URL, new Object[0]);
    }

    @Test
    public void testGetSingleTaskAttachmentContentForNonExistingTaskWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"nonExistingId").pathParam("attachmentId", (Object)"aTaskAttachmentId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(Matchers.containsString((String)"History is not enabled"), new Matcher[0]).when().get(SINGLE_TASK_SINGLE_ATTACHMENT_DATA_URL, new Object[0]);
    }

    @Test
    public void testDeleteSingleTaskAttachment() {
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("attachmentId", (Object)"aTaskAttachmentId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete("/rest-test/task/{id}/attachment/{attachmentId}", new Object[0]);
    }

    @Test
    public void testDeleteSingleTaskAttachmentWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("attachmentId", (Object)"aTaskAttachmentId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body(Matchers.containsString((String)"History is not enabled"), new Matcher[0]).when().delete("/rest-test/task/{id}/attachment/{attachmentId}", new Object[0]);
    }

    @Test
    public void testDeleteSingleTaskAttachmentForNonExistingAttachmentId() {
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException()}).when((Object)this.taskServiceMock)).deleteTaskAttachment("anId", "nonExistingId");
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("attachmentId", (Object)"nonExistingId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body(Matchers.containsString((String)"Deletion is not possible. No attachment exists for task id 'anId' and attachment id 'nonExistingId'."), new Matcher[0]).when().delete("/rest-test/task/{id}/attachment/{attachmentId}", new Object[0]);
    }

    @Test
    public void testDeleteSingleTaskAttachmentForNonExistingAttachmentIdWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"anId").pathParam("attachmentId", (Object)"nonExistingId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body(Matchers.containsString((String)"History is not enabled"), new Matcher[0]).when().delete("/rest-test/task/{id}/attachment/{attachmentId}", new Object[0]);
    }

    @Test
    public void testDeleteSingleTaskAttachmentForNonExistingTask() {
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException()}).when((Object)this.taskServiceMock)).deleteTaskAttachment("nonExistingId", "aTaskAttachmentId");
        RestAssured.given().pathParam("id", (Object)"nonExistingId").pathParam("attachmentId", (Object)"aTaskAttachmentId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body(Matchers.containsString((String)"Deletion is not possible. No attachment exists for task id 'nonExistingId' and attachment id 'aTaskAttachmentId'."), new Matcher[0]).when().delete("/rest-test/task/{id}/attachment/{attachmentId}", new Object[0]);
    }

    @Test
    public void testDeleteSingleTaskAttachmentForNonExistingTaskWithHistoryDisabled() {
        this.mockHistoryDisabled();
        RestAssured.given().pathParam("id", (Object)"nonExistingId").pathParam("attachmentId", (Object)"aTaskAttachmentId").header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body(Matchers.containsString((String)"History is not enabled"), new Matcher[0]).when().delete("/rest-test/task/{id}/attachment/{attachmentId}", new Object[0]);
    }

    @Test
    public void testDeleteDeleteTask() {
        RestAssured.given().pathParam("id", (Object)"anId").expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().delete(SINGLE_TASK_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).deleteTask("anId");
    }

    @Test
    public void testPostCreateTask() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("id", "anyTaskId");
        json.put("name", "A Task");
        json.put("description", "Some description");
        json.put("priority", 30);
        json.put("assignee", "demo");
        json.put("owner", "mary");
        json.put("delegationState", "PENDING");
        json.put("due", DateTimeUtils.withTimezone("2014-01-01T00:00:00"));
        json.put("followUp", DateTimeUtils.withTimezone("2014-01-01T00:00:00"));
        json.put("parentTaskId", "aParentTaskId");
        json.put("caseInstanceId", "aCaseInstanceId");
        json.put("tenantId", "aTenantId");
        Task newTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)this.taskServiceMock.newTask(ArgumentMatchers.anyString())).thenReturn((Object)newTask);
        RestAssured.given().body(json).contentType(ContentType.JSON).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(TASK_CREATE_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).newTask((String)json.get("id"));
        ((Task)Mockito.verify((Object)newTask)).setName((String)json.get("name"));
        ((Task)Mockito.verify((Object)newTask)).setDescription((String)json.get("description"));
        ((Task)Mockito.verify((Object)newTask)).setPriority(((Integer)json.get("priority")).intValue());
        ((Task)Mockito.verify((Object)newTask)).setAssignee((String)json.get("assignee"));
        ((Task)Mockito.verify((Object)newTask)).setOwner((String)json.get("owner"));
        ((Task)Mockito.verify((Object)newTask)).setDelegationState(DelegationState.valueOf((String)((String)json.get("delegationState"))));
        ((Task)Mockito.verify((Object)newTask)).setDueDate((Date)ArgumentMatchers.any(Date.class));
        ((Task)Mockito.verify((Object)newTask)).setFollowUpDate((Date)ArgumentMatchers.any(Date.class));
        ((Task)Mockito.verify((Object)newTask)).setParentTaskId((String)json.get("parentTaskId"));
        ((Task)Mockito.verify((Object)newTask)).setCaseInstanceId((String)json.get("caseInstanceId"));
        ((Task)Mockito.verify((Object)newTask)).setTenantId((String)json.get("tenantId"));
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).saveTask(newTask);
    }

    @Test
    public void testPostCreateTaskPartialProperties() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("name", "A Task");
        json.put("description", "Some description");
        json.put("assignee", "demo");
        json.put("owner", "mary");
        json.put("due", DateTimeUtils.withTimezone("2014-01-01T00:00:00"));
        json.put("parentTaskId", "aParentTaskId");
        Task newTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)this.taskServiceMock.newTask((String)ArgumentMatchers.any())).thenReturn((Object)newTask);
        RestAssured.given().body(json).contentType(ContentType.JSON).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(TASK_CREATE_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).newTask(null);
        ((Task)Mockito.verify((Object)newTask)).setName((String)json.get("name"));
        ((Task)Mockito.verify((Object)newTask)).setDescription((String)json.get("description"));
        ((Task)Mockito.verify((Object)newTask)).setPriority(0);
        ((Task)Mockito.verify((Object)newTask)).setAssignee((String)json.get("assignee"));
        ((Task)Mockito.verify((Object)newTask)).setOwner((String)json.get("owner"));
        ((Task)Mockito.verify((Object)newTask)).setDelegationState(null);
        ((Task)Mockito.verify((Object)newTask)).setDueDate((Date)ArgumentMatchers.any(Date.class));
        ((Task)Mockito.verify((Object)newTask)).setFollowUpDate(null);
        ((Task)Mockito.verify((Object)newTask)).setParentTaskId((String)json.get("parentTaskId"));
        ((Task)Mockito.verify((Object)newTask)).setCaseInstanceId(null);
        ((Task)Mockito.verify((Object)newTask)).setTenantId(null);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).saveTask(newTask);
    }

    @Test
    public void testPostCreateTaskDelegationStateResolved() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("delegationState", "RESOLVED");
        Task newTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)this.taskServiceMock.newTask((String)ArgumentMatchers.any())).thenReturn((Object)newTask);
        RestAssured.given().body(json).contentType(ContentType.JSON).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(TASK_CREATE_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).newTask(null);
        ((Task)Mockito.verify((Object)newTask)).setDelegationState(DelegationState.valueOf((String)((String)json.get("delegationState"))));
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).saveTask(newTask);
    }

    @Test
    public void testPostCreateTaskDelegationStatePending() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("delegationState", "PENDING");
        Task newTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)this.taskServiceMock.newTask((String)ArgumentMatchers.any())).thenReturn((Object)newTask);
        RestAssured.given().body(json).contentType(ContentType.JSON).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(TASK_CREATE_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).newTask(null);
        ((Task)Mockito.verify((Object)newTask)).setDelegationState(DelegationState.valueOf((String)((String)json.get("delegationState"))));
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).saveTask(newTask);
    }

    @Test
    public void testPostCreateTaskUnsupportedDelegationState() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("delegationState", "unsupported");
        Task newTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)this.taskServiceMock.newTask((String)ArgumentMatchers.any())).thenReturn((Object)newTask);
        RestAssured.given().body(json).contentType(ContentType.JSON).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Valid values for property 'delegationState' are 'PENDING' or 'RESOLVED', but was 'unsupported'"), new Object[0]).when().post(TASK_CREATE_URL, new Object[0]);
    }

    @Test
    public void testPostCreateTaskLowercaseDelegationState() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("delegationState", "pending");
        Task newTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)this.taskServiceMock.newTask((String)ArgumentMatchers.any())).thenReturn((Object)newTask);
        RestAssured.given().body(json).contentType(ContentType.JSON).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(TASK_CREATE_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).newTask(null);
        ((Task)Mockito.verify((Object)newTask)).setDelegationState(DelegationState.PENDING);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).saveTask(newTask);
    }

    @Test
    public void testPostCreateTask_NotValidValueException() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("id", "anyTaskId");
        Task newTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)this.taskServiceMock.newTask(ArgumentMatchers.anyString())).thenReturn((Object)newTask);
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new NotValidException("parent task is null")}).when((Object)this.taskServiceMock)).saveTask(newTask);
        RestAssured.given().body(json).contentType(ContentType.JSON).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Could not save task: parent task is null"), new Object[0]).when().post(TASK_CREATE_URL, new Object[0]);
    }

    @Test
    public void testPostCreateTaskThrowsAuthorizationException() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("id", "anyTaskId");
        String message = "expected exception";
        Mockito.when((Object)this.taskServiceMock.newTask(ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().body(json).contentType(ContentType.JSON).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(TASK_CREATE_URL, new Object[0]);
    }

    @Test
    public void testSaveNewTaskThrowsAuthorizationException() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("id", "anyTaskId");
        Task newTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)this.taskServiceMock.newTask(ArgumentMatchers.anyString())).thenReturn((Object)newTask);
        String message = "expected exception";
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.taskServiceMock)).saveTask(newTask);
        RestAssured.given().body(json).contentType(ContentType.JSON).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(TASK_CREATE_URL, new Object[0]);
    }

    @Test
    public void testPutUpdateTask() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("id", "anyTaskId");
        json.put("name", "A Task");
        json.put("description", "Some description");
        json.put("priority", 30);
        json.put("assignee", "demo");
        json.put("owner", "mary");
        json.put("delegationState", "PENDING");
        json.put("due", DateTimeUtils.withTimezone("2014-01-01T00:00:00"));
        json.put("followUp", DateTimeUtils.withTimezone("2014-01-01T00:00:00"));
        json.put("parentTaskId", "aParentTaskId");
        json.put("caseInstanceId", "aCaseInstanceId");
        json.put("tenantId", "aTenantId");
        RestAssured.given().pathParam("id", (Object)"anId").body(json).contentType(ContentType.JSON).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_TASK_URL, new Object[0]);
        ((Task)Mockito.verify((Object)this.mockTask)).setName((String)json.get("name"));
        ((Task)Mockito.verify((Object)this.mockTask)).setDescription((String)json.get("description"));
        ((Task)Mockito.verify((Object)this.mockTask)).setPriority(((Integer)json.get("priority")).intValue());
        ((Task)Mockito.verify((Object)this.mockTask)).setAssignee((String)json.get("assignee"));
        ((Task)Mockito.verify((Object)this.mockTask)).setOwner((String)json.get("owner"));
        ((Task)Mockito.verify((Object)this.mockTask)).setDelegationState(DelegationState.valueOf((String)((String)json.get("delegationState"))));
        ((Task)Mockito.verify((Object)this.mockTask)).setDueDate((Date)ArgumentMatchers.any(Date.class));
        ((Task)Mockito.verify((Object)this.mockTask)).setFollowUpDate((Date)ArgumentMatchers.any(Date.class));
        ((Task)Mockito.verify((Object)this.mockTask)).setParentTaskId((String)json.get("parentTaskId"));
        ((Task)Mockito.verify((Object)this.mockTask)).setCaseInstanceId((String)json.get("caseInstanceId"));
        ((Task)Mockito.verify((Object)this.mockTask)).setTenantId((String)json.get("tenantId"));
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).saveTask(this.mockTask);
    }

    @Test
    public void testPutUpdateTaskPartialProperties() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("name", "A Task");
        json.put("description", "Some description");
        json.put("assignee", "demo");
        json.put("owner", "mary");
        json.put("due", DateTimeUtils.withTimezone("2014-01-01T00:00:00"));
        json.put("parentTaskId", "aParentTaskId");
        RestAssured.given().pathParam("id", (Object)"anId").body(json).contentType(ContentType.JSON).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_TASK_URL, new Object[0]);
        ((Task)Mockito.verify((Object)this.mockTask)).setName((String)json.get("name"));
        ((Task)Mockito.verify((Object)this.mockTask)).setDescription((String)json.get("description"));
        ((Task)Mockito.verify((Object)this.mockTask)).setPriority(0);
        ((Task)Mockito.verify((Object)this.mockTask)).setAssignee((String)json.get("assignee"));
        ((Task)Mockito.verify((Object)this.mockTask)).setOwner((String)json.get("owner"));
        ((Task)Mockito.verify((Object)this.mockTask)).setDelegationState(null);
        ((Task)Mockito.verify((Object)this.mockTask)).setDueDate((Date)ArgumentMatchers.any(Date.class));
        ((Task)Mockito.verify((Object)this.mockTask)).setFollowUpDate(null);
        ((Task)Mockito.verify((Object)this.mockTask)).setParentTaskId((String)json.get("parentTaskId"));
        ((Task)Mockito.verify((Object)this.mockTask)).setCaseInstanceId(null);
        ((Task)Mockito.verify((Object)this.mockTask)).setTenantId(null);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).saveTask(this.mockTask);
    }

    @Test
    public void testPutUpdateTaskNotFound() {
        Mockito.when((Object)((Task)this.mockQuery.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"anId").body("{}").contentType(ContentType.JSON).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"No matching task with id anId"), new Object[0]).when().put(SINGLE_TASK_URL, new Object[0]);
    }

    @Test
    public void testPutUpdateTaskDelegationStateResolved() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("delegationState", "RESOLVED");
        RestAssured.given().pathParam("id", (Object)"anId").body(json).contentType(ContentType.JSON).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_TASK_URL, new Object[0]);
        ((Task)Mockito.verify((Object)this.mockTask)).setDelegationState(DelegationState.valueOf((String)((String)json.get("delegationState"))));
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).saveTask(this.mockTask);
    }

    @Test
    public void testPutUpdateTaskDelegationStatePending() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("delegationState", "PENDING");
        Task newTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)this.taskServiceMock.newTask(ArgumentMatchers.anyString())).thenReturn((Object)newTask);
        RestAssured.given().pathParam("id", (Object)"anId").body(json).contentType(ContentType.JSON).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_TASK_URL, new Object[0]);
        ((Task)Mockito.verify((Object)this.mockTask)).setDelegationState(DelegationState.valueOf((String)((String)json.get("delegationState"))));
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).saveTask(this.mockTask);
    }

    @Test
    public void testPutUpdateTaskUnsupportedDelegationState() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("delegationState", "unsupported");
        Task newTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)this.taskServiceMock.newTask(ArgumentMatchers.anyString())).thenReturn((Object)newTask);
        RestAssured.given().pathParam("id", (Object)"anId").body(json).contentType(ContentType.JSON).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Valid values for property 'delegationState' are 'PENDING' or 'RESOLVED', but was 'unsupported'"), new Object[0]).when().put(SINGLE_TASK_URL, new Object[0]);
    }

    @Test
    public void testPutUpdateTaskLowercaseDelegationState() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("delegationState", "pending");
        Task newTask = (Task)Mockito.mock(Task.class);
        Mockito.when((Object)this.taskServiceMock.newTask(ArgumentMatchers.anyString())).thenReturn((Object)newTask);
        RestAssured.given().pathParam("id", (Object)"anId").body(json).contentType(ContentType.JSON).header("accept", (Object)"application/json", new Object[0]).expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().put(SINGLE_TASK_URL, new Object[0]);
        ((Task)Mockito.verify((Object)this.mockTask)).setDelegationState(DelegationState.PENDING);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).saveTask(this.mockTask);
    }

    @Test
    public void testPutUpdateTaskThrowsAuthorizationException() {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("delegationState", "pending");
        String message = "expected exception";
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException(message)}).when((Object)this.taskServiceMock)).saveTask((Task)ArgumentMatchers.any(Task.class));
        RestAssured.given().pathParam("id", (Object)"anId").contentType(ContentType.JSON).body(json).then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().put(SINGLE_TASK_URL, new Object[0]);
    }

    @Test
    public void testGetDeployedTaskForm() {
        ByteArrayInputStream deployedFormMock = new ByteArrayInputStream("Test".getBytes());
        Mockito.when((Object)this.formServiceMock.getDeployedTaskForm(ArgumentMatchers.anyString())).thenReturn((Object)deployedFormMock);
        RestAssured.given().pathParam("id", (Object)"anId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body(Matchers.equalTo((Object)"Test"), new Matcher[0]).contentType("application/xhtml+xml").when().get(DEPLOYED_TASK_FORM_URL, new Object[0]);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).getDeployedTaskForm("anId");
    }

    @Test
    public void testGetDeployedTaskFormJson() {
        ByteArrayInputStream deployedFormMock = new ByteArrayInputStream("Test".getBytes());
        Mockito.when((Object)this.formServiceMock.getDeployedTaskForm(ArgumentMatchers.anyString())).thenReturn((Object)deployedFormMock);
        Mockito.when((Object)this.mockTask.getFormKey()).thenReturn((Object)"test.form");
        RestAssured.given().pathParam("id", (Object)"anId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body(Matchers.equalTo((Object)"Test"), new Matcher[0]).contentType("application/json").when().get(DEPLOYED_TASK_FORM_URL, new Object[0]);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).getDeployedTaskForm("anId");
    }

    @Test
    public void testGetDeployedTaskFormJsonUsingFormRef() {
        ByteArrayInputStream deployedFormMock = new ByteArrayInputStream("{\"id\":\"myForm\"}".getBytes());
        Mockito.when((Object)this.formServiceMock.getDeployedTaskForm(ArgumentMatchers.anyString())).thenReturn((Object)deployedFormMock);
        Mockito.when((Object)this.mockTask.getFormKey()).thenReturn(null);
        Mockito.when((Object)this.mockTask.getCamundaFormRef()).thenReturn((Object)new CamundaFormRefImpl("myForm", "latest"));
        RestAssured.given().pathParam("id", (Object)"anId").then().expect().statusCode(Response.Status.OK.getStatusCode()).body(Matchers.equalTo((Object)"{\"id\":\"myForm\"}"), new Matcher[0]).contentType("application/json").when().get(DEPLOYED_TASK_FORM_URL, new Object[0]);
        ((FormService)Mockito.verify((Object)this.formServiceMock)).getDeployedTaskForm("anId");
    }

    @Test
    public void testGetDeployedTaskFormWithoutAuthorization() {
        String message = "unauthorized";
        Mockito.when((Object)this.formServiceMock.getDeployedTaskForm(ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new AuthorizationException(message)});
        RestAssured.given().pathParam("id", (Object)"anId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("message", Matchers.equalTo((Object)message), new Object[0]).when().get(DEPLOYED_TASK_FORM_URL, new Object[0]);
    }

    @Test
    public void testGetDeployedTaskFormWithWrongFormKey() {
        String message = "wrong key format";
        Mockito.when((Object)this.formServiceMock.getDeployedTaskForm(ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new BadUserRequestException(message)});
        RestAssured.given().pathParam("id", (Object)"anId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", Matchers.equalTo((Object)message), new Object[0]).when().get(DEPLOYED_TASK_FORM_URL, new Object[0]);
    }

    @Test
    public void testGetDeployedTaskFormWithUnexistingForm() {
        String message = "not found";
        Mockito.when((Object)this.formServiceMock.getDeployedTaskForm(ArgumentMatchers.anyString())).thenThrow(new Throwable[]{new NotFoundException(message)});
        RestAssured.given().pathParam("id", (Object)"anId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("message", Matchers.equalTo((Object)message), new Object[0]).when().get(DEPLOYED_TASK_FORM_URL, new Object[0]);
    }

    @Test
    public void testGetDeployedTaskFormWithUnexistingTask() {
        ByteArrayInputStream deployedFormMock = new ByteArrayInputStream("Test".getBytes());
        Mockito.when((Object)this.formServiceMock.getDeployedTaskForm(ArgumentMatchers.anyString())).thenReturn((Object)deployedFormMock);
        Mockito.when((Object)((Task)this.mockQuery.singleResult())).thenReturn(null);
        RestAssured.given().pathParam("id", (Object)"anId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("message", Matchers.containsString((String)"No task found for taskId"), new Object[0]).when().get(DEPLOYED_TASK_FORM_URL, new Object[0]);
    }

    @Test
    public void testHandleBpmnError() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("errorCode", "anErrorCode");
        parameters.put("errorMessage", "anErrorMessage");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"aTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(HANDLE_BPMN_ERROR_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).handleBpmnError("aTaskId", "anErrorCode", "anErrorMessage", null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.taskServiceMock});
    }

    @Test
    public void testHandleBpmnErrorWithVariables() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("errorCode", "anErrorCode");
        Map<String, Object> variables = VariablesBuilder.create().variable("var1", "val1").variable("var2", (Object)"val2", "String").variable("var3", ValueType.OBJECT.getName(), "val3", "aFormat", "aRootType").getVariables();
        parameters.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"aTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(HANDLE_BPMN_ERROR_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).handleBpmnError((String)ArgumentMatchers.eq((Object)"aTaskId"), (String)ArgumentMatchers.eq((Object)"anErrorCode"), (String)ArgumentMatchers.isNull(), (Map)MockitoHamcrest.argThat((Matcher)EqualsVariableMap.matches().matcher("var1", (Matcher<?>)EqualsUntypedValue.matcher().value("val1")).matcher("var2", (Matcher<?>)EqualsPrimitiveValue.stringValue("val2")).matcher("var3", (Matcher<?>)((EqualsObjectValue)((Object)EqualsObjectValue.objectValueMatcher().type((ValueType)ValueType.OBJECT))).serializedValue("val3").serializationFormat("aFormat").objectTypeName("aRootType"))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.taskServiceMock});
    }

    @Test
    public void testHandleBpmnErrorNonExistingTask() {
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new NotFoundException()}).when((Object)this.taskServiceMock)).handleBpmnError((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("errorCode", "anErrorCode");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"aTaskId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).when().post(HANDLE_BPMN_ERROR_URL, new Object[0]);
    }

    @Test
    public void testHandleBpmnErrorNoErrorCode() {
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException()}).when((Object)this.taskServiceMock)).handleBpmnError((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("errorCode", "");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"aTaskId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).when().post(HANDLE_BPMN_ERROR_URL, new Object[0]);
    }

    @Test
    public void testHandleBpmnErrorThrowsAuthorizationException() {
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException("aMessage")}).when((Object)this.taskServiceMock)).handleBpmnError((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("errorCode", "errorCode");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"aTaskId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"aMessage"), new Object[0]).when().post(HANDLE_BPMN_ERROR_URL, new Object[0]);
    }

    @Test
    public void testHandleBpmnErrorThrowsBadUserRequestException() {
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("aMessage")}).when((Object)this.taskServiceMock)).handleBpmnError((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("errorCode", "errorCode");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"aTaskId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"aMessage"), new Object[0]).when().post(HANDLE_BPMN_ERROR_URL, new Object[0]);
    }

    @Test
    public void testHandleBpmnEscalation() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("escalationCode", "anEscalationCode");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"aTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(HANDLE_BPMN_ESCALATION_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).handleEscalation("aTaskId", "anEscalationCode", null);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.taskServiceMock});
    }

    @Test
    public void testHandleBpmnEscalationWithVariables() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("escalationCode", "anEscalationCode");
        Map<String, Object> variables = VariablesBuilder.create().variable("var1", "val1").variable("var2", (Object)"val2", "String").variable("var3", ValueType.OBJECT.getName(), "val3", "aFormat", "aRootType").getVariables();
        parameters.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"aTaskId").then().expect().statusCode(Response.Status.NO_CONTENT.getStatusCode()).when().post(HANDLE_BPMN_ESCALATION_URL, new Object[0]);
        ((TaskService)Mockito.verify((Object)this.taskServiceMock)).handleEscalation((String)ArgumentMatchers.eq((Object)"aTaskId"), (String)ArgumentMatchers.eq((Object)"anEscalationCode"), (Map)MockitoHamcrest.argThat((Matcher)EqualsVariableMap.matches().matcher("var1", (Matcher<?>)EqualsUntypedValue.matcher().value("val1")).matcher("var2", (Matcher<?>)EqualsPrimitiveValue.stringValue("val2")).matcher("var3", (Matcher<?>)((EqualsObjectValue)((Object)EqualsObjectValue.objectValueMatcher().type((ValueType)ValueType.OBJECT))).serializedValue("val3").serializationFormat("aFormat").objectTypeName("aRootType"))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.taskServiceMock});
    }

    @Test
    public void testHandleBpmnEscalationNonExistingTask() {
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new NotFoundException("Task with id aTaskId does not exist")}).when((Object)this.taskServiceMock)).handleEscalation((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("escalationCode", "anEscalationCode");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"aTaskId").then().expect().statusCode(Response.Status.NOT_FOUND.getStatusCode()).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"Task with id aTaskId does not exist"), new Object[0]).when().post(HANDLE_BPMN_ESCALATION_URL, new Object[0]);
    }

    @Test
    public void testHandleBpmnEscalationThrowsAuthorizationException() {
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new AuthorizationException("aMessage")}).when((Object)this.taskServiceMock)).handleEscalation((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("escalationCode", "escalationCode");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"aTaskId").then().expect().statusCode(Response.Status.FORBIDDEN.getStatusCode()).body("type", Matchers.equalTo((Object)AuthorizationException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"aMessage"), new Object[0]).when().post(HANDLE_BPMN_ESCALATION_URL, new Object[0]);
    }

    @Test
    public void testHandleBpmnEscalationThrowsBadUserRequestException() {
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("aMessage")}).when((Object)this.taskServiceMock)).handleEscalation((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("escalationCode", "escalationCode");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"aTaskId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"aMessage"), new Object[0]).when().post(HANDLE_BPMN_ESCALATION_URL, new Object[0]);
    }

    @Test
    public void testHandleBpmnEscalationMissingEscalationCode() {
        ((TaskService)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException("aMessage")}).when((Object)this.taskServiceMock)).handleEscalation((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        HashMap parameters = new HashMap();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).pathParam("id", (Object)"aTaskId").then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).body("type", Matchers.equalTo((Object)RestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)"aMessage"), new Object[0]).when().post(HANDLE_BPMN_ESCALATION_URL, new Object[0]);
    }

    private void verifyTaskComments(List<Comment> mockTaskComments, Response response) {
        List list = (List)response.as(List.class);
        Assert.assertEquals((long)1L, (long)list.size());
        LinkedHashMap resourceHashMap = (LinkedHashMap)list.get(0);
        String returnedId = (String)resourceHashMap.get("id");
        String returnedUserId = (String)resourceHashMap.get("userId");
        String returnedTaskId = (String)resourceHashMap.get("taskId");
        Date returnedTime = DateTimeUtil.parseDate((String)((String)resourceHashMap.get("time")));
        String returnedFullMessage = (String)resourceHashMap.get("message");
        Comment mockComment = mockTaskComments.get(0);
        Assert.assertEquals((Object)mockComment.getId(), (Object)returnedId);
        Assert.assertEquals((Object)mockComment.getTaskId(), (Object)returnedTaskId);
        Assert.assertEquals((Object)mockComment.getUserId(), (Object)returnedUserId);
        Assert.assertEquals((Object)mockComment.getTime(), (Object)returnedTime);
        Assert.assertEquals((Object)mockComment.getFullMessage(), (Object)returnedFullMessage);
    }

    private void verifyCreatedTaskComment(Comment mockTaskComment, Response response) {
        String content = response.asString();
        this.verifyTaskCommentValues(mockTaskComment, content);
        this.verifyTaskCommentLink(mockTaskComment, content);
    }

    private void verifyTaskCommentValues(Comment mockTaskComment, String responseContent) {
        JsonPath path = JsonPath.from((String)responseContent);
        String returnedId = (String)path.get("id");
        String returnedUserId = (String)path.get("userId");
        String returnedTaskId = (String)path.get("taskId");
        String returnedProcessInstanceId = (String)path.get("processInstanceId");
        Date returnedTime = DateTimeUtil.parseDate((String)((String)path.get("time")));
        String returnedFullMessage = (String)path.get("message");
        Assert.assertEquals((Object)mockTaskComment.getId(), (Object)returnedId);
        Assert.assertEquals((Object)mockTaskComment.getTaskId(), (Object)returnedTaskId);
        Assert.assertEquals((Object)mockTaskComment.getProcessInstanceId(), (Object)returnedProcessInstanceId);
        Assert.assertEquals((Object)mockTaskComment.getUserId(), (Object)returnedUserId);
        Assert.assertEquals((Object)mockTaskComment.getTime(), (Object)returnedTime);
        Assert.assertEquals((Object)mockTaskComment.getFullMessage(), (Object)returnedFullMessage);
    }

    private void verifyTaskCommentLink(Comment mockTaskComment, String responseContent) {
        List returnedLinks = JsonPath.from((String)responseContent).getList("links");
        Assert.assertEquals((long)1L, (long)returnedLinks.size());
        Map returnedLink = (Map)returnedLinks.get(0);
        Assert.assertEquals((Object)"GET", returnedLink.get("method"));
        Assert.assertTrue((boolean)((String)returnedLink.get("href")).endsWith(SINGLE_TASK_COMMENTS_URL.replace("{id}", mockTaskComment.getTaskId()) + "/" + mockTaskComment.getId()));
        Assert.assertEquals((Object)"self", returnedLink.get("rel"));
    }

    private void verifyTaskAttachments(List<Attachment> mockTaskAttachments, Response response) {
        List list = (List)response.as(List.class);
        Assert.assertEquals((long)1L, (long)list.size());
        LinkedHashMap resourceHashMap = (LinkedHashMap)list.get(0);
        String returnedId = (String)resourceHashMap.get("id");
        String returnedTaskId = (String)resourceHashMap.get("taskId");
        String returnedName = (String)resourceHashMap.get("name");
        String returnedType = (String)resourceHashMap.get("type");
        String returnedDescription = (String)resourceHashMap.get("description");
        String returnedUrl = (String)resourceHashMap.get("url");
        Attachment mockAttachment = mockTaskAttachments.get(0);
        Assert.assertEquals((Object)mockAttachment.getId(), (Object)returnedId);
        Assert.assertEquals((Object)mockAttachment.getTaskId(), (Object)returnedTaskId);
        Assert.assertEquals((Object)mockAttachment.getName(), (Object)returnedName);
        Assert.assertEquals((Object)mockAttachment.getType(), (Object)returnedType);
        Assert.assertEquals((Object)mockAttachment.getDescription(), (Object)returnedDescription);
        Assert.assertEquals((Object)mockAttachment.getUrl(), (Object)returnedUrl);
    }

    private void verifyCreatedTaskAttachment(Attachment mockTaskAttachment, Response response, boolean urlExist) {
        String content = response.asString();
        this.verifyTaskAttachmentValues(mockTaskAttachment, content, urlExist);
        this.verifyTaskAttachmentLink(mockTaskAttachment, content);
    }

    private void verifyTaskAttachmentValues(Attachment mockTaskAttachment, String responseContent, boolean urlExist) {
        JsonPath path = JsonPath.from((String)responseContent);
        String returnedId = (String)path.get("id");
        String returnedTaskId = (String)path.get("taskId");
        String returnedName = (String)path.get("name");
        String returnedType = (String)path.get("type");
        String returnedDescription = (String)path.get("description");
        String returnedUrl = (String)path.get("url");
        Attachment mockAttachment = this.mockTaskAttachments.get(0);
        Assert.assertEquals((Object)mockAttachment.getId(), (Object)returnedId);
        Assert.assertEquals((Object)mockAttachment.getTaskId(), (Object)returnedTaskId);
        Assert.assertEquals((Object)mockAttachment.getName(), (Object)returnedName);
        Assert.assertEquals((Object)mockAttachment.getType(), (Object)returnedType);
        Assert.assertEquals((Object)mockAttachment.getDescription(), (Object)returnedDescription);
        if (urlExist) {
            Assert.assertEquals((Object)mockAttachment.getUrl(), (Object)returnedUrl);
        }
    }

    private void verifyTaskAttachmentLink(Attachment mockTaskAttachment, String responseContent) {
        List returnedLinks = JsonPath.from((String)responseContent).getList("links");
        Assert.assertEquals((long)1L, (long)returnedLinks.size());
        Map returnedLink = (Map)returnedLinks.get(0);
        Assert.assertEquals((Object)"GET", returnedLink.get("method"));
        Assert.assertTrue((boolean)((String)returnedLink.get("href")).endsWith(SINGLE_TASK_ATTACHMENTS_URL.replace("{id}", mockTaskAttachment.getTaskId()) + "/" + mockTaskAttachment.getId()));
        Assert.assertEquals((Object)"self", returnedLink.get("rel"));
    }
}

