/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.impl.digest._apacheCommonsCodec.Base64;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.dto.VariableValueDto;
import org.camunda.bpm.engine.rest.dto.converter.StringArrayConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.bpm.engine.variable.value.BytesValue;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.camunda.bpm.engine.variable.value.StringValue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class HistoricDecisionInstanceRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_DECISION_INSTANCE_RESOURCE_URL = "/rest-test/history/decision-instance";
    protected static final String HISTORIC_DECISION_INSTANCE_COUNT_RESOURCE_URL = "/rest-test/history/decision-instance/count";
    protected HistoricDecisionInstanceQuery mockedQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedQuery = this.setUpMockHistoricDecisionInstanceQuery(MockProvider.createMockHistoricDecisionInstances());
    }

    protected HistoricDecisionInstanceQuery setUpMockHistoricDecisionInstanceQuery(List<HistoricDecisionInstance> mockedHistoricDecisionInstances) {
        HistoricDecisionInstanceQuery mockedHistoricDecisionInstanceQuery = (HistoricDecisionInstanceQuery)Mockito.mock(HistoricDecisionInstanceQuery.class);
        Mockito.when((Object)mockedHistoricDecisionInstanceQuery.list()).thenReturn(mockedHistoricDecisionInstances);
        Mockito.when((Object)mockedHistoricDecisionInstanceQuery.count()).thenReturn((Object)mockedHistoricDecisionInstances.size());
        Mockito.when((Object)processEngine.getHistoryService().createHistoricDecisionInstanceQuery()).thenReturn((Object)mockedHistoricDecisionInstanceQuery);
        return mockedHistoricDecisionInstanceQuery;
    }

    @Test
    public void testEmptyQuery() {
        String queryKey = "";
        RestAssured.given().queryParam("caseDefinitionKey", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("definitionId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"evaluationTime"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("evaluationTime", "asc", Response.Status.OK);
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByEvaluationTime();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("evaluationTime", "desc", Response.Status.OK);
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByEvaluationTime();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(HISTORIC_DECISION_INSTANCE_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testSimpleHistoricDecisionInstanceQuery() {
        String decisionDefinitionId = "aDecisionDefinitionId";
        Response response = (Response)RestAssured.given().queryParam("decisionDefinitionId", new Object[]{decisionDefinitionId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).decisionDefinitionId(decisionDefinitionId);
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertNotNull(instances.get(0));
        String returnedHistoricDecisionInstanceId = JsonPath.from((String)content).getString("[0].id");
        String returnedDecisionDefinitionId = JsonPath.from((String)content).getString("[0].decisionDefinitionId");
        String returnedDecisionDefinitionKey = JsonPath.from((String)content).getString("[0].decisionDefinitionKey");
        String returnedDecisionDefinitionName = JsonPath.from((String)content).getString("[0].decisionDefinitionName");
        String returnedEvaluationTime = JsonPath.from((String)content).getString("[0].evaluationTime");
        String returnedRemovalTime = JsonPath.from((String)content).getString("[0].removalTime");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedProcessDefinitionKey = JsonPath.from((String)content).getString("[0].processDefinitionKey");
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("[0].processInstanceId");
        String returnedCaseDefinitionId = JsonPath.from((String)content).getString("[0].caseDefinitionId");
        String returnedCaseDefinitionKey = JsonPath.from((String)content).getString("[0].caseDefinitionKey");
        String returnedCaseInstanceId = JsonPath.from((String)content).getString("[0].caseInstanceId");
        String returnedActivityId = JsonPath.from((String)content).getString("[0].activityId");
        String returnedActivityInstanceId = JsonPath.from((String)content).getString("[0].activityInstanceId");
        List returnedInputs = JsonPath.from((String)content).getList("[0].inputs");
        List returnedOutputs = JsonPath.from((String)content).getList("[0].outputs");
        Double returnedCollectResultValue = JsonPath.from((String)content).getDouble("[0].collectResultValue");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedRootDecisionInstanceId = JsonPath.from((String)content).getString("[0].rootDecisionInstanceId");
        String returnedRootProcessInstanceId = JsonPath.from((String)content).getString("[0].rootProcessInstanceId");
        String returnedDecisionRequirementsDefinitionId = JsonPath.from((String)content).getString("[0].decisionRequirementsDefinitionId");
        String returnedDecisionRequirementsDefinitionKey = JsonPath.from((String)content).getString("[0].decisionRequirementsDefinitionKey");
        MatcherAssert.assertThat((Object)returnedHistoricDecisionInstanceId, (Matcher)Matchers.is((Object)"aHistoricDecisionInstanceId"));
        MatcherAssert.assertThat((Object)returnedDecisionDefinitionId, (Matcher)Matchers.is((Object)"aDecisionDefinitionId"));
        MatcherAssert.assertThat((Object)returnedDecisionDefinitionKey, (Matcher)Matchers.is((Object)"aDecisionDefinitionKey"));
        MatcherAssert.assertThat((Object)returnedDecisionDefinitionName, (Matcher)Matchers.is((Object)"aDecisionDefinitionName"));
        MatcherAssert.assertThat((Object)returnedEvaluationTime, (Matcher)Matchers.is((Object)MockProvider.EXAMPLE_HISTORIC_DECISION_INSTANCE_EVALUATION_TIME));
        MatcherAssert.assertThat((Object)returnedRemovalTime, (Matcher)Matchers.is((Object)MockProvider.EXAMPLE_HISTORIC_DECISION_INSTANCE_REMOVAL_TIME));
        MatcherAssert.assertThat((Object)returnedProcessDefinitionId, (Matcher)Matchers.is((Object)"aProcDefId"));
        MatcherAssert.assertThat((Object)returnedProcessDefinitionKey, (Matcher)Matchers.is((Object)"aKey"));
        MatcherAssert.assertThat((Object)returnedProcessInstanceId, (Matcher)Matchers.is((Object)"aProcInstId"));
        MatcherAssert.assertThat((Object)returnedCaseDefinitionId, (Matcher)Matchers.is((Object)"aCaseDefnitionId"));
        MatcherAssert.assertThat((Object)returnedCaseDefinitionKey, (Matcher)Matchers.is((Object)"aCaseDefinitionKey"));
        MatcherAssert.assertThat((Object)returnedCaseInstanceId, (Matcher)Matchers.is((Object)"aCaseInstId"));
        MatcherAssert.assertThat((Object)returnedActivityId, (Matcher)Matchers.is((Object)"aHistoricDecisionInstanceActivityId"));
        MatcherAssert.assertThat((Object)returnedActivityInstanceId, (Matcher)Matchers.is((Object)"aHistoricDecisionInstanceActivityInstanceId"));
        MatcherAssert.assertThat((Object)returnedInputs, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)returnedOutputs, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)returnedCollectResultValue, (Matcher)Matchers.is((Object)MockProvider.EXAMPLE_HISTORIC_DECISION_INSTANCE_COLLECT_RESULT_VALUE));
        MatcherAssert.assertThat((Object)returnedTenantId, (Matcher)Matchers.is((Object)"aTenantId"));
        MatcherAssert.assertThat((Object)returnedRootDecisionInstanceId, (Matcher)Matchers.is((Object)"aHistoricDecisionInstanceId"));
        MatcherAssert.assertThat((Object)returnedRootProcessInstanceId, (Matcher)Matchers.is((Object)"aRootProcInstId"));
        MatcherAssert.assertThat((Object)returnedDecisionRequirementsDefinitionId, (Matcher)Matchers.is((Object)"aDecisionRequirementsDefinitionId"));
        MatcherAssert.assertThat((Object)returnedDecisionRequirementsDefinitionKey, (Matcher)Matchers.is((Object)"aDecisionRequirementsDefinitionKey"));
    }

    @Test
    public void testAdditionalParameters() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        RestAssured.given().queryParams(stringQueryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStringParameterQueryInvocations();
    }

    @Test
    public void testIncludeInputs() {
        this.mockedQuery = this.setUpMockHistoricDecisionInstanceQuery(Collections.singletonList(MockProvider.createMockHistoricDecisionInstanceWithInputs()));
        String decisionDefinitionId = "aDecisionDefinitionId";
        Response response = (Response)RestAssured.given().queryParam("decisionDefinitionId", new Object[]{decisionDefinitionId}).queryParam("includeInputs", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).decisionDefinitionId(decisionDefinitionId);
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).includeInputs();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery, Mockito.never())).includeOutputs();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertNotNull(instances.get(0));
        List returnedInputs = JsonPath.from((String)content).getList("[0].inputs");
        List returnedOutputs = JsonPath.from((String)content).getList("[0].outputs");
        MatcherAssert.assertThat((Object)returnedInputs, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)returnedOutputs, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        this.verifyHistoricDecisionInputInstances(returnedInputs);
    }

    @Test
    public void testIncludeOutputs() {
        this.mockedQuery = this.setUpMockHistoricDecisionInstanceQuery(Collections.singletonList(MockProvider.createMockHistoricDecisionInstanceWithOutputs()));
        String decisionDefinitionId = "aDecisionDefinitionId";
        Response response = (Response)RestAssured.given().queryParam("decisionDefinitionId", new Object[]{decisionDefinitionId}).queryParam("includeOutputs", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).decisionDefinitionId(decisionDefinitionId);
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery, Mockito.never())).includeInputs();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).includeOutputs();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertNotNull(instances.get(0));
        List returnedInputs = JsonPath.from((String)content).getList("[0].inputs");
        List returnedOutputs = JsonPath.from((String)content).getList("[0].outputs");
        MatcherAssert.assertThat((Object)returnedInputs, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)returnedOutputs, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.verifyHistoricDecisionOutputInstances(returnedOutputs);
    }

    @Test
    public void testIncludeInputsAndOutputs() {
        this.mockedQuery = this.setUpMockHistoricDecisionInstanceQuery(Collections.singletonList(MockProvider.createMockHistoricDecisionInstanceWithInputsAndOutputs()));
        String decisionDefinitionId = "aDecisionDefinitionId";
        Response response = (Response)RestAssured.given().queryParam("decisionDefinitionId", new Object[]{decisionDefinitionId}).queryParam("includeInputs", new Object[]{true}).queryParam("includeOutputs", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).decisionDefinitionId(decisionDefinitionId);
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).includeInputs();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).includeOutputs();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertNotNull(instances.get(0));
        List returnedInputs = JsonPath.from((String)content).getList("[0].inputs");
        List returnedOutputs = JsonPath.from((String)content).getList("[0].outputs");
        MatcherAssert.assertThat((Object)returnedInputs, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)returnedOutputs, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        this.verifyHistoricDecisionInputInstances(returnedInputs);
        this.verifyHistoricDecisionOutputInstances(returnedOutputs);
    }

    @Test
    public void testDefaultBinaryFetching() {
        String decisionDefinitionId = "aDecisionDefinitionId";
        RestAssured.given().queryParam("decisionDefinitionId", new Object[]{decisionDefinitionId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).decisionDefinitionId(decisionDefinitionId);
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery, Mockito.never())).disableBinaryFetching();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testDisableBinaryFetching() {
        String decisionDefinitionId = "aDecisionDefinitionId";
        RestAssured.given().queryParam("decisionDefinitionId", new Object[]{decisionDefinitionId}).queryParam("disableBinaryFetching", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).decisionDefinitionId(decisionDefinitionId);
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).disableBinaryFetching();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testDefaultCustomObjectDeserialization() {
        String decisionDefinitionId = "aDecisionDefinitionId";
        RestAssured.given().queryParam("decisionDefinitionId", new Object[]{decisionDefinitionId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).decisionDefinitionId(decisionDefinitionId);
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery, Mockito.never())).disableCustomObjectDeserialization();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testDisableCustomObjectDeserialization() {
        String decisionDefinitionId = "aDecisionDefinitionId";
        RestAssured.given().queryParam("decisionDefinitionId", new Object[]{decisionDefinitionId}).queryParam("disableCustomObjectDeserialization", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).decisionDefinitionId(decisionDefinitionId);
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).disableCustomObjectDeserialization();
        ((HistoricDecisionInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testRootDecisionInstancesOnly() {
        RestAssured.given().queryParam("rootDecisionInstancesOnly", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).rootDecisionInstancesOnly();
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testTenantIdListParameter() {
        this.mockedQuery = this.setUpMockHistoricDecisionInstanceQuery(this.createMockHistoricDecisionInstancesTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List historicDecisionInstances = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)historicDecisionInstances).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testWithoutTenantIdQueryParameter() {
        this.mockedQuery = this.setUpMockHistoricDecisionInstanceQuery(Collections.singletonList(MockProvider.createMockHistoricDecisionInstanceBase(null)));
        Response response = (Response)RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
    }

    private List<HistoricDecisionInstance> createMockHistoricDecisionInstancesTwoTenants() {
        return Arrays.asList(MockProvider.createMockHistoricDecisionInstanceBase("aTenantId"), MockProvider.createMockHistoricDecisionInstanceBase("anotherTenantId"));
    }

    protected Map<String, String> getCompleteStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("decisionInstanceId", "aHistoricDecisionInstanceId");
        parameters.put("decisionInstanceIdIn", "aHistoricDecisionInstanceId,anotherHistoricDecisionInstanceId");
        parameters.put("decisionDefinitionId", "aDecisionDefinitionId");
        parameters.put("decisionDefinitionIdIn", "aDecisionDefinitionId,anotherDecisionDefinitionId");
        parameters.put("decisionDefinitionKey", "aDecisionDefinitionKey");
        parameters.put("decisionDefinitionKeyIn", "aDecisionDefinitionKey,anotherDecisionDefinitionKey");
        parameters.put("decisionDefinitionName", "aDecisionDefinitionName");
        parameters.put("decisionDefinitionNameLike", "aDecisionDefinitionNameLike");
        parameters.put("processDefinitionId", "aProcDefId");
        parameters.put("processDefinitionKey", "aKey");
        parameters.put("processInstanceId", "aProcInstId");
        parameters.put("caseDefinitionId", "aCaseDefnitionId");
        parameters.put("caseDefinitionKey", "aCaseDefinitionKey");
        parameters.put("caseInstanceId", "aCaseInstId");
        parameters.put("activityIdIn", "aHistoricDecisionInstanceActivityId,anotherHistoricDecisionInstanceActivityId");
        parameters.put("activityInstanceIdIn", "aHistoricDecisionInstanceActivityInstanceId,anotherHistoricDecisionInstanceActivityInstanceId");
        parameters.put("evaluatedBefore", MockProvider.EXAMPLE_HISTORIC_DECISION_INSTANCE_EVALUATED_BEFORE);
        parameters.put("evaluatedAfter", MockProvider.EXAMPLE_HISTORIC_DECISION_INSTANCE_EVALUATED_AFTER);
        parameters.put("userId", "aUserId");
        parameters.put("rootDecisionInstanceId", "aHistoricDecisionInstanceId");
        parameters.put("decisionRequirementsDefinitionId", "aDecisionRequirementsDefinitionId");
        parameters.put("decisionRequirementsDefinitionKey", "aDecisionRequirementsDefinitionKey");
        return parameters;
    }

    protected void verifyStringParameterQueryInvocations() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        StringArrayConverter stringArrayConverter = new StringArrayConverter();
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).decisionInstanceId(stringQueryParameters.get("decisionInstanceId"));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).decisionInstanceIdIn(stringArrayConverter.convertQueryParameterToType(stringQueryParameters.get("decisionInstanceIdIn")));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).decisionDefinitionId(stringQueryParameters.get("decisionDefinitionId"));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).decisionDefinitionIdIn(stringArrayConverter.convertQueryParameterToType(stringQueryParameters.get("decisionDefinitionIdIn")));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).decisionDefinitionKey(stringQueryParameters.get("decisionDefinitionKey"));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).decisionDefinitionKeyIn(stringArrayConverter.convertQueryParameterToType(stringQueryParameters.get("decisionDefinitionKeyIn")));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).decisionDefinitionName(stringQueryParameters.get("decisionDefinitionName"));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).decisionDefinitionNameLike(stringQueryParameters.get("decisionDefinitionNameLike"));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId(stringQueryParameters.get("processDefinitionId"));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKey(stringQueryParameters.get("processDefinitionKey"));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceId(stringQueryParameters.get("processInstanceId"));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionId(stringQueryParameters.get("caseDefinitionId"));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionKey(stringQueryParameters.get("caseDefinitionKey"));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceId(stringQueryParameters.get("caseInstanceId"));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityIdIn(stringArrayConverter.convertQueryParameterToType(stringQueryParameters.get("activityIdIn")));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityInstanceIdIn(stringArrayConverter.convertQueryParameterToType(stringQueryParameters.get("activityInstanceIdIn")));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).evaluatedBefore(DateTimeUtil.parseDate((String)stringQueryParameters.get("evaluatedBefore")));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).evaluatedAfter(DateTimeUtil.parseDate((String)stringQueryParameters.get("evaluatedAfter")));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).userId(stringQueryParameters.get("userId"));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).rootDecisionInstanceId(stringQueryParameters.get("rootDecisionInstanceId"));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).decisionRequirementsDefinitionId(stringQueryParameters.get("decisionRequirementsDefinitionId"));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).decisionRequirementsDefinitionKey(stringQueryParameters.get("decisionRequirementsDefinitionKey"));
        ((HistoricDecisionInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(HISTORIC_DECISION_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    protected void verifyHistoricDecisionInputInstances(List<Map<String, Object>> returnedInputs) {
        MatcherAssert.assertThat(returnedInputs, (Matcher)Matchers.hasSize((int)3));
        for (Map<String, Object> returnedInput : returnedInputs) {
            MatcherAssert.assertThat(returnedInput, (Matcher)Matchers.hasEntry((Object)"id", (Object)"aDecisionInputInstanceId"));
            MatcherAssert.assertThat(returnedInput, (Matcher)Matchers.hasEntry((Object)"decisionInstanceId", (Object)"aHistoricDecisionInstanceId"));
            MatcherAssert.assertThat(returnedInput, (Matcher)Matchers.hasEntry((Object)"clauseId", (Object)"aDecisionInputClauseId"));
            MatcherAssert.assertThat(returnedInput, (Matcher)Matchers.hasEntry((Object)"clauseName", (Object)"aDecisionInputClauseName"));
            MatcherAssert.assertThat(returnedInput, (Matcher)Matchers.hasEntry((Object)"errorMessage", null));
            MatcherAssert.assertThat(returnedInput, (Matcher)Matchers.hasEntry((Object)"createTime", (Object)MockProvider.EXAMPLE_HISTORIC_DECISION_INPUT_INSTANCE_CREATE_TIME));
            MatcherAssert.assertThat(returnedInput, (Matcher)Matchers.hasEntry((Object)"removalTime", (Object)MockProvider.EXAMPLE_HISTORIC_DECISION_INPUT_INSTANCE_REMOVAL_TIME));
            MatcherAssert.assertThat(returnedInput, (Matcher)Matchers.hasEntry((Object)"rootProcessInstanceId", (Object)"aRootProcInstId"));
        }
        this.verifyStringValue(returnedInputs.get(0));
        this.verifyByteArrayValue(returnedInputs.get(1));
        this.verifySerializedValue(returnedInputs.get(2));
    }

    protected void verifyHistoricDecisionOutputInstances(List<Map<String, Object>> returnedOutputs) {
        MatcherAssert.assertThat(returnedOutputs, (Matcher)Matchers.hasSize((int)3));
        for (Map<String, Object> returnedOutput : returnedOutputs) {
            MatcherAssert.assertThat(returnedOutput, (Matcher)Matchers.hasEntry((Object)"id", (Object)"aDecisionInputInstanceId"));
            MatcherAssert.assertThat(returnedOutput, (Matcher)Matchers.hasEntry((Object)"decisionInstanceId", (Object)"aHistoricDecisionInstanceId"));
            MatcherAssert.assertThat(returnedOutput, (Matcher)Matchers.hasEntry((Object)"clauseId", (Object)"aDecisionInputClauseId"));
            MatcherAssert.assertThat(returnedOutput, (Matcher)Matchers.hasEntry((Object)"clauseName", (Object)"aDecisionInputClauseName"));
            MatcherAssert.assertThat(returnedOutput, (Matcher)Matchers.hasEntry((Object)"ruleId", (Object)"aDecisionInputRuleId"));
            MatcherAssert.assertThat(returnedOutput, (Matcher)Matchers.hasEntry((Object)"ruleOrder", (Object)MockProvider.EXAMPLE_HISTORIC_DECISION_OUTPUT_INSTANCE_RULE_ORDER));
            MatcherAssert.assertThat(returnedOutput, (Matcher)Matchers.hasEntry((Object)"variableName", (Object)"aDecisionInputInstanceName"));
            MatcherAssert.assertThat(returnedOutput, (Matcher)Matchers.hasEntry((Object)"errorMessage", null));
            MatcherAssert.assertThat(returnedOutput, (Matcher)Matchers.hasEntry((Object)"createTime", (Object)MockProvider.EXAMPLE_HISTORIC_DECISION_OUTPUT_INSTANCE_CREATE_TIME));
            MatcherAssert.assertThat(returnedOutput, (Matcher)Matchers.hasEntry((Object)"removalTime", (Object)MockProvider.EXAMPLE_HISTORIC_DECISION_OUTPUT_INSTANCE_REMOVAL_TIME));
            MatcherAssert.assertThat(returnedOutput, (Matcher)Matchers.hasEntry((Object)"rootProcessInstanceId", (Object)"aRootProcInstId"));
        }
        this.verifyStringValue(returnedOutputs.get(0));
        this.verifyByteArrayValue(returnedOutputs.get(1));
        this.verifySerializedValue(returnedOutputs.get(2));
    }

    protected void verifyStringValue(Map<String, Object> stringValue) {
        StringValue exampleValue = MockProvider.EXAMPLE_HISTORIC_DECISION_STRING_VALUE;
        MatcherAssert.assertThat(stringValue, (Matcher)Matchers.hasEntry((Object)"type", (Object)VariableValueDto.toRestApiTypeName((String)exampleValue.getType().getName())));
        MatcherAssert.assertThat(stringValue, (Matcher)Matchers.hasEntry((Object)"value", (Object)exampleValue.getValue()));
        MatcherAssert.assertThat(stringValue, (Matcher)Matchers.hasEntry((Object)"valueInfo", Collections.emptyMap()));
    }

    protected void verifyByteArrayValue(Map<String, Object> byteArrayValue) {
        BytesValue exampleValue = MockProvider.EXAMPLE_HISTORIC_DECISION_BYTE_ARRAY_VALUE;
        MatcherAssert.assertThat(byteArrayValue, (Matcher)Matchers.hasEntry((Object)"type", (Object)VariableValueDto.toRestApiTypeName((String)exampleValue.getType().getName())));
        String byteString = Base64.encodeBase64String((byte[])((byte[])exampleValue.getValue())).trim();
        MatcherAssert.assertThat(byteArrayValue, (Matcher)Matchers.hasEntry((Object)"value", (Object)byteString));
        MatcherAssert.assertThat(byteArrayValue, (Matcher)Matchers.hasEntry((Object)"valueInfo", Collections.emptyMap()));
    }

    protected void verifySerializedValue(Map<String, Object> serializedValue) {
        ObjectValue exampleValue = MockProvider.EXAMPLE_HISTORIC_DECISION_SERIALIZED_VALUE;
        MatcherAssert.assertThat(serializedValue, (Matcher)Matchers.hasEntry((Object)"type", (Object)VariableValueDto.toRestApiTypeName((String)exampleValue.getType().getName())));
        MatcherAssert.assertThat(serializedValue, (Matcher)Matchers.hasEntry((Object)"value", (Object)exampleValue.getValue()));
        Map valueInfo = (Map)serializedValue.get("valueInfo");
        MatcherAssert.assertThat((Object)valueInfo, (Matcher)Matchers.hasEntry((Object)"serializationDataFormat", (Object)exampleValue.getSerializationDataFormat()));
        MatcherAssert.assertThat((Object)valueInfo, (Matcher)Matchers.hasEntry((Object)"objectTypeName", (Object)exampleValue.getObjectTypeName()));
    }
}

