/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.externaltask;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.converter.LongConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringSetConverter;

public class ExternalTaskQueryDto
extends AbstractQueryDto<ExternalTaskQuery> {
    public static final Map<String, Consumer<ExternalTaskQuery>> SORT_METHODS_BY_FIELD = Map.of("id", ExternalTaskQuery::orderById, "lockExpirationTime", ExternalTaskQuery::orderByLockExpirationTime, "processInstanceId", ExternalTaskQuery::orderByProcessInstanceId, "processDefinitionId", ExternalTaskQuery::orderByProcessDefinitionId, "processDefinitionKey", ExternalTaskQuery::orderByProcessDefinitionKey, "tenantId", ExternalTaskQuery::orderByTenantId, "taskPriority", ExternalTaskQuery::orderByPriority, "createTime", ExternalTaskQuery::orderByCreateTime);
    protected String externalTaskId;
    protected Set<String> externalTaskIds;
    protected String activityId;
    protected List<String> activityIdIn;
    protected Date lockExpirationBefore;
    protected Date lockExpirationAfter;
    protected String topicName;
    protected Boolean locked;
    protected Boolean notLocked;
    protected String executionId;
    protected String processInstanceId;
    protected List<String> processInstanceIdIn;
    protected String processDefinitionId;
    protected Boolean active;
    protected Boolean suspended;
    protected Boolean withRetriesLeft;
    protected Boolean noRetriesLeft;
    protected String workerId;
    protected List<String> tenantIds;
    protected Long priorityHigherThanOrEquals;
    protected Long priorityLowerThanOrEquals;

    public ExternalTaskQueryDto() {
    }

    public ExternalTaskQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="externalTaskId")
    public void setExternalTaskId(String externalTaskId) {
        this.externalTaskId = externalTaskId;
    }

    @CamundaQueryParam(value="externalTaskIdIn", converter=StringSetConverter.class)
    public void setExternalTaskIdIn(Set<String> externalTaskIds) {
        this.externalTaskIds = externalTaskIds;
    }

    @CamundaQueryParam(value="activityId")
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @CamundaQueryParam(value="activityIdIn", converter=StringListConverter.class)
    public void setActivityIdIn(List<String> activityIdIn) {
        this.activityIdIn = activityIdIn;
    }

    @CamundaQueryParam(value="lockExpirationBefore", converter=DateConverter.class)
    public void setLockExpirationBefore(Date lockExpirationBefore) {
        this.lockExpirationBefore = lockExpirationBefore;
    }

    @CamundaQueryParam(value="lockExpirationAfter", converter=DateConverter.class)
    public void setLockExpirationAfter(Date lockExpirationAfter) {
        this.lockExpirationAfter = lockExpirationAfter;
    }

    @CamundaQueryParam(value="topicName")
    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    @CamundaQueryParam(value="locked", converter=BooleanConverter.class)
    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    @CamundaQueryParam(value="notLocked", converter=BooleanConverter.class)
    public void setNotLocked(Boolean notLocked) {
        this.notLocked = notLocked;
    }

    @CamundaQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="processInstanceIdIn", converter=StringListConverter.class)
    public void setProcessInstanceIdIn(List<String> processInstanceIdIn) {
        this.processInstanceIdIn = processInstanceIdIn;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @CamundaQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    @CamundaQueryParam(value="withRetriesLeft", converter=BooleanConverter.class)
    public void setWithRetriesLeft(Boolean withRetriesLeft) {
        this.withRetriesLeft = withRetriesLeft;
    }

    @CamundaQueryParam(value="noRetriesLeft", converter=BooleanConverter.class)
    public void setNoRetriesLeft(Boolean noRetriesLeft) {
        this.noRetriesLeft = noRetriesLeft;
    }

    @CamundaQueryParam(value="workerId")
    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    @CamundaQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @CamundaQueryParam(value="priorityHigherThanOrEquals", converter=LongConverter.class)
    public void setPriorityHigherThanOrEquals(Long priorityHigherThanOrEquals) {
        this.priorityHigherThanOrEquals = priorityHigherThanOrEquals;
    }

    @CamundaQueryParam(value="priorityLowerThanOrEquals", converter=LongConverter.class)
    public void setPriorityLowerThanOrEquals(Long priorityLowerThanOrEquals) {
        this.priorityLowerThanOrEquals = priorityLowerThanOrEquals;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return SORT_METHODS_BY_FIELD.containsKey(value);
    }

    @Override
    protected ExternalTaskQuery createNewQuery(ProcessEngine engine) {
        return engine.getExternalTaskService().createExternalTaskQuery();
    }

    @Override
    protected void applyFilters(ExternalTaskQuery query) {
        if (this.externalTaskId != null) {
            query.externalTaskId(this.externalTaskId);
        }
        if (this.externalTaskIds != null && !this.externalTaskIds.isEmpty()) {
            query.externalTaskIdIn(this.externalTaskIds);
        }
        if (this.activityId != null) {
            query.activityId(this.activityId);
        }
        if (this.activityIdIn != null && !this.activityIdIn.isEmpty()) {
            query.activityIdIn(this.activityIdIn.toArray(new String[0]));
        }
        if (this.lockExpirationBefore != null) {
            query.lockExpirationBefore(this.lockExpirationBefore);
        }
        if (this.lockExpirationAfter != null) {
            query.lockExpirationAfter(this.lockExpirationAfter);
        }
        if (this.topicName != null) {
            query.topicName(this.topicName);
        }
        if (this.locked != null && this.locked.booleanValue()) {
            query.locked();
        }
        if (this.notLocked != null && this.notLocked.booleanValue()) {
            query.notLocked();
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.processInstanceIdIn != null && !this.processInstanceIdIn.isEmpty()) {
            query.processInstanceIdIn(this.processInstanceIdIn.toArray(new String[0]));
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.active != null && this.active.booleanValue()) {
            query.active();
        }
        if (this.suspended != null && this.suspended.booleanValue()) {
            query.suspended();
        }
        if (this.priorityHigherThanOrEquals != null) {
            query.priorityHigherThanOrEquals(this.priorityHigherThanOrEquals.longValue());
        }
        if (this.priorityLowerThanOrEquals != null) {
            query.priorityLowerThanOrEquals(this.priorityLowerThanOrEquals.longValue());
        }
        if (this.withRetriesLeft != null && this.withRetriesLeft.booleanValue()) {
            query.withRetriesLeft();
        }
        if (this.noRetriesLeft != null && this.noRetriesLeft.booleanValue()) {
            query.noRetriesLeft();
        }
        if (this.workerId != null) {
            query.workerId(this.workerId);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[0]));
        }
    }

    @Override
    protected void applySortBy(ExternalTaskQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        Consumer<ExternalTaskQuery> sortByMethod = SORT_METHODS_BY_FIELD.get(sortBy);
        if (sortByMethod != null) {
            sortByMethod.accept(query);
        }
    }
}

