/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime.modification;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.dto.runtime.TriggerVariableValueDto;
import org.camunda.bpm.engine.rest.dto.runtime.modification.CancellationInstructionDto;
import org.camunda.bpm.engine.rest.dto.runtime.modification.StartAfterInstructionDto;
import org.camunda.bpm.engine.rest.dto.runtime.modification.StartBeforeInstructionDto;
import org.camunda.bpm.engine.rest.dto.runtime.modification.StartTransitionInstructionDto;
import org.camunda.bpm.engine.runtime.ActivityInstantiationBuilder;
import org.camunda.bpm.engine.runtime.InstantiationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationBuilder;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CancellationInstructionDto.class), @JsonSubTypes.Type(value=StartBeforeInstructionDto.class), @JsonSubTypes.Type(value=StartAfterInstructionDto.class), @JsonSubTypes.Type(value=StartTransitionInstructionDto.class)})
public abstract class ProcessInstanceModificationInstructionDto {
    public static final String CANCEL_INSTRUCTION_TYPE = "cancel";
    public static final String START_BEFORE_INSTRUCTION_TYPE = "startBeforeActivity";
    public static final String START_TRANSITION_INSTRUCTION_TYPE = "startTransition";
    public static final String START_AFTER_INSTRUCTION_TYPE = "startAfterActivity";
    protected String type;
    protected Map<String, TriggerVariableValueDto> variables;
    protected String activityId;
    protected String transitionId;
    protected String activityInstanceId;
    protected String transitionInstanceId;
    protected String ancestorActivityInstanceId;
    protected boolean cancelCurrentActiveActivityInstances;

    public Map<String, TriggerVariableValueDto> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, TriggerVariableValueDto> variables) {
        this.variables = variables;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getTransitionId() {
        return this.transitionId;
    }

    public void setTransitionId(String transitionId) {
        this.transitionId = transitionId;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
    }

    public String getTransitionInstanceId() {
        return this.transitionInstanceId;
    }

    public void setTransitionInstanceId(String transitionInstanceId) {
        this.transitionInstanceId = transitionInstanceId;
    }

    public String getAncestorActivityInstanceId() {
        return this.ancestorActivityInstanceId;
    }

    public void setAncestorActivityInstanceId(String ancestorActivityInstanceId) {
        this.ancestorActivityInstanceId = ancestorActivityInstanceId;
    }

    public boolean isCancelCurrentActiveActivityInstances() {
        return this.cancelCurrentActiveActivityInstances;
    }

    public void setCancelCurrentActiveActivityInstances(boolean cancelCurrentActiveActivityInstances) {
        this.cancelCurrentActiveActivityInstances = cancelCurrentActiveActivityInstances;
    }

    public abstract void applyTo(ProcessInstanceModificationBuilder var1, ProcessEngine var2, ObjectMapper var3);

    public abstract void applyTo(InstantiationBuilder<?> var1, ProcessEngine var2, ObjectMapper var3);

    protected String buildErrorMessage(String message) {
        return "For instruction type '" + this.type + "': " + message;
    }

    protected void applyVariables(ActivityInstantiationBuilder<?> builder, ProcessEngine engine, ObjectMapper mapper) {
        if (this.variables != null) {
            for (Map.Entry<String, TriggerVariableValueDto> variableValue : this.variables.entrySet()) {
                TriggerVariableValueDto value = variableValue.getValue();
                if (value.isLocal()) {
                    builder.setVariableLocal(variableValue.getKey(), (Object)value.toTypedValue(engine, mapper));
                    continue;
                }
                builder.setVariable(variableValue.getKey(), (Object)value.toTypedValue(engine, mapper));
            }
        }
    }
}

