/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.hal.task;

import java.util.Date;
import javax.ws.rs.core.UriBuilder;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.form.CamundaFormRef;
import org.camunda.bpm.engine.rest.CaseDefinitionRestService;
import org.camunda.bpm.engine.rest.CaseExecutionRestService;
import org.camunda.bpm.engine.rest.CaseInstanceRestService;
import org.camunda.bpm.engine.rest.ExecutionRestService;
import org.camunda.bpm.engine.rest.IdentityRestService;
import org.camunda.bpm.engine.rest.ProcessDefinitionRestService;
import org.camunda.bpm.engine.rest.ProcessInstanceRestService;
import org.camunda.bpm.engine.rest.TaskRestService;
import org.camunda.bpm.engine.rest.UserRestService;
import org.camunda.bpm.engine.rest.hal.HalRelation;
import org.camunda.bpm.engine.rest.hal.HalResource;
import org.camunda.bpm.engine.rest.hal.identitylink.HalIdentityLink;
import org.camunda.bpm.engine.task.DelegationState;
import org.camunda.bpm.engine.task.Task;

public class HalTask
extends HalResource<HalTask> {
    public static HalRelation REL_SELF = HalRelation.build("self", TaskRestService.class, UriBuilder.fromPath((String)"/task").path("{id}"));
    public static HalRelation REL_ASSIGNEE = HalRelation.build("assignee", UserRestService.class, UriBuilder.fromPath((String)"/user").path("{id}"));
    public static HalRelation REL_OWNER = HalRelation.build("owner", UserRestService.class, UriBuilder.fromPath((String)"/user").path("{id}"));
    public static HalRelation REL_EXECUTION = HalRelation.build("execution", ExecutionRestService.class, UriBuilder.fromPath((String)"/execution").path("{id}"));
    public static HalRelation REL_PARENT_TASK = HalRelation.build("parentTask", TaskRestService.class, UriBuilder.fromPath((String)"/task").path("{id}"));
    public static HalRelation REL_PROCESS_DEFINITION = HalRelation.build("processDefinition", ProcessDefinitionRestService.class, UriBuilder.fromPath((String)"/process-definition").path("{id}"));
    public static HalRelation REL_PROCESS_INSTANCE = HalRelation.build("processInstance", ProcessInstanceRestService.class, UriBuilder.fromPath((String)"/process-instance").path("{id}"));
    public static HalRelation REL_CASE_INSTANCE = HalRelation.build("caseInstance", CaseInstanceRestService.class, UriBuilder.fromPath((String)"/case-instance").path("{id}"));
    public static HalRelation REL_CASE_EXECUTION = HalRelation.build("caseExecution", CaseExecutionRestService.class, UriBuilder.fromPath((String)"/case-execution").path("{id}"));
    public static HalRelation REL_CASE_DEFINITION = HalRelation.build("caseDefinition", CaseDefinitionRestService.class, UriBuilder.fromPath((String)"/case-definition").path("{id}"));
    public static HalRelation REL_IDENTITY_LINKS = HalRelation.build("identityLink", IdentityRestService.class, UriBuilder.fromPath((String)"/task").path("{taskId}").path("identity-links"));
    private String id;
    private String name;
    private String assignee;
    private Date created;
    private Date due;
    private Date followUp;
    private DelegationState delegationState;
    private String description;
    private String executionId;
    private String owner;
    private String parentTaskId;
    private int priority;
    private String processDefinitionId;
    private String processInstanceId;
    private String taskDefinitionKey;
    private String caseExecutionId;
    private String caseInstanceId;
    private String caseDefinitionId;
    private boolean suspended;
    private String formKey;
    private CamundaFormRef camundaFormRef;
    private String tenantId;

    public static HalTask generate(Task task, ProcessEngine engine) {
        return (HalTask)((HalTask)((HalTask)((HalTask)((HalTask)HalTask.fromTask(task).embed(REL_PROCESS_DEFINITION, engine)).embed(REL_CASE_DEFINITION, engine)).embed(REL_IDENTITY_LINKS, engine)).embed(HalIdentityLink.REL_USER, engine)).embed(HalIdentityLink.REL_GROUP, engine);
    }

    public static HalTask fromTask(Task task) {
        HalTask dto = new HalTask();
        dto.id = task.getId();
        dto.name = task.getName();
        dto.assignee = task.getAssignee();
        dto.created = task.getCreateTime();
        dto.due = task.getDueDate();
        dto.followUp = task.getFollowUpDate();
        dto.delegationState = task.getDelegationState();
        dto.description = task.getDescription();
        dto.executionId = task.getExecutionId();
        dto.owner = task.getOwner();
        dto.parentTaskId = task.getParentTaskId();
        dto.priority = task.getPriority();
        dto.processDefinitionId = task.getProcessDefinitionId();
        dto.processInstanceId = task.getProcessInstanceId();
        dto.taskDefinitionKey = task.getTaskDefinitionKey();
        dto.caseDefinitionId = task.getCaseDefinitionId();
        dto.caseExecutionId = task.getCaseExecutionId();
        dto.caseInstanceId = task.getCaseInstanceId();
        dto.suspended = task.isSuspended();
        dto.tenantId = task.getTenantId();
        try {
            dto.formKey = task.getFormKey();
            dto.camundaFormRef = task.getCamundaFormRef();
        }
        catch (BadUserRequestException badUserRequestException) {
            // empty catch block
        }
        dto.linker.createLink(REL_SELF, task.getId());
        dto.linker.createLink(REL_ASSIGNEE, task.getAssignee());
        dto.linker.createLink(REL_OWNER, task.getOwner());
        dto.linker.createLink(REL_EXECUTION, task.getExecutionId());
        dto.linker.createLink(REL_PARENT_TASK, task.getParentTaskId());
        dto.linker.createLink(REL_PROCESS_DEFINITION, task.getProcessDefinitionId());
        dto.linker.createLink(REL_PROCESS_INSTANCE, task.getProcessInstanceId());
        dto.linker.createLink(REL_CASE_INSTANCE, task.getCaseInstanceId());
        dto.linker.createLink(REL_CASE_EXECUTION, task.getCaseExecutionId());
        dto.linker.createLink(REL_CASE_DEFINITION, task.getCaseDefinitionId());
        dto.linker.createLink(REL_IDENTITY_LINKS, task.getId());
        return dto;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getDue() {
        return this.due;
    }

    public DelegationState getDelegationState() {
        return this.delegationState;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getParentTaskId() {
        return this.parentTaskId;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getTaskDefinitionKey() {
        return this.taskDefinitionKey;
    }

    public Date getFollowUp() {
        return this.followUp;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public CamundaFormRef getCamundaFormRef() {
        return this.camundaFormRef;
    }

    public String getTenantId() {
        return this.tenantId;
    }
}

