/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.CleanableHistoricCaseInstanceReport;
import org.camunda.bpm.engine.history.CleanableHistoricCaseInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricCaseActivityStatistics;
import org.camunda.bpm.engine.history.HistoricCaseActivityStatisticsQuery;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.history.CleanableHistoricCaseInstanceReportDto;
import org.camunda.bpm.engine.rest.dto.history.CleanableHistoricCaseInstanceReportResultDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricCaseActivityStatisticsDto;
import org.camunda.bpm.engine.rest.history.HistoricCaseDefinitionRestService;
import org.camunda.bpm.engine.rest.util.QueryUtil;

public class HistoricCaseDefinitionRestServiceImpl
implements HistoricCaseDefinitionRestService {
    protected ObjectMapper objectMapper;
    protected ProcessEngine processEngine;

    public HistoricCaseDefinitionRestServiceImpl(ObjectMapper objectMapper, ProcessEngine processEngine) {
        this.objectMapper = objectMapper;
        this.processEngine = processEngine;
    }

    @Override
    public List<HistoricCaseActivityStatisticsDto> getHistoricCaseActivityStatistics(String caseDefinitionId) {
        HistoryService historyService = this.processEngine.getHistoryService();
        HistoricCaseActivityStatisticsQuery historicCaseActivityStatisticsQuery = historyService.createHistoricCaseActivityStatisticsQuery(caseDefinitionId);
        List statistics = historicCaseActivityStatisticsQuery.unlimitedList();
        ArrayList<HistoricCaseActivityStatisticsDto> result = new ArrayList<HistoricCaseActivityStatisticsDto>();
        for (HistoricCaseActivityStatistics currentStatistics : statistics) {
            result.add(HistoricCaseActivityStatisticsDto.fromHistoricCaseActivityStatistics(currentStatistics));
        }
        return result;
    }

    @Override
    public List<CleanableHistoricCaseInstanceReportResultDto> getCleanableHistoricCaseInstanceReport(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        CleanableHistoricCaseInstanceReportDto queryDto = new CleanableHistoricCaseInstanceReportDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        CleanableHistoricCaseInstanceReport query = (CleanableHistoricCaseInstanceReport)queryDto.toQuery(this.processEngine);
        List<CleanableHistoricCaseInstanceReportResult> reportResult = QueryUtil.list(query, firstResult, maxResults);
        return CleanableHistoricCaseInstanceReportResultDto.convert(reportResult);
    }

    @Override
    public CountResultDto getCleanableHistoricCaseInstanceReportCount(UriInfo uriInfo) {
        CleanableHistoricCaseInstanceReportDto queryDto = new CleanableHistoricCaseInstanceReportDto(this.objectMapper, (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        queryDto.setObjectMapper(this.objectMapper);
        CleanableHistoricCaseInstanceReport query = (CleanableHistoricCaseInstanceReport)queryDto.toQuery(this.processEngine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

