/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.externaltask.ExternalTaskQueryTopicBuilder;
import org.camunda.bpm.engine.externaltask.FetchAndLockBuilder;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.rest.dto.externaltask.FetchExternalTasksDto;
import org.camunda.bpm.engine.rest.dto.externaltask.FetchExternalTasksExtendedDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.impl.FetchAndLockHandlerImpl;
import org.camunda.bpm.engine.rest.impl.FetchAndLockRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class FetchAndLockHandlerTest {
    @Mock
    protected ProcessEngine processEngine;
    @Mock
    protected IdentityService identityService;
    @Mock
    protected ExternalTaskService externalTaskService;
    @Mock
    protected ExternalTaskQueryTopicBuilder externalTaskQueryTopicBuilder;
    @Mock
    protected FetchAndLockBuilder fetchAndLockBuilder;
    @Spy
    protected FetchAndLockHandlerImpl handler;
    protected LockedExternalTask lockedExternalTaskMock;
    protected static final Date START_DATE = new Date(1457326800000L);

    @Before
    public void initMocks() {
        Mockito.when((Object)this.fetchAndLockBuilder.workerId(ArgumentMatchers.anyString())).thenReturn((Object)this.fetchAndLockBuilder);
        Mockito.when((Object)this.fetchAndLockBuilder.maxTasks(ArgumentMatchers.anyInt())).thenReturn((Object)this.fetchAndLockBuilder);
        Mockito.when((Object)this.fetchAndLockBuilder.usePriority(ArgumentMatchers.anyBoolean())).thenReturn((Object)this.fetchAndLockBuilder);
        Mockito.when((Object)this.processEngine.getIdentityService()).thenReturn((Object)this.identityService);
        Mockito.when((Object)this.processEngine.getExternalTaskService()).thenReturn((Object)this.externalTaskService);
        Mockito.when((Object)this.processEngine.getName()).thenReturn((Object)"default");
        Mockito.when((Object)this.externalTaskService.fetchAndLock()).thenReturn((Object)this.fetchAndLockBuilder);
        Mockito.when((Object)this.fetchAndLockBuilder.subscribe()).thenReturn((Object)this.externalTaskQueryTopicBuilder);
        Mockito.when((Object)this.externalTaskQueryTopicBuilder.topic((String)Mockito.any(String.class), Mockito.anyLong())).thenReturn((Object)this.externalTaskQueryTopicBuilder);
        ((FetchAndLockHandlerImpl)Mockito.doNothing().when((Object)this.handler)).suspend(Mockito.anyLong());
        ((FetchAndLockHandlerImpl)Mockito.doReturn((Object)this.processEngine).when((Object)this.handler)).getProcessEngine((FetchAndLockRequest)Mockito.any(FetchAndLockRequest.class));
        this.lockedExternalTaskMock = MockProvider.createMockLockedExternalTask();
    }

    @Before
    public void setClock() {
        ClockUtil.setCurrentTime((Date)START_DATE);
    }

    @After
    public void resetClock() {
        ClockUtil.reset();
    }

    @After
    public void resetUniqueWorkerRequestParam() {
        this.handler.parseUniqueWorkerRequestParam("false");
    }

    @Test
    public void shouldResumeAsyncResponseDueToAvailableTasks() {
        ArrayList<LockedExternalTask> tasks = new ArrayList<LockedExternalTask>();
        tasks.add(this.lockedExternalTaskMock);
        Mockito.when((Object)this.fetchAndLockBuilder.subscribe()).thenReturn((Object)this.externalTaskQueryTopicBuilder);
        Mockito.when((Object)this.externalTaskQueryTopicBuilder.execute()).thenReturn(tasks);
        AsyncResponse asyncResponse = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.handler.addPendingRequest(this.createDto(5000L), asyncResponse, this.processEngine);
        this.handler.acquire();
        ((AsyncResponse)Mockito.verify((Object)asyncResponse)).resume(MockitoHamcrest.argThat((Matcher)IsCollectionWithSize.hasSize((int)1)));
        MatcherAssert.assertThat((Object)this.handler.getPendingRequests().size(), (Matcher)Is.is((Object)0));
        ((FetchAndLockHandlerImpl)Mockito.verify((Object)this.handler)).suspend(Long.MAX_VALUE);
    }

    @Test
    public void shouldNotResumeAsyncResponseDueToNoAvailableTasks() {
        Mockito.when((Object)this.fetchAndLockBuilder.subscribe()).thenReturn((Object)this.externalTaskQueryTopicBuilder);
        Mockito.when((Object)this.externalTaskQueryTopicBuilder.execute()).thenReturn(Collections.emptyList());
        AsyncResponse asyncResponse = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.handler.addPendingRequest(this.createDto(5000L), asyncResponse, this.processEngine);
        this.handler.acquire();
        ((AsyncResponse)Mockito.verify((Object)asyncResponse, (VerificationMode)Mockito.never())).resume((Throwable)Mockito.any());
        MatcherAssert.assertThat((Object)this.handler.getPendingRequests().size(), (Matcher)Is.is((Object)1));
        ((FetchAndLockHandlerImpl)Mockito.verify((Object)this.handler)).suspend(5000L);
    }

    @Test
    public void shouldResumeAsyncResponseDueToTimeoutExpired_1() {
        Mockito.when((Object)this.fetchAndLockBuilder.subscribe()).thenReturn((Object)this.externalTaskQueryTopicBuilder);
        Mockito.when((Object)this.externalTaskQueryTopicBuilder.execute()).thenReturn(Collections.emptyList());
        AsyncResponse asyncResponse = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.handler.addPendingRequest(this.createDto(5000L), asyncResponse, this.processEngine);
        this.handler.acquire();
        MatcherAssert.assertThat((Object)this.handler.getPendingRequests().size(), (Matcher)Is.is((Object)1));
        ((FetchAndLockHandlerImpl)Mockito.verify((Object)this.handler)).suspend(5000L);
        ArrayList<LockedExternalTask> tasks = new ArrayList<LockedExternalTask>();
        tasks.add(this.lockedExternalTaskMock);
        Mockito.when((Object)this.externalTaskQueryTopicBuilder.execute()).thenReturn(tasks);
        this.addSecondsToClock(5);
        this.handler.acquire();
        ((AsyncResponse)Mockito.verify((Object)asyncResponse)).resume(MockitoHamcrest.argThat((Matcher)IsCollectionWithSize.hasSize((int)1)));
        MatcherAssert.assertThat((Object)this.handler.getPendingRequests().size(), (Matcher)Is.is((Object)0));
        ((FetchAndLockHandlerImpl)Mockito.verify((Object)this.handler)).suspend(Long.MAX_VALUE);
    }

    @Test
    public void shouldResumeAsyncResponseDueToTimeoutExpired_2() {
        Mockito.when((Object)this.fetchAndLockBuilder.subscribe()).thenReturn((Object)this.externalTaskQueryTopicBuilder);
        Mockito.when((Object)this.externalTaskQueryTopicBuilder.execute()).thenReturn(Collections.emptyList());
        AsyncResponse asyncResponse = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.handler.addPendingRequest(this.createDto(5000L), asyncResponse, this.processEngine);
        this.addSecondsToClock(1);
        this.handler.acquire();
        MatcherAssert.assertThat((Object)this.handler.getPendingRequests().size(), (Matcher)Is.is((Object)1));
        ((FetchAndLockHandlerImpl)Mockito.verify((Object)this.handler)).suspend(4000L);
        this.addSecondsToClock(4);
        this.handler.acquire();
        ((AsyncResponse)Mockito.verify((Object)asyncResponse)).resume(MockitoHamcrest.argThat((Matcher)IsCollectionWithSize.hasSize((int)0)));
        MatcherAssert.assertThat((Object)this.handler.getPendingRequests().size(), (Matcher)Is.is((Object)0));
        ((FetchAndLockHandlerImpl)Mockito.verify((Object)this.handler)).suspend(Long.MAX_VALUE);
    }

    @Test
    public void shouldResumeAsyncResponseDueToTimeoutExpired_3() {
        Mockito.when((Object)this.fetchAndLockBuilder.subscribe()).thenReturn((Object)this.externalTaskQueryTopicBuilder);
        Mockito.when((Object)this.externalTaskQueryTopicBuilder.execute()).thenReturn(Collections.emptyList());
        AsyncResponse asyncResponse = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.handler.addPendingRequest(this.createDto(5000L), asyncResponse, this.processEngine);
        this.handler.addPendingRequest(this.createDto(4000L), asyncResponse, this.processEngine);
        this.addSecondsToClock(1);
        this.handler.acquire();
        MatcherAssert.assertThat((Object)this.handler.getPendingRequests().size(), (Matcher)Is.is((Object)2));
        ((FetchAndLockHandlerImpl)Mockito.verify((Object)this.handler)).suspend(3000L);
        this.addSecondsToClock(4);
        this.handler.acquire();
        ((AsyncResponse)Mockito.verify((Object)asyncResponse, (VerificationMode)Mockito.times((int)2))).resume(Collections.emptyList());
        MatcherAssert.assertThat((Object)this.handler.getPendingRequests().size(), (Matcher)Is.is((Object)0));
        ((FetchAndLockHandlerImpl)Mockito.verify((Object)this.handler)).suspend(Long.MAX_VALUE);
    }

    @Test
    public void shouldResumeAsyncResponseImmediatelyDueToProcessEngineException() {
        Mockito.when((Object)this.fetchAndLockBuilder.subscribe()).thenReturn((Object)this.externalTaskQueryTopicBuilder);
        Mockito.when((Object)this.externalTaskQueryTopicBuilder.execute()).thenThrow(new Throwable[]{new ProcessEngineException()});
        AsyncResponse asyncResponse = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.handler.addPendingRequest(this.createDto(5000L), asyncResponse, this.processEngine);
        MatcherAssert.assertThat((Object)this.handler.getPendingRequests().size(), (Matcher)Is.is((Object)0));
        ((FetchAndLockHandlerImpl)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).suspend(Mockito.anyLong());
        ((AsyncResponse)Mockito.verify((Object)asyncResponse)).resume((Throwable)Mockito.any(ProcessEngineException.class));
    }

    @Test
    public void shouldResumeAsyncResponseAfterBackoffDueToProcessEngineException() {
        Mockito.when((Object)this.fetchAndLockBuilder.subscribe()).thenReturn((Object)this.externalTaskQueryTopicBuilder);
        Mockito.when((Object)this.externalTaskQueryTopicBuilder.execute()).thenReturn(Collections.emptyList());
        AsyncResponse asyncResponse = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.handler.addPendingRequest(this.createDto(5000L), asyncResponse, this.processEngine);
        this.handler.acquire();
        MatcherAssert.assertThat((Object)this.handler.getPendingRequests().size(), (Matcher)Is.is((Object)1));
        ((FetchAndLockHandlerImpl)Mockito.verify((Object)this.handler)).suspend(5000L);
        ((ExternalTaskQueryTopicBuilder)Mockito.doThrow((Throwable[])new Throwable[]{new ProcessEngineException()}).when((Object)this.externalTaskQueryTopicBuilder)).execute();
        this.handler.acquire();
        MatcherAssert.assertThat((Object)this.handler.getPendingRequests().size(), (Matcher)Is.is((Object)0));
        ((FetchAndLockHandlerImpl)Mockito.verify((Object)this.handler)).suspend(Long.MAX_VALUE);
        ((AsyncResponse)Mockito.verify((Object)asyncResponse)).resume((Throwable)Mockito.any(ProcessEngineException.class));
    }

    @Test
    public void shouldResumeAsyncResponseDueToTimeoutExceeded() {
        MatcherAssert.assertThat((Object)this.handler.getPendingRequests().size(), (Matcher)Is.is((Object)0));
        AsyncResponse asyncResponse = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.handler.addPendingRequest(this.createDto(1800001L), asyncResponse, this.processEngine);
        ((FetchAndLockHandlerImpl)Mockito.verify((Object)this.handler, (VerificationMode)Mockito.never())).suspend(Mockito.anyLong());
        MatcherAssert.assertThat((Object)this.handler.getPendingRequests().size(), (Matcher)Is.is((Object)0));
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(InvalidRequestException.class);
        ((AsyncResponse)Mockito.verify((Object)asyncResponse)).resume((Throwable)argumentCaptor.capture());
        MatcherAssert.assertThat((Object)((InvalidRequestException)argumentCaptor.getValue()).getMessage(), (Matcher)Is.is((Object)"The asynchronous response timeout cannot be set to a value greater than 1800000 milliseconds"));
    }

    @Test
    public void shouldPollPeriodicallyWhenRequestPending() {
        ((ExternalTaskQueryTopicBuilder)Mockito.doReturn(Collections.emptyList()).when((Object)this.externalTaskQueryTopicBuilder)).execute();
        AsyncResponse asyncResponse = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.handler.addPendingRequest(this.createDto(1800000L), asyncResponse, this.processEngine);
        this.handler.acquire();
        ((FetchAndLockHandlerImpl)Mockito.verify((Object)this.handler)).suspend(30000L);
    }

    @Test
    public void shouldNotPollPeriodicallyWhenNotRequestsPending() {
        this.handler.acquire();
        ((FetchAndLockHandlerImpl)Mockito.verify((Object)this.handler)).suspend(Long.MAX_VALUE);
    }

    @Test
    public void shouldCancelPreviousPendingRequestWhenWorkerIdsEqual() {
        ((ExternalTaskQueryTopicBuilder)Mockito.doReturn(Collections.emptyList()).when((Object)this.externalTaskQueryTopicBuilder)).execute();
        this.handler.parseUniqueWorkerRequestParam("true");
        AsyncResponse asyncResponse = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.handler.addPendingRequest(this.createDto(1800000L, "aWorkerId"), asyncResponse, this.processEngine);
        this.handler.acquire();
        this.handler.addPendingRequest(this.createDto(1800000L, "aWorkerId"), (AsyncResponse)Mockito.mock(AsyncResponse.class), this.processEngine);
        this.handler.acquire();
        ((AsyncResponse)Mockito.verify((Object)asyncResponse)).cancel();
        MatcherAssert.assertThat((Object)this.handler.getPendingRequests().size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldNotCancelPreviousPendingRequestWhenWorkerIdsDiffer() {
        ((ExternalTaskQueryTopicBuilder)Mockito.doReturn(Collections.emptyList()).when((Object)this.externalTaskQueryTopicBuilder)).execute();
        this.handler.parseUniqueWorkerRequestParam("true");
        AsyncResponse asyncResponse = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.handler.addPendingRequest(this.createDto(1800000L, "aWorkerId"), asyncResponse, this.processEngine);
        this.handler.acquire();
        this.handler.addPendingRequest(this.createDto(1800000L, "anotherWorkerId"), (AsyncResponse)Mockito.mock(AsyncResponse.class), this.processEngine);
        this.handler.acquire();
        ((AsyncResponse)Mockito.verify((Object)asyncResponse, (VerificationMode)Mockito.never())).cancel();
        MatcherAssert.assertThat((Object)this.handler.getPendingRequests().size(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void shouldResumeAsyncResponseDueToTooManyRequests() {
        AsyncResponse asyncResponse = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.handler.errorTooManyRequests(asyncResponse);
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(InvalidRequestException.class);
        ((AsyncResponse)Mockito.verify((Object)asyncResponse)).resume((Throwable)argumentCaptor.capture());
        MatcherAssert.assertThat((Object)((InvalidRequestException)argumentCaptor.getValue()).getMessage(), (Matcher)Is.is((Object)"At the moment the server has to handle too many requests at the same time. Please try again later."));
    }

    @Test
    public void shouldSuspendForeverDueToNoPendingRequests() {
        MatcherAssert.assertThat((Object)this.handler.getPendingRequests().size(), (Matcher)Is.is((Object)0));
        this.handler.acquire();
        MatcherAssert.assertThat((Object)this.handler.getPendingRequests().size(), (Matcher)Is.is((Object)0));
        ((FetchAndLockHandlerImpl)Mockito.verify((Object)this.handler)).suspend(Long.MAX_VALUE);
    }

    @Test
    public void shouldRejectRequestDueToShutdown() {
        AsyncResponse asyncResponse = (AsyncResponse)Mockito.mock(AsyncResponse.class);
        this.handler.addPendingRequest(this.createDto(5000L), asyncResponse, this.processEngine);
        this.handler.acquire();
        MatcherAssert.assertThat((Object)this.handler.getPendingRequests().size(), (Matcher)Is.is((Object)1));
        this.handler.rejectPendingRequests();
        ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(RestException.class);
        ((AsyncResponse)Mockito.verify((Object)asyncResponse)).resume((Throwable)argumentCaptor.capture());
        MatcherAssert.assertThat((Object)((RestException)argumentCaptor.getValue()).getStatus(), (Matcher)Is.is((Object)Response.Status.INTERNAL_SERVER_ERROR));
        MatcherAssert.assertThat((Object)((RestException)argumentCaptor.getValue()).getMessage(), (Matcher)Is.is((Object)"Request rejected due to shutdown of application server."));
    }

    protected FetchExternalTasksExtendedDto createDto(Long responseTimeout, String workerId) {
        FetchExternalTasksExtendedDto externalTask = new FetchExternalTasksExtendedDto();
        FetchExternalTasksDto.FetchExternalTaskTopicDto topic = new FetchExternalTasksDto.FetchExternalTaskTopicDto();
        topic.setTopicName("aTopicName");
        topic.setLockDuration(12354L);
        externalTask.setMaxTasks(5);
        externalTask.setWorkerId(workerId);
        externalTask.setTopics(Collections.singletonList(topic));
        if (responseTimeout != null) {
            externalTask.setAsyncResponseTimeout(responseTimeout);
        }
        return externalTask;
    }

    protected FetchExternalTasksExtendedDto createDto(Long responseTimeout) {
        return this.createDto(responseTimeout, "aWorkerId");
    }

    protected Date addSeconds(Date date, int seconds) {
        return new Date(date.getTime() + (long)(seconds * 1000));
    }

    protected void addSecondsToClock(int seconds) {
        Date newDate = this.addSeconds(ClockUtil.getCurrentTime(), seconds);
        ClockUtil.setCurrentTime((Date)newDate);
    }
}

