/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.message;

import org.camunda.bpm.engine.rest.dto.runtime.ExecutionDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceDto;
import org.camunda.bpm.engine.runtime.MessageCorrelationResult;
import org.camunda.bpm.engine.runtime.MessageCorrelationResultType;

public class MessageCorrelationResultDto {
    private MessageCorrelationResultType resultType;
    private ExecutionDto execution;
    private ProcessInstanceDto processInstance;

    public static MessageCorrelationResultDto fromMessageCorrelationResult(MessageCorrelationResult result) {
        MessageCorrelationResultDto dto = new MessageCorrelationResultDto();
        return MessageCorrelationResultDto.setExecutionAndProcessInstance(dto, result);
    }

    public static MessageCorrelationResultDto setExecutionAndProcessInstance(MessageCorrelationResultDto dto, MessageCorrelationResult result) {
        if (result != null) {
            dto.setResultType(result.getResultType());
            if (result.getResultType() == MessageCorrelationResultType.Execution && result.getExecution() != null) {
                dto.setExecution(ExecutionDto.fromExecution(result.getExecution()));
            } else if (result.getResultType() == MessageCorrelationResultType.ProcessDefinition && result.getProcessInstance() != null) {
                dto.setProcessInstance(ProcessInstanceDto.fromProcessInstance(result.getProcessInstance()));
            }
        }
        return dto;
    }

    public MessageCorrelationResultType getResultType() {
        return this.resultType;
    }

    public void setResultType(MessageCorrelationResultType resultType) {
        this.resultType = resultType;
    }

    public ExecutionDto getExecution() {
        return this.execution;
    }

    public void setExecution(ExecutionDto execution) {
        this.execution = execution;
    }

    public ProcessInstanceDto getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ProcessInstanceDto processInstance) {
        this.processInstance = processInstance;
    }
}

