/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.filter.FilterQuery;
import org.camunda.bpm.engine.rest.FilterRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.ResourceOptionsDto;
import org.camunda.bpm.engine.rest.dto.runtime.FilterDto;
import org.camunda.bpm.engine.rest.dto.runtime.FilterQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.impl.AbstractAuthorizedRestResource;
import org.camunda.bpm.engine.rest.sub.runtime.FilterResource;
import org.camunda.bpm.engine.rest.sub.runtime.impl.FilterResourceImpl;
import org.camunda.bpm.engine.rest.util.QueryUtil;

public class FilterRestServiceImpl
extends AbstractAuthorizedRestResource
implements FilterRestService {
    public FilterRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, (Resource)Resources.FILTER, "*", objectMapper);
    }

    @Override
    public FilterResource getFilter(String filterId) {
        return new FilterResourceImpl(this.getProcessEngine().getName(), this.getObjectMapper(), filterId, this.relativeRootResourcePath);
    }

    @Override
    public List<FilterDto> getFilters(UriInfo uriInfo, Boolean itemCount, Integer firstResult, Integer maxResults) {
        FilterService filterService = this.getProcessEngine().getFilterService();
        FilterQuery query = this.getQueryFromQueryParameters((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        List<Filter> matchingFilters = QueryUtil.list(query, firstResult, maxResults);
        ArrayList<FilterDto> filters = new ArrayList<FilterDto>();
        for (Filter filter : matchingFilters) {
            FilterDto dto = FilterDto.fromFilter(filter);
            if (itemCount != null && itemCount.booleanValue()) {
                dto.setItemCount(filterService.count(filter.getId()));
            }
            filters.add(dto);
        }
        return filters;
    }

    @Override
    public CountResultDto getFiltersCount(UriInfo uriInfo) {
        FilterQuery query = this.getQueryFromQueryParameters((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        return new CountResultDto(query.count());
    }

    @Override
    public FilterDto createFilter(FilterDto filterDto) {
        FilterService filterService = this.getProcessEngine().getFilterService();
        String resourceType = filterDto.getResourceType();
        if (!"Task".equals(resourceType)) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Unable to create filter with invalid resource type '" + resourceType + "'");
        }
        Filter filter = filterService.newTaskFilter();
        try {
            filterDto.updateFilter(filter, this.getProcessEngine());
        }
        catch (NotValidException e) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, (Exception)((Object)e), "Unable to create filter with invalid content");
        }
        filterService.saveFilter(filter);
        return FilterDto.fromFilter(filter);
    }

    protected FilterQuery getQueryFromQueryParameters(MultivaluedMap<String, String> queryParameters) {
        ProcessEngine engine = this.getProcessEngine();
        FilterQueryDto queryDto = new FilterQueryDto(this.getObjectMapper(), queryParameters);
        return (FilterQuery)queryDto.toQuery(engine);
    }

    @Override
    public ResourceOptionsDto availableOperations(UriInfo context) {
        UriBuilder baseUriBuilder = context.getBaseUriBuilder().path(this.relativeRootResourcePath).path("/filter");
        ResourceOptionsDto resourceOptionsDto = new ResourceOptionsDto();
        URI baseUri = baseUriBuilder.build(new Object[0]);
        resourceOptionsDto.addReflexiveLink(baseUri, "GET", "list");
        URI countUri = baseUriBuilder.clone().path("/count").build(new Object[0]);
        resourceOptionsDto.addReflexiveLink(countUri, "GET", "count");
        if (this.isAuthorized((Permission)Permissions.CREATE)) {
            URI createUri = baseUriBuilder.clone().path("/create").build(new Object[0]);
            resourceOptionsDto.addReflexiveLink(createUri, "POST", "create");
        }
        return resourceOptionsDto;
    }
}

