/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import io.restassured.RestAssured;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.Mockito;

public class ExternalTaskTopicNamesRestServiceTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String EXTERNAL_TASK_QUERY_URL = "/rest-test/external-task";
    protected static final String GET_EXTERNAL_TASK_TOPIC_NAMES_URL = "/rest-test/external-task/topic-names";
    protected static final String WITH_LOCKED_TASKS = "withLockedTasks";
    protected static final String WITH_UNLOCKED_TASKS = "withUnlockedTasks";
    protected static final String WITH_RETRIES_LEFT = "withRetriesLeft";

    @Before
    public void setupMocks() {
        Mockito.when((Object)processEngine.getExternalTaskService().getTopicNames(false, false, false)).thenReturn(Arrays.asList("allTopics"));
        Mockito.when((Object)processEngine.getExternalTaskService().getTopicNames(true, false, false)).thenReturn(Arrays.asList("lockedTasks"));
        Mockito.when((Object)processEngine.getExternalTaskService().getTopicNames(false, true, false)).thenReturn(Arrays.asList("unlockedTasks"));
        Mockito.when((Object)processEngine.getExternalTaskService().getTopicNames(false, false, true)).thenReturn(Arrays.asList(WITH_RETRIES_LEFT));
    }

    @Test
    public void testGetTopicNames() {
        Response response = (Response)RestAssured.given().then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(GET_EXTERNAL_TASK_TOPIC_NAMES_URL, new Object[0]);
        String content = response.asString();
        List topicNames = JsonPath.from((String)content).getList("");
        Assert.assertEquals((Object)"allTopics", topicNames.get(0));
    }

    @Test
    public void testGetTopicNamesOfLockedTasks() {
        Response response = (Response)RestAssured.given().header("accept", (Object)"application/json", new Object[0]).param(WITH_LOCKED_TASKS, new Object[]{true}).param(WITH_UNLOCKED_TASKS, new Object[]{false}).param(WITH_RETRIES_LEFT, new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(GET_EXTERNAL_TASK_TOPIC_NAMES_URL, new Object[0]);
        String content = response.asString();
        List topicNames = JsonPath.from((String)content).getList("");
        Assert.assertEquals((Object)"lockedTasks", topicNames.get(0));
    }

    @Test
    public void testGetTopicNamesOfUnlockedTasks() {
        Response response = (Response)RestAssured.given().header("accept", (Object)"application/json", new Object[0]).param(WITH_LOCKED_TASKS, new Object[]{false}).param(WITH_UNLOCKED_TASKS, new Object[]{true}).param(WITH_RETRIES_LEFT, new Object[]{false}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(GET_EXTERNAL_TASK_TOPIC_NAMES_URL, new Object[0]);
        String content = response.asString();
        List topicNames = JsonPath.from((String)content).getList("");
        Assert.assertEquals((Object)"unlockedTasks", topicNames.get(0));
    }

    @Test
    public void testGetTopicNamesOfTasksWithRetriesLeft() {
        Response response = (Response)RestAssured.given().header("accept", (Object)"application/json", new Object[0]).param(WITH_LOCKED_TASKS, new Object[]{false}).param(WITH_UNLOCKED_TASKS, new Object[]{false}).param(WITH_RETRIES_LEFT, new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(GET_EXTERNAL_TASK_TOPIC_NAMES_URL, new Object[0]);
        String content = response.asString();
        List topicNames = JsonPath.from((String)content).getList("");
        Assert.assertEquals((Object)WITH_RETRIES_LEFT, topicNames.get(0));
    }
}

