/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.history.HistoricCaseInstance;
import org.camunda.bpm.engine.history.HistoricCaseInstanceQuery;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.camunda.bpm.engine.rest.util.OrderingBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;

public class HistoricCaseInstanceRestServiceQueryTest
extends AbstractRestServiceTest {
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_CASE_INSTANCE_RESOURCE_URL = "/rest-test/history/case-instance";
    protected static final String HISTORIC_CASE_INSTANCE_COUNT_RESOURCE_URL = "/rest-test/history/case-instance/count";
    protected HistoricCaseInstanceQuery mockedQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedQuery = this.setUpMockHistoricCaseInstanceQuery(MockProvider.createMockHistoricCaseInstances());
    }

    protected HistoricCaseInstanceQuery setUpMockHistoricCaseInstanceQuery(List<HistoricCaseInstance> mockedHistoricCaseInstances) {
        HistoricCaseInstanceQuery mockedHistoricCaseInstanceQuery = (HistoricCaseInstanceQuery)Mockito.mock(HistoricCaseInstanceQuery.class);
        Mockito.when((Object)mockedHistoricCaseInstanceQuery.list()).thenReturn(mockedHistoricCaseInstances);
        Mockito.when((Object)mockedHistoricCaseInstanceQuery.count()).thenReturn((Object)mockedHistoricCaseInstances.size());
        Mockito.when((Object)processEngine.getHistoryService().createHistoricCaseInstanceQuery()).thenReturn((Object)mockedHistoricCaseInstanceQuery);
        return mockedHistoricCaseInstanceQuery;
    }

    @Test
    public void testEmptyQuery() {
        String queryKey = "";
        RestAssured.given().queryParam("caseDefinitionKey", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testNoParametersQueryAsPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("definitionId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"definitionId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("instanceId", "asc", Response.Status.OK);
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceId();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("instanceId", "desc", Response.Status.OK);
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceId();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("definitionId", "asc", Response.Status.OK);
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseDefinitionId();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("definitionId", "desc", Response.Status.OK);
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseDefinitionId();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("businessKey", "asc", Response.Status.OK);
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceBusinessKey();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("businessKey", "desc", Response.Status.OK);
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceBusinessKey();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("createTime", "asc", Response.Status.OK);
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceCreateTime();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("createTime", "desc", Response.Status.OK);
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceCreateTime();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("closeTime", "asc", Response.Status.OK);
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceCloseTime();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("closeTime", "desc", Response.Status.OK);
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceCloseTime();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("duration", "asc", Response.Status.OK);
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceDuration();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("duration", "desc", Response.Status.OK);
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceDuration();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "desc", Response.Status.OK);
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
    }

    @Test
    public void testSecondarySortingAsPost() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        HashMap<String, List<Map<String, Object>>> json = new HashMap<String, List<Map<String, Object>>>();
        json.put("sorting", OrderingBuilder.create().orderBy("businessKey").desc().orderBy("closeTime").asc().getJson());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceBusinessKey();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByCaseInstanceCloseTime();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(HISTORIC_CASE_INSTANCE_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testQueryCountForPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().body("count", Matchers.equalTo((Object)1), new Object[0]).when().post(HISTORIC_CASE_INSTANCE_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testSimpleHistoricCaseQuery() {
        String caseInstanceId = "aCaseInstId";
        Response response = (Response)RestAssured.given().queryParam("caseInstanceId", new Object[]{caseInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).caseInstanceId(caseInstanceId);
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertNotNull(instances.get(0));
        String returnedCaseInstanceId = JsonPath.from((String)content).getString("[0].id");
        String returnedCaseInstanceBusinessKey = JsonPath.from((String)content).getString("[0].businessKey");
        String returnedCaseDefinitionId = JsonPath.from((String)content).getString("[0].caseDefinitionId");
        String returnedCaseDefinitionKey = JsonPath.from((String)content).getString("[0].caseDefinitionKey");
        String returnedCaseDefinitionName = JsonPath.from((String)content).getString("[0].caseDefinitionName");
        String returnedCreateTime = JsonPath.from((String)content).getString("[0].createTime");
        String returnedCloseTime = JsonPath.from((String)content).getString("[0].closeTime");
        long returnedDurationInMillis = JsonPath.from((String)content).getLong("[0].durationInMillis");
        String returnedCreateUserId = JsonPath.from((String)content).getString("[0].createUserId");
        String returnedSuperCaseInstanceId = JsonPath.from((String)content).getString("[0].superCaseInstanceId");
        String returnedSuperProcessInstanceId = JsonPath.from((String)content).getString("[0].superProcessInstanceId");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        boolean active = JsonPath.from((String)content).getBoolean("[0].active");
        boolean completed = JsonPath.from((String)content).getBoolean("[0].completed");
        boolean terminated = JsonPath.from((String)content).getBoolean("[0].terminated");
        boolean closed = JsonPath.from((String)content).getBoolean("[0].closed");
        Assert.assertEquals((Object)"aCaseInstId", (Object)returnedCaseInstanceId);
        Assert.assertEquals((Object)"aBusinessKey", (Object)returnedCaseInstanceBusinessKey);
        Assert.assertEquals((Object)"aCaseDefnitionId", (Object)returnedCaseDefinitionId);
        Assert.assertEquals((Object)"aCaseDefinitionKey", (Object)returnedCaseDefinitionKey);
        Assert.assertEquals((Object)"aCaseDefinitionName", (Object)returnedCaseDefinitionName);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_CASE_INSTANCE_CREATE_TIME, (Object)returnedCreateTime);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_CASE_INSTANCE_CLOSE_TIME, (Object)returnedCloseTime);
        Assert.assertEquals((long)2000L, (long)returnedDurationInMillis);
        Assert.assertEquals((Object)"aCreateUserId", (Object)returnedCreateUserId);
        Assert.assertEquals((Object)"aSuperCaseInstanceId", (Object)returnedSuperCaseInstanceId);
        Assert.assertEquals((Object)"aSuperProcessInstanceId", (Object)returnedSuperProcessInstanceId);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId);
        Assert.assertEquals((Object)true, (Object)active);
        Assert.assertEquals((Object)true, (Object)completed);
        Assert.assertEquals((Object)true, (Object)terminated);
        Assert.assertEquals((Object)true, (Object)closed);
    }

    @Test
    public void testAdditionalParametersExcludingCases() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        RestAssured.given().queryParams(stringQueryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStringParameterQueryInvocations();
    }

    @Test
    public void testAdditionalParametersExcludingCasesAsPost() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(stringQueryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStringParameterQueryInvocations();
    }

    @Test
    public void testHistoricBeforeAndAfterCreateTimeQuery() {
        RestAssured.given().queryParam("createdBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_CASE_INSTANCE_CREATED_BEFORE}).queryParam("createdAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_CASE_INSTANCE_CREATED_AFTER}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyCreateParameterQueryInvocations();
    }

    @Test
    public void testHistoricBeforeAndAfterCreateTimeQueryAsPost() {
        Map<String, Date> parameters = this.getCompleteCreateDateQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyCreateParameterQueryInvocations();
    }

    @Test
    public void testHistoricBeforeAndAfterCreateTimeAsStringQueryAsPost() {
        Map<String, String> parameters = this.getCompleteCreateDateAsStringQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStringCreateParameterQueryInvocations();
    }

    @Test
    public void testHistoricAfterAndBeforeCloseTimeQuery() {
        RestAssured.given().queryParam("closedAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_CASE_INSTANCE_CLOSED_AFTER}).queryParam("closedBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_CASE_INSTANCE_CLOSED_BEFORE}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyClosedParameterQueryInvocations();
    }

    @Test
    public void testHistoricAfterAndBeforeCloseTimeQueryAsPost() {
        Map<String, Date> parameters = this.getCompleteClosedDateQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyClosedParameterQueryInvocations();
    }

    @Test
    public void testHistoricAfterAndBeforeCloseTimeAsStringQueryAsPost() {
        Map<String, String> parameters = this.getCompleteClosedDateAsStringQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStringClosedParameterQueryInvocations();
    }

    @Test
    public void testCaseActiveClosed() {
        RestAssured.given().queryParam("active", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).active();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testCaseQueryActiveAsPost() {
        HashMap<String, Boolean> body = new HashMap<String, Boolean>();
        body.put("active", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).active();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testCaseQueryCompleted() {
        RestAssured.given().queryParam("completed", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).completed();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testCaseQueryCompletedAsPost() {
        HashMap<String, Boolean> body = new HashMap<String, Boolean>();
        body.put("completed", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).completed();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testCaseQueryTerminated() {
        RestAssured.given().queryParam("terminated", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).terminated();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testCaseQueryTerminatedAsPost() {
        HashMap<String, Boolean> body = new HashMap<String, Boolean>();
        body.put("terminated", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).terminated();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testCaseQueryClosed() {
        RestAssured.given().queryParam("closed", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).closed();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testCaseQueryClosedAsPost() {
        HashMap<String, Boolean> body = new HashMap<String, Boolean>();
        body.put("closed", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).closed();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testCaseQueryNotClosed() {
        List<HistoricCaseInstance> mockedHistoricCaseInstances = MockProvider.createMockRunningHistoricCaseInstances();
        HistoricCaseInstanceQuery mockedHistoricCaseInstanceQuery = (HistoricCaseInstanceQuery)Mockito.mock(HistoricCaseInstanceQuery.class);
        Mockito.when((Object)mockedHistoricCaseInstanceQuery.list()).thenReturn(mockedHistoricCaseInstances);
        Mockito.when((Object)processEngine.getHistoryService().createHistoricCaseInstanceQuery()).thenReturn((Object)mockedHistoricCaseInstanceQuery);
        Response response = (Response)RestAssured.given().queryParam("notClosed", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockedHistoricCaseInstanceQuery});
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)mockedHistoricCaseInstanceQuery)).notClosed();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)mockedHistoricCaseInstanceQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertNotNull(instances.get(0));
        String returnedCaseInstanceId = JsonPath.from((String)content).getString("[0].id");
        String returnedCloseTime = JsonPath.from((String)content).getString("[0].closeTime");
        Assert.assertEquals((Object)"aCaseInstId", (Object)returnedCaseInstanceId);
        Assert.assertEquals(null, (Object)returnedCloseTime);
    }

    @Test
    public void testCaseQueryNotClosedAsPost() {
        List<HistoricCaseInstance> mockedHistoricCaseInstances = MockProvider.createMockRunningHistoricCaseInstances();
        HistoricCaseInstanceQuery mockedHistoricCaseInstanceQuery = (HistoricCaseInstanceQuery)Mockito.mock(HistoricCaseInstanceQuery.class);
        Mockito.when((Object)mockedHistoricCaseInstanceQuery.list()).thenReturn(mockedHistoricCaseInstances);
        Mockito.when((Object)processEngine.getHistoryService().createHistoricCaseInstanceQuery()).thenReturn((Object)mockedHistoricCaseInstanceQuery);
        HashMap<String, Boolean> body = new HashMap<String, Boolean>();
        body.put("notClosed", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockedHistoricCaseInstanceQuery});
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)mockedHistoricCaseInstanceQuery)).notClosed();
        ((HistoricCaseInstanceQuery)inOrder.verify((Object)mockedHistoricCaseInstanceQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((long)1L, (long)instances.size());
        Assert.assertNotNull(instances.get(0));
        String returnedCaseInstanceId = JsonPath.from((String)content).getString("[0].id");
        String returnedCloseTime = JsonPath.from((String)content).getString("[0].closeTime");
        Assert.assertEquals((Object)"aCaseInstId", (Object)returnedCaseInstanceId);
        Assert.assertEquals(null, (Object)returnedCloseTime);
    }

    @Test
    public void testQueryByCaseInstanceIds() {
        RestAssured.given().queryParam("caseInstanceIds", new Object[]{"firstCaseInstanceId,secondCaseInstanceId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyCaseInstanceIdSetInvocation();
    }

    @Test
    public void testQueryByCaseInstanceIdsAsPost() {
        Map<String, Set<String>> parameters = this.getCompleteCaseInstanceIdSetQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyCaseInstanceIdSetInvocation();
    }

    @Test
    public void testQueryByCaseDefinitionKeyNotIn() {
        RestAssured.given().queryParam("caseDefinitionKeyNotIn", new Object[]{"firstCaseInstanceKey,secondCaseInstanceKey"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyCaseDefinitionKeyNotInListInvocation();
    }

    @Test
    public void testQueryByCaseDefinitionKeyNotInAsPost() {
        Map<String, List<String>> parameters = this.getCompleteCaseDefinitionKeyNotInListQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyCaseDefinitionKeyNotInListInvocation();
    }

    @Test
    public void testVariableValueEquals() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValueGreaterThan() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_gt_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThan(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValueGreaterThanEquals() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_gteq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThanOrEqual(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValueLessThan() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_lt_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThan(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValueLessThanEquals() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_lteq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThanOrEqual(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValueLike() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike(variableName, variableValue);
    }

    @Test
    public void testVariableValueNotEquals() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValuesEqualsIgnoreCase() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
    }

    @Test
    public void testVariableValuesNotEqualsIgnoreCase() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName, (Object)variableValue);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
    }

    @Test
    public void testVariableValuesLikeIgnoreCase() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike(variableName, variableValue);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
    }

    @Test
    public void testVariableNamesEqualsIgnoreCase() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).queryParam("variableNamesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
    }

    @Test
    public void testVariableNamesNotEqualsIgnoreCase() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).queryParam("variableNamesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName, (Object)variableValue);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
    }

    @Test
    public void testVariableValueEqualsAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "eq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals("varName", (Object)"varValue");
    }

    @Test
    public void testVariableValueGreaterThanAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "gt");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThan("varName", (Object)"varValue");
    }

    @Test
    public void testVariableValueGreaterThanEqualsAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "gteq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThanOrEqual("varName", (Object)"varValue");
    }

    @Test
    public void testVariableValueLessThanAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "lt");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThan("varName", (Object)"varValue");
    }

    @Test
    public void testVariableValueLessThanEqualsAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "lteq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThanOrEqual("varName", (Object)"varValue");
    }

    @Test
    public void testVariableValueLikeAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "like");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike("varName", "varValue");
    }

    @Test
    public void testVariableValueNotEqualsAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "neq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals("varName", (Object)"varValue");
    }

    @Test
    public void testVariableValuesEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "eq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variables", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals("varName", (Object)"varValue");
    }

    @Test
    public void testVariableValuesNotEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "neq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variables", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals("varName", (Object)"varValue");
    }

    @Test
    public void testVariableValuesLikeIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "like");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variables", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike("varName", "varValue");
    }

    @Test
    public void testVariableNamesEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "eq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variables", variables);
        json.put("variableNamesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals("varName", (Object)"varValue");
    }

    @Test
    public void testVariableNamesNotEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "neq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variables", variables);
        json.put("variableNamesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals("varName", (Object)"varValue");
    }

    @Test
    public void testMultipleVariableParameters() {
        String variableName1 = "varName";
        String variableValue1 = "varValue";
        String variableParameter1 = variableName1 + "_eq_" + variableValue1;
        String variableName2 = "anotherVarName";
        String variableValue2 = "anotherVarValue";
        String variableParameter2 = variableName2 + "_neq_" + variableValue2;
        String queryValue = variableParameter1 + "," + variableParameter2;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName1, (Object)variableValue1);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName2, (Object)variableValue2);
    }

    @Test
    public void testMultipleVariableParametersAsPost() {
        String variableName = "varName";
        String variableValue = "varValue";
        String anotherVariableName = "anotherVarName";
        Integer anotherVariableValue = 30;
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", "eq");
        variableJson.put("value", variableValue);
        HashMap<String, Object> anotherVariableJson = new HashMap<String, Object>();
        anotherVariableJson.put("name", anotherVariableName);
        anotherVariableJson.put("operator", "neq");
        anotherVariableJson.put("value", anotherVariableValue);
        ArrayList<HashMap<String, Object>> variables = new ArrayList<HashMap<String, Object>>();
        variables.add(variableJson);
        variables.add(anotherVariableJson);
        HashMap<String, ArrayList<HashMap<String, Object>>> json = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals((String)Mockito.eq((Object)anotherVariableName), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.numberValue(anotherVariableValue)));
    }

    @Test
    public void testTenantIdListParameter() {
        this.mockedQuery = this.setUpMockHistoricCaseInstanceQuery(this.createMockHistoricCaseInstancesTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List historicCaseInstances = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)historicCaseInstances).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testTenantIdListPostParameter() {
        this.mockedQuery = this.setUpMockHistoricCaseInstanceQuery(this.createMockHistoricCaseInstancesTwoTenants());
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("tenantIdIn", "aTenantId,anotherTenantId".split(","));
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List historicCaseInstances = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)historicCaseInstances).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testWithoutTenantIdParameter() {
        this.mockedQuery = this.setUpMockHistoricCaseInstanceQuery(Arrays.asList(MockProvider.createMockHistoricCaseInstance(null)));
        Response response = (Response)RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
    }

    @Test
    public void testWithoutTenantIdPostParameter() {
        this.mockedQuery = this.setUpMockHistoricCaseInstanceQuery(Arrays.asList(MockProvider.createMockHistoricCaseInstance(null)));
        HashMap<String, Boolean> queryParameters = new HashMap<String, Boolean>();
        queryParameters.put("withoutTenantId", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
    }

    private List<HistoricCaseInstance> createMockHistoricCaseInstancesTwoTenants() {
        return Arrays.asList(MockProvider.createMockHistoricCaseInstance("aTenantId"), MockProvider.createMockHistoricCaseInstance("anotherTenantId"));
    }

    @Test
    public void testCaseActivityIdListParameter() {
        Response response = (Response)RestAssured.given().queryParam("caseActivityIdIn", new Object[]{"aCaseActivityId,anotherCaseActivityId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseActivityIdIn(new String[]{"aCaseActivityId", "anotherCaseActivityId"});
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List historicCaseInstances = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)historicCaseInstances).hasSize(1);
    }

    @Test
    public void testCaseActivityIdListPostParameter() {
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("caseActivityIdIn", "aCaseActivityId,anotherCaseActivityId".split(","));
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseActivityIdIn(new String[]{"aCaseActivityId", "anotherCaseActivityId"});
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List historicCaseInstances = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)historicCaseInstances).hasSize(1);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(HISTORIC_CASE_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    protected Map<String, String> getCompleteStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("caseInstanceId", "aCaseInstId");
        parameters.put("caseInstanceBusinessKey", "aBusinessKey");
        parameters.put("caseInstanceBusinessKeyLike", "aBusinessKeyLike");
        parameters.put("caseDefinitionId", "aCaseDefnitionId");
        parameters.put("caseDefinitionKey", "aCaseDefinitionKey");
        parameters.put("caseDefinitionName", "aCaseDefinitionName");
        parameters.put("caseDefinitionNameLike", "aCaseDefinitionNameLike");
        parameters.put("createdBy", "createdBySomeone");
        parameters.put("superCaseInstanceId", "aSuperCaseInstanceId");
        parameters.put("subCaseInstanceId", "aSubCaseInstanceId");
        parameters.put("superProcessInstanceId", "aSuperProcessInstanceId");
        parameters.put("subProcessInstanceId", "aSuperProcessInstanceId");
        return parameters;
    }

    protected void verifyStringParameterQueryInvocations() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceId(stringQueryParameters.get("caseInstanceId"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceBusinessKey(stringQueryParameters.get("caseInstanceBusinessKey"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceBusinessKeyLike(stringQueryParameters.get("caseInstanceBusinessKeyLike"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionId(stringQueryParameters.get("caseDefinitionId"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionKey(stringQueryParameters.get("caseDefinitionKey"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionName(stringQueryParameters.get("caseDefinitionName"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionNameLike(stringQueryParameters.get("caseDefinitionNameLike"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).createdBy(stringQueryParameters.get("createdBy"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).superCaseInstanceId(stringQueryParameters.get("superCaseInstanceId"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).subCaseInstanceId(stringQueryParameters.get("subCaseInstanceId"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).superProcessInstanceId(stringQueryParameters.get("superProcessInstanceId"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).subProcessInstanceId(stringQueryParameters.get("subProcessInstanceId"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceId(stringQueryParameters.get("caseInstanceId"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    protected Map<String, Date> getCompleteCreateDateQueryParameters() {
        HashMap<String, Date> parameters = new HashMap<String, Date>();
        parameters.put("createdAfter", DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_CASE_INSTANCE_CREATED_AFTER));
        parameters.put("createdBefore", DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_CASE_INSTANCE_CREATED_BEFORE));
        return parameters;
    }

    protected void verifyCreateParameterQueryInvocations() {
        Map<String, Date> createDateParameters = this.getCompleteCreateDateQueryParameters();
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).createdBefore(createDateParameters.get("createdBefore"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).createdAfter(createDateParameters.get("createdAfter"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    protected Map<String, String> getCompleteCreateDateAsStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("createdAfter", MockProvider.EXAMPLE_HISTORIC_CASE_INSTANCE_CREATED_AFTER);
        parameters.put("createdBefore", MockProvider.EXAMPLE_HISTORIC_CASE_INSTANCE_CREATED_BEFORE);
        return parameters;
    }

    protected void verifyStringCreateParameterQueryInvocations() {
        Map<String, String> createDateParameters = this.getCompleteCreateDateAsStringQueryParameters();
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).createdBefore(DateTimeUtil.parseDate((String)createDateParameters.get("createdBefore")));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).createdAfter(DateTimeUtil.parseDate((String)createDateParameters.get("createdAfter")));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    protected Map<String, Date> getCompleteClosedDateQueryParameters() {
        HashMap<String, Date> parameters = new HashMap<String, Date>();
        parameters.put("closedAfter", DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_CASE_INSTANCE_CLOSED_AFTER));
        parameters.put("closedBefore", DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_CASE_INSTANCE_CLOSED_BEFORE));
        return parameters;
    }

    protected void verifyClosedParameterQueryInvocations() {
        Map<String, Date> closedDateParameters = this.getCompleteClosedDateQueryParameters();
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).closedAfter(closedDateParameters.get("closedAfter"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).closedBefore(closedDateParameters.get("closedBefore"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    protected Map<String, String> getCompleteClosedDateAsStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("closedAfter", MockProvider.EXAMPLE_HISTORIC_CASE_INSTANCE_CLOSED_AFTER);
        parameters.put("closedBefore", MockProvider.EXAMPLE_HISTORIC_CASE_INSTANCE_CLOSED_BEFORE);
        return parameters;
    }

    protected void verifyStringClosedParameterQueryInvocations() {
        Map<String, String> closedDateParameters = this.getCompleteClosedDateAsStringQueryParameters();
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).closedAfter(DateTimeUtil.parseDate((String)closedDateParameters.get("closedAfter")));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).closedBefore(DateTimeUtil.parseDate((String)closedDateParameters.get("closedBefore")));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    protected Map<String, Set<String>> getCompleteCaseInstanceIdSetQueryParameters() {
        HashMap<String, Set<String>> parameters = new HashMap<String, Set<String>>();
        HashSet<String> caseInstanceIds = new HashSet<String>();
        caseInstanceIds.add("firstCaseInstanceId");
        caseInstanceIds.add("secondCaseInstanceId");
        parameters.put("caseInstanceIds", caseInstanceIds);
        return parameters;
    }

    protected void verifyCaseInstanceIdSetInvocation() {
        Map<String, Set<String>> parameters = this.getCompleteCaseInstanceIdSetQueryParameters();
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceIds(parameters.get("caseInstanceIds"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    protected Map<String, List<String>> getCompleteCaseDefinitionKeyNotInListQueryParameters() {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        ArrayList<String> caseInstanceIds = new ArrayList<String>();
        caseInstanceIds.add("firstCaseInstanceKey");
        caseInstanceIds.add("secondCaseInstanceKey");
        parameters.put("caseDefinitionKeyNotIn", caseInstanceIds);
        return parameters;
    }

    protected void verifyCaseDefinitionKeyNotInListInvocation() {
        Map<String, List<String>> parameters = this.getCompleteCaseDefinitionKeyNotInListQueryParameters();
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseDefinitionKeyNotIn(parameters.get("caseDefinitionKeyNotIn"));
        ((HistoricCaseInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }
}

