/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.util.container;

import java.net.URI;
import java.util.HashMap;
import java.util.Properties;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.UriBuilder;
import org.camunda.bpm.engine.rest.util.container.EmbeddedServerBootstrap;
import org.camunda.bpm.engine.rest.util.container.JaxrsApplication;
import org.camunda.bpm.engine.rest.util.container.ServerBootstrapException;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;

public class JerseyServerBootstrap
extends EmbeddedServerBootstrap {
    protected HttpServer server;

    public JerseyServerBootstrap() {
        super(new JaxrsApplication());
    }

    public JerseyServerBootstrap(Application application) {
        super(application);
    }

    @Override
    public void stop() {
        this.server.shutdownNow();
    }

    @Override
    protected void startServerInternal() throws Exception {
        this.server.start();
    }

    @Override
    protected void setupServer(Application application) {
        ResourceConfig rc = ResourceConfig.forApplication((Application)application);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("jersey.config.server.tracing.type", "ALL");
        rc.addProperties(properties);
        Properties serverProperties = this.readProperties();
        int port = Integer.parseInt(serverProperties.getProperty("rest.http.port"));
        URI serverUri = UriBuilder.fromPath((String)"/rest-test").scheme("http").host("localhost").port(port).build(new Object[0]);
        try {
            this.server = GrizzlyHttpServerFactory.createHttpServer((URI)serverUri, (ResourceConfig)rc, (boolean)false);
        }
        catch (IllegalArgumentException e) {
            throw new ServerBootstrapException(e);
        }
        catch (NullPointerException e) {
            throw new ServerBootstrapException(e);
        }
    }
}

