/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import io.restassured.RestAssured;
import java.sql.SQLNonTransientConnectionException;
import java.util.List;
import org.apache.ibatis.exceptions.PersistenceException;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEnginePersistenceException;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.impl.util.ExceptionUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.hamcrest.Matchers;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public class NonPersistenceConnectionExceptionLoggingTest
extends AbstractRestServiceTest {
    protected static final String USER_QUERY_URL = "/rest-test/user";
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch(new String[]{"org.camunda.bpm.engine.rest.exception"});

    @Test
    public void shouldLogNonPersistenceExceptionOnWarning() {
        this.stubFailingUserQuery(new SQLNonTransientConnectionException());
        String expectedMessage = "An exception occurred in the persistence layer. Please check the server logs for a detailed message and the entire exception stack trace.";
        RestAssured.given().queryParam("firstName", new Object[]{"firstName"}).then().expect().statusCode(500).body("type", Matchers.equalTo((Object)"ProcessEnginePersistenceException"), new Object[0]).body("message", Matchers.equalTo((Object)expectedMessage), new Object[0]).body("code", Matchers.equalTo((Object)0), new Object[0]).when().get(USER_QUERY_URL, new Object[0]);
        this.verifyLogs(Level.WARN, expectedMessage);
    }

    protected void verifyLogs(Level logLevel, String message) {
        List logs = this.loggingRule.getLog();
        Assertions.assertThat((List)logs).hasSize(1);
        Assertions.assertThat((Object)((ILoggingEvent)logs.get(0)).getLevel()).isEqualTo((Object)logLevel);
        Assertions.assertThat((String)((ILoggingEvent)logs.get(0)).getMessage()).containsIgnoringCase((CharSequence)message);
    }

    protected void stubFailingUserQuery(Exception secondRootCause) {
        UserQuery result = (UserQuery)Mockito.mock(UserQuery.class);
        PersistenceException persistenceException = new PersistenceException("Failed to execute list", (Throwable)secondRootCause);
        ProcessEnginePersistenceException exception = ExceptionUtil.wrapPersistenceException((Exception)persistenceException);
        Mockito.when((Object)result.list()).thenThrow(new Throwable[]{exception});
        Mockito.when((Object)processEngine.getIdentityService().createUserQuery()).thenReturn((Object)result);
    }
}

