/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.history;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.rest.AbstractRestServiceTest;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.helper.MockProvider;
import org.camunda.bpm.engine.rest.helper.variable.EqualsPrimitiveValue;
import org.camunda.bpm.engine.rest.util.OrderingBuilder;
import org.camunda.bpm.engine.rest.util.container.TestContainerRule;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;

public class HistoricProcessInstanceRestServiceQueryTest
extends AbstractRestServiceTest {
    protected static final String QUERY_PARAM_EXECUTED_JOB_BEFORE = "executedJobBefore";
    protected static final String QUERY_PARAM_EXECUTED_JOB_AFTER = "executedJobAfter";
    protected static final String QUERY_PARAM_EXECUTED_ACTIVITY_BEFORE = "executedActivityBefore";
    protected static final String QUERY_PARAM_EXECUTED_ACTIVITY_AFTER = "executedActivityAfter";
    protected static final String QUERY_PARAM_EXECUTED_ACTIVITY_IDS = "executedActivityIdIn";
    protected static final String QUERY_PARAM_ACTIVE_ACTIVITY_IDS = "activeActivityIdIn";
    protected static final String QUERY_PARAM_INCIDENT_IDS = "incidentIdIn";
    protected static final String QUERY_PARAM_ACTIVE_OR_FAILING_ACTIVITY_IDS = "activityIdIn";
    @ClassRule
    public static TestContainerRule rule = new TestContainerRule();
    protected static final String HISTORIC_PROCESS_INSTANCE_RESOURCE_URL = "/rest-test/history/process-instance";
    protected static final String HISTORIC_PROCESS_INSTANCE_COUNT_RESOURCE_URL = "/rest-test/history/process-instance/count";
    protected HistoricProcessInstanceQuery mockedQuery;

    @Before
    public void setUpRuntimeData() {
        this.mockedQuery = this.setUpMockHistoricProcessInstanceQuery(MockProvider.createMockHistoricProcessInstances());
    }

    private HistoricProcessInstanceQuery setUpMockHistoricProcessInstanceQuery(List<HistoricProcessInstance> mockedHistoricProcessInstances) {
        HistoricProcessInstanceQuery mockedhistoricProcessInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQuery.class);
        Mockito.when((Object)mockedhistoricProcessInstanceQuery.list()).thenReturn(mockedHistoricProcessInstances);
        Mockito.when((Object)mockedhistoricProcessInstanceQuery.count()).thenReturn((Object)mockedHistoricProcessInstances.size());
        Mockito.when((Object)processEngine.getHistoryService().createHistoricProcessInstanceQuery()).thenReturn((Object)mockedhistoricProcessInstanceQuery);
        return mockedhistoricProcessInstanceQuery;
    }

    @Test
    public void testEmptyQuery() {
        String queryKey = "";
        RestAssured.given().queryParam("processDefinitionKey", new Object[]{queryKey}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testNoParametersQuery() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testNoParametersQueryAsPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockedQuery});
    }

    @Test
    public void testInvalidVariableRequests() {
        String invalidComparator = "anInvalidComparator";
        String variableName = "varName";
        String variableValue = "varValue";
        Object queryValue = variableName + "_" + invalidComparator + "_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)("Invalid variable comparator specified: " + invalidComparator)), new Object[0]).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        queryValue = "invalidFormattedVariableQuery";
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"variable query parameter has to have format KEY_OPERATOR_VALUE"), new Object[0]).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testInvalidSortingOptions() {
        this.executeAndVerifySorting("anInvalidSortByOption", "asc", Response.Status.BAD_REQUEST);
        this.executeAndVerifySorting("definitionId", "anInvalidSortOrderOption", Response.Status.BAD_REQUEST);
    }

    protected void executeAndVerifySorting(String sortBy, String sortOrder, Response.Status expectedStatus) {
        RestAssured.given().queryParam("sortBy", new Object[]{sortBy}).queryParam("sortOrder", new Object[]{sortOrder}).then().expect().statusCode(expectedStatus.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortByParameterOnly() {
        RestAssured.given().queryParam("sortBy", new Object[]{"definitionId"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortOrderParameterOnly() {
        RestAssured.given().queryParam("sortOrder", new Object[]{"asc"}).then().expect().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)InvalidRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.containsString((String)"Only a single sorting parameter specified. sortBy and sortOrder required"), new Object[0]).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
    }

    @Test
    public void testSortingParameters() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("instanceId", "asc", Response.Status.OK);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("instanceId", "desc", Response.Status.OK);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("definitionId", "asc", Response.Status.OK);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("definitionId", "desc", Response.Status.OK);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionId();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("definitionKey", "desc", Response.Status.OK);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionKey();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("definitionName", "desc", Response.Status.OK);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionName();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("definitionVersion", "desc", Response.Status.OK);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessDefinitionVersion();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("businessKey", "asc", Response.Status.OK);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceBusinessKey();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("businessKey", "desc", Response.Status.OK);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceBusinessKey();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("startTime", "asc", Response.Status.OK);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceStartTime();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("startTime", "desc", Response.Status.OK);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceStartTime();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("endTime", "asc", Response.Status.OK);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceEndTime();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("endTime", "desc", Response.Status.OK);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceEndTime();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("duration", "asc", Response.Status.OK);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceDuration();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("duration", "desc", Response.Status.OK);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceDuration();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        this.executeAndVerifySorting("tenantId", "asc", Response.Status.OK);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByTenantId();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSecondarySortingAsPost() {
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        HashMap<String, List<Map<String, Object>>> json = new HashMap<String, List<Map<String, Object>>>();
        json.put("sorting", OrderingBuilder.create().orderBy("instanceId").desc().orderBy("startTime").asc().getJson());
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceId();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).desc();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).orderByProcessInstanceStartTime();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).asc();
    }

    @Test
    public void testSuccessfulPagination() {
        int firstResult = 0;
        int maxResults = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, maxResults);
    }

    @Test
    public void testMissingFirstResultParameter() {
        int maxResults = 10;
        RestAssured.given().queryParam("maxResults", new Object[]{maxResults}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(0, maxResults);
    }

    @Test
    public void testMissingMaxResultsParameter() {
        int firstResult = 10;
        RestAssured.given().queryParam("firstResult", new Object[]{firstResult}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).listPage(firstResult, Integer.MAX_VALUE);
    }

    @Test
    public void testQueryCount() {
        RestAssured.expect().statusCode(Response.Status.OK.getStatusCode()).body("count", Matchers.equalTo((Object)1), new Object[0]).when().get(HISTORIC_PROCESS_INSTANCE_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testQueryCountForPost() {
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body("{}").then().expect().body("count", Matchers.equalTo((Object)1), new Object[0]).when().post(HISTORIC_PROCESS_INSTANCE_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
    }

    @Test
    public void testSimpleHistoricProcessQuery() {
        String processInstanceId = "aProcInstId";
        Response response = (Response)RestAssured.given().queryParam("processInstanceId", new Object[]{processInstanceId}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).processInstanceId(processInstanceId);
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one process instance returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"The returned process instance should not be null.", instances.get(0));
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("[0].id");
        String returnedProcessInstanceBusinessKey = JsonPath.from((String)content).getString("[0].businessKey");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedProcessDefinitionKey = JsonPath.from((String)content).getString("[0].processDefinitionKey");
        String returnedProcessDefinitionName = JsonPath.from((String)content).getString("[0].processDefinitionName");
        int returnedProcessDefinitionVersion = JsonPath.from((String)content).getInt("[0].processDefinitionVersion");
        String returnedStartTime = JsonPath.from((String)content).getString("[0].startTime");
        String returnedEndTime = JsonPath.from((String)content).getString("[0].endTime");
        String returnedRemovalTime = JsonPath.from((String)content).getString("[0].removalTime");
        long returnedDurationInMillis = JsonPath.from((String)content).getLong("[0].durationInMillis");
        String returnedStartUserId = JsonPath.from((String)content).getString("[0].startUserId");
        String returnedStartActivityId = JsonPath.from((String)content).getString("[0].startActivityId");
        String returnedDeleteReason = JsonPath.from((String)content).getString("[0].deleteReason");
        String returnedRootProcessInstanceId = JsonPath.from((String)content).getString("[0].rootProcessInstanceId");
        String returnedSuperProcessInstanceId = JsonPath.from((String)content).getString("[0].superProcessInstanceId");
        String returnedSuperCaseInstanceId = JsonPath.from((String)content).getString("[0].superCaseInstanceId");
        String returnedCaseInstanceId = JsonPath.from((String)content).getString("[0].caseInstanceId");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedState = JsonPath.from((String)content).getString("[0].state");
        String restartedProcessInstanceId = JsonPath.from((String)content).getString("[0].restartedProcessInstanceId");
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals((Object)"aKey", (Object)returnedProcessInstanceBusinessKey);
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId);
        Assert.assertEquals((Object)"aKey", (Object)returnedProcessDefinitionKey);
        Assert.assertEquals((Object)"aName", (Object)returnedProcessDefinitionName);
        Assert.assertEquals((long)42L, (long)returnedProcessDefinitionVersion);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_START_TIME, (Object)returnedStartTime);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_END_TIME, (Object)returnedEndTime);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_REMOVAL_TIME, (Object)returnedRemovalTime);
        Assert.assertEquals((long)2000L, (long)returnedDurationInMillis);
        Assert.assertEquals((Object)"aStartUserId", (Object)returnedStartUserId);
        Assert.assertEquals((Object)"aStartActivityId", (Object)returnedStartActivityId);
        Assert.assertEquals((Object)"aDeleteReason", (Object)returnedDeleteReason);
        Assert.assertEquals((Object)"aRootProcessInstanceId", (Object)returnedRootProcessInstanceId);
        Assert.assertEquals((Object)"aSuperProcessInstanceId", (Object)returnedSuperProcessInstanceId);
        Assert.assertEquals((Object)"aSuperCaseInstanceId", (Object)returnedSuperCaseInstanceId);
        Assert.assertEquals((Object)"aCaseInstanceId", (Object)returnedCaseInstanceId);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId);
        Assert.assertEquals((Object)"aState", (Object)returnedState);
        Assert.assertEquals((Object)"aProcInstId", (Object)restartedProcessInstanceId);
    }

    @Test
    public void testGetHistoryProcessInstancesForRootProcessInstanceId() {
        Response response = (Response)RestAssured.given().queryParam("rootProcessInstanceId", new Object[]{"aRootProcessInstanceId"}).header("accept", (Object)"application/json", new Object[0]).then().expect().statusCode(Response.Status.OK.getStatusCode()).contentType(ContentType.JSON).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)instances).size().isGreaterThan(0);
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("[0].id");
        String returnedProcessInstanceBusinessKey = JsonPath.from((String)content).getString("[0].businessKey");
        String returnedProcessDefinitionId = JsonPath.from((String)content).getString("[0].processDefinitionId");
        String returnedProcessDefinitionKey = JsonPath.from((String)content).getString("[0].processDefinitionKey");
        String returnedProcessDefinitionName = JsonPath.from((String)content).getString("[0].processDefinitionName");
        int returnedProcessDefinitionVersion = JsonPath.from((String)content).getInt("[0].processDefinitionVersion");
        String returnedStartTime = JsonPath.from((String)content).getString("[0].startTime");
        String returnedEndTime = JsonPath.from((String)content).getString("[0].endTime");
        String returnedRemovalTime = JsonPath.from((String)content).getString("[0].removalTime");
        long returnedDurationInMillis = JsonPath.from((String)content).getLong("[0].durationInMillis");
        String returnedStartUserId = JsonPath.from((String)content).getString("[0].startUserId");
        String returnedStartActivityId = JsonPath.from((String)content).getString("[0].startActivityId");
        String returnedDeleteReason = JsonPath.from((String)content).getString("[0].deleteReason");
        String returnedRootProcessInstanceId = JsonPath.from((String)content).getString("[0].rootProcessInstanceId");
        String returnedSuperProcessInstanceId = JsonPath.from((String)content).getString("[0].superProcessInstanceId");
        String returnedSuperCaseInstanceId = JsonPath.from((String)content).getString("[0].superCaseInstanceId");
        String returnedCaseInstanceId = JsonPath.from((String)content).getString("[0].caseInstanceId");
        String returnedTenantId = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedState = JsonPath.from((String)content).getString("[0].state");
        String restartedProcessInstanceId = JsonPath.from((String)content).getString("[0].restartedProcessInstanceId");
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals((Object)"aKey", (Object)returnedProcessInstanceBusinessKey);
        Assert.assertEquals((Object)"aProcDefId", (Object)returnedProcessDefinitionId);
        Assert.assertEquals((Object)"aKey", (Object)returnedProcessDefinitionKey);
        Assert.assertEquals((Object)"aName", (Object)returnedProcessDefinitionName);
        Assert.assertEquals((long)42L, (long)returnedProcessDefinitionVersion);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_START_TIME, (Object)returnedStartTime);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_END_TIME, (Object)returnedEndTime);
        Assert.assertEquals((Object)MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_REMOVAL_TIME, (Object)returnedRemovalTime);
        Assert.assertEquals((long)2000L, (long)returnedDurationInMillis);
        Assert.assertEquals((Object)"aStartUserId", (Object)returnedStartUserId);
        Assert.assertEquals((Object)"aStartActivityId", (Object)returnedStartActivityId);
        Assert.assertEquals((Object)"aDeleteReason", (Object)returnedDeleteReason);
        Assert.assertEquals((Object)"aRootProcessInstanceId", (Object)returnedRootProcessInstanceId);
        Assert.assertEquals((Object)"aSuperProcessInstanceId", (Object)returnedSuperProcessInstanceId);
        Assert.assertEquals((Object)"aSuperCaseInstanceId", (Object)returnedSuperCaseInstanceId);
        Assert.assertEquals((Object)"aCaseInstanceId", (Object)returnedCaseInstanceId);
        Assert.assertEquals((Object)"aTenantId", (Object)returnedTenantId);
        Assert.assertEquals((Object)"aState", (Object)returnedState);
        Assert.assertEquals((Object)"aProcInstId", (Object)restartedProcessInstanceId);
    }

    @Test
    public void testAdditionalParametersExcludingProcesses() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        RestAssured.given().queryParams(stringQueryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStringParameterQueryInvocations();
    }

    @Test
    public void testAdditionalParametersExcludingProcessesAsPost() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(stringQueryParameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStringParameterQueryInvocations();
    }

    private Map<String, String> getCompleteStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("processInstanceId", "aProcInstId");
        parameters.put("processInstanceBusinessKey", "aKey");
        parameters.put("processInstanceBusinessKeyLike", "aKeyLike");
        parameters.put("processDefinitionId", "aProcDefId");
        parameters.put("processDefinitionKey", "aKey");
        parameters.put("processDefinitionName", "aName");
        parameters.put("processDefinitionNameLike", "aNameLike");
        parameters.put("startedBy", "startedBySomeone");
        parameters.put("superProcessInstanceId", "aSuperProcessInstanceId");
        parameters.put("subProcessInstanceId", "aSubProcessInstanceId");
        parameters.put("superCaseInstanceId", "aSuperCaseInstanceId");
        parameters.put("subCaseInstanceId", "aSubCaseInstanceId");
        parameters.put("caseInstanceId", "aCaseInstanceId");
        parameters.put("state", "aState");
        parameters.put("incidentType", "anIncidentType");
        parameters.put("rootProcessInstanceId", "aRootProcessInstanceId");
        return parameters;
    }

    private void verifyStringParameterQueryInvocations() {
        Map<String, String> stringQueryParameters = this.getCompleteStringQueryParameters();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceId(stringQueryParameters.get("processInstanceId"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceBusinessKey(stringQueryParameters.get("processInstanceBusinessKey"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceBusinessKeyLike(stringQueryParameters.get("processInstanceBusinessKeyLike"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionId(stringQueryParameters.get("processDefinitionId"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKey(stringQueryParameters.get("processDefinitionKey"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionName(stringQueryParameters.get("processDefinitionName"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionNameLike(stringQueryParameters.get("processDefinitionNameLike"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).startedBy(stringQueryParameters.get("startedBy"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).superProcessInstanceId(stringQueryParameters.get("superProcessInstanceId"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).subProcessInstanceId(stringQueryParameters.get("subProcessInstanceId"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).superCaseInstanceId(stringQueryParameters.get("superCaseInstanceId"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).subCaseInstanceId(stringQueryParameters.get("subCaseInstanceId"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).caseInstanceId(stringQueryParameters.get("caseInstanceId"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).incidentType(stringQueryParameters.get("incidentType"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).rootProcessInstanceId(stringQueryParameters.get("rootProcessInstanceId"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testHistoricBeforeAndAfterStartTimeQuery() {
        RestAssured.given().queryParam("startedBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_BEFORE}).queryParam("startedAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_AFTER}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStartParameterQueryInvocations();
    }

    @Test
    public void testHistoricBeforeAndAfterStartTimeQueryAsPost() {
        Map<String, Date> parameters = this.getCompleteStartDateQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStartParameterQueryInvocations();
    }

    @Test
    public void testHistoricBeforeAndAfterStartTimeAsStringQueryAsPost() {
        Map<String, String> parameters = this.getCompleteStartDateAsStringQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStringStartParameterQueryInvocations();
    }

    private Map<String, Date> getCompleteStartDateQueryParameters() {
        HashMap<String, Date> parameters = new HashMap<String, Date>();
        parameters.put("startedAfter", DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_AFTER));
        parameters.put("startedBefore", DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_BEFORE));
        return parameters;
    }

    private Map<String, String> getCompleteStartDateAsStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("startedAfter", MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_AFTER);
        parameters.put("startedBefore", MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_BEFORE);
        return parameters;
    }

    private void verifyStartParameterQueryInvocations() {
        Map<String, Date> startDateParameters = this.getCompleteStartDateQueryParameters();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).startedBefore(startDateParameters.get("startedBefore"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).startedAfter(startDateParameters.get("startedAfter"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    private void verifyStringStartParameterQueryInvocations() {
        Map<String, String> startDateParameters = this.getCompleteStartDateAsStringQueryParameters();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).startedBefore(DateTimeUtil.parseDate((String)startDateParameters.get("startedBefore")));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).startedAfter(DateTimeUtil.parseDate((String)startDateParameters.get("startedAfter")));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testHistoricAfterAndBeforeFinishTimeQuery() {
        RestAssured.given().queryParam("finishedAfter", new Object[]{MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_FINISHED_AFTER}).queryParam("finishedBefore", new Object[]{MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_FINISHED_BEFORE}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyFinishedParameterQueryInvocations();
    }

    @Test
    public void testHistoricAfterAndBeforeFinishTimeQueryAsPost() {
        Map<String, Date> parameters = this.getCompleteFinishedDateQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyFinishedParameterQueryInvocations();
    }

    @Test
    public void testHistoricAfterAndBeforeFinishTimeAsStringQueryAsPost() {
        Map<String, String> parameters = this.getCompleteFinishedDateAsStringQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStringFinishedParameterQueryInvocations();
    }

    private Map<String, Date> getCompleteFinishedDateQueryParameters() {
        HashMap<String, Date> parameters = new HashMap<String, Date>();
        parameters.put("finishedAfter", DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_FINISHED_AFTER));
        parameters.put("finishedBefore", DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_FINISHED_BEFORE));
        return parameters;
    }

    private Map<String, String> getCompleteFinishedDateAsStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("finishedAfter", MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_FINISHED_AFTER);
        parameters.put("finishedBefore", MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_FINISHED_BEFORE);
        return parameters;
    }

    private void verifyFinishedParameterQueryInvocations() {
        Map<String, Date> finishedDateParameters = this.getCompleteFinishedDateQueryParameters();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).finishedAfter(finishedDateParameters.get("finishedAfter"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).finishedBefore(finishedDateParameters.get("finishedBefore"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    private void verifyStringFinishedParameterQueryInvocations() {
        Map<String, String> finishedDateParameters = this.getCompleteFinishedDateAsStringQueryParameters();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).finishedAfter(DateTimeUtil.parseDate((String)finishedDateParameters.get("finishedAfter")));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).finishedBefore(DateTimeUtil.parseDate((String)finishedDateParameters.get("finishedBefore")));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testProcessQueryFinished() {
        RestAssured.given().queryParam("finished", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).finished();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testProcessQueryFinishedAsPost() {
        HashMap<String, Boolean> body = new HashMap<String, Boolean>();
        body.put("finished", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).finished();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testProcessQueryUnfinished() {
        List<HistoricProcessInstance> mockedHistoricProcessInstances = MockProvider.createMockRunningHistoricProcessInstances();
        HistoricProcessInstanceQuery mockedhistoricProcessInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQuery.class);
        Mockito.when((Object)mockedhistoricProcessInstanceQuery.list()).thenReturn(mockedHistoricProcessInstances);
        Mockito.when((Object)processEngine.getHistoryService().createHistoricProcessInstanceQuery()).thenReturn((Object)mockedhistoricProcessInstanceQuery);
        Response response = (Response)RestAssured.given().queryParam("unfinished", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockedhistoricProcessInstanceQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)mockedhistoricProcessInstanceQuery)).unfinished();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)mockedhistoricProcessInstanceQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one process instance returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"The returned process instance should not be null.", instances.get(0));
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("[0].id");
        String returnedEndTime = JsonPath.from((String)content).getString("[0].endTime");
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals(null, (Object)returnedEndTime);
    }

    @Test
    public void testProcessQueryUnfinishedAsPost() {
        List<HistoricProcessInstance> mockedHistoricProcessInstances = MockProvider.createMockRunningHistoricProcessInstances();
        HistoricProcessInstanceQuery mockedhistoricProcessInstanceQuery = (HistoricProcessInstanceQuery)Mockito.mock(HistoricProcessInstanceQuery.class);
        Mockito.when((Object)mockedhistoricProcessInstanceQuery.list()).thenReturn(mockedHistoricProcessInstances);
        Mockito.when((Object)processEngine.getHistoryService().createHistoricProcessInstanceQuery()).thenReturn((Object)mockedhistoricProcessInstanceQuery);
        HashMap<String, Boolean> body = new HashMap<String, Boolean>();
        body.put("unfinished", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockedhistoricProcessInstanceQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)mockedhistoricProcessInstanceQuery)).unfinished();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)mockedhistoricProcessInstanceQuery)).list();
        String content = response.asString();
        List instances = JsonPath.from((String)content).getList("");
        Assert.assertEquals((String)"There should be one process instance returned.", (long)1L, (long)instances.size());
        Assert.assertNotNull((String)"The returned process instance should not be null.", instances.get(0));
        String returnedProcessInstanceId = JsonPath.from((String)content).getString("[0].id");
        String returnedEndTime = JsonPath.from((String)content).getString("[0].endTime");
        Assert.assertEquals((Object)"aProcInstId", (Object)returnedProcessInstanceId);
        Assert.assertEquals(null, (Object)returnedEndTime);
    }

    @Test
    public void testQueryWithJobsRetrying() {
        RestAssured.given().queryParam("withJobsRetrying", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).withJobsRetrying();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryWithJobsRetryingAsPost() {
        HashMap<String, Boolean> body = new HashMap<String, Boolean>();
        body.put("withJobsRetrying", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).withJobsRetrying();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryWithIncidents() {
        RestAssured.given().queryParam("withIncidents", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).withIncidents();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryWithIncidentsAsPost() {
        HashMap<String, Boolean> body = new HashMap<String, Boolean>();
        body.put("withIncidents", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).withIncidents();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryWithIncidentStatusOpen() {
        RestAssured.given().queryParam("incidentStatus", new Object[]{"open"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).incidentStatus("open");
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryWithIncidentStatusOpenAsPost() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("incidentStatus", "open");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).incidentStatus("open");
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryCountIncidentStatusOpenForPost() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("incidentStatus", "open");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(body).then().expect().body("count", Matchers.equalTo((Object)1), new Object[0]).when().post(HISTORIC_PROCESS_INSTANCE_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).incidentStatus("open");
    }

    @Test
    public void testQueryWithIncidentStatusResolved() {
        RestAssured.given().queryParam("incidentStatus", new Object[]{"resolved"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).incidentStatus("resolved");
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryWithIncidentStatusResolvedAsPost() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("incidentStatus", "resolved");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).incidentStatus("resolved");
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryCountIncidentStatusResolvedForPost() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("incidentStatus", "resolved");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(body).then().expect().body("count", Matchers.equalTo((Object)1), new Object[0]).when().post(HISTORIC_PROCESS_INSTANCE_COUNT_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).count();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).incidentStatus("resolved");
    }

    @Test
    public void testQueryIncidentType() {
        RestAssured.given().queryParam("incidentType", new Object[]{"anIncidentType"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).incidentType("anIncidentType");
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryIncidentTypeAsPost() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("incidentType", "anIncidentType");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).incidentType("anIncidentType");
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryIncidentMessage() {
        RestAssured.given().queryParam("incidentMessage", new Object[]{"anIncidentMessage"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).incidentMessage("anIncidentMessage");
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryIncidentMessageAsPost() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("incidentMessage", "anIncidentMessage");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).incidentMessage("anIncidentMessage");
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryIncidentMessageLike() {
        RestAssured.given().queryParam("incidentMessageLike", new Object[]{"%anIncidentMessageLike%"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).incidentMessageLike("%anIncidentMessageLike%");
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryIncidentMessageLikeAsPost() {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("incidentMessageLike", "%anIncidentMessageLike%");
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(body).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).incidentMessageLike("%anIncidentMessageLike%");
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryByProcessInstanceIds() {
        RestAssured.given().queryParam("processInstanceIds", new Object[]{"firstProcessInstanceId,secondProcessInstanceId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyProcessInstanceIdSetInvocation();
    }

    @Test
    public void testQueryByProcessInstanceIdsAsPost() {
        Map<String, Set<String>> parameters = this.getCompleteProcessInstanceIdSetQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyProcessInstanceIdSetInvocation();
    }

    private Map<String, Set<String>> getCompleteProcessInstanceIdSetQueryParameters() {
        HashMap<String, Set<String>> parameters = new HashMap<String, Set<String>>();
        HashSet<String> processInstanceIds = new HashSet<String>();
        processInstanceIds.add("firstProcessInstanceId");
        processInstanceIds.add("secondProcessInstanceId");
        parameters.put("processInstanceIds", processInstanceIds);
        return parameters;
    }

    private void verifyProcessInstanceIdSetInvocation() {
        Map<String, Set<String>> parameters = this.getCompleteProcessInstanceIdSetQueryParameters();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceIds(parameters.get("processInstanceIds"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryByProcessInstanceIdNotIn() {
        RestAssured.given().queryParam("processInstanceIdNotIn", new Object[]{"firstProcessInstanceId,secondProcessInstanceId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceIdNotIn(new String[]{"firstProcessInstanceId", "secondProcessInstanceId"});
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryByProcessInstanceIdNotInAsPost() {
        HashMap parameters = new HashMap();
        HashSet<String> processInstanceIds = new HashSet<String>();
        processInstanceIds.add("firstProcessInstanceId");
        processInstanceIds.add("secondProcessInstanceId");
        parameters.put("processInstanceIdNotIn", processInstanceIds);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceIdNotIn(new String[]{"firstProcessInstanceId", "secondProcessInstanceId"});
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryByProcessDefinitionKeyNotIn() {
        RestAssured.given().queryParam("processDefinitionKeyNotIn", new Object[]{"firstProcessInstanceKey,secondProcessInstanceKey"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyProcessDefinitionKeyNotInListInvocation();
    }

    @Test
    public void testQueryByProcessDefinitionKeyNotInAsPost() {
        Map<String, List<String>> parameters = this.getCompleteProcessDefinitionKeyNotInListQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyProcessDefinitionKeyNotInListInvocation();
    }

    private Map<String, List<String>> getCompleteProcessDefinitionKeyNotInListQueryParameters() {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        processInstanceIds.add("firstProcessInstanceKey");
        processInstanceIds.add("secondProcessInstanceKey");
        parameters.put("processDefinitionKeyNotIn", processInstanceIds);
        return parameters;
    }

    private void verifyProcessDefinitionKeyNotInListInvocation() {
        Map<String, List<String>> parameters = this.getCompleteProcessDefinitionKeyNotInListQueryParameters();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKeyNotIn(parameters.get("processDefinitionKeyNotIn"));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void shouldQueryByBusinessKeyIn() {
        RestAssured.given().queryParam("processInstanceBusinessKeyIn", new Object[]{"business-key-one,business-key-two"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyBusinessKeyInListInvocation();
    }

    @Test
    public void shouldQueryByBusinessKeyInAsPost() {
        Map<String, List<String>> parameters = this.getCompleteBusinessKeyInListQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyBusinessKeyInListInvocation();
    }

    protected Map<String, List<String>> getCompleteBusinessKeyInListQueryParameters() {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        ArrayList<String> processInstanceBusinessKeys = new ArrayList<String>();
        processInstanceBusinessKeys.add("business-key-one");
        processInstanceBusinessKeys.add("business-key-two");
        parameters.put("processInstanceBusinessKeyIn", processInstanceBusinessKeys);
        return parameters;
    }

    protected void verifyBusinessKeyInListInvocation() {
        Map<String, List<String>> parameters = this.getCompleteBusinessKeyInListQueryParameters();
        List<String> value = parameters.get("processInstanceBusinessKeyIn");
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processInstanceBusinessKeyIn(value.toArray(new String[0]));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryByProcessDefinitionKeyIn() {
        RestAssured.given().queryParam("processDefinitionKeyIn", new Object[]{"firstProcessDefinitionKey,secondProcessDefinitionKey"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyProcessDefinitionKeyInListInvocation();
    }

    @Test
    public void testQueryByProcessDefinitionKeyInAsPost() {
        Map<String, List<String>> parameters = this.getCompleteProcessDefinitionKeyInListQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyProcessDefinitionKeyInListInvocation();
    }

    private Map<String, List<String>> getCompleteProcessDefinitionKeyInListQueryParameters() {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        processInstanceIds.add("firstProcessDefinitionKey");
        processInstanceIds.add("secondProcessDefinitionKey");
        parameters.put("processDefinitionKeyIn", processInstanceIds);
        return parameters;
    }

    private void verifyProcessDefinitionKeyInListInvocation() {
        Map<String, List<String>> parameters = this.getCompleteProcessDefinitionKeyInListQueryParameters();
        List<String> value = parameters.get("processDefinitionKeyIn");
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).processDefinitionKeyIn(value.toArray(new String[value.size()]));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testVariableValueEquals() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValueGreaterThan() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_gt_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThan(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValueGreaterThanEquals() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_gteq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThanOrEqual(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValueLessThan() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_lt_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThan(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValueLessThanEquals() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_lteq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThanOrEqual(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValueLike() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike(variableName, variableValue);
    }

    @Test
    public void testVariableValueNotEquals() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName, (Object)variableValue);
    }

    @Test
    public void testVariableValuesEqualsIgnoreCase() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
    }

    @Test
    public void testVariableValuesNotEqualsIgnoreCase() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName, (Object)variableValue);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
    }

    @Test
    public void testVariableValuesLikeIgnoreCase() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_like_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).queryParam("variableValuesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike(variableName, variableValue);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
    }

    @Test
    public void testVariableNamesEqualsIgnoreCase() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_eq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).queryParam("variableNamesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
    }

    @Test
    public void testVariableNamesNotEqualsIgnoreCase() {
        String variableName = "varName";
        String variableValue = "varValue";
        String queryValue = variableName + "_neq_" + variableValue;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).queryParam("variableNamesIgnoreCase", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName, (Object)variableValue);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
    }

    @Test
    public void testVariableValueEqualsAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "eq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals("varName", (Object)"varValue");
    }

    @Test
    public void testVariableValueGreaterThanAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "gt");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThan("varName", (Object)"varValue");
    }

    @Test
    public void testVariableValueGreaterThanEqualsAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "gteq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueGreaterThanOrEqual("varName", (Object)"varValue");
    }

    @Test
    public void testVariableValueLessThanAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "lt");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThan("varName", (Object)"varValue");
    }

    @Test
    public void testVariableValueLessThanEqualsAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "lteq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLessThanOrEqual("varName", (Object)"varValue");
    }

    @Test
    public void testVariableValueLikeAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "like");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike("varName", "varValue");
    }

    @Test
    public void testVariableValueNotEqualsAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "neq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, ArrayList<HashMap<String, String>>> json = new HashMap<String, ArrayList<HashMap<String, String>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals("varName", (Object)"varValue");
    }

    @Test
    public void testVariableValuesEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "eq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variables", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals("varName", (Object)"varValue");
    }

    @Test
    public void testVariableValuesNotEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "neq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variables", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals("varName", (Object)"varValue");
    }

    @Test
    public void testVariableValuesLikeIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "like");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variables", variables);
        json.put("variableValuesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableValuesIgnoreCase();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueLike("varName", "varValue");
    }

    @Test
    public void testVariableNamesEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "eq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variables", variables);
        json.put("variableNamesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals("varName", (Object)"varValue");
    }

    @Test
    public void testVariableNamesNotEqualsIgnoreCaseAsPost() {
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", "varName");
        variableJson.put("value", "varValue");
        variableJson.put("operator", "neq");
        ArrayList<HashMap<String, String>> variables = new ArrayList<HashMap<String, String>>();
        variables.add(variableJson);
        HashMap<String, Serializable> json = new HashMap<String, Serializable>();
        json.put("variables", variables);
        json.put("variableNamesIgnoreCase", Boolean.valueOf(true));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).matchVariableNamesIgnoreCase();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals("varName", (Object)"varValue");
    }

    @Test
    public void testMultipleVariableParameters() {
        String variableName1 = "varName";
        String variableValue1 = "varValue";
        String variableParameter1 = variableName1 + "_eq_" + variableValue1;
        String variableName2 = "anotherVarName";
        String variableValue2 = "anotherVarValue";
        String variableParameter2 = variableName2 + "_neq_" + variableValue2;
        String queryValue = variableParameter1 + "," + variableParameter2;
        RestAssured.given().queryParam("variables", new Object[]{queryValue}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName1, (Object)variableValue1);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals(variableName2, (Object)variableValue2);
    }

    @Test
    public void testMultipleVariableParametersAsPost() {
        String variableName = "varName";
        String variableValue = "varValue";
        String anotherVariableName = "anotherVarName";
        Integer anotherVariableValue = 30;
        HashMap<String, String> variableJson = new HashMap<String, String>();
        variableJson.put("name", variableName);
        variableJson.put("operator", "eq");
        variableJson.put("value", variableValue);
        HashMap<String, Object> anotherVariableJson = new HashMap<String, Object>();
        anotherVariableJson.put("name", anotherVariableName);
        anotherVariableJson.put("operator", "neq");
        anotherVariableJson.put("value", anotherVariableValue);
        ArrayList<HashMap<String, Object>> variables = new ArrayList<HashMap<String, Object>>();
        variables.add(variableJson);
        variables.add(anotherVariableJson);
        HashMap<String, ArrayList<HashMap<String, Object>>> json = new HashMap<String, ArrayList<HashMap<String, Object>>>();
        json.put("variables", variables);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(json).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueEquals(variableName, (Object)variableValue);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).variableValueNotEquals((String)Mockito.eq((Object)anotherVariableName), MockitoHamcrest.argThat((Matcher)EqualsPrimitiveValue.numberValue(anotherVariableValue)));
    }

    @Test
    public void testTenantIdListParameter() {
        this.mockedQuery = this.setUpMockHistoricProcessInstanceQuery(this.createMockHistoricProcessInstancesTwoTenants());
        Response response = (Response)RestAssured.given().queryParam("tenantIdIn", new Object[]{"aTenantId,anotherTenantId"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)executions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testTenantIdListPostParameter() {
        this.mockedQuery = this.setUpMockHistoricProcessInstanceQuery(this.createMockHistoricProcessInstancesTwoTenants());
        HashMap<String, String[]> queryParameters = new HashMap<String, String[]>();
        queryParameters.put("tenantIdIn", "aTenantId,anotherTenantId".split(","));
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).tenantIdIn(new String[]{"aTenantId", "anotherTenantId"});
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List executions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)executions).hasSize(2);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        String returnedTenantId2 = JsonPath.from((String)content).getString("[1].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo((Object)"aTenantId");
        Assertions.assertThat((String)returnedTenantId2).isEqualTo((Object)"anotherTenantId");
    }

    @Test
    public void testWithoutTenantIdParameter() {
        this.mockedQuery = this.setUpMockHistoricProcessInstanceQuery(Collections.singletonList(MockProvider.createMockHistoricProcessInstance(null)));
        Response response = (Response)RestAssured.given().queryParam("withoutTenantId", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
    }

    @Test
    public void testWithoutTenantIdPostParameter() {
        this.mockedQuery = this.setUpMockHistoricProcessInstanceQuery(Collections.singletonList(MockProvider.createMockHistoricProcessInstance(null)));
        HashMap<String, Boolean> queryParameters = new HashMap<String, Boolean>();
        queryParameters.put("withoutTenantId", true);
        Response response = (Response)RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(queryParameters).expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withoutTenantId();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
        String content = response.asString();
        List definitions = JsonPath.from((String)content).getList("");
        Assertions.assertThat((List)definitions).hasSize(1);
        String returnedTenantId1 = JsonPath.from((String)content).getString("[0].tenantId");
        Assertions.assertThat((String)returnedTenantId1).isEqualTo(null);
    }

    private List<HistoricProcessInstance> createMockHistoricProcessInstancesTwoTenants() {
        return Arrays.asList(MockProvider.createMockHistoricProcessInstance("aTenantId"), MockProvider.createMockHistoricProcessInstance("anotherTenantId"));
    }

    @Test
    public void testExecutedActivityBeforeAndAfterTimeQuery() {
        RestAssured.given().queryParam(QUERY_PARAM_EXECUTED_ACTIVITY_BEFORE, new Object[]{MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_BEFORE}).queryParam(QUERY_PARAM_EXECUTED_ACTIVITY_AFTER, new Object[]{MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_AFTER}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyExecutedActivityParameterQueryInvocations();
    }

    @Test
    public void testExecutedActivityBeforeAndAfterTimeQueryAsPost() {
        Map<String, Date> parameters = this.getCompleteExecutedActivityDateQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyExecutedActivityParameterQueryInvocations();
    }

    @Test
    public void testExecutedActivityBeforeAndAfterTimeAsStringQueryAsPost() {
        Map<String, String> parameters = this.getCompleteExecutedActivityDateAsStringQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStringExecutedActivityParameterQueryInvocations();
    }

    private void verifyExecutedActivityParameterQueryInvocations() {
        Map<String, Date> startDateParameters = this.getCompleteExecutedActivityDateQueryParameters();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executedActivityBefore(startDateParameters.get(QUERY_PARAM_EXECUTED_ACTIVITY_BEFORE));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executedActivityAfter(startDateParameters.get(QUERY_PARAM_EXECUTED_ACTIVITY_AFTER));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    private void verifyStringExecutedActivityParameterQueryInvocations() {
        Map<String, String> startDateParameters = this.getCompleteExecutedActivityDateAsStringQueryParameters();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executedActivityBefore(DateTimeUtil.parseDate((String)startDateParameters.get(QUERY_PARAM_EXECUTED_ACTIVITY_BEFORE)));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executedActivityAfter(DateTimeUtil.parseDate((String)startDateParameters.get(QUERY_PARAM_EXECUTED_ACTIVITY_AFTER)));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    private Map<String, Date> getCompleteExecutedActivityDateQueryParameters() {
        HashMap<String, Date> parameters = new HashMap<String, Date>();
        parameters.put(QUERY_PARAM_EXECUTED_ACTIVITY_BEFORE, DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_BEFORE));
        parameters.put(QUERY_PARAM_EXECUTED_ACTIVITY_AFTER, DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_AFTER));
        return parameters;
    }

    private Map<String, String> getCompleteExecutedActivityDateAsStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(QUERY_PARAM_EXECUTED_ACTIVITY_AFTER, MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_AFTER);
        parameters.put(QUERY_PARAM_EXECUTED_ACTIVITY_BEFORE, MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_BEFORE);
        return parameters;
    }

    @Test
    public void testExecutedJobBeforeAndAfterTimeQuery() {
        RestAssured.given().queryParam(QUERY_PARAM_EXECUTED_JOB_BEFORE, new Object[]{MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_BEFORE}).queryParam(QUERY_PARAM_EXECUTED_JOB_AFTER, new Object[]{MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_AFTER}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyExecutedJobParameterQueryInvocations();
    }

    @Test
    public void testExecutedJobBeforeAndAfterTimeQueryAsPost() {
        Map<String, Date> parameters = this.getCompleteExecutedJobDateQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyExecutedJobParameterQueryInvocations();
    }

    @Test
    public void testExecutedJobBeforeAndAfterTimeAsStringQueryAsPost() {
        Map<String, String> parameters = this.getCompleteExecutedJobDateAsStringQueryParameters();
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        this.verifyStringExecutedJobParameterQueryInvocations();
    }

    @Test
    public void testExecutedActivityIdIn() {
        RestAssured.given().queryParam(QUERY_PARAM_EXECUTED_ACTIVITY_IDS, new Object[]{"1,2"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executedActivityIdIn(new String[]{"1", "2"});
    }

    @Test
    public void testExecutedActivityIdInAsPost() {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put(QUERY_PARAM_EXECUTED_ACTIVITY_IDS, Arrays.asList("1", "2"));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executedActivityIdIn(new String[]{"1", "2"});
    }

    @Test
    public void testActiveActivityIdIn() {
        RestAssured.given().queryParam(QUERY_PARAM_ACTIVE_ACTIVITY_IDS, new Object[]{"1,2"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activeActivityIdIn(new String[]{"1", "2"});
    }

    @Test
    public void testActiveActivityIdInAsPost() {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put(QUERY_PARAM_ACTIVE_ACTIVITY_IDS, Arrays.asList("1", "2"));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activeActivityIdIn(new String[]{"1", "2"});
    }

    @Test
    public void testQueryWithRootIncidents() {
        RestAssured.given().queryParam("withRootIncidents", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockedQuery});
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).withRootIncidents();
        ((HistoricProcessInstanceQuery)inOrder.verify((Object)this.mockedQuery)).list();
    }

    @Test
    public void testQueryWithRootIncidentsAsPost() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("withRootIncidents", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).withRootIncidents();
    }

    private void verifyExecutedJobParameterQueryInvocations() {
        Map<String, Date> startDateParameters = this.getCompleteExecutedJobDateQueryParameters();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executedJobBefore(startDateParameters.get(QUERY_PARAM_EXECUTED_JOB_BEFORE));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executedJobAfter(startDateParameters.get(QUERY_PARAM_EXECUTED_JOB_AFTER));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    private void verifyStringExecutedJobParameterQueryInvocations() {
        Map<String, String> startDateParameters = this.getCompleteExecutedJobDateAsStringQueryParameters();
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executedJobBefore(DateTimeUtil.parseDate((String)startDateParameters.get(QUERY_PARAM_EXECUTED_JOB_BEFORE)));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).executedJobAfter(DateTimeUtil.parseDate((String)startDateParameters.get(QUERY_PARAM_EXECUTED_JOB_AFTER)));
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).list();
    }

    private Map<String, Date> getCompleteExecutedJobDateQueryParameters() {
        HashMap<String, Date> parameters = new HashMap<String, Date>();
        parameters.put(QUERY_PARAM_EXECUTED_JOB_BEFORE, DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_BEFORE));
        parameters.put(QUERY_PARAM_EXECUTED_JOB_AFTER, DateTimeUtil.parseDate((String)MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_AFTER));
        return parameters;
    }

    private Map<String, String> getCompleteExecutedJobDateAsStringQueryParameters() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(QUERY_PARAM_EXECUTED_JOB_AFTER, MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_AFTER);
        parameters.put(QUERY_PARAM_EXECUTED_JOB_BEFORE, MockProvider.EXAMPLE_HISTORIC_PROCESS_INSTANCE_STARTED_BEFORE);
        return parameters;
    }

    @Test
    public void testQueryByActive() {
        RestAssured.given().queryParam("active", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).active();
    }

    @Test
    public void testQueryByCompleted() {
        RestAssured.given().queryParam("completed", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).completed();
    }

    @Test
    public void testQueryBySuspended() {
        RestAssured.given().queryParam("suspended", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).suspended();
    }

    @Test
    public void testQueryByExternallyTerminated() {
        RestAssured.given().queryParam("externallyTerminated", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).externallyTerminated();
    }

    @Test
    public void testQueryByInternallyTerminated() {
        RestAssured.given().queryParam("internallyTerminated", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).internallyTerminated();
    }

    @Test
    public void testQueryByTwoStates() {
        String message = "expected exception";
        ((HistoricProcessInstanceQuery)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException(message)}).when((Object)this.mockedQuery)).completed();
        RestAssured.given().queryParam("active", new Object[]{true}).queryParam("completed", new Object[]{true}).then().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)BadUserRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).active();
    }

    @Test
    public void testQueryByActiveAsPost() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("active", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).active();
    }

    @Test
    public void testQueryByCompletedAsPost() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("completed", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).completed();
    }

    @Test
    public void testQueryBySuspendedAsPost() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("suspended", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).suspended();
    }

    @Test
    public void testQueryByExternallyTerminatedAsPost() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("externallyTerminated", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).externallyTerminated();
    }

    @Test
    public void testQueryByInternallyTerminatedAsPost() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("internallyTerminated", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).internallyTerminated();
    }

    @Test
    public void testQueryByTwoStatesAsPost() {
        String message = "expected exception";
        ((HistoricProcessInstanceQuery)Mockito.doThrow((Throwable[])new Throwable[]{new BadUserRequestException(message)}).when((Object)this.mockedQuery)).completed();
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("active", true);
        parameters.put("completed", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().statusCode(Response.Status.BAD_REQUEST.getStatusCode()).contentType(ContentType.JSON).body("type", Matchers.equalTo((Object)BadUserRequestException.class.getSimpleName()), new Object[0]).body("message", Matchers.equalTo((Object)message), new Object[0]).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).active();
    }

    @Test
    public void testQueryByRootProcessInstances() {
        RestAssured.given().queryParam("rootProcessInstances", new Object[]{true}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).rootProcessInstances();
    }

    @Test
    public void testQueryByRootProcessInstancesAsPost() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("rootProcessInstances", true);
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).rootProcessInstances();
    }

    @Test
    public void testQueryByIncidentIdIn() {
        RestAssured.given().queryParam(QUERY_PARAM_INCIDENT_IDS, new Object[]{"1,2"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).incidentIdIn(new String[]{"1", "2"});
    }

    @Test
    public void testQueryByIncidentIdInAsPost() {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put(QUERY_PARAM_INCIDENT_IDS, Arrays.asList("1", "2"));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).incidentIdIn(new String[]{"1", "2"});
    }

    @Test
    public void testQueryByActivityIdIn() {
        RestAssured.given().queryParam(QUERY_PARAM_ACTIVE_OR_FAILING_ACTIVITY_IDS, new Object[]{"1,2"}).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().get(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityIdIn(new String[]{"1", "2"});
    }

    @Test
    public void testQueryByActivityIdInAsPost() {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put(QUERY_PARAM_ACTIVE_OR_FAILING_ACTIVITY_IDS, Arrays.asList("1", "2"));
        RestAssured.given().contentType(POST_JSON_CONTENT_TYPE).body(parameters).then().expect().statusCode(Response.Status.OK.getStatusCode()).when().post(HISTORIC_PROCESS_INSTANCE_RESOURCE_URL, new Object[0]);
        ((HistoricProcessInstanceQuery)Mockito.verify((Object)this.mockedQuery)).activityIdIn(new String[]{"1", "2"});
    }
}

