/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.mapper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.rest.dto.history.HistoricProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.dto.runtime.JobQueryDto;
import org.camunda.bpm.engine.rest.dto.runtime.ProcessInstanceQueryDto;
import org.camunda.bpm.engine.rest.dto.runtime.RetriesDto;
import org.camunda.bpm.engine.rest.dto.runtime.SetJobRetriesByProcessDto;
import org.camunda.bpm.engine.rest.dto.runtime.SetJobRetriesDto;
import org.junit.Test;

public class RetriesDtoObjectMapperTest {
    @Test
    public void shouldExcludeDueDateSetPropertyRetriesDto() throws JsonProcessingException {
        RetriesDto dto = new RetriesDto();
        dto.setRetries(Integer.valueOf(4));
        dto.setDueDate(new Date(1675752840000L));
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)dto);
        Assertions.assertThat((String)json).doesNotContain(new CharSequence[]{"dueDateSet"});
    }

    @Test
    public void shouldIncludeDueDateSetPropertyRetriesDto() throws JsonProcessingException {
        String json = "{\"retries\":4,\"dueDate\":1675752840000}";
        ObjectMapper mapper = new ObjectMapper();
        RetriesDto dto = (RetriesDto)mapper.readValue(json, RetriesDto.class);
        Assertions.assertThat((boolean)dto.isDueDateSet()).isTrue();
    }

    @Test
    public void shouldIgnoreDueDateSetPropertyRetriesDto() throws JsonProcessingException {
        String json = "{\"retries\":4}";
        ObjectMapper mapper = new ObjectMapper();
        RetriesDto dto = (RetriesDto)mapper.readValue(json, RetriesDto.class);
        Assertions.assertThat((boolean)dto.isDueDateSet()).isFalse();
    }

    @Test
    public void shouldExcludeDueDateSetPropertySetJobRetriesDto() throws JsonProcessingException {
        SetJobRetriesDto dto = new SetJobRetriesDto();
        dto.setRetries(Integer.valueOf(4));
        dto.setDueDate(new Date(1675752840000L));
        dto.setJobIds(new ArrayList());
        dto.setJobQuery(new JobQueryDto());
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)dto);
        Assertions.assertThat((String)json).doesNotContain(new CharSequence[]{"dueDateSet"});
    }

    @Test
    public void shouldIncludeDueDateSetPropertySetJobRetriesDto() throws JsonProcessingException {
        String json = "{\"retries\":4,\"dueDate\":1675752840000,\"jobIds\":[],\"jobQuery\":{\"sorting\":null}}";
        ObjectMapper mapper = new ObjectMapper();
        SetJobRetriesDto dto = (SetJobRetriesDto)mapper.readValue(json, SetJobRetriesDto.class);
        Assertions.assertThat((boolean)dto.isDueDateSet()).isTrue();
    }

    @Test
    public void shouldIgnoreDueDateSetPropertySetJobRetriesDto() throws JsonProcessingException {
        String json = "{\"retries\":4,\"jobIds\":[],\"jobQuery\":{\"sorting\":null}}";
        ObjectMapper mapper = new ObjectMapper();
        SetJobRetriesDto dto = (SetJobRetriesDto)mapper.readValue(json, SetJobRetriesDto.class);
        Assertions.assertThat((boolean)dto.isDueDateSet()).isFalse();
    }

    @Test
    public void shouldExcludeDueDateSetPropertySetJobRetriesByProcessDto() throws JsonProcessingException {
        SetJobRetriesByProcessDto dto = new SetJobRetriesByProcessDto();
        dto.setRetries(Integer.valueOf(4));
        dto.setDueDate(new Date(1675752840000L));
        dto.setHistoricProcessInstanceQuery(new HistoricProcessInstanceQueryDto());
        dto.setProcessInstanceQuery(new ProcessInstanceQueryDto());
        dto.setProcessInstances(new ArrayList());
        ObjectMapper mapper = new ObjectMapper();
        String json = mapper.writeValueAsString((Object)dto);
        Assertions.assertThat((String)json).doesNotContain(new CharSequence[]{"dueDateSet"});
    }

    @Test
    public void shouldIncludeDueDateSetPropertySetJobRetriesByProcessDto() throws JsonProcessingException {
        String json = "{\"retries\":4,\"dueDate\":1675752840000,\"jobIds\":null,\"jobQuery\":null,\"processInstances\":[],\"historicProcessInstanceQuery\":{\"processDefinitionId\":null,\"incidentType\":null,\"orQueries\":null,\"sorting\":null}}";
        ObjectMapper mapper = new ObjectMapper();
        SetJobRetriesByProcessDto dto = (SetJobRetriesByProcessDto)mapper.readValue(json, SetJobRetriesByProcessDto.class);
        Assertions.assertThat((boolean)dto.isDueDateSet()).isTrue();
    }

    @Test
    public void shouldIgnoreDueDateSetPropertySetJobRetriesByProcessDto() throws JsonProcessingException {
        String json = "{\"retries\":4,\"jobIds\":null,\"jobQuery\":null,\"processInstances\":[],\"processInstanceQuery\":{\"deploymentId\":null,\"processDefinitionKey\":null,\"processDefinitionKeys\":null,\"processDefinitionKeyNotIn\":null,\"businessKey\":null,\"businessKeyLike\":null,\"caseInstanceId\":null,\"processDefinitionId\":null,\"superProcessInstance\":null,\"subProcessInstance\":null,\"superCaseInstance\":null,\"subCaseInstance\":null,\"active\":null,\"suspended\":null,\"processInstanceIds\":null,\"withIncident\":null,\"incidentId\":null,\"incidentType\":null,\"incidentMessage\":null,\"incidentMessageLike\":null,\"withoutTenantId\":null,\"activityIds\":null,\"rootProcessInstances\":null,\"leafProcessInstances\":null,\"variableNamesIgnoreCase\":null,\"variableValuesIgnoreCase\":null,\"variables\":null,\"orQueries\":null,\"processDefinitionWithoutTenantId\":null,\"tenantIdIn\":null,\"sorting\":null},\"historicProcessInstanceQuery\":{\"processDefinitionId\":null,\"incidentType\":null,\"orQueries\":null,\"sorting\":null}}";
        ObjectMapper mapper = new ObjectMapper();
        SetJobRetriesByProcessDto dto = (SetJobRetriesByProcessDto)mapper.readValue(json, SetJobRetriesByProcessDto.class);
        Assertions.assertThat((boolean)dto.isDueDateSet()).isFalse();
    }
}

