/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Date;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricProcessInstanceReport;
import org.camunda.bpm.engine.rest.dto.AbstractReportDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringArrayConverter;

public class HistoricProcessInstanceReportDto
extends AbstractReportDto<HistoricProcessInstanceReport> {
    protected String[] processDefinitionIdIn;
    protected String[] processDefinitionKeyIn;
    protected Date startedAfter;
    protected Date startedBefore;

    public HistoricProcessInstanceReportDto() {
    }

    public HistoricProcessInstanceReportDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="processDefinitionIdIn", converter=StringArrayConverter.class)
    public void setProcessDefinitionIdIn(String[] processDefinitionIdIn) {
        this.processDefinitionIdIn = processDefinitionIdIn;
    }

    @CamundaQueryParam(value="processDefinitionKeyIn", converter=StringArrayConverter.class)
    public void setProcessDefinitionKeyIn(String[] processDefinitionKeyIn) {
        this.processDefinitionKeyIn = processDefinitionKeyIn;
    }

    @CamundaQueryParam(value="startedAfter", converter=DateConverter.class)
    public void setStartedAfter(Date startedAfter) {
        this.startedAfter = startedAfter;
    }

    @CamundaQueryParam(value="startedBefore", converter=DateConverter.class)
    public void setStartedBefore(Date startedBefore) {
        this.startedBefore = startedBefore;
    }

    @Override
    protected HistoricProcessInstanceReport createNewReportQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricProcessInstanceReport();
    }

    @Override
    protected void applyFilters(HistoricProcessInstanceReport reportQuery) {
        if (this.processDefinitionIdIn != null && this.processDefinitionIdIn.length > 0) {
            reportQuery.processDefinitionIdIn(this.processDefinitionIdIn);
        }
        if (this.processDefinitionKeyIn != null && this.processDefinitionKeyIn.length > 0) {
            reportQuery.processDefinitionKeyIn(this.processDefinitionKeyIn);
        }
        if (this.startedAfter != null) {
            reportQuery.startedAfter(this.startedAfter);
        }
        if (this.startedBefore != null) {
            reportQuery.startedBefore(this.startedBefore);
        }
    }
}

