/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.repository;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;

public class DeploymentQueryDto
extends AbstractQueryDto<DeploymentQuery> {
    private static final String SORT_BY_ID_VALUE = "id";
    private static final String SORT_BY_NAME_VALUE = "name";
    private static final String SORT_BY_DEPLOYMENT_TIME_VALUE = "deploymentTime";
    private static final String SORT_BY_TENANT_ID = "tenantId";
    private static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    private String id;
    private String name;
    private String nameLike;
    private String source;
    private Boolean withoutSource;
    private Date before;
    private Date after;
    private List<String> tenantIds;

    public DeploymentQueryDto() {
    }

    public DeploymentQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @CamundaQueryParam(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @CamundaQueryParam(value="nameLike")
    public void setNameLike(String nameLike) {
        this.nameLike = nameLike;
    }

    @CamundaQueryParam(value="source")
    public void setSource(String source) {
        this.source = source;
    }

    @CamundaQueryParam(value="withoutSource", converter=BooleanConverter.class)
    public void setWithoutSource(Boolean withoutSource) {
        this.withoutSource = withoutSource;
    }

    @CamundaQueryParam(value="before", converter=DateConverter.class)
    public void setDeploymentBefore(Date deploymentBefore) {
        this.before = deploymentBefore;
    }

    @CamundaQueryParam(value="after", converter=DateConverter.class)
    public void setDeploymentAfter(Date deploymentAfter) {
        this.after = deploymentAfter;
    }

    @CamundaQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected DeploymentQuery createNewQuery(ProcessEngine engine) {
        return engine.getRepositoryService().createDeploymentQuery();
    }

    @Override
    protected void applyFilters(DeploymentQuery query) {
        if (this.withoutSource != null && this.withoutSource.booleanValue() && this.source != null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "The query parameters \"withoutSource\" and \"source\" cannot be used in combination.");
        }
        if (this.id != null) {
            query.deploymentId(this.id);
        }
        if (this.name != null) {
            query.deploymentName(this.name);
        }
        if (this.nameLike != null) {
            query.deploymentNameLike(this.nameLike);
        }
        if (this.withoutSource != null && this.withoutSource.booleanValue()) {
            query.deploymentSource(null);
        }
        if (this.source != null) {
            query.deploymentSource(this.source);
        }
        if (this.before != null) {
            query.deploymentBefore(this.before);
        }
        if (this.after != null) {
            query.deploymentAfter(this.after);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
    }

    @Override
    protected void applySortBy(DeploymentQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_ID_VALUE)) {
            query.orderByDeploymentId();
        } else if (sortBy.equals(SORT_BY_NAME_VALUE)) {
            query.orderByDeploymentName();
        } else if (sortBy.equals(SORT_BY_DEPLOYMENT_TIME_VALUE)) {
            query.orderByDeploymenTime();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_NAME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_DEPLOYMENT_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

