/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime;

import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.rest.dto.SuspensionStateDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;

public class ProcessInstanceSuspensionStateDto
extends SuspensionStateDto {
    private String processInstanceId;
    private String processDefinitionId;
    private String processDefinitionKey;

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public void updateSuspensionState(ProcessEngine engine) {
        int params = (this.processInstanceId != null ? 1 : 0) + (this.processDefinitionId != null ? 1 : 0) + (this.processDefinitionKey != null ? 1 : 0);
        if (params > 1) {
            String message = "Only one of processInstanceId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        RuntimeService runtimeService = engine.getRuntimeService();
        if (this.processInstanceId != null) {
            if (this.getSuspended()) {
                runtimeService.suspendProcessInstanceById(this.processInstanceId);
            } else {
                runtimeService.activateProcessInstanceById(this.processInstanceId);
            }
        } else if (this.processDefinitionId != null) {
            if (this.getSuspended()) {
                runtimeService.suspendProcessInstanceByProcessDefinitionId(this.processDefinitionId);
            } else {
                runtimeService.activateProcessInstanceByProcessDefinitionId(this.processDefinitionId);
            }
        } else if (this.processDefinitionKey != null) {
            if (this.getSuspended()) {
                runtimeService.suspendProcessInstanceByProcessDefinitionKey(this.processDefinitionKey);
            } else {
                runtimeService.activateProcessInstanceByProcessDefinitionKey(this.processDefinitionKey);
            }
        } else {
            String message = "Either processInstanceId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
    }
}

