/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.rest.dto.AuthorizationExceptionDto;
import org.camunda.bpm.engine.rest.dto.ExceptionDto;
import org.camunda.bpm.engine.rest.exception.ExceptionHandler;

@Provider
public class ProcessEngineExceptionHandler
implements ExceptionMapper<ProcessEngineException> {
    private static final Logger LOGGER = Logger.getLogger(ExceptionHandler.class.getSimpleName());

    public Response toResponse(ProcessEngineException exception) {
        LOGGER.log(Level.WARNING, this.getStackTrace(exception));
        if (exception instanceof AuthorizationException) {
            AuthorizationExceptionDto exceptionDto = AuthorizationExceptionDto.fromException((AuthorizationException)((Object)exception));
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)exceptionDto).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        ExceptionDto exceptionDto = ExceptionDto.fromException((Exception)((Object)exception));
        return Response.serverError().entity((Object)exceptionDto).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    protected String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }
}

