/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.rest.DecisionDefinitionRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.repository.DecisionDefinitionDto;
import org.camunda.bpm.engine.rest.dto.repository.DecisionDefinitionQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.exception.RestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.sub.repository.DecisionDefinitionResource;
import org.camunda.bpm.engine.rest.sub.repository.impl.DecisionDefinitionResourceImpl;

public class DecisionDefinitionRestServiceImpl
extends AbstractRestProcessEngineAware
implements DecisionDefinitionRestService {
    public DecisionDefinitionRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public DecisionDefinitionResource getDecisionDefinitionByKey(String decisionDefinitionKey) {
        if (decisionDefinitionKey == null) {
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, "Query parameter 'decisionDefinitionKey' cannot be null");
        }
        ProcessEngine engine = this.getProcessEngine();
        RepositoryService repositoryService = engine.getRepositoryService();
        DecisionDefinitionQuery query = repositoryService.createDecisionDefinitionQuery();
        query.decisionDefinitionKey(decisionDefinitionKey).latestVersion();
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        if (decisionDefinition == null) {
            String errorMessage = String.format("No matching decision definition with key: %s ", decisionDefinitionKey);
            throw new RestException(Response.Status.NOT_FOUND, errorMessage);
        }
        return this.getDecisionDefinitionById(decisionDefinition.getId());
    }

    @Override
    public DecisionDefinitionResource getDecisionDefinitionById(String decisionDefinitionId) {
        return new DecisionDefinitionResourceImpl(this.getProcessEngine(), decisionDefinitionId, this.relativeRootResourcePath, this.getObjectMapper());
    }

    @Override
    public List<DecisionDefinitionDto> getDecisionDefinitions(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        DecisionDefinitionQueryDto queryDto = new DecisionDefinitionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ArrayList<DecisionDefinitionDto> definitions = new ArrayList<DecisionDefinitionDto>();
        ProcessEngine engine = this.getProcessEngine();
        DecisionDefinitionQuery query = (DecisionDefinitionQuery)queryDto.toQuery(engine);
        List<DecisionDefinition> matchingDefinitions = null;
        matchingDefinitions = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        for (DecisionDefinition definition : matchingDefinitions) {
            DecisionDefinitionDto def = DecisionDefinitionDto.fromDecisionDefinition(definition);
            definitions.add(def);
        }
        return definitions;
    }

    private List<DecisionDefinition> executePaginatedQuery(DecisionDefinitionQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    @Override
    public CountResultDto getDecisionDefinitionsCount(UriInfo uriInfo) {
        DecisionDefinitionQueryDto queryDto = new DecisionDefinitionQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ProcessEngine engine = this.getProcessEngine();
        DecisionDefinitionQuery query = (DecisionDefinitionQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }
}

