/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.externaltask;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;

public class ExternalTaskQueryDto
extends AbstractQueryDto<ExternalTaskQuery> {
    public static final String SORT_BY_ID_VALUE = "id";
    public static final String SORT_BY_LOCK_EXPIRATION_TIME = "lockExpirationTime";
    public static final String SORT_BY_PROCESS_INSTANCE_ID = "processInstanceId";
    public static final String SORT_BY_PROCESS_DEFINITION_ID = "processDefinitionId";
    public static final String SORT_BY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
    public static final String SORT_BY_TENANT_ID = "tenantId";
    public static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String externalTaskId;
    protected String activityId;
    protected Date lockExpirationBefore;
    protected Date lockExpirationAfter;
    protected String topicName;
    protected Boolean locked;
    protected Boolean notLocked;
    protected String executionId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected Boolean active;
    protected Boolean suspended;
    protected Boolean withRetriesLeft;
    protected Boolean noRetriesLeft;
    protected String workerId;
    protected List<String> tenantIds;

    public ExternalTaskQueryDto() {
    }

    public ExternalTaskQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="externalTaskId")
    public void setExternalTaskId(String externalTaskId) {
        this.externalTaskId = externalTaskId;
    }

    @CamundaQueryParam(value="activityId")
    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    @CamundaQueryParam(value="lockExpirationBefore", converter=DateConverter.class)
    public void setLockExpirationBefore(Date lockExpirationBefore) {
        this.lockExpirationBefore = lockExpirationBefore;
    }

    @CamundaQueryParam(value="lockExpirationAfter", converter=DateConverter.class)
    public void setLockExpirationAfter(Date lockExpirationAfter) {
        this.lockExpirationAfter = lockExpirationAfter;
    }

    @CamundaQueryParam(value="topicName")
    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    @CamundaQueryParam(value="locked", converter=BooleanConverter.class)
    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    @CamundaQueryParam(value="notLocked", converter=BooleanConverter.class)
    public void setNotLocked(Boolean notLocked) {
        this.notLocked = notLocked;
    }

    @CamundaQueryParam(value="executionId")
    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="active", converter=BooleanConverter.class)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @CamundaQueryParam(value="suspended", converter=BooleanConverter.class)
    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    @CamundaQueryParam(value="withRetriesLeft", converter=BooleanConverter.class)
    public void setWithRetriesLeft(Boolean withRetriesLeft) {
        this.withRetriesLeft = withRetriesLeft;
    }

    @CamundaQueryParam(value="noRetriesLeft", converter=BooleanConverter.class)
    public void setNoRetriesLeft(Boolean noRetriesLeft) {
        this.noRetriesLeft = noRetriesLeft;
    }

    @CamundaQueryParam(value="workerId")
    public void setWorkerId(String workerId) {
        this.workerId = workerId;
    }

    @CamundaQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected ExternalTaskQuery createNewQuery(ProcessEngine engine) {
        return engine.getExternalTaskService().createExternalTaskQuery();
    }

    @Override
    protected void applyFilters(ExternalTaskQuery query) {
        if (this.externalTaskId != null) {
            query.externalTaskId(this.externalTaskId);
        }
        if (this.activityId != null) {
            query.activityId(this.activityId);
        }
        if (this.lockExpirationBefore != null) {
            query.lockExpirationBefore(this.lockExpirationBefore);
        }
        if (this.lockExpirationAfter != null) {
            query.lockExpirationAfter(this.lockExpirationAfter);
        }
        if (this.topicName != null) {
            query.topicName(this.topicName);
        }
        if (this.locked != null && this.locked.booleanValue()) {
            query.locked();
        }
        if (this.notLocked != null && this.notLocked.booleanValue()) {
            query.notLocked();
        }
        if (this.executionId != null) {
            query.executionId(this.executionId);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.active != null && this.active.booleanValue()) {
            query.active();
        }
        if (this.suspended != null && this.suspended.booleanValue()) {
            query.suspended();
        }
        if (this.withRetriesLeft != null && this.withRetriesLeft.booleanValue()) {
            query.withRetriesLeft();
        }
        if (this.noRetriesLeft != null && this.noRetriesLeft.booleanValue()) {
            query.noRetriesLeft();
        }
        if (this.workerId != null) {
            query.workerId(this.workerId);
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
    }

    @Override
    protected void applySortBy(ExternalTaskQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (SORT_BY_ID_VALUE.equals(sortBy)) {
            query.orderById();
        } else if (SORT_BY_LOCK_EXPIRATION_TIME.equals(sortBy)) {
            query.orderByLockExpirationTime();
        } else if (SORT_BY_PROCESS_DEFINITION_ID.equals(sortBy)) {
            query.orderByProcessDefinitionId();
        } else if (SORT_BY_PROCESS_DEFINITION_KEY.equals(sortBy)) {
            query.orderByProcessDefinitionKey();
        } else if (SORT_BY_PROCESS_INSTANCE_ID.equals(sortBy)) {
            query.orderByProcessInstanceId();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_ID_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_LOCK_EXPIRATION_TIME);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_INSTANCE_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_ID);
        VALID_SORT_BY_VALUES.add(SORT_BY_PROCESS_DEFINITION_KEY);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

