/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Date;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricFormField;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.rest.dto.history.HistoricFormFieldDto;
import org.camunda.bpm.engine.rest.dto.history.HistoricVariableUpdateDto;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=HistoricFormFieldDto.class), @JsonSubTypes.Type(value=HistoricVariableUpdateDto.class)})
public abstract class HistoricDetailDto {
    protected String id;
    protected String processDefinitionKey;
    protected String processDefinitionId;
    protected String processInstanceId;
    protected String activityInstanceId;
    protected String executionId;
    protected String caseDefinitionKey;
    protected String caseDefinitionId;
    protected String caseInstanceId;
    protected String caseExecutionId;
    protected String taskId;
    protected Date time;

    public String getId() {
        return this.id;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Date getTime() {
        return this.time;
    }

    public static HistoricDetailDto fromHistoricDetail(HistoricDetail historicDetail) {
        HistoricDetailDto dto = null;
        if (historicDetail instanceof HistoricFormField) {
            HistoricFormField historicFormField = (HistoricFormField)historicDetail;
            dto = HistoricFormFieldDto.fromHistoricFormField(historicFormField);
        } else if (historicDetail instanceof HistoricVariableUpdate) {
            HistoricVariableUpdate historicVariableUpdate = (HistoricVariableUpdate)historicDetail;
            dto = HistoricVariableUpdateDto.fromHistoricVariableUpdate(historicVariableUpdate);
        }
        dto.id = historicDetail.getId();
        dto.processDefinitionKey = historicDetail.getProcessDefinitionKey();
        dto.processDefinitionId = historicDetail.getProcessDefinitionId();
        dto.processInstanceId = historicDetail.getProcessInstanceId();
        dto.activityInstanceId = historicDetail.getActivityInstanceId();
        dto.executionId = historicDetail.getExecutionId();
        dto.taskId = historicDetail.getTaskId();
        dto.caseDefinitionKey = historicDetail.getCaseDefinitionKey();
        dto.caseDefinitionId = historicDetail.getCaseDefinitionId();
        dto.caseInstanceId = historicDetail.getCaseInstanceId();
        dto.caseExecutionId = historicDetail.getCaseExecutionId();
        dto.time = historicDetail.getTime();
        return dto;
    }
}

