/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.migration;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.MigrationPlanBuilder;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.migration.MigrationInstruction;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.rest.dto.migration.MigrationInstructionDto;

public class MigrationPlanDto {
    protected String sourceProcessDefinitionId;
    protected String targetProcessDefinitionId;
    protected List<MigrationInstructionDto> instructions;

    public String getSourceProcessDefinitionId() {
        return this.sourceProcessDefinitionId;
    }

    public void setSourceProcessDefinitionId(String sourceProcessDefinitionId) {
        this.sourceProcessDefinitionId = sourceProcessDefinitionId;
    }

    public String getTargetProcessDefinitionId() {
        return this.targetProcessDefinitionId;
    }

    public void setTargetProcessDefinitionId(String targetProcessDefinitionId) {
        this.targetProcessDefinitionId = targetProcessDefinitionId;
    }

    public List<MigrationInstructionDto> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(List<MigrationInstructionDto> instructions) {
        this.instructions = instructions;
    }

    public static MigrationPlanDto fromMigrationPlan(MigrationPlan migrationPlan) {
        MigrationPlanDto dto = new MigrationPlanDto();
        dto.setSourceProcessDefinitionId(migrationPlan.getSourceProcessDefinitionId());
        dto.setTargetProcessDefinitionId(migrationPlan.getTargetProcessDefinitionId());
        ArrayList<MigrationInstructionDto> instructionDtos = new ArrayList<MigrationInstructionDto>();
        for (MigrationInstruction migrationInstruction : migrationPlan.getInstructions()) {
            MigrationInstructionDto migrationInstructionDto = MigrationInstructionDto.fromMigrationInstruction(migrationInstruction);
            instructionDtos.add(migrationInstructionDto);
        }
        dto.setInstructions(instructionDtos);
        return dto;
    }

    public static MigrationPlan toMigrationPlan(ProcessEngine processEngine, MigrationPlanDto migrationPlanDto) {
        MigrationPlanBuilder migrationPlanBuilder = processEngine.getRuntimeService().createMigrationPlan(migrationPlanDto.getSourceProcessDefinitionId(), migrationPlanDto.getTargetProcessDefinitionId());
        for (MigrationInstructionDto migrationInstructionDto : migrationPlanDto.getInstructions()) {
            migrationPlanBuilder.mapActivities(migrationInstructionDto.getSourceActivityIds(), migrationInstructionDto.getTargetActivityIds());
        }
        return migrationPlanBuilder.build();
    }
}

