/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.rest.DeploymentRestService;
import org.camunda.bpm.engine.rest.dto.CountResultDto;
import org.camunda.bpm.engine.rest.dto.repository.DeploymentDto;
import org.camunda.bpm.engine.rest.dto.repository.DeploymentQueryDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;
import org.camunda.bpm.engine.rest.impl.AbstractRestProcessEngineAware;
import org.camunda.bpm.engine.rest.mapper.MultipartFormData;
import org.camunda.bpm.engine.rest.sub.repository.DeploymentResource;
import org.camunda.bpm.engine.rest.sub.repository.impl.DeploymentResourceImpl;

public class DeploymentRestServiceImpl
extends AbstractRestProcessEngineAware
implements DeploymentRestService {
    public static final String DEPLOYMENT_NAME = "deployment-name";
    public static final String ENABLE_DUPLICATE_FILTERING = "enable-duplicate-filtering";
    public static final String DEPLOY_CHANGED_ONLY = "deploy-changed-only";
    public static final String DEPLOYMENT_SOURCE = "deployment-source";
    public static final String TENANT_ID = "tenant-id";
    protected static final Set<String> RESERVED_KEYWORDS = new HashSet<String>();

    public DeploymentRestServiceImpl(String engineName, ObjectMapper objectMapper) {
        super(engineName, objectMapper);
    }

    @Override
    public DeploymentResource getDeployment(String deploymentId) {
        return new DeploymentResourceImpl(this.getProcessEngine().getName(), deploymentId, this.relativeRootResourcePath, this.getObjectMapper());
    }

    @Override
    public List<DeploymentDto> getDeployments(UriInfo uriInfo, Integer firstResult, Integer maxResults) {
        DeploymentQueryDto queryDto = new DeploymentQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ProcessEngine engine = this.getProcessEngine();
        DeploymentQuery query = (DeploymentQuery)queryDto.toQuery(engine);
        List<Deployment> matchingDeployments = firstResult != null || maxResults != null ? this.executePaginatedQuery(query, firstResult, maxResults) : query.list();
        ArrayList<DeploymentDto> deployments = new ArrayList<DeploymentDto>();
        for (Deployment deployment : matchingDeployments) {
            DeploymentDto def = DeploymentDto.fromDeployment(deployment);
            deployments.add(def);
        }
        return deployments;
    }

    @Override
    public DeploymentDto createDeployment(UriInfo uriInfo, MultipartFormData payload) {
        MultipartFormData.FormPart part;
        MultipartFormData.FormPart part2;
        DeploymentBuilder deploymentBuilder = this.getProcessEngine().getRepositoryService().createDeployment();
        Set<String> partNames = payload.getPartNames();
        for (String name : partNames) {
            part2 = payload.getNamedPart(name);
            if (RESERVED_KEYWORDS.contains(name)) continue;
            deploymentBuilder.addInputStream(part2.getFileName(), (InputStream)new ByteArrayInputStream(part2.getBinaryContent()));
        }
        if (payload.getNamedPart(DEPLOYMENT_NAME) != null) {
            part = payload.getNamedPart(DEPLOYMENT_NAME);
            deploymentBuilder.name(part.getTextContent());
        }
        if (payload.getNamedPart(DEPLOYMENT_SOURCE) != null) {
            part = payload.getNamedPart(DEPLOYMENT_SOURCE);
            deploymentBuilder.source(part.getTextContent());
        }
        if (payload.getNamedPart(TENANT_ID) != null) {
            part = payload.getNamedPart(TENANT_ID);
            deploymentBuilder.tenantId(part.getTextContent());
        }
        boolean enableDuplicateFiltering = false;
        boolean deployChangedOnly = false;
        if (payload.getNamedPart(ENABLE_DUPLICATE_FILTERING) != null) {
            part2 = payload.getNamedPart(ENABLE_DUPLICATE_FILTERING);
            enableDuplicateFiltering = Boolean.parseBoolean(part2.getTextContent());
        }
        if (payload.getNamedPart(DEPLOY_CHANGED_ONLY) != null) {
            part2 = payload.getNamedPart(DEPLOY_CHANGED_ONLY);
            deployChangedOnly = Boolean.parseBoolean(part2.getTextContent());
        }
        if (deployChangedOnly) {
            deploymentBuilder.enableDuplicateFiltering(true);
        } else if (enableDuplicateFiltering) {
            deploymentBuilder.enableDuplicateFiltering(false);
        }
        if (!deploymentBuilder.getResourceNames().isEmpty()) {
            Deployment deployment = deploymentBuilder.deploy();
            DeploymentDto deploymentDto = DeploymentDto.fromDeployment(deployment);
            URI uri = uriInfo.getBaseUriBuilder().path(this.relativeRootResourcePath).path("/deployment").path(deployment.getId()).build(new Object[0]);
            deploymentDto.addReflexiveLink(uri, "GET", "self");
            return deploymentDto;
        }
        throw new InvalidRequestException(Response.Status.BAD_REQUEST, "No deployment resources contained in the form upload.");
    }

    private List<Deployment> executePaginatedQuery(DeploymentQuery query, Integer firstResult, Integer maxResults) {
        if (firstResult == null) {
            firstResult = 0;
        }
        if (maxResults == null) {
            maxResults = Integer.MAX_VALUE;
        }
        return query.listPage(firstResult.intValue(), maxResults.intValue());
    }

    @Override
    public CountResultDto getDeploymentsCount(UriInfo uriInfo) {
        DeploymentQueryDto queryDto = new DeploymentQueryDto(this.getObjectMapper(), (MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        ProcessEngine engine = this.getProcessEngine();
        DeploymentQuery query = (DeploymentQuery)queryDto.toQuery(engine);
        long count = query.count();
        CountResultDto result = new CountResultDto();
        result.setCount(count);
        return result;
    }

    static {
        RESERVED_KEYWORDS.add(DEPLOYMENT_NAME);
        RESERVED_KEYWORDS.add(ENABLE_DUPLICATE_FILTERING);
        RESERVED_KEYWORDS.add(DEPLOY_CHANGED_ONLY);
        RESERVED_KEYWORDS.add(DEPLOYMENT_SOURCE);
        RESERVED_KEYWORDS.add(TENANT_ID);
    }
}

