/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.rest.dto.AbstractQueryDto;
import org.camunda.bpm.engine.rest.dto.CamundaQueryParam;
import org.camunda.bpm.engine.rest.dto.converter.BooleanConverter;
import org.camunda.bpm.engine.rest.dto.converter.DateConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringArrayConverter;
import org.camunda.bpm.engine.rest.dto.converter.StringListConverter;

public class HistoricDecisionInstanceQueryDto
extends AbstractQueryDto<HistoricDecisionInstanceQuery> {
    public static final String SORT_BY_EVALUATION_TIME_VALUE = "evaluationTime";
    public static final String SORT_BY_TENANT_ID = "tenantId";
    public static final List<String> VALID_SORT_BY_VALUES = new ArrayList<String>();
    protected String decisionInstanceId;
    protected String[] decisionInstanceIdIn;
    protected String decisionDefinitionId;
    protected String decisionDefinitionKey;
    protected String decisionDefinitionName;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String processInstanceId;
    protected String caseDefinitionId;
    protected String caseDefinitionKey;
    protected String caseInstanceId;
    protected String[] activityIdIn;
    protected String[] activityInstanceIdIn;
    protected Date evaluatedBefore;
    protected Date evaluatedAfter;
    protected String userId;
    protected Boolean includeInputs;
    protected Boolean includeOutputs;
    protected Boolean disableBinaryFetching;
    protected Boolean disableCustomObjectDeserialization;
    protected List<String> tenantIds;

    public HistoricDecisionInstanceQueryDto() {
    }

    public HistoricDecisionInstanceQueryDto(ObjectMapper objectMapper, MultivaluedMap<String, String> queryParameters) {
        super(objectMapper, queryParameters);
    }

    @CamundaQueryParam(value="decisionInstanceId")
    public void setDecisionInstanceId(String decisionInstanceId) {
        this.decisionInstanceId = decisionInstanceId;
    }

    @CamundaQueryParam(value="decisionInstanceIdIn", converter=StringArrayConverter.class)
    public void setDecisionInstanceIdIn(String[] decisionInstanceIdIn) {
        this.decisionInstanceIdIn = decisionInstanceIdIn;
    }

    @CamundaQueryParam(value="decisionDefinitionId")
    public void setDecisionDefinitionId(String decisionDefinitionId) {
        this.decisionDefinitionId = decisionDefinitionId;
    }

    @CamundaQueryParam(value="decisionDefinitionKey")
    public void setDecisionDefinitionKey(String decisionDefinitionKey) {
        this.decisionDefinitionKey = decisionDefinitionKey;
    }

    @CamundaQueryParam(value="decisionDefinitionName")
    public void setDecisionDefinitionName(String decisionDefinitionName) {
        this.decisionDefinitionName = decisionDefinitionName;
    }

    @CamundaQueryParam(value="processDefinitionId")
    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    @CamundaQueryParam(value="processDefinitionKey")
    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    @CamundaQueryParam(value="processInstanceId")
    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    @CamundaQueryParam(value="caseDefinitionId")
    public void setCaseDefinitionId(String caseDefinitionId) {
        this.caseDefinitionId = caseDefinitionId;
    }

    @CamundaQueryParam(value="caseDefinitionKey")
    public void setCaseDefinitionKey(String caseDefinitionKey) {
        this.caseDefinitionKey = caseDefinitionKey;
    }

    @CamundaQueryParam(value="caseInstanceId")
    public void setCaseInstanceId(String caseInstanceId) {
        this.caseInstanceId = caseInstanceId;
    }

    @CamundaQueryParam(value="activityIdIn", converter=StringArrayConverter.class)
    public void setActivityIdIn(String[] activityIdIn) {
        this.activityIdIn = activityIdIn;
    }

    @CamundaQueryParam(value="activityInstanceIdIn", converter=StringArrayConverter.class)
    public void setActivityInstanceIdIn(String[] activityInstanceIdIn) {
        this.activityInstanceIdIn = activityInstanceIdIn;
    }

    @CamundaQueryParam(value="evaluatedBefore", converter=DateConverter.class)
    public void setEvaluatedBefore(Date evaluatedBefore) {
        this.evaluatedBefore = evaluatedBefore;
    }

    @CamundaQueryParam(value="evaluatedAfter", converter=DateConverter.class)
    public void setEvaluatedAfter(Date evaluatedAfter) {
        this.evaluatedAfter = evaluatedAfter;
    }

    @CamundaQueryParam(value="userId")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @CamundaQueryParam(value="includeInputs", converter=BooleanConverter.class)
    public void setIncludeInputs(Boolean includeInputs) {
        this.includeInputs = includeInputs;
    }

    @CamundaQueryParam(value="includeOutputs", converter=BooleanConverter.class)
    public void setIncludeOutputs(Boolean includeOutputs) {
        this.includeOutputs = includeOutputs;
    }

    @CamundaQueryParam(value="disableBinaryFetching", converter=BooleanConverter.class)
    public void setDisableBinaryFetching(Boolean disableBinaryFetching) {
        this.disableBinaryFetching = disableBinaryFetching;
    }

    @CamundaQueryParam(value="disableCustomObjectDeserialization", converter=BooleanConverter.class)
    public void setDisableCustomObjectDeserialization(Boolean disableCustomObjectDeserialization) {
        this.disableCustomObjectDeserialization = disableCustomObjectDeserialization;
    }

    @CamundaQueryParam(value="tenantIdIn", converter=StringListConverter.class)
    public void setTenantIdIn(List<String> tenantIds) {
        this.tenantIds = tenantIds;
    }

    @Override
    protected boolean isValidSortByValue(String value) {
        return VALID_SORT_BY_VALUES.contains(value);
    }

    @Override
    protected HistoricDecisionInstanceQuery createNewQuery(ProcessEngine engine) {
        return engine.getHistoryService().createHistoricDecisionInstanceQuery();
    }

    @Override
    protected void applyFilters(HistoricDecisionInstanceQuery query) {
        if (this.decisionInstanceId != null) {
            query.decisionInstanceId(this.decisionInstanceId);
        }
        if (this.decisionInstanceIdIn != null) {
            query.decisionInstanceIdIn(this.decisionInstanceIdIn);
        }
        if (this.decisionDefinitionId != null) {
            query.decisionDefinitionId(this.decisionDefinitionId);
        }
        if (this.decisionDefinitionKey != null) {
            query.decisionDefinitionKey(this.decisionDefinitionKey);
        }
        if (this.decisionDefinitionName != null) {
            query.decisionDefinitionName(this.decisionDefinitionName);
        }
        if (this.processDefinitionId != null) {
            query.processDefinitionId(this.processDefinitionId);
        }
        if (this.processDefinitionKey != null) {
            query.processDefinitionKey(this.processDefinitionKey);
        }
        if (this.processInstanceId != null) {
            query.processInstanceId(this.processInstanceId);
        }
        if (this.caseDefinitionId != null) {
            query.caseDefinitionId(this.caseDefinitionId);
        }
        if (this.caseDefinitionKey != null) {
            query.caseDefinitionKey(this.caseDefinitionKey);
        }
        if (this.caseInstanceId != null) {
            query.caseInstanceId(this.caseInstanceId);
        }
        if (this.activityIdIn != null) {
            query.activityIdIn(this.activityIdIn);
        }
        if (this.activityInstanceIdIn != null) {
            query.activityInstanceIdIn(this.activityInstanceIdIn);
        }
        if (this.evaluatedBefore != null) {
            query.evaluatedBefore(this.evaluatedBefore);
        }
        if (this.evaluatedAfter != null) {
            query.evaluatedAfter(this.evaluatedAfter);
        }
        if (this.userId != null) {
            query.userId(this.userId);
        }
        if (this.includeInputs != null && this.includeInputs.booleanValue()) {
            query.includeInputs();
        }
        if (this.includeOutputs != null && this.includeOutputs.booleanValue()) {
            query.includeOutputs();
        }
        if (this.disableBinaryFetching != null && this.disableBinaryFetching.booleanValue()) {
            query.disableBinaryFetching();
        }
        if (this.disableCustomObjectDeserialization != null && this.disableCustomObjectDeserialization.booleanValue()) {
            query.disableCustomObjectDeserialization();
        }
        if (this.tenantIds != null && !this.tenantIds.isEmpty()) {
            query.tenantIdIn(this.tenantIds.toArray(new String[this.tenantIds.size()]));
        }
    }

    @Override
    protected void applySortBy(HistoricDecisionInstanceQuery query, String sortBy, Map<String, Object> parameters, ProcessEngine engine) {
        if (sortBy.equals(SORT_BY_EVALUATION_TIME_VALUE)) {
            query.orderByEvaluationTime();
        } else if (sortBy.equals(SORT_BY_TENANT_ID)) {
            query.orderByTenantId();
        }
    }

    static {
        VALID_SORT_BY_VALUES.add(SORT_BY_EVALUATION_TIME_VALUE);
        VALID_SORT_BY_VALUES.add(SORT_BY_TENANT_ID);
    }
}

