/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.management;

import java.util.Date;
import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.calendar.DateTimeUtil;
import org.camunda.bpm.engine.impl.management.UpdateJobDefinitionSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.rest.dto.SuspensionStateDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;

public class JobDefinitionSuspensionStateDto
extends SuspensionStateDto {
    private String executionDate;
    private boolean includeJobs;
    private String jobDefinitionId;
    private String processDefinitionId;
    private String processDefinitionKey;
    private String processDefinitionTenantId;
    private boolean processDefinitionWithoutTenantId;

    public String getJobDefinitionId() {
        return this.jobDefinitionId;
    }

    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    public void setExecutionDate(String executionDate) {
        this.executionDate = executionDate;
    }

    public void setIncludeJobs(boolean includeJobs) {
        this.includeJobs = includeJobs;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public void setProcessDefinitionTenantId(String processDefinitionTenantId) {
        this.processDefinitionTenantId = processDefinitionTenantId;
    }

    public void setProcessDefinitionWithoutTenantId(boolean processDefinitionWithoutTenantId) {
        this.processDefinitionWithoutTenantId = processDefinitionWithoutTenantId;
    }

    @Override
    public void updateSuspensionState(ProcessEngine engine) {
        int params = (this.jobDefinitionId != null ? 1 : 0) + (this.processDefinitionId != null ? 1 : 0) + (this.processDefinitionKey != null ? 1 : 0);
        if (params > 1) {
            String message = "Only one of jobDefinitionId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        if (params == 0) {
            String message = "Either jobDefinitionId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        UpdateJobDefinitionSuspensionStateBuilderImpl updateJobDefinitionSuspensionStateBuilder = (UpdateJobDefinitionSuspensionStateBuilderImpl)engine.getManagementService().updateJobDefinitionSuspensionState();
        if (this.jobDefinitionId != null) {
            updateJobDefinitionSuspensionStateBuilder.byJobDefinitionId(this.jobDefinitionId);
        } else if (this.processDefinitionId != null) {
            updateJobDefinitionSuspensionStateBuilder.byProcessDefinitionId(this.processDefinitionId);
        } else if (this.processDefinitionKey != null) {
            updateJobDefinitionSuspensionStateBuilder.byProcessDefinitionKey(this.processDefinitionKey);
            if (this.processDefinitionTenantId != null) {
                updateJobDefinitionSuspensionStateBuilder.processDefinitionTenantId(this.processDefinitionTenantId);
            } else if (this.processDefinitionWithoutTenantId) {
                updateJobDefinitionSuspensionStateBuilder.processDefinitionWithoutTenantId();
            }
        }
        if (this.executionDate != null && !this.executionDate.equals("")) {
            Date delayedExecutionDate = DateTimeUtil.parseDate((String)this.executionDate);
            updateJobDefinitionSuspensionStateBuilder.executionDate(delayedExecutionDate);
        }
        updateJobDefinitionSuspensionStateBuilder.includeJobs(this.includeJobs);
        if (this.getSuspended()) {
            updateJobDefinitionSuspensionStateBuilder.suspend();
        } else {
            updateJobDefinitionSuspensionStateBuilder.activate();
        }
    }
}

