/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.rest.dto.runtime;

import javax.ws.rs.core.Response;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.impl.management.UpdateJobSuspensionStateBuilderImpl;
import org.camunda.bpm.engine.rest.dto.SuspensionStateDto;
import org.camunda.bpm.engine.rest.exception.InvalidRequestException;

public class JobSuspensionStateDto
extends SuspensionStateDto {
    private String jobId;
    private String jobDefinitionId;
    private String processInstanceId;
    private String processDefinitionId;
    private String processDefinitionKey;
    private String processDefinitionTenantId;
    private boolean processDefinitionWithoutTenantId;

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setJobDefinitionId(String jobDefinitionId) {
        this.jobDefinitionId = jobDefinitionId;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public void setProcessDefinitionTenantId(String processDefinitionTenantId) {
        this.processDefinitionTenantId = processDefinitionTenantId;
    }

    public void setProcessDefinitionWithoutTenantId(boolean processDefinitionWithoutTenantId) {
        this.processDefinitionWithoutTenantId = processDefinitionWithoutTenantId;
    }

    @Override
    public void updateSuspensionState(ProcessEngine engine) {
        int params = (this.jobId != null ? 1 : 0) + (this.jobDefinitionId != null ? 1 : 0) + (this.processInstanceId != null ? 1 : 0) + (this.processDefinitionId != null ? 1 : 0) + (this.processDefinitionKey != null ? 1 : 0);
        if (params > 1) {
            String message = "Only one of jobId, jobDefinitionId, processInstanceId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        if (params == 0) {
            String message = "Either jobId, jobDefinitionId, processInstanceId, processDefinitionId or processDefinitionKey should be set to update the suspension state.";
            throw new InvalidRequestException(Response.Status.BAD_REQUEST, message);
        }
        UpdateJobSuspensionStateBuilderImpl updateJobSuspensionStateBuilder = (UpdateJobSuspensionStateBuilderImpl)engine.getManagementService().updateJobSuspensionState();
        if (this.jobId != null) {
            updateJobSuspensionStateBuilder.byJobId(this.jobId);
        } else if (this.jobDefinitionId != null) {
            updateJobSuspensionStateBuilder.byJobDefinitionId(this.jobDefinitionId);
        } else if (this.processInstanceId != null) {
            updateJobSuspensionStateBuilder.byProcessInstanceId(this.processInstanceId);
        } else if (this.processDefinitionId != null) {
            updateJobSuspensionStateBuilder.byProcessDefinitionId(this.processDefinitionId);
        } else if (this.processDefinitionKey != null) {
            updateJobSuspensionStateBuilder.byProcessDefinitionKey(this.processDefinitionKey);
            if (this.processDefinitionTenantId != null) {
                updateJobSuspensionStateBuilder.processDefinitionTenantId(this.processDefinitionTenantId);
            } else if (this.processDefinitionWithoutTenantId) {
                updateJobSuspensionStateBuilder.processDefinitionWithoutTenantId();
            }
        }
        if (this.getSuspended()) {
            updateJobSuspensionStateBuilder.suspend();
        } else {
            updateJobSuspensionStateBuilder.activate();
        }
    }
}

